/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector;

import de.hannse.netobjects.objectstore.CommandManagerExecutive;
import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.util.Babel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mausoleum.alert.Alert;
import mausoleum.gui.BorderPanel;
import mausoleum.gui.MGButton;
import mausoleum.inspector.DormantPanel;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.InspectorActionButton;
import mausoleum.inspector.SensitiveTable;
import mausoleum.inspector.actions.IAManager;
import mausoleum.inspector.panels.AttributePane;
import mausoleum.inspector.panels.CagePane;
import mausoleum.inspector.panels.DocumentsPane;
import mausoleum.inspector.panels.IPTabPanel;
import mausoleum.inspector.panels.MousePane;
import mausoleum.inspector.panels.TasksPane;
import mausoleum.inspector.sensitives.ChangeSensitive;
import mausoleum.inspector.util.ActionBundleSimple;
import mausoleum.inspector.util.InspectorCommandSender;
import mausoleum.main.DefaultManager;
import mausoleum.main.MausoleumClient;
import mausoleum.tables.MausoleumTable;
import mausoleum.tables.models.MTCage;
import mausoleum.tables.models.MTMouse;
import mausoleum.ui.UIDef;

public abstract class InspectorPanel
extends JPanel
implements LayoutManager {
    private static final long serialVersionUID = 132313L;
    protected final String ivTitle;
    private final MGButton ivNewButton;
    private final MGButton ivRemoveButton;
    private final MGButton ivSetButton;
    protected final Vector ivChangeSensitives = new Vector();
    public final HashMap ivActionButtons = new HashMap(10);
    public final Vector ivSelObjects = new Vector();
    private final TreeSet ivSelExtIds = new TreeSet();
    public MausoleumTable ivActTable = null;
    private IPTabbedPane ivTabbedPane = null;
    protected SensitiveTable ivSensitiveTable = null;
    protected BorderPanel ivActionPanel = null;
    private Vector ivActionPanelButtons = new Vector();
    private final ActionBundleSimple ivActionBundle = this.createActionBundle();

    public InspectorPanel(int objectType, String title) {
        this.ivTitle = String.valueOf(title) + "-" + Babel.get("INSPECTOR");
        Inspector.addPanel(this, objectType);
        this.setLayout(this);
        this.setOpaque(false);
        this.ivNewButton = MGButton.getNewRemSetButton(Babel.get("IBNEW"), this);
        this.ivNewButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                DormantPanel.actionDone();
                InspectorPanel.this.doNew(true);
            }
        });
        this.ivRemoveButton = MGButton.getNewRemSetButton(Babel.get("IBREMOVE"), this);
        this.ivRemoveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                DormantPanel.actionDone();
                InspectorPanel.this.doRemove(true);
            }
        });
        this.ivSetButton = MGButton.getNewRemSetButton(Babel.get("IBSET"), this);
        this.ivSetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                DormantPanel.actionDone();
                InspectorPanel.this.doTheSet();
            }
        });
        this.ivTabbedPane = new IPTabbedPane();
        this.add(this.ivTabbedPane);
        String[] defs = this.getActionDefs();
        if (defs != null) {
            JPanel mp = new JPanel(this.getActionLayout());
            mp.setOpaque(false);
            int i = 0;
            while (i < defs.length) {
                InspectorActionButton iab = InspectorActionButton.createButton(defs[i], this.ivActionButtons, mp);
                this.ivActionPanelButtons.add(iab);
                ++i;
            }
            this.ivActionPanel = new BorderPanel(mp, Babel.get("ACTIONS"));
            this.add(this.ivActionPanel);
        }
    }

    public abstract boolean doNew(boolean var1);

    public abstract boolean doRemove(boolean var1);

    public abstract ActionBundleSimple createActionBundle();

    private final int getActionHeight() {
        return this.ivActionBundle == null ? 0 : this.ivActionBundle.getNeededHeight();
    }

    private final String[] getActionDefs() {
        return this.ivActionBundle == null ? null : this.ivActionBundle.ivButtDefs;
    }

    private final LayoutManager getActionLayout() {
        return this.ivActionBundle == null ? null : this.ivActionBundle.ivLayoutmanager;
    }

    public boolean hasSelection() {
        return !this.ivSelObjects.isEmpty();
    }

    protected void addMouseTab(String convMouseTableTitle, MTMouse mouseTableModel) {
        this.addMouseTabIndependentOfServiceGroup(convMouseTableTitle, mouseTableModel);
    }

    protected void addMouseTabIndependentOfServiceGroup(String convMouseTableTitle, MTMouse mouseTableModel) {
        this.ivTabbedPane.addTab(Babel.get("MICE"), new MousePane(convMouseTableTitle, mouseTableModel));
    }

    protected void addCageTab(String convCageTableTitle, MTCage cageTableModel) {
        this.addCageTabIndependentOfServiceGroup(convCageTableTitle, cageTableModel);
    }

    protected void addCageTabIndependentOfServiceGroup(String convCageTableTitle, MTCage cageTableModel) {
        this.ivTabbedPane.addTab(Babel.get("CAGES"), new CagePane(convCageTableTitle, cageTableModel));
    }

    protected void addTaskTable() {
        if (MausoleumClient.isRegularOrTGService() || MausoleumClient.isServiceCaretaker()) {
            this.ivTabbedPane.addTab(Babel.get("TASKS"), new TasksPane());
        }
    }

    protected DocumentsPane addDocumentsTab(String addPrivilege, String removePrivilege, String showPrivilege) {
        DocumentsPane dp = new DocumentsPane(addPrivilege, removePrivilege, showPrivilege);
        this.ivTabbedPane.addTab(Babel.get("DOCUMENTS"), dp);
        return dp;
    }

    public void disableAllActionButtons() {
        Iterator iterator = this.ivActionButtons.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            MGButton but = (MGButton)this.ivActionButtons.get(key);
            but.setEnabled(false);
        }
    }

    public void setToNonApplicable(ChangeSensitive cs) {
        if (cs != null) {
            cs.setToNonApplicable();
        }
    }

    public void setToNonApplicable(ChangeSensitive[] csArr) {
        int i = 0;
        while (i < csArr.length) {
            this.setToNonApplicable(csArr[i]);
            ++i;
        }
    }

    public void setToPassive(ChangeSensitive cs) {
        if (cs != null) {
            cs.setToPassive();
        }
    }

    public void setToPassive(ChangeSensitive[] csArr) {
        int i = 0;
        while (i < csArr.length) {
            this.setToPassive(csArr[i]);
            ++i;
        }
    }

    public void setToActive(ChangeSensitive cs) {
        if (cs != null) {
            cs.setToActive();
        }
    }

    public void setToActive(ChangeSensitive[] csArr) {
        int i = 0;
        while (i < csArr.length) {
            this.setToActive(csArr[i]);
            ++i;
        }
    }

    public void adjustToSelectionChange(MausoleumTable mt) {
        this.adjustToSelectionChange(mt, false);
    }

    public void adjustToSelectionChange(MausoleumTable mt, boolean doitOverride) {
        boolean isNewTable = mt != this.ivActTable;
        this.ivActTable = mt;
        if (this.ivActTable == null) {
            this.disableFields();
        } else {
            Vector neuSelektiert = mt.getSelectedObjects();
            boolean doit = false;
            int neuSiz = neuSelektiert.size();
            if (neuSiz == 0) {
                if (!this.ivSelObjects.isEmpty()) {
                    this.ivSelObjects.clear();
                    this.ivSelExtIds.clear();
                    doit = true;
                }
            } else {
                String[] nextid = new String[neuSelektiert.size()];
                int i = 0;
                while (i < nextid.length) {
                    IDObject ido = (IDObject)neuSelektiert.elementAt(i);
                    nextid[i] = ido.getExtendedIdentifier();
                    ++i;
                }
                if (this.ivSelObjects.size() != neuSiz) {
                    doit = true;
                } else {
                    i = 0;
                    while (i < nextid.length && !doit) {
                        if (!this.ivSelExtIds.contains(nextid[i])) {
                            doit = true;
                        }
                        ++i;
                    }
                }
                if (doit) {
                    this.ivSelObjects.clear();
                    this.ivSelExtIds.clear();
                    this.ivSelObjects.addAll(neuSelektiert);
                    i = 0;
                    while (i < nextid.length) {
                        this.ivSelExtIds.add(nextid[i]);
                        ++i;
                    }
                }
            }
            if (doit || isNewTable || doitOverride) {
                if (this.ivSelObjects.isEmpty()) {
                    this.ivRemoveButton.setEnabled(false);
                    this.disableFields();
                } else {
                    this.ivRemoveButton.setEnabled(this.doRemove(false));
                }
                this.ivSetButton.setEnabled(false);
                this.ivNewButton.setEnabled(this.doNew(false));
                String commonGroup = IDObject.commonGroup(this.ivSelObjects);
                boolean touchable = IDObject.touchable(this.ivSelObjects);
                Iterator iterator = this.ivActionButtons.keySet().iterator();
                while (iterator.hasNext()) {
                    this.manageButEnabling((String)iterator.next(), commonGroup, touchable);
                }
                this.ivTabbedPane.adapt();
            }
        }
        DormantPanel.actionDone();
    }

    public void manageButEnabling(String command, String commonGroup, boolean touchable) {
        MGButton but;
        if (command != null && (but = (MGButton)this.ivActionButtons.get(command)) != null) {
            but.setEnabled(IAManager.isActive(command, this.ivSelObjects, commonGroup, touchable));
        }
    }

    public void disableFields() {
    }

    public void passiviereFelder() {
    }

    public void deblockiereFelder() {
    }

    public void setCSState(ChangeSensitive cs, boolean state) {
        if (cs != null) {
            cs.setState(state);
        }
    }

    public void adaptToSelection(ChangeSensitive cs) {
        if (cs != null) {
            cs.adaptToVector(this.ivSelObjects);
        }
    }

    public void doTheSet() {
        Vector changeSensitives;
        if (!this.ivSelObjects.isEmpty() && (changeSensitives = this.getTheRealChangedItems()) != null && !changeSensitives.isEmpty()) {
            if (this.checkSet(changeSensitives)) {
                HashMap obsByGroup = IDObject.sortByGroup(this.ivSelObjects);
                if (obsByGroup != null) {
                    String group;
                    Iterator iter = obsByGroup.keySet().iterator();
                    while (iter.hasNext()) {
                        group = (String)iter.next();
                        Vector obs = (Vector)obsByGroup.get(group);
                        String command = this.getSetCommand(changeSensitives, obs);
                        if (command != null && command.length() != 0) {
                            obsByGroup.put(group, command);
                            continue;
                        }
                        obsByGroup.put(group, "");
                    }
                    iter = obsByGroup.keySet().iterator();
                    while (iter.hasNext()) {
                        group = (String)iter.next();
                        String command = (String)obsByGroup.get(group);
                        if (command.length() == 0) continue;
                        InspectorCommandSender.executeCommand(command, group);
                    }
                }
                this.adjustToSelectionChange(this.ivActTable);
            } else {
                this.adjustToSelectionChange(this.ivActTable, true);
            }
        }
    }

    public boolean checkSet(Vector changeSensitives) {
        return true;
    }

    public abstract String getSetCommand(Vector var1, Vector var2);

    public MGButton getSetButton() {
        return this.ivSetButton;
    }

    public boolean isSetAllowed() {
        return true;
    }

    public void addChangeSensitive(ChangeSensitive cs) {
        if (this.ivChangeSensitives.indexOf(cs) == -1) {
            this.ivChangeSensitives.addElement(cs);
        }
    }

    public boolean containsCS(ChangeSensitive cs) {
        return this.ivChangeSensitives.contains(cs);
    }

    public void somethingChanged() {
        if (this.isSetAllowed()) {
            boolean setEnabled = false;
            int i = 0;
            while (i < this.ivChangeSensitives.size()) {
                ChangeSensitive cs = (ChangeSensitive)this.ivChangeSensitives.elementAt(i);
                if (cs.didYouChange()) {
                    setEnabled = true;
                }
                ++i;
            }
            this.ivSetButton.setEnabled(setEnabled);
        }
        this.ivActTable.repaint();
    }

    protected Vector getTheRealChangedItems() {
        Vector<ChangeSensitive> erg = new Vector<ChangeSensitive>();
        if (!this.ivChangeSensitives.isEmpty()) {
            Iterator iter = this.ivChangeSensitives.iterator();
            while (iter.hasNext()) {
                ChangeSensitive cs = (ChangeSensitive)iter.next();
                if (!cs.didYouChange()) continue;
                erg.addElement(cs);
            }
        }
        return erg;
    }

    public static void addComToStrBuf(StringBuffer msb, String com, IDObject ido) {
        if (msb.length() != 0) {
            msb.append("\n");
        }
        if (ido.canSitInRoom()) {
            msb.append(CommandManagerExecutive.getServiceRoomTag(ido, ""));
        }
        msb.append(com);
    }

    public static void makeCommand(String command, String param1, int posForID, StringBuffer msb, Vector idObjects) {
        InspectorPanel.makeCommand(command, param1, null, posForID, msb, idObjects);
    }

    public static void makeCommand(String command, String param1, String param2, int posForID, StringBuffer msb, Vector idObjects) {
        Vector<String> commandSpecs = new Vector<String>();
        commandSpecs.addElement(command);
        if (param1 != null) {
            commandSpecs.addElement(param1);
        }
        if (param2 != null) {
            commandSpecs.addElement(param2);
        }
        int j = 0;
        while (j < idObjects.size()) {
            IDObject ido = (IDObject)idObjects.elementAt(j);
            InspectorPanel.addComToStrBuf(msb, InspectorPanel.addIDAtPos(commandSpecs, ido, posForID), ido);
            ++j;
        }
    }

    public static String addIDAtPos(Vector v, IDObject ido, int pos) {
        v.insertElementAt(Long.toString(ido.getID()), pos);
        StringBuffer msb = new StringBuffer();
        int i = 0;
        while (i < v.size()) {
            if (msb.length() != 0) {
                msb.append(" ");
            }
            msb.append((String)v.elementAt(i));
            ++i;
        }
        v.removeElementAt(pos);
        return msb.toString();
    }

    public void disableActionButtons(String[] keys) {
        int i = 0;
        while (i < keys.length) {
            InspectorActionButton iab = (InspectorActionButton)this.ivActionButtons.get(keys[i]);
            if (iab != null) {
                iab.setEnabled(false);
            }
            ++i;
        }
    }

    public void addTab(String name, Component comp) {
        this.ivTabbedPane.addTab(name, comp);
    }

    public Vector getMatchingMice() {
        return null;
    }

    public void removeImportantObject(String privilege, String command, String alertEmpty, String alertPrivilege, String alertQuestion) {
        HashMap obsByGroup;
        if (this.ivSelObjects.isEmpty()) {
            Alert.showAlert(Babel.get(alertEmpty), true);
            return;
        }
        if (!Privileges.hasPrivilege(privilege)) {
            Alert.showAlert(Babel.get(alertPrivilege), true);
            return;
        }
        boolean warja = Alert.showAlert(Babel.get(alertQuestion), Babel.get("YES"), Babel.get("NO"), false);
        if (warja && (obsByGroup = IDObject.sortByGroup(this.ivSelObjects)) != null) {
            Iterator iter = obsByGroup.keySet().iterator();
            while (iter.hasNext()) {
                String group = (String)iter.next();
                Vector obs = (Vector)obsByGroup.get(group);
                StringBuffer msb = new StringBuffer();
                int j = 0;
                while (j < obs.size()) {
                    IDObject ido = (IDObject)obs.elementAt(j);
                    if (j != 0) {
                        msb.append("\n");
                    }
                    msb.append(String.valueOf(command) + " " + Long.toString(ido.getID()));
                    ++j;
                }
                InspectorCommandSender.executeCommand(msb.toString(), group);
            }
        }
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void layoutContainer(Container parent) {
        Dimension d = this.getSize();
        int y = 0;
        int x = 0;
        int lbw = (d.width - 2 * Inspector.INTER_BUT) / 3;
        int rbw = d.width - 2 * (lbw + Inspector.INTER_BUT);
        this.ivNewButton.setBounds(x, y, lbw, UIDef.BUT_HEIGHT_SMALL);
        this.ivRemoveButton.setBounds(x += lbw + Inspector.INTER_BUT, y, lbw, UIDef.BUT_HEIGHT_SMALL);
        this.ivSetButton.setBounds(x += lbw + Inspector.INTER_BUT, y, rbw, UIDef.BUT_HEIGHT_SMALL);
        int actionHeight = this.getActionHeight();
        int hoehe = d.height - (y += UIDef.BUT_HEIGHT_SMALL + Inspector.RAND) - actionHeight - Inspector.RAND;
        this.ivTabbedPane.setBounds(0, y, d.width, hoehe);
        if (this.ivActionPanel != null) {
            this.ivActionPanel.setBounds(0, d.height - actionHeight, d.width, actionHeight);
        }
    }

    public Dimension minimumLayoutSize(Container parent) {
        return UIDef.MINI_DIM;
    }

    public Dimension preferredLayoutSize(Container parent) {
        return UIDef.MINI_DIM;
    }

    public void removeLayoutComponent(Component comp) {
    }

    private class IPTabbedPane
    extends JTabbedPane {
        private static final long serialVersionUID = 13232L;
        private IPTabPanel ivAktPanel = null;
        private AttributePane ivAttributePane = null;
        private Vector ivActMice = null;

        public IPTabbedPane() {
            this.setOpaque(false);
            this.setBackground(new Color(220, 220, 220, 70));
            this.addChangeListener(new ChangeListener(this){
                final /* synthetic */ IPTabbedPane this$1;
                {
                    this.this$1 = iPTabbedPane;
                }

                public void stateChanged(ChangeEvent arg0) {
                    IPTabbedPane.access$0(this.this$1, (IPTabPanel)((Object)this.this$1.getComponentAt(this.this$1.getSelectedIndex())));
                    IPTabbedPane.access$1(this.this$1);
                    DormantPanel.actionDone();
                }
            });
        }

        public void adapt() {
            this.ivActMice = MausoleumClient.isRegular() || MausoleumClient.isServiceCaretaker() ? InspectorPanel.this.getMatchingMice() : null;
            this.adapt2();
        }

        private void adapt2() {
            if (this.ivAktPanel != null) {
                this.ivAktPanel.adapt(InspectorPanel.this.ivSelObjects, this.ivActMice, InspectorPanel.this.ivChangeSensitives);
                ((Component)((Object)this.ivAktPanel)).repaint();
            }
            if (DefaultManager.getExecuteInTable() && Privileges.hasPrivilege("EXECUTE_IN_TABLE") && this.ivAttributePane != null && !this.ivAttributePane.equals(this.ivAktPanel)) {
                this.ivAttributePane.adapt(InspectorPanel.this.ivSelObjects, this.ivActMice, InspectorPanel.this.ivChangeSensitives);
            }
        }

        public void addTab(String name, Component comp) {
            if (comp instanceof IPTabPanel) {
                super.addTab(name, comp);
                if (comp instanceof AttributePane) {
                    this.ivAttributePane = (AttributePane)comp;
                }
            } else {
                throw new IllegalArgumentException("Component has to implement IPTabPanel-Interface");
            }
        }

        static /* synthetic */ void access$0(IPTabbedPane iPTabbedPane, IPTabPanel iPTabPanel) {
            iPTabbedPane.ivAktPanel = iPTabPanel;
        }

        static /* synthetic */ void access$1(IPTabbedPane iPTabbedPane) {
            iPTabbedPane.adapt2();
        }
    }
}

