/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector;

import de.hannse.netobjects.objectstore.CommandManagerExecutive;
import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import java.awt.Container;
import java.awt.Dimension;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JScrollPane;
import mausoleum.alert.Alert;
import mausoleum.cage.Cage;
import mausoleum.cage.cagetalker.CageTalker;
import mausoleum.gui.BorderPanel;
import mausoleum.gui.MLabel;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.InspectorPanel;
import mausoleum.inspector.SensitiveTable;
import mausoleum.inspector.actions.cage.CageAction;
import mausoleum.inspector.panels.AttributePane;
import mausoleum.inspector.panels.CageCardPane;
import mausoleum.inspector.panels.PoolPane;
import mausoleum.inspector.sensitives.CSANTag;
import mausoleum.inspector.sensitives.CSCageNumber;
import mausoleum.inspector.sensitives.CSCageTalkerID;
import mausoleum.inspector.sensitives.CSForeignID;
import mausoleum.inspector.sensitives.CSMark;
import mausoleum.inspector.sensitives.CSTextArea;
import mausoleum.inspector.sensitives.CSTextField;
import mausoleum.inspector.sensitives.CSTextFieldTag;
import mausoleum.inspector.util.ActionBundleSimple;
import mausoleum.inspector.util.InspectorCommandSender;
import mausoleum.main.MausoleumClient;
import mausoleum.requester.cage.NewCageRequester;
import mausoleum.requester.calendar.CalendarRequester;
import mausoleum.room.RoomManager;

public class InspectorPanelCage
extends InspectorPanel {
    private static final long serialVersionUID = 148613513L;
    private static final String[] BUTTONS1 = new String[]{"CA_SHOWPOS", "CA_PRINTLABEL", "CA_CONTIG", "CA_MOVETOORCUS", "CA_SHOWALLMICE", "CA_ADD_COMMENT", "CA_SHOW_TASKS", "CA_TRANSFER_TO_ROOM", "CA_GROUP_TRANSFER"};
    public CSTextField ivLicenseField = null;
    public MLabel ivLicenseLabel = new MLabel(Babel.get("LICENSE"));
    public CSMark ivMarkButton = null;
    public CSANTag ivANTagButton = null;
    public CSCageNumber ivNumberButton = null;
    public CSForeignID ivCSForeignID = null;
    public CSCageTalkerID ivCageTalkerID = null;
    private CSTextArea ivCommentField = new CSTextArea(this, "CAG_COMMENT");
    private BorderPanel ivCommentPanel = new BorderPanel(new JScrollPane(this.ivCommentField), Babel.get("COMMENTS"));

    public InspectorPanelCage() {
        super(2, "CAGE");
        this.ivMarkButton = new CSMark(this);
        this.ivNumberButton = new CSCageNumber(this);
        this.ivANTagButton = new CSANTag(this);
        this.ivLicenseField = new CSTextFieldTag(this, "CAG_LICENSEID", Babel.get("LICENSE"));
        this.ivLicenseField.ivSetCommand = "ENTERCAGELICENSE";
        this.ivCSForeignID = new CSForeignID(this);
        if (CageTalker.useCageTalker()) {
            this.ivCageTalkerID = new CSCageTalkerID(this);
        }
        this.addTab(Babel.get("ATTRIBUTES"), new CageAttributePanel());
        this.addMouseTabIndependentOfServiceGroup(Babel.get("CAGESNAPSHOT"), null);
        this.addTaskTable();
        this.addTab(Babel.get("POOL_NC"), new PoolPane(2, this.ivActionButtons));
        this.addTab(Babel.get("CAGE_CARD_VIEW"), new CageCardPane());
    }

    public ActionBundleSimple createActionBundle() {
        return new ActionBundleSimple(CageAction.getCageActions(), 3);
    }

    public boolean isSetAllowed() {
        return !this.ivSelObjects.isEmpty();
    }

    public boolean doNew(boolean withExecution) {
        boolean res = Privileges.hasPrivilege("CREATE_CAGES");
        if (res && withExecution) {
            NewCageRequester ncr = new NewCageRequester(Inspector.getInspector());
            ncr.setVisible(true);
            if (ncr.ivWarOK) {
                String group = UserManager.getFirstGroup();
                String command = "CN";
                String raumID = null;
                boolean doit = true;
                if (MausoleumClient.isServiceCaretaker()) {
                    long srid;
                    group = ncr.getGroup();
                    command = "CN_ROOMID";
                    if (!ncr.isSingleMode()) {
                        command = "CNDOUBLE_ROOMID";
                    }
                    if ((srid = RoomManager.getGROUPRoomIDForServiceRoom(group)) == -1L) {
                        doit = false;
                    } else {
                        raumID = " " + srid;
                    }
                } else if (!ncr.isSingleMode()) {
                    command = "CNDOUBLE";
                }
                if (doit && group != null) {
                    StringBuffer msb = new StringBuffer();
                    msb.append(command).append(" ");
                    msb.append(ncr.getDate().getTime());
                    if (raumID != null) {
                        msb.append(raumID);
                    }
                    InspectorCommandSender.executeCommand(msb.toString(), group);
                }
            }
        }
        return res;
    }

    public boolean doRemove(boolean withExecution) {
        boolean res;
        boolean bl = res = Privileges.hasPrivilege("REMOVE_CAGES") && !this.ivSelObjects.isEmpty() && this.areCagesRemovable();
        if (res && withExecution) {
            HashMap obsByGroup;
            Date d;
            Vector<Cage> toRemoves = new Vector<Cage>();
            int i = 0;
            while (i < this.ivSelObjects.size()) {
                Cage c = (Cage)this.ivSelObjects.elementAt(i);
                if (c.isDead()) {
                    Alert.showAlert(Babel.get("ALERTOLDCAGE"), true);
                    return res;
                }
                if (c.getNumberOfMice() > 0) {
                    Alert.showAlert(Babel.get("ALERTNOTEMPTYCAGE"), true);
                    return res;
                }
                Cage sc = c.getSuperCageIfThere();
                if (!toRemoves.contains(sc)) {
                    toRemoves.addElement(sc);
                }
                ++i;
            }
            if (!toRemoves.isEmpty() && (d = CalendarRequester.getDate(Inspector.getInspector())) != null && (obsByGroup = IDObject.sortByGroup(toRemoves)) != null) {
                Iterator iter = obsByGroup.keySet().iterator();
                while (iter.hasNext()) {
                    String group = (String)iter.next();
                    Vector obs = (Vector)obsByGroup.get(group);
                    StringBuilder msb = new StringBuilder();
                    int j = 0;
                    while (j < obs.size()) {
                        Cage c = (Cage)obs.elementAt(j);
                        if (j != 0) {
                            msb.append("\n");
                        }
                        msb.append(CommandManagerExecutive.getServiceRoomTag(c, ""));
                        msb.append("CR").append(" ");
                        msb.append(c.getID()).append(" ");
                        msb.append(d.getTime());
                        ++j;
                    }
                    InspectorCommandSender.executeCommand(msb.toString(), group);
                }
            }
        }
        return res;
    }

    public void passiviereFelder() {
        super.disableActionButtons(BUTTONS1);
        this.ivCommentField.setToPassive();
    }

    public Vector getMatchingMice() {
        Vector erg = new Vector();
        Iterator iter = this.ivSelObjects.iterator();
        while (iter.hasNext()) {
            Cage c = (Cage)iter.next();
            c.addActualMice(erg);
        }
        return erg;
    }

    public void disableFields() {
        this.ivMarkButton.setToNonApplicable();
        this.ivLicenseField.setToNonApplicable();
        this.ivNumberButton.setToNonApplicable();
        this.ivANTagButton.setToNonApplicable();
        this.ivCSForeignID.setToNonApplicable();
        if (this.ivCageTalkerID != null) {
            this.ivCageTalkerID.setToNonApplicable();
        }
    }

    private boolean areCagesRemovable() {
        int i = 0;
        while (i < this.ivSelObjects.size()) {
            Cage sc;
            Cage c = (Cage)this.ivSelObjects.elementAt(i);
            if (c.isDead()) {
                return false;
            }
            if (c.hasSubCages()) {
                Cage cl = c.getLeftSubCage();
                if (cl != null && cl.getNumberOfMice() > 0) {
                    return false;
                }
                Cage cr = c.getRightSubCage();
                return cr == null || cr.getNumberOfMice() <= 0;
            }
            if (c.get("CAG_SUPERCAGE") != null && (sc = c.getSuperCageIfThere()) != null) {
                Cage cl = sc.getLeftSubCage();
                if (cl != null && cl.getNumberOfMice() > 0) {
                    return false;
                }
                Cage cr = sc.getRightSubCage();
                return cr == null || cr.getNumberOfMice() <= 0;
            }
            if (c.getNumberOfMice() > 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean checkSet(Vector changeSensitives) {
        return true;
    }

    public String getSetCommand(Vector changeSensitives, Vector idObjects) {
        StringBuffer msb = new StringBuffer();
        int i = 0;
        while (i < changeSensitives.size()) {
            Object ooo = changeSensitives.elementAt(i);
            if (ooo == this.ivMarkButton) {
                InspectorPanelCage.makeCommand("CSTG", this.ivMarkButton.getRequestString(), 1, msb, this.ivMarkButton.getAffecteds(idObjects));
            } else if (ooo == this.ivCommentField) {
                InspectorPanelCage.makeCommand("CSETC", Base64Manager.encodeBase64(this.ivCommentField.getText()), 1, msb, this.ivCommentField.getAffecteds(idObjects));
            } else if (changeSensitives.elementAt(i) == this.ivLicenseField) {
                InspectorPanelCage.makeCommand("CLICENSEID", Base64Manager.encodeBase64(this.ivLicenseField.getText().trim()), 1, msb, this.ivLicenseField.getAffecteds(idObjects));
            } else if (changeSensitives.elementAt(i) == this.ivNumberButton && this.ivNumberButton.didYouChange() && idObjects.size() == 1) {
                if (idObjects.size() == 1) {
                    Vector<Cage> v = new Vector<Cage>(1);
                    Cage cage = (Cage)idObjects.firstElement();
                    if (cage.hasSuperCage() || cage.hasSubCages()) {
                        Cage superCage = cage.getSuperCageIfThere();
                        v.add(superCage);
                        Cage subCage = superCage.getLeftSubCage();
                        if (subCage != null) {
                            v.add(subCage);
                        }
                        if ((subCage = superCage.getRightSubCage()) != null) {
                            v.add(subCage);
                        }
                    } else {
                        v.add(cage);
                    }
                    InspectorPanelCage.makeCommand("CPSEUODID", Integer.toString(this.ivNumberButton.getValue()), 1, msb, v);
                }
            } else if (changeSensitives.elementAt(i) == this.ivANTagButton && this.ivANTagButton.didYouChange()) {
                InspectorPanelCage.makeCommand("CSETANTAG", Base64Manager.encodeBase64(this.ivANTagButton.getValue()), 1, msb, this.ivANTagButton.getAffecteds(idObjects));
            } else if (changeSensitives.elementAt(i) == this.ivCageTalkerID && this.ivCageTalkerID.didYouChange()) {
                InspectorPanelCage.makeCommand("CSETCAGETLAKERID", Base64Manager.encodeBase64(this.ivCageTalkerID.getValue()), 1, msb, this.ivCageTalkerID.getAffecteds(idObjects));
            } else if (changeSensitives.elementAt(i) == this.ivCSForeignID && this.ivCSForeignID.didYouChange()) {
                InspectorPanelCage.makeCommand("SET_FOREIGN_ID", Integer.toString(2), Base64Manager.encodeBase64(this.ivCSForeignID.getValue()), 1, msb, this.ivCSForeignID.getAffecteds(idObjects));
            }
            ++i;
        }
        return msb.toString();
    }

    class CageAttributePanel
    extends AttributePane {
        private static final long serialVersionUID = 5067010713733060702L;

        public CageAttributePanel() {
            InspectorPanelCage.this.ivSensitiveTable = new SensitiveTable(InspectorPanelCage.this.ivChangeSensitives);
            this.add(InspectorPanelCage.this.ivSensitiveTable);
            this.add(InspectorPanelCage.this.ivCommentPanel);
        }

        public void layoutContainer(Container parent) {
            Dimension d = parent.getSize();
            int sth = InspectorPanelCage.this.ivSensitiveTable.getPreferredSize().height;
            int ra = 4;
            int iw = d.width;
            int y = 0;
            InspectorPanelCage.this.ivSensitiveTable.setBounds(0, y, iw, sth);
            InspectorPanelCage.this.ivCommentPanel.setBounds(0, y += sth + ra, iw, d.height - y);
        }

        public void adapt(Vector idObjects, Vector mice, Vector changeSensitives) {
            super.adapt(idObjects, mice, changeSensitives);
            if (idObjects != null && !idObjects.isEmpty()) {
                if (idObjects.size() == 1) {
                    boolean darf = ((Cage)InspectorPanelCage.this.ivSelObjects.firstElement()).isTouchable();
                    InspectorPanelCage.this.ivMarkButton.setState(darf && Privileges.hasPrivilege("CAG_CH_MARK"));
                    InspectorPanelCage.this.ivANTagButton.setState(darf && Privileges.hasPrivilege("CAG_CH_TAG"));
                    InspectorPanelCage.this.ivNumberButton.setState(darf && Privileges.hasPrivilege("CAG_CH_NUMBER"));
                    InspectorPanelCage.this.ivLicenseField.setState(darf && Privileges.hasPrivilege("CAG_CH_LICENSE"));
                    InspectorPanelCage.this.ivCommentField.setState(darf && Privileges.hasPrivilege("CAG_CH_COMMENT"));
                    InspectorPanelCage.this.ivCSForeignID.setState(darf && Privileges.hasPrivilege("EDIT_FOREIGN_ID"));
                    if (InspectorPanelCage.this.ivCageTalkerID != null) {
                        InspectorPanelCage.this.ivCageTalkerID.setState(darf && Privileges.hasPrivilege("CAG_SET_CAGETALKER_ID"));
                    }
                } else {
                    InspectorPanelCage.this.ivNumberButton.setToNonApplicable();
                    InspectorPanelCage.this.ivCommentField.setToNonApplicable();
                    InspectorPanelCage.this.ivLicenseField.setToNonApplicable();
                    InspectorPanelCage.this.ivANTagButton.setToNonApplicable();
                    InspectorPanelCage.this.ivCSForeignID.setToNonApplicable();
                    if (InspectorPanelCage.this.ivCageTalkerID != null) {
                        InspectorPanelCage.this.ivCageTalkerID.setToNonApplicable();
                    }
                    boolean darf = true;
                    Iterator iter = InspectorPanelCage.this.ivSelObjects.iterator();
                    while (iter.hasNext()) {
                        Cage c = (Cage)iter.next();
                        if (c.isTouchable()) continue;
                        darf = false;
                    }
                    InspectorPanelCage.this.ivMarkButton.setState(darf && Privileges.hasPrivilege("CAG_CH_MARK"));
                }
            }
        }
    }
}

