/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.MyDate;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import mausoleum.alert.Alert;
import mausoleum.gui.BorderPanel;
import mausoleum.helper.ExportHelper;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.InspectorPanel;
import mausoleum.inspector.SensitiveTable;
import mausoleum.inspector.actions.line.KnubbelSelector;
import mausoleum.inspector.actions.mouse.MAExport;
import mausoleum.inspector.actions.mouse.MALitter;
import mausoleum.inspector.panels.AttributePane;
import mausoleum.inspector.panels.MouseCohortPanel;
import mausoleum.inspector.panels.MouseInspEmbryoTransferPanel;
import mausoleum.inspector.panels.MouseInspHealthReportPanel;
import mausoleum.inspector.panels.MouseInspLineEvaluationReportPanel;
import mausoleum.inspector.panels.MousePlugDatePanel;
import mausoleum.inspector.panels.MouseResultPanel;
import mausoleum.inspector.panels.MouseTissuePanel;
import mausoleum.inspector.panels.OwnerPanel;
import mausoleum.inspector.panels.PoolPane;
import mausoleum.inspector.sensitives.CSANTag;
import mausoleum.inspector.sensitives.CSColorCoat;
import mausoleum.inspector.sensitives.CSDate;
import mausoleum.inspector.sensitives.CSDateIntTagReal;
import mausoleum.inspector.sensitives.CSEartag;
import mausoleum.inspector.sensitives.CSForeignID;
import mausoleum.inspector.sensitives.CSGeneration;
import mausoleum.inspector.sensitives.CSGenotype;
import mausoleum.inspector.sensitives.CSLicense;
import mausoleum.inspector.sensitives.CSLieferschein;
import mausoleum.inspector.sensitives.CSLine;
import mausoleum.inspector.sensitives.CSMark;
import mausoleum.inspector.sensitives.CSMatLim;
import mausoleum.inspector.sensitives.CSSex;
import mausoleum.inspector.sensitives.CSSterile;
import mausoleum.inspector.sensitives.CSStrain;
import mausoleum.inspector.sensitives.CSStressLevelMouse;
import mausoleum.inspector.sensitives.CSTextArea;
import mausoleum.inspector.sensitives.ChangeSensitive;
import mausoleum.inspector.util.ActionBundleSimple;
import mausoleum.inspector.util.InspectorCommandSender;
import mausoleum.license.License;
import mausoleum.license.LicenseManager;
import mausoleum.main.MausoleumClient;
import mausoleum.mouse.Mouse;
import mausoleum.mouse.MouseManager;
import mausoleum.mouse.TaskExtended;
import mausoleum.mouse.tierschutz.StressRule;
import mausoleum.mouse.tierschutz.TierSchutz;
import mausoleum.objectstore.CommandmanagerLicense;
import mausoleum.requester.AllgChoiceRequester;
import mausoleum.requester.calendar.CalendarRequester;
import mausoleum.requester.mouse.EartagRequester;
import mausoleum.requester.mouse.NewMiceRequester;
import mausoleum.requester.pope.PopeAlert;
import mausoleum.result.embryotransfer.EmbryoTransfer;
import mausoleum.room.RoomManager;
import mausoleum.tables.TableFrameMouse;
import mausoleum.ui.UIDef;
import mausoleum.util.InstallationType;
import mausoleum.util.Standards;

public class InspectorPanelMouse
extends InspectorPanel {
    private static final long serialVersionUID = 145681383765L;
    private static final String[] ACTION_BUTT_DEFS = new String[]{"MA_TRANSFER", "MA_EXPORT", "MA_IMPORT", "MA_LITTER", "MA_ANCESTORS", "MA_PROGENIES", "MA_SET_PLUGDATE", "MA_CLEAR_PLUGDATE", "MA_ADD_COMMENT", "MA_CLEAR_COMMENT", "MA_ADD_TASK", "MA_SHOW_TASKS", "MA_SHOWPOS", "MA_SET_PREGNANT", "MA_SET_NOT_PREGNANT", "MA_SEND_MAIL_TO_OWNERS"};
    private static final String[] ACTION_BUTT_DEFS_FISH = new String[]{"MA_TRANSFER", "MA_EXPORT", "MA_IMPORT", "MA_LITTER", "MA_ANCESTORS", "MA_PROGENIES", "MA_ADD_COMMENT", "MA_ADD_TASK", "MA_SHOW_TASKS", "MA_SHOWPOS", "MA_SEND_MAIL_TO_OWNERS"};
    private static final String[] ACTION_BUTT_DEFS_SERVICE_CARETAKER = new String[]{"MA_TRANSFER", "MA_EXPORT", "MA_IMPORT", "MA_LITTER", "MA_ANCESTORS", "MA_PROGENIES", "MA_SET_PLUGDATE", "MA_CLEAR_PLUGDATE", "MA_ADD_COMMENT", "MA_CLEAR_COMMENT", "MA_ADD_TASK", "MA_SHOW_TASKS", "MA_SHOWPOS", "MA_SET_PREGNANT", "MA_SET_NOT_PREGNANT", "MA_SEND_MAIL_TO_OWNERS"};
    private static final String[] ACTION_BUTT_DEFS_SERVICE_CARETAKER_FISH = new String[]{"MA_TRANSFER", "MA_EXPORT", "MA_IMPORT", "MA_LITTER", "MA_ANCESTORS", "MA_PROGENIES", "MA_ADD_COMMENT", "MA_ADD_TASK", "MA_SHOW_TASKS", "MA_SHOWPOS", "MA_SEND_MAIL_TO_OWNERS"};
    private static final String[] REMOVE_CHOICES_FULL = new String[]{Babel.get("BYDEATH"), Babel.get("BYSACRIFICE"), Babel.get("BYEXPORT"), Babel.get("BYREMOVAL"), Babel.get("BYDIGITALNIRVANA")};
    private static final String[] REMOVE_CHOICES_NORMAL = new String[]{Babel.get("BYDEATH"), Babel.get("BYSACRIFICE"), Babel.get("BYEXPORT"), Babel.get("BYREMOVAL")};
    private static final String[] REMOVE_TOOLTIPS_FULL = new String[]{Babel.get("EXIT_TT_TOD"), Babel.get("EXIT_TT_TOETUNG"), Babel.get("EXIT_TT_EXPORT"), Babel.get("EXIT_TT_ENTFERNUNG"), Babel.get("EXIT_TT_DIGITAL_NIRWANA")};
    private static final String[] REMOVE_TOOLTIPS_NORMAL = new String[]{Babel.get("EXIT_TT_TOD"), Babel.get("EXIT_TT_TOETUNG"), Babel.get("EXIT_TT_EXPORT"), Babel.get("EXIT_TT_ENTFERNUNG")};
    private static final int[] REMOVE_MODI_FULL = new int[]{4, 5, 6, 8, 10};
    private static final String[] REMOVE_TRAFFIC = new String[]{"TRD_BYDEATH", "TRD_BYSACRIFICE", "TRD_BYEXPORT", "TRD_BYREMOVAL", "TRD_DIGITAL_NIRVANA"};
    private static final Integer TOLERABLE_PREV_EARTAG = new Integer(0);
    public final CSEartag ivCSEartag = new CSEartag(this);
    public final CSMark ivCSMark = new CSMark(this);
    public final CSDate ivCSBirthDay = new CSDate(this, Babel.get("BIRTHDAY"));
    public final CSSex ivCSSex = new CSSex(this);
    public final CSStrain ivCSStrain = new CSStrain(this);
    public final CSLine ivCSLine = new CSLine(this);
    public final CSLicense ivCSLicense1 = new CSLicense((InspectorPanel)this, 1);
    public final CSLicense ivCSLicense2 = new CSLicense((InspectorPanel)this, 2);
    public final CSLicense ivCSLineLicense = new CSLicense((InspectorPanel)this, 4);
    public final CSGenotype ivCSGenotype = new CSGenotype(this);
    public final CSANTag ivCSANTag = new CSANTag(this);
    public final CSLieferschein ivCSLieferschein = new CSLieferschein(this);
    public final CSMatLim ivCSMatLim = new CSMatLim(this);
    public final CSColorCoat ivCSCoat = new CSColorCoat(this);
    public final CSGeneration ivCSGeneration = new CSGeneration(this);
    public final CSDateIntTagReal ivCSSpecialDate = new CSDateIntTagReal(this, "MOS_SPDAT", Babel.get("SPECIAL_DATE"));
    public final CSForeignID ivCSForeignID = new CSForeignID(this);
    public final CSSterile ivCSSterile = new CSSterile(this);
    public final CSStressLevelMouse ivStressLevelLife = TierSchutz.belastungNeeded() ? new CSStressLevelMouse((InspectorPanel)this, true) : null;
    public final CSStressLevelMouse ivStressLevelDeath = TierSchutz.belastungNeeded() ? new CSStressLevelMouse((InspectorPanel)this, false) : null;
    public final CSTextArea ivCommentField = new CSTextArea(this, "MOS_COMMENT");
    private CSLicense[] ivLicenseComps = new CSLicense[]{this.ivCSLicense1, this.ivCSLicense2};

    public InspectorPanelMouse() {
        super(1, "MOUSE");
        this.addTab(Babel.get("ATTRIBUTES"), new MouseAttributePanel());
        this.addTab(Babel.get("RESULTS"), new MouseResultPanel());
        this.addTab(Babel.get("HR_TAB_TITLE"), new MouseInspHealthReportPanel());
        if (InstallationType.isMouse()) {
            this.addTab(Babel.get("PLUGS"), new MousePlugDatePanel());
        }
        this.addTab(Babel.get("IPM_OWNERS"), new OwnerPanel(this.ivActionButtons));
        this.addTaskTable();
        this.addTab(Babel.get("POOL_NC"), new PoolPane(1, this.ivActionButtons));
        this.addTab(Babel.get("COHORTS"), new MouseCohortPanel());
        this.addCageTab(Babel.get("CAGES"), null);
        this.addTab(Babel.get("TISSUE_SAMPLES"), new MouseTissuePanel());
        if (InstallationType.isMouse() && TierSchutz.isLineEvaluationPossible()) {
            this.addTab(Babel.get("STRESS_EVALUATION"), new MouseInspLineEvaluationReportPanel());
        }
        if (InstallationType.isMouse() && EmbryoTransfer.useEmbryoTransfer() && Privileges.hasPrivilege("MOS_VIEW_EMBRYO_TRANSFER")) {
            this.addTab(Babel.get("EMBRYO_TRANSFERS"), new MouseInspEmbryoTransferPanel());
        }
    }

    public ActionBundleSimple createActionBundle() {
        String[] actions = null;
        actions = InstallationType.isFish() ? (MausoleumClient.isRegularOrTGService() ? ACTION_BUTT_DEFS_FISH : ACTION_BUTT_DEFS_SERVICE_CARETAKER_FISH) : (MausoleumClient.isRegularOrTGService() ? ACTION_BUTT_DEFS : ACTION_BUTT_DEFS_SERVICE_CARETAKER);
        return new ActionBundleSimple(actions, InstallationType.isMouse() ? 4 : 3);
    }

    public boolean isSetAllowed() {
        boolean mitToten = false;
        Vector changeSensitives = this.getTheRealChangedItems();
        Iterator iterator = changeSensitives.iterator();
        while (iterator.hasNext()) {
            ChangeSensitive cs = (ChangeSensitive)iterator.next();
            if (cs != this.ivCSMark && cs != this.ivCommentField && cs != this.ivStressLevelLife && cs != this.ivStressLevelDeath) continue;
            mitToten = true;
        }
        return mitToten ? Mouse.areMiceTouchableInclDeads(this.ivSelObjects) : Mouse.areMiceTouchable(this.ivSelObjects);
    }

    public boolean doNew(boolean withExecution) {
        boolean res = Privileges.hasPrivilege("CREATE_MICE");
        if (res && withExecution) {
            NewMiceRequester nmr = new NewMiceRequester((Frame)Inspector.getInspector(), null, MyDate.getMyDate(System.currentTimeMillis()), false);
            nmr.setVisible(true);
            if (nmr.ivWarOK) {
                String group = UserManager.getFirstGroup();
                String command = "MI";
                String raumID = null;
                String lieferschein = nmr.getLieferschein();
                if (MausoleumClient.isServiceCaretaker()) {
                    group = nmr.getGroup();
                    command = "MIRID";
                    long groupRoomID = RoomManager.getGROUPRoomIDForServiceRoom(group);
                    if (groupRoomID == -1L) {
                        return res;
                    }
                    raumID = " " + groupRoomID;
                }
                if (group != null) {
                    int frageLimit;
                    StringBuffer msb = new StringBuffer();
                    msb.append(command);
                    int anz = MALitter.getWantedAnz(nmr, Integer.MAX_VALUE);
                    if (anz <= 0) {
                        return res;
                    }
                    int n = frageLimit = InstallationType.isFish() ? 300 : 100;
                    if (anz > frageLimit) {
                        String as = Babel.get("SURE_TO_IMPORT_MANY_MICE");
                        if (!Alert.showAlert(as = StringHelper.gSub(as, "_NUM_", Integer.toString(anz)), Babel.get("OK"), Babel.get("CANCEL"), false)) {
                            return res;
                        }
                    }
                    msb.append(" ").append(anz);
                    msb.append(" ").append(nmr.getDate().getTime());
                    if (nmr.getOwnerMode() == 1) {
                        msb.append(" ").append(UserManager.getIDOFUser());
                    } else {
                        msb.append(" ").append("0");
                    }
                    msb.append(" ").append(nmr.getHerkunft());
                    if (raumID != null) {
                        msb.append(raumID);
                    }
                    msb.append(" ").append(lieferschein);
                    InspectorCommandSender.executeCommand(msb.toString(), group);
                }
            }
        }
        return res;
    }

    public boolean doRemove(boolean withExecution) {
        boolean res;
        boolean bl = res = Privileges.hasPrivilege("REMOVE_MICE") && Mouse.areMiceTouchable(this.ivSelObjects) && !Mouse.areMiceRoomAccesibilityRestricted(this.ivSelObjects);
        if (res && withExecution) {
            HashMap stressByMouse;
            boolean nirvanaPossible = true;
            int i = 0;
            while (i < this.ivSelObjects.size()) {
                Mouse maus = (Mouse)this.ivSelObjects.elementAt(i);
                if (maus.isDead()) {
                    Alert.showAlert(Babel.get("ALERTREMOVEDEADMICE"), true);
                    return res;
                }
                if (!maus.isTouchable()) {
                    Alert.showAlert(Babel.get("ALERTREMOVEFOREIGNMICE"), true);
                    return res;
                }
                if (maus.hasKids()) {
                    nirvanaPossible = false;
                }
                ++i;
            }
            boolean fullModus = nirvanaPossible && Privileges.hasPrivilege("MOS_DIGITAL_REMOVAL_ALLOWED");
            int modusSelection = AllgChoiceRequester.getIndexAnswer((Frame)Inspector.getInspector(), Babel.get("ALERTREMOVEMICE"), fullModus ? REMOVE_CHOICES_FULL : REMOVE_CHOICES_NORMAL, fullModus ? REMOVE_TOOLTIPS_FULL : REMOVE_TOOLTIPS_NORMAL);
            if (modusSelection == -1) {
                return res;
            }
            int exitModus = REMOVE_MODI_FULL[modusSelection];
            String targetAddress = null;
            Date d = CalendarRequester.getDate(Inspector.getInspector());
            if (d == null) {
                return res;
            }
            if (exitModus == 6) {
                String commonGroup = IDObject.commonGroup(this.ivSelObjects);
                if (commonGroup == null) {
                    if (Standards.isExportAdressManadatory()) {
                        Alert.showAlert(Babel.get("REMOVAL_BY_EXPORT_IMPOSSIBLE_DIV_GROUPS"), true);
                        return res;
                    }
                } else {
                    String[] target = new String[]{null};
                    if (!MAExport.getTargetAddress(commonGroup, !Standards.isExportAdressManadatory(), target)) {
                        return res;
                    }
                    targetAddress = target[0];
                }
            }
            if ((stressByMouse = KnubbelSelector.getStressLevelsForMice(this.ivSelObjects, exitModus, true, false, false, null, false)) == null) {
                return res;
            }
            StringBuilder msb = new StringBuilder();
            HashMap obsByGroup = IDObject.sortByGroup(this.ivSelObjects);
            if (obsByGroup != null) {
                Iterator iter = obsByGroup.keySet().iterator();
                while (iter.hasNext()) {
                    String group = (String)iter.next();
                    Vector mice = (Vector)obsByGroup.get(group);
                    msb.setLength(0);
                    Iterator iterator = mice.iterator();
                    while (iterator.hasNext()) {
                        Integer level;
                        Mouse mouse = (Mouse)iterator.next();
                        if (!TierSchutz.belastungNeeded()) continue;
                        int levelByLine = StressRule.getStress(mouse.getLine(), mouse);
                        if (levelByLine != 0) {
                            msb.append("MOSStressLevel").append(" ");
                            msb.append(mouse.getID()).append(" ");
                            msb.append(levelByLine).append(" ");
                            msb.append(2).append("\n");
                        }
                        if ((level = (Integer)stressByMouse.get(mouse)) == null) continue;
                        msb.append("MOSStressLevel").append(" ");
                        msb.append(mouse.getID()).append(" ");
                        msb.append(level).append(" ");
                        msb.append(1).append("\n");
                    }
                    String removeCommand = String.valueOf(msb.toString()) + ExportHelper.getRemoveMiceCommand(mice, d.getTime(), exitModus, "TASK_AC_KILL", targetAddress, StringHelper.getStringForInt(exitModus, REMOVE_MODI_FULL, REMOVE_TRAFFIC, false, null));
                    boolean res3 = InspectorCommandSender.executeCommand(removeCommand, group);
                    if (!res3 || !MausoleumClient.isServiceCaretaker()) continue;
                    Vector<Mouse> killed = new Vector<Mouse>();
                    Iterator iterator2 = mice.iterator();
                    while (iterator2.hasNext()) {
                        Mouse mouse = (Mouse)iterator2.next();
                        Mouse kmouse = MouseManager.getMouse(mouse.getID(), group);
                        if (kmouse == null) continue;
                        killed.add(kmouse);
                    }
                    if (killed.isEmpty()) continue;
                    TableFrameMouse.addKilledMice(killed);
                }
            }
        }
        return res;
    }

    public void deblockiereFelder() {
        this.ivCSMark.setToNonBlocked();
        this.ivCSBirthDay.setToNonBlocked();
        this.ivCSEartag.setToNonBlocked();
        this.ivCSGeneration.setToNonBlocked();
        this.ivCSSex.setToNonBlocked();
        this.ivCSStrain.setToNonBlocked();
        this.ivCSLine.setToNonBlocked();
        this.ivCSLicense1.setToNonBlocked();
        this.ivCSLicense2.setToNonBlocked();
        this.ivCSLineLicense.setToNonBlocked();
        this.ivCSGenotype.setToNonBlocked();
        this.ivCSANTag.setToNonBlocked();
        this.ivCSLieferschein.setToNonBlocked();
        this.ivCSMatLim.setToNonBlocked();
        this.ivCSCoat.setToNonBlocked();
        this.ivCSForeignID.setToNonBlocked();
        this.ivCSSpecialDate.setToNonBlocked();
        this.ivCSSterile.setToNonBlocked();
        if (this.ivStressLevelLife != null) {
            this.ivStressLevelLife.setToNonBlocked();
        }
        if (this.ivStressLevelDeath != null) {
            this.ivStressLevelDeath.setToNonBlocked();
        }
    }

    public void passiviereFelder() {
        this.ivCSMark.setToBlocked();
        this.ivCSBirthDay.setToBlocked();
        this.ivCSEartag.setToBlocked();
        this.ivCSGeneration.setToBlocked();
        this.ivCSSex.setToBlocked();
        this.ivCSStrain.setToBlocked();
        this.ivCSLine.setToBlocked();
        this.ivCSLicense1.setToBlocked();
        this.ivCSLicense2.setToNonBlocked();
        this.ivCSLineLicense.setToNonBlocked();
        this.ivCSGenotype.setToBlocked();
        this.ivCSANTag.setToBlocked();
        this.ivCSLieferschein.setToBlocked();
        this.ivCSMatLim.setToBlocked();
        this.ivCSCoat.setToBlocked();
        this.ivCSForeignID.setToBlocked();
        this.ivCSSpecialDate.setToBlocked();
        this.ivCSSterile.setToBlocked();
        if (this.ivStressLevelLife != null) {
            this.ivStressLevelLife.setToBlocked();
        }
        if (this.ivStressLevelDeath != null) {
            this.ivStressLevelDeath.setToBlocked();
        }
        this.disableAllActionButtons();
        this.ivCommentField.setToPassive();
    }

    public void disableFields() {
        this.ivCSMark.setToNonApplicable();
        this.ivCSBirthDay.setToNonApplicable();
        this.ivCSEartag.setToNonApplicable();
        this.ivCSGeneration.setToNonApplicable();
        this.ivCSSex.setToNonApplicable();
        this.ivCSStrain.setToNonApplicable();
        this.ivCSLine.setToNonApplicable();
        this.ivCSLicense1.setToNonApplicable();
        this.ivCSLicense2.setToNonBlocked();
        this.ivCSLineLicense.setToNonBlocked();
        this.ivCSGenotype.setToNonApplicable();
        this.ivCSForeignID.setToNonApplicable();
        this.ivCSSpecialDate.setToNonApplicable();
        this.ivCSSterile.setToNonApplicable();
        if (this.ivStressLevelLife != null) {
            this.ivStressLevelLife.setToNonApplicable();
        }
        if (this.ivStressLevelDeath != null) {
            this.ivStressLevelDeath.setToNonApplicable();
        }
        this.disableAllActionButtons();
        this.ivCommentField.setToNonApplicable();
        this.ivCSANTag.setToNonApplicable();
        this.ivCSLieferschein.setToNonApplicable();
        this.ivCSMatLim.setToNonApplicable();
        this.ivCSCoat.setToNonApplicable();
    }

    public long getLineValue() {
        return this.ivCSLine.getValue();
    }

    public Vector getMatchingMice() {
        return this.ivSelObjects;
    }

    public boolean checkSet(Vector changeSensitives) {
        int i = 0;
        while (i < changeSensitives.size()) {
            if (changeSensitives.elementAt(i) == this.ivCSBirthDay && this.ivCSBirthDay.didYouChange()) {
                if (!PopeAlert.settingOk(this.ivSelObjects, "MOS_BIRTHDAY", "POPE_BIRTHDAY")) {
                    return false;
                }
            } else if (changeSensitives.elementAt(i) == this.ivCSEartag) {
                if (this.ivCSEartag.didYouChange()) {
                    if (!PopeAlert.settingOk(this.ivSelObjects, "MOS_EARTAG", "POPE_EARTAG", TOLERABLE_PREV_EARTAG)) {
                        return false;
                    }
                    EartagRequester.BigEarTagInfo beti = this.ivCSEartag.getValue();
                    if (!PopeAlert.checkForEartagCollision(beti.ivEarTag, beti.ivPrefix == null ? "" : beti.ivPrefix, this.ivSelObjects)) {
                        return false;
                    }
                }
            } else if (changeSensitives.elementAt(i) == this.ivCSSex && this.ivCSSex.didYouChange()) {
                if (!PopeAlert.checkSex(this.ivSelObjects, "POPE_SEX")) {
                    return false;
                }
            } else if (changeSensitives.elementAt(i) == this.ivCSStrain && this.ivCSStrain.didYouChange()) {
                if (!PopeAlert.settingOk(this.ivSelObjects, "MOS_STRAIN", "POPE_STRAIN")) {
                    return false;
                }
            } else if (changeSensitives.elementAt(i) == this.ivCSLine && this.ivCSLine.didYouChange()) {
                if (!PopeAlert.settingOk(this.ivSelObjects, "MOS_LINEID", "POPE_LINE")) {
                    return false;
                }
            } else {
                int j = 0;
                while (j < this.ivLicenseComps.length) {
                    if (changeSensitives.elementAt(i) == this.ivLicenseComps[j] && this.ivLicenseComps[j].didYouChange() && !PopeAlert.settingOk(this.ivSelObjects, Mouse.getLicenseTag(this.ivLicenseComps[j].getLizenzNummer()), "POPE_LICENSE")) {
                        return false;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return true;
    }

    public String getSetCommand(Vector changeSensitives, Vector idObjects) {
        StringBuffer msb = new StringBuffer();
        int i = 0;
        while (i < changeSensitives.size()) {
            if (changeSensitives.elementAt(i) == this.ivCSMark) {
                InspectorPanelMouse.makeCommand("MSTG", this.ivCSMark.getRequestString(), 1, msb, this.ivCSMark.getAffecteds(idObjects));
            } else if (changeSensitives.elementAt(i) == this.ivCSBirthDay && this.ivCSBirthDay.didYouChange()) {
                InspectorPanelMouse.makeCommand("MSBD", this.ivCSBirthDay.getRequestString(), 1, msb, this.ivCSBirthDay.getAffecteds(idObjects));
            } else if (changeSensitives.elementAt(i) == this.ivCSEartag) {
                if (this.ivCSEartag.didYouChange()) {
                    EartagRequester.BigEarTagInfo beti = this.ivCSEartag.getValue();
                    CSEartag.cvLastSetEartag = beti.ivEarTag;
                    CSEartag.cvLastSetEartagPrefix = beti.ivPrefix;
                    String prefixCom = beti.ivPrefix != null ? Base64Manager.encodeBase64(beti.ivPrefix) : "";
                    int j = 0;
                    while (j < idObjects.size()) {
                        Vector<String> es = new Vector<String>();
                        es.addElement("MCT");
                        Mouse mouse = (Mouse)idObjects.elementAt(j);
                        int index = this.ivSelObjects.indexOf(mouse);
                        es.addElement(Integer.toString(beti.ivEarTag + index));
                        if (beti.ivEarTag + index > CSEartag.cvLastSetEartag) {
                            CSEartag.cvLastSetEartag = beti.ivEarTag + index;
                        }
                        es.addElement(prefixCom);
                        InspectorPanelMouse.addComToStrBuf(msb, InspectorPanelMouse.addIDAtPos(es, mouse, 1), mouse);
                        TaskExtended.addTaskFinishsToComBuff(mouse, mouse.getTaskKey(), "TASK_AC_EARTAG", 0L, msb, MyDate.HEUTE);
                        ++j;
                    }
                }
            } else if (changeSensitives.elementAt(i) == this.ivCSGeneration) {
                InspectorPanelMouse.makeCommand("MSETGEN", Integer.toString(this.ivCSGeneration.getValue()), 1, msb, this.ivCSGeneration.getAffecteds(idObjects));
            } else if (changeSensitives.elementAt(i) == this.ivCSSex && this.ivCSSex.didYouChange()) {
                InspectorPanelMouse.makeCommand("MCX", this.ivCSSex.getCommandValue(), 1, msb, idObjects);
                TaskExtended.addTaskFinishsToMiceComBuff(idObjects, "TASK_AC_SEX", msb, MyDate.HEUTE);
            } else if (changeSensitives.elementAt(i) == this.ivCSStrain && this.ivCSStrain.didYouChange()) {
                InspectorPanelMouse.makeCommand("MCS", this.ivCSStrain.getCommandValue(), 1, msb, this.ivCSStrain.getAffecteds(idObjects));
            } else if (changeSensitives.elementAt(i) == this.ivCSLine && this.ivCSLine.didYouChange()) {
                InspectorPanelMouse.makeCommand("MCL", this.ivCSLine.getCommandValue(), 1, msb, this.ivCSLine.getAffecteds(idObjects));
            } else if (changeSensitives.elementAt(i) == this.ivCommentField) {
                InspectorPanelMouse.makeCommand("MSETC", Base64Manager.encodeBase64(this.ivCommentField.getText()), 1, msb, this.ivCommentField.getAffecteds(idObjects));
            } else if (changeSensitives.elementAt(i) == this.ivCSANTag && this.ivCSANTag.didYouChange()) {
                InspectorPanelMouse.makeCommand("MADDANTAG", Base64Manager.encodeBase64(this.ivCSANTag.getValue()), 1, msb, this.ivCSANTag.getAffecteds(idObjects));
            } else if (changeSensitives.elementAt(i) == this.ivCSLieferschein && this.ivCSLieferschein.didYouChange()) {
                InspectorPanelMouse.makeCommand("MSTLIEFERSCHEIN", Base64Manager.encodeBase64(this.ivCSLieferschein.getValue()), 1, msb, this.ivCSLieferschein.getAffecteds(idObjects));
            } else if (changeSensitives.elementAt(i) == this.ivCSMatLim && this.ivCSMatLim.didYouChange()) {
                InspectorPanelMouse.makeCommand("MSETMATLIM", Integer.toString(this.ivCSMatLim.getValue()), 1, msb, this.ivCSMatLim.getAffecteds(idObjects));
            } else if (changeSensitives.elementAt(i) == this.ivCSCoat && this.ivCSCoat.didYouChange()) {
                InspectorPanelMouse.makeCommand("MSETCOATCOLOR", Integer.toString(this.ivCSCoat.getValue()), 1, msb, this.ivCSCoat.getAffecteds(idObjects));
            } else if (changeSensitives.elementAt(i) == this.ivCSForeignID && this.ivCSForeignID.didYouChange()) {
                InspectorPanelMouse.makeCommand("SET_FOREIGN_ID", Integer.toString(1), Base64Manager.encodeBase64(this.ivCSForeignID.getValue()), 1, msb, this.ivCSForeignID.getAffecteds(idObjects));
            } else if (changeSensitives.elementAt(i) == this.ivCSSpecialDate && this.ivCSSpecialDate.didYouChange()) {
                InspectorPanelMouse.makeCommand("MSSETSPECDATE", this.ivCSSpecialDate.getRequestString(), 1, msb, this.ivCSSpecialDate.getAffecteds(idObjects));
            } else if (changeSensitives.elementAt(i) == this.ivCSSterile && this.ivCSSterile.didYouChange()) {
                InspectorPanelMouse.makeCommand("MOSSETSTERILE", this.ivCSSterile.getValueForCommand(), 1, msb, this.ivCSSterile.getAffecteds(idObjects));
            } else if (this.ivStressLevelLife != null && changeSensitives.elementAt(i) == this.ivStressLevelLife && this.ivStressLevelLife.didYouChange()) {
                this.ivStressLevelLife.appendCommand(idObjects, msb);
            } else if (this.ivStressLevelDeath != null && changeSensitives.elementAt(i) == this.ivStressLevelDeath && this.ivStressLevelDeath.didYouChange()) {
                this.ivStressLevelDeath.appendCommand(idObjects, msb);
            } else {
                int j = 0;
                while (j < this.ivLicenseComps.length) {
                    if (changeSensitives.elementAt(i) == this.ivLicenseComps[j] && this.ivLicenseComps[j].didYouChange()) {
                        this.getLicenseSet(this.ivLicenseComps[j], idObjects, msb);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return msb.toString();
    }

    private void getLicenseSet(CSLicense licenseComponent, Vector idObjects, StringBuffer msb) {
        long licid = licenseComponent.getValue();
        if (licid == 0L) {
            Iterator iter = idObjects.iterator();
            while (iter.hasNext()) {
                CommandmanagerLicense.appendRemoveCommand((Mouse)iter.next(), msb, licenseComponent.getLizenzNummer());
            }
        } else {
            License license = licenseComponent.ivSelectedLicense;
            if (license != null && (license.isValid() || PopeAlert.getAnswer(PopeAlert.getPopeMeldung("POPE_LICENSE_NOT_VALID_NOW")))) {
                Iterator iter = idObjects.iterator();
                while (iter.hasNext()) {
                    CommandmanagerLicense.appendRemoveCommand((Mouse)iter.next(), msb, licenseComponent.getLizenzNummer());
                }
                InspectorPanelMouse.makeCommand("LIC_ADD_MOUSE", licenseComponent.getCommandValue(), Integer.toString(licenseComponent.getLizenzNummer()), 3, msb, idObjects);
            } else {
                licenseComponent.adaptToVector(this.ivSelObjects);
            }
        }
    }

    class MouseAttributePanel
    extends AttributePane {
        private static final long serialVersionUID = 5067010713733060702L;
        private int MIN_COM_HEIGHT = UIDef.getScaled(60);
        private final BorderPanel ivCommentPanel;
        private JScrollPane ivSensitivePane;

        public MouseAttributePanel() {
            InspectorPanelMouse.this.ivSensitiveTable = new SensitiveTable(InspectorPanelMouse.this.ivChangeSensitives);
            this.ivSensitivePane = new JScrollPane(InspectorPanelMouse.this.ivSensitiveTable);
            this.add(this.ivSensitivePane);
            JPanel mp2 = new JPanel(new BorderLayout());
            mp2.setOpaque(false);
            mp2.add((Component)new JScrollPane(InspectorPanelMouse.this.ivCommentField), "Center");
            this.ivCommentPanel = new BorderPanel(mp2, Babel.get("COMMENTS"));
            this.add(this.ivCommentPanel);
        }

        public void layoutContainer(Container parent) {
            int sensiHeight;
            int commentHeight;
            Insets insets;
            Dimension d = parent.getSize();
            int innerRand = 2;
            int extra = 5;
            if (this.ivSensitivePane != null && (insets = this.ivSensitivePane.getInsets()) != null) {
                extra = insets.top + insets.bottom;
            }
            if ((commentHeight = d.height - ((sensiHeight = InspectorPanelMouse.this.ivSensitiveTable.getPreferredSize().height + extra) + innerRand)) < this.MIN_COM_HEIGHT) {
                commentHeight = this.MIN_COM_HEIGHT;
                sensiHeight = d.height - (commentHeight + innerRand);
            }
            int y = 0;
            this.ivSensitivePane.setBounds(0, y, d.width, sensiHeight);
            this.ivCommentPanel.setBounds(0, y += sensiHeight + innerRand, d.width, commentHeight);
        }

        public void adapt(Vector idObjects, Vector mice, Vector changeSensitives) {
            super.adapt(idObjects, mice, changeSensitives);
            if (idObjects != null && !idObjects.isEmpty()) {
                String commonGroup = IDObject.commonGroup(InspectorPanelMouse.this.ivSelObjects);
                boolean oneGroup = commonGroup != null;
                boolean darf = Mouse.areMiceTouchable(InspectorPanelMouse.this.ivSelObjects);
                boolean darfMitToten = Mouse.areMiceTouchableInclDeads(InspectorPanelMouse.this.ivSelObjects);
                boolean darfInRaum = darf && !Mouse.areMiceRoomAccesibilityRestricted(InspectorPanelMouse.this.ivSelObjects);
                boolean darfLizenzen = darf && oneGroup && LicenseManager.hasAllowedLicenses(commonGroup, true);
                InspectorPanelMouse.this.ivCSMark.setState(darfMitToten && Privileges.hasPrivilege("MOS_CH_MARK"));
                InspectorPanelMouse.this.ivCSBirthDay.setState(darf && Privileges.hasPrivilege("MOS_CH_BIRTHDAY"));
                InspectorPanelMouse.this.ivCSEartag.setState(darfInRaum && InspectorPanelMouse.this.ivCSEartag.doPrivilegesMatch());
                InspectorPanelMouse.this.ivCSGeneration.setState(darf && Privileges.hasPrivilege("MOS_CH_GENERATION"));
                InspectorPanelMouse.this.ivCSSex.setState(darfInRaum && Privileges.hasPrivilege("MOS_CH_SEX"));
                InspectorPanelMouse.this.ivCSStrain.setState(darf && oneGroup && Privileges.hasPrivilege("MOS_CH_STRAIN"));
                InspectorPanelMouse.this.ivCSLine.setState(darf && oneGroup && Privileges.hasPrivilege("MOS_CH_LINE"));
                InspectorPanelMouse.this.ivCSLicense1.setState(darfLizenzen);
                InspectorPanelMouse.this.ivCSLicense2.setState(darfLizenzen);
                InspectorPanelMouse.this.ivCSLineLicense.setState(false);
                InspectorPanelMouse.this.ivCSANTag.setState(darf && Privileges.hasPrivilege("MOS_CH_TAG"));
                InspectorPanelMouse.this.ivCSLieferschein.setState(darf && Privileges.hasPrivilege("MOS_CH_LIEFERSCHEIN"));
                InspectorPanelMouse.this.ivCSMatLim.setState(darf && Privileges.hasPrivilege("MOS_CH_MATLIM"));
                InspectorPanelMouse.this.ivCSCoat.setState(darfInRaum && Privileges.hasPrivilege("MOS_CH_COAT_COLOR"));
                InspectorPanelMouse.this.ivCSForeignID.setState(darf && idObjects.size() == 1 && Privileges.hasPrivilege("EDIT_FOREIGN_ID"));
                InspectorPanelMouse.this.ivCSSpecialDate.setState(darfMitToten && Privileges.hasPrivilege("MOS_SET_SPECIAL_DATE"));
                InspectorPanelMouse.this.ivCSSterile.setState(darf && Privileges.hasPrivilege("MOS_SET_STERILE") && InspectorPanelMouse.this.ivCSSterile.isAllowed(idObjects));
                if (idObjects.size() == 1) {
                    InspectorPanelMouse.this.ivCommentField.setState(darfMitToten && Privileges.hasPrivilege("MOS_CH_COMMENT"));
                } else {
                    InspectorPanelMouse.this.ivCommentField.setToNonApplicable();
                }
            }
        }
    }
}

