/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.ArrayHelper;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.RequestManager;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.alert.Alert;
import mausoleum.helper.ZeileAbstr;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.InspectorPanel;
import mausoleum.inspector.SensitiveTable;
import mausoleum.inspector.actions.usergroup.UsergroupAction;
import mausoleum.inspector.panels.AttributePane;
import mausoleum.inspector.panels.GrantedGroupsPane;
import mausoleum.inspector.panels.QuotaPane;
import mausoleum.inspector.panels.RackInspHealthResultPanel;
import mausoleum.inspector.sensitives.CSTextField;
import mausoleum.inspector.sensitives.CSTextFieldName;
import mausoleum.inspector.sensitives.CSTextFieldTag;
import mausoleum.inspector.sensitives.ChangeSensitive;
import mausoleum.inspector.util.ActionBundleSimple;
import mausoleum.main.MausoleumClient;
import mausoleum.rack.Rack;
import mausoleum.rack.RackManager;
import mausoleum.requester.AllgChoiceRequester;
import mausoleum.requester.calendar.CalendarRequester;
import mausoleum.requester.pope.PopeAlert;
import mausoleum.requester.rack.NewRackRequester;
import mausoleum.room.Room;
import mausoleum.room.RoomManager;

public class InspectorPanelRack
extends InspectorPanel {
    private static final long serialVersionUID = 145684313L;
    private static final String[] ACTION_BUTT_DEFS = new String[]{"IPR_MOVE", "IPR_OVERVIEW"};
    public CSTextField ivNameField = new CSTextFieldName(this);
    public CSTextField ivHaltungsFormField = new CSTextFieldTag(this, "RCK_HAFO", Babel.get("RES_TS_WB_HALTUNGSFORM"));
    private final ChangeSensitive[] ivCSArr = new ChangeSensitive[]{this.ivNameField, this.ivHaltungsFormField};

    public InspectorPanelRack() {
        super(3, "RACKS");
        this.addTab(Babel.get("ATTRIBUTES"), new RackAttributePanel());
        if (MausoleumClient.isHeadOfService()) {
            this.addTab(Babel.get("GROUPS"), new GrantedGroupsPane(3, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String ac = e.getActionCommand();
                    int ind = ac.indexOf(" ");
                    if (ind != -1) {
                        UsergroupAction.invalidateRackStatus(ac.substring(ind + 1, ac.length()));
                    }
                }
            }));
            this.addTab(Babel.get("QUOTA"), new QuotaPane());
            if (Privileges.hasPrivilege("RCK_VIEW_HEALTHREPORT")) {
                this.addTab(Babel.get("RACK_HEALTH_REPORTS"), new RackInspHealthResultPanel());
            }
        }
    }

    public ActionBundleSimple createActionBundle() {
        String[] orig = ACTION_BUTT_DEFS;
        if (MausoleumClient.isHeadOfService() && Privileges.hasPrivilege("RCK_VIEW_HEALTHREPORT")) {
            orig = ArrayHelper.enlargeStringArray(orig, "IPR_RACKHEALTH");
        }
        return new ActionBundleSimple(orig);
    }

    public boolean isSetAllowed() {
        return !this.ivSelObjects.isEmpty();
    }

    public void passiviereFelder() {
        this.setToPassive(this.ivCSArr);
    }

    public void disableFields() {
        this.setToNonApplicable(this.ivCSArr);
    }

    public String getSetCommand(Vector changeSensitives, Vector idObjects) {
        StringBuffer msb = new StringBuffer();
        int i = 0;
        while (i < changeSensitives.size()) {
            if (changeSensitives.elementAt(i) == this.ivNameField) {
                String nname = this.ivNameField.getText().trim();
                if (nname.length() == 0) {
                    Alert.showAlert(Babel.get("EMPTY_NOT_ALLOWED"), true);
                    this.adjustToSelectionChange(this.ivActTable);
                    return null;
                }
                Vector v = RackManager.cvInstance.getActualObjectVector(UserManager.getFirstGroup());
                boolean nameTaken = false;
                Iterator iter = v.iterator();
                while (iter.hasNext()) {
                    Rack room = (Rack)iter.next();
                    if (!room.getString("RCK_NAME", "").equals(nname)) continue;
                    nameTaken = true;
                }
                if (nameTaken) {
                    Alert.showAlert(Babel.get("RACKALREADYPRESENT"), true);
                    this.adjustToSelectionChange(this.ivActTable);
                    return null;
                }
                InspectorPanelRack.makeCommand("RKNAME", Base64Manager.encodeBase64(nname), 1, msb, idObjects);
            } else if (changeSensitives.elementAt(i) == this.ivHaltungsFormField) {
                InspectorPanelRack.makeCommand("RKHAFO", Base64Manager.encodeBase64(this.ivHaltungsFormField.getText()), 1, msb, this.ivHaltungsFormField.getAffecteds(idObjects));
            }
            ++i;
        }
        return msb.toString();
    }

    public boolean doNew(boolean withExecution) {
        return InspectorPanelRack.doNewST(withExecution);
    }

    public static boolean doNewST(boolean withExecution) {
        boolean res = false;
        if (Privileges.hasPrivilege("CREATE_RACK")) {
            Date myDate;
            String srcString;
            if (MausoleumClient.isRegularOrTGService()) {
                res = true;
            } else if (MausoleumClient.isHeadOfService()) {
                Vector rooms = RoomManager.getActualObjects("service");
                boolean bl = res = !rooms.isEmpty();
            }
            if (res && withExecution && (srcString = NewRackRequester.getSRCNString(Inspector.getInspector(), UserManager.getFirstGroup())) != null && (myDate = CalendarRequester.getDate(Inspector.getInspector())) != null) {
                if (MausoleumClient.isRegularOrTGService()) {
                    String group = UserManager.getFirstGroup();
                    RequestManager.sendCommandRequestAndGetAnswer("RKNSRCN " + srcString + " " + Long.toString(myDate.getTime()), group);
                    if (!"service".equals(group)) {
                        String petzText = "<html><body>User <b>" + UserManager.getNameOfUser() + "</b> created a a new Rack (\"" + ZeileAbstr.getStringB64(srcString, ' ', 3, "?") + "\") for group " + UserManager.getFirstGroup() + "</body></html>";
                        PopeAlert.petze("New rack in regular group", petzText, "service", "PETZ_NEW_RACK_IN_NORMAL_GROUP");
                    }
                } else if (MausoleumClient.isHeadOfService()) {
                    Vector rooms = RoomManager.getActualObjects("service");
                    Collections.sort(rooms, IDObject.SORTER_BY_NAME);
                    Vector<String> names = new Vector<String>();
                    Iterator iter = rooms.iterator();
                    while (iter.hasNext()) {
                        Room room = (Room)iter.next();
                        names.add(room.getBrowseName());
                    }
                    int index = AllgChoiceRequester.getIndexAnswer((Frame)Inspector.getInspector(), Babel.get("SELECT_ROOM_FOR_NEW_RACK"), names);
                    if (index >= 0 && index < rooms.size()) {
                        Room selRoom = (Room)rooms.elementAt(index);
                        RequestManager.sendCommandRequestAndGetAnswer("RKNSRCN_ROOM " + srcString + " " + Long.toString(myDate.getTime()) + " " + selRoom.getID(), UserManager.getFirstGroup());
                    }
                }
            }
        }
        return res;
    }

    public boolean doRemove(boolean withExecution) {
        Date myDate;
        Rack rack;
        boolean res = false;
        if (Privileges.hasPrivilege("REMOVE_RACK") && this.ivSelObjects.size() == 1 && (res = (rack = (Rack)this.ivSelObjects.firstElement()).isEmptyAlsoWithShareds()) && withExecution && (myDate = CalendarRequester.getDate(Inspector.getInspector())) != null) {
            String com = "RKR " + Long.toString(rack.getID()) + " " + Long.toString(myDate.getTime());
            RequestManager.sendCommandRequestAndGetAnswer(com, UserManager.getFirstGroup());
        }
        return res;
    }

    class RackAttributePanel
    extends AttributePane {
        private static final long serialVersionUID = 5067010713733060702L;

        public RackAttributePanel() {
            InspectorPanelRack.this.ivSensitiveTable = new SensitiveTable(InspectorPanelRack.this.ivChangeSensitives);
            this.add(InspectorPanelRack.this.ivSensitiveTable);
        }

        public void layoutContainer(Container parent) {
            Dimension d = parent.getSize();
            int x = Inspector.INTER_BUT;
            int w = d.width - 2 * Inspector.INTER_BUT;
            int y = Inspector.INTER_BUT;
            int sh = InspectorPanelRack.this.ivSensitiveTable.getPreferredSize().height;
            InspectorPanelRack.this.ivSensitiveTable.setBounds(x, y, w, sh);
            y += sh + Inspector.RAND;
        }

        public void adapt(Vector idObjects, Vector mice, Vector changeSensitives) {
            super.adapt(idObjects, mice, changeSensitives);
            if (idObjects == null || idObjects.isEmpty()) {
                this.disableAllSensitives(InspectorPanelRack.this.ivChangeSensitives);
            } else if (idObjects.size() == 1) {
                Rack rack = (Rack)InspectorPanelRack.this.ivSelObjects.elementAt(0);
                InspectorPanelRack.this.ivNameField.setState(Privileges.hasPrivilege("NAME_RACK") && !rack.isSharedWithOtherGroups());
                InspectorPanelRack.this.ivHaltungsFormField.setState(Privileges.hasPrivilege("NAME_RACK") && !rack.isSharedWithOtherGroups());
            } else {
                InspectorPanelRack.this.ivNameField.setToNonApplicable();
                boolean shared = false;
                Iterator iterator = InspectorPanelRack.this.ivSelObjects.iterator();
                while (iterator.hasNext()) {
                    Rack rack = (Rack)iterator.next();
                    shared |= rack.isSharedWithOtherGroups();
                }
                InspectorPanelRack.this.ivHaltungsFormField.setState(Privileges.hasPrivilege("NAME_RACK") && !shared);
            }
        }
    }
}

