/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.ArrayHelper;
import de.hannse.netobjects.util.Babel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import mausoleum.alert.Alert;
import mausoleum.gui.BorderPanel;
import mausoleum.gui.MLabel;
import mausoleum.helper.FontManager;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.InspectorPanel;
import mausoleum.inspector.SensitiveTable;
import mausoleum.inspector.actions.room.RoomAction;
import mausoleum.inspector.panels.AttributePane;
import mausoleum.inspector.panels.QuotaPane;
import mausoleum.inspector.sensitives.CSAccessible;
import mausoleum.inspector.sensitives.CSSecurityLevel;
import mausoleum.inspector.sensitives.CSTextArea;
import mausoleum.inspector.sensitives.CSTextField;
import mausoleum.inspector.sensitives.CSTextFieldName;
import mausoleum.inspector.util.ActionBundleSimple;
import mausoleum.inspector.util.InspectorCommandSender;
import mausoleum.main.MausoleumClient;
import mausoleum.rack.Rack;
import mausoleum.rack.RackManager;
import mausoleum.requester.TextRequester;
import mausoleum.requester.pope.PopeAlert;
import mausoleum.room.Room;
import mausoleum.room.RoomManager;
import mausoleum.room.RoomStatusListener;
import mausoleum.ui.UIDef;

public class InspectorPanelRoom
extends InspectorPanel
implements RoomStatusListener {
    private static final long serialVersionUID = 2948534710284070955L;
    private static final int STATUS_HEIGHT = UIDef.getScaled(65);
    private static final String[] ACTION_BUTT_DEFS = new String[]{"ROA_USE_ALL", "ROA_USE_THIS"};
    private static final String[] ACTION_BUTT_DEFS_HOS = new String[]{"ROA_SET_BUILDING", "ROA_REMOVE_EMPTY_CAGES"};
    public CSTextField ivNameField = new CSTextFieldName(this);
    public CSSecurityLevel ivSecurityButton = new CSSecurityLevel(this);
    private CSTextArea ivCommentField = new CSTextArea(this, "ROM_DESC");
    private CSTextArea ivBaubesonderheitenField = new CSTextArea(this, "ROM_BBS");
    private MLabel ivStatusLabel = null;
    private JTextArea ivRackField = null;
    public CSAccessible ivAccesible = null;

    public InspectorPanelRoom() {
        super(10, "ROOM");
        if (MausoleumClient.isHeadOfService()) {
            this.ivAccesible = new CSAccessible(this);
        }
        this.addTab(Babel.get("ATTRIBUTES"), new RoomAttributePanel());
        if (MausoleumClient.isHeadOfService()) {
            this.addTab(Babel.get("QUOTA"), new QuotaPane());
        }
        this.addDocumentsTab("ROM_ADD_DOC", "ROM_REM_DOC", "ROM_GET_DOC");
        RoomAction.addListener(this);
    }

    public ActionBundleSimple createActionBundle() {
        String[] orig = null;
        if (MausoleumClient.isHeadOfService()) {
            orig = ACTION_BUTT_DEFS_HOS;
            if (Privileges.hasPrivilege("RCK_VIEW_HEALTHREPORT")) {
                orig = ArrayHelper.enlargeStringArray(orig, "IPR_RACKHEALTH");
            }
        } else if (MausoleumClient.isRegularOrTGService()) {
            orig = ACTION_BUTT_DEFS;
        }
        return new ActionBundleSimple(orig);
    }

    public boolean isSetAllowed() {
        return !this.ivSelObjects.isEmpty();
    }

    public boolean doNew(boolean withExecution) {
        String ns;
        boolean res;
        boolean bl = res = (MausoleumClient.isRegularOrTGService() || MausoleumClient.isHeadOfService()) && Privileges.hasPrivilege("CREATE_ROOM");
        if (res && withExecution && (ns = TextRequester.displayTextRequester(Inspector.getInspector(), Babel.get("NEW_ROOM"))) != null) {
            if ((ns = ns.trim()).length() == 0) {
                Alert.showAlert(Babel.get("ALERTNOBLANKS"), true);
            } else {
                InspectorCommandSender.executeCommand("ROMNEW " + Base64Manager.encodeBase64(ns), UserManager.getFirstGroup());
            }
        }
        return res;
    }

    public boolean doRemove(boolean withExecution) {
        boolean res = false;
        if (Privileges.hasPrivilege("REMOVE_ROOM") && this.ivSelObjects.size() == 1) {
            Room room = (Room)this.ivSelObjects.firstElement();
            boolean bl = res = !room.isSharedWithOtherGroups() && !RackManager.istEinRackInRaum(room.getID(), room.getGroup());
            if (res && withExecution) {
                boolean aktRoomChanged = false;
                if (RoomAction.cvRoomID == room.getID()) {
                    RoomAction.cvRoomID = 0L;
                    aktRoomChanged = true;
                }
                InspectorCommandSender.executeCommand("ROMRM " + room.getID(), room.getGroup());
                if (aktRoomChanged) {
                    this.roomStatusChanged();
                }
            }
        }
        return res;
    }

    public void passiviereFelder() {
        this.ivNameField.setToPassive();
        this.ivCommentField.setToPassive();
        this.ivBaubesonderheitenField.setToPassive();
        this.ivSecurityButton.setToPassive();
        if (this.ivAccesible != null) {
            this.ivAccesible.setToPassive();
        }
    }

    public void disableFields() {
        this.ivNameField.setToNonApplicable();
        this.ivCommentField.setToNonApplicable();
        this.ivBaubesonderheitenField.setToNonApplicable();
        this.ivRackField.setText("");
        this.ivRackField.setBackground(Color.lightGray);
        if (this.ivAccesible != null) {
            this.ivAccesible.setToNonApplicable();
        }
    }

    public void roomStatusChanged() {
        if (MausoleumClient.isRegularOrTGService()) {
            Room room = RoomAction.cvRoomID == 0L ? null : RoomManager.getRoom(RoomAction.cvRoomID, UserManager.getFirstGroup());
            this.ivStatusLabel.setText(room == null ? Babel.get("USINGALLROOMS") : String.valueOf(Babel.get("USINGROOM")) + ": " + room.getName());
            this.ivStatusLabel.setBackground(room != null ? Color.red : null);
            this.ivStatusLabel.setForeground(room != null ? Color.white : Color.black);
            this.ivStatusLabel.setOpaque(room != null);
            this.manageButEnabling("ROA_USE_ALL", null, true);
            this.manageButEnabling("ROA_USE_THIS", null, true);
            this.repaint();
        }
    }

    public boolean checkSet(Vector changeSensitives) {
        int i = 0;
        while (i < changeSensitives.size()) {
            if (changeSensitives.elementAt(i) == this.ivSecurityButton && this.ivSecurityButton.didYouChange() && !PopeAlert.settingOk(this.ivSelObjects, "ROM_SECURITY", "POPE_SECURITY_LEVEL")) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String getSetCommand(Vector changeSensitives, Vector idObjects) {
        StringBuffer msb = new StringBuffer();
        int i = 0;
        while (i < changeSensitives.size()) {
            if (changeSensitives.elementAt(i) == this.ivNameField) {
                String nname = this.ivNameField.getText().trim();
                if (nname.length() == 0) {
                    Alert.showAlert(Babel.get("EMPTY_NOT_ALLOWED"), true);
                    this.adjustToSelectionChange(this.ivActTable);
                    return null;
                }
                Vector v = RoomManager.cvInstance.getActualObjectVector(UserManager.getFirstGroup());
                boolean nameTaken = false;
                Iterator iter = v.iterator();
                while (iter.hasNext()) {
                    Room room = (Room)iter.next();
                    if (!room.getString("ROM_NAME", "").equals(nname)) continue;
                    nameTaken = true;
                }
                if (nameTaken) {
                    Alert.showAlert(Babel.get("ROOMALREADYPRESENT"), true);
                    this.adjustToSelectionChange(this.ivActTable);
                    return null;
                }
                InspectorPanelRoom.makeCommand("ROMCHNAME", Base64Manager.encodeBase64(nname), 1, msb, idObjects);
            } else if (changeSensitives.elementAt(i) == this.ivCommentField) {
                InspectorPanelRoom.makeCommand("ROMCHCOMMENT", Base64Manager.encodeBase64(this.ivCommentField.getText()), 1, msb, this.ivCommentField.getAffecteds(idObjects));
            } else if (changeSensitives.elementAt(i) == this.ivBaubesonderheitenField) {
                InspectorPanelRoom.makeCommand("ROMCHBAUBESONDERHEITEN", Base64Manager.encodeBase64(this.ivBaubesonderheitenField.getText()), 1, msb, this.ivBaubesonderheitenField.getAffecteds(idObjects));
            } else if (this.ivAccesible != null && changeSensitives.elementAt(i) == this.ivAccesible) {
                InspectorPanelRoom.makeCommand("ROMSET_ACCESSIBLE", this.ivAccesible.getValue(), 1, msb, this.ivAccesible.getAffecteds(idObjects));
            } else if (changeSensitives.elementAt(i) == this.ivSecurityButton) {
                InspectorPanelRoom.makeCommand("ROMCHSECURITY", Integer.toString(this.ivSecurityButton.getValue()), 1, msb, this.ivSecurityButton.getAffecteds(idObjects));
            }
            ++i;
        }
        return msb.toString();
    }

    class RoomAttributePanel
    extends AttributePane {
        private static final long serialVersionUID = 5067010713733060702L;
        private BorderPanel ivAP_Status = null;
        private BorderPanel ivAP_Comment = null;
        private JSplitPane ivAP_Racks_ETC = new JSplitPane(0);

        public RoomAttributePanel() {
            InspectorPanelRoom.this.ivSensitiveTable = new SensitiveTable(InspectorPanelRoom.this.ivChangeSensitives);
            this.add(InspectorPanelRoom.this.ivSensitiveTable);
            if (MausoleumClient.isRegularOrTGService()) {
                InspectorPanelRoom.this.ivStatusLabel = new MLabel(Babel.get("USINGALLROOMS"), 0);
                InspectorPanelRoom.this.ivStatusLabel.setFont(FontManager.getFont("SSB24"));
                InspectorPanelRoom.this.ivStatusLabel.setOpaque(false);
                JPanel mpStatus = new JPanel(new BorderLayout());
                mpStatus.setOpaque(false);
                mpStatus.add((Component)InspectorPanelRoom.this.ivStatusLabel, "Center");
                this.ivAP_Status = new BorderPanel(mpStatus, Babel.get("ROOMSTATUS"));
                this.add(this.ivAP_Status);
            }
            JPanel mp = new JPanel(new BorderLayout());
            mp.setOpaque(false);
            mp.add("Center", new JScrollPane(InspectorPanelRoom.this.ivCommentField));
            this.ivAP_Comment = new BorderPanel(mp, Babel.get("DESCRIPTION"));
            this.add(this.ivAP_Comment);
            InspectorPanelRoom.this.ivRackField = new JTextArea();
            InspectorPanelRoom.this.ivRackField.setEnabled(false);
            InspectorPanelRoom.this.ivRackField.setEditable(false);
            InspectorPanelRoom.this.ivRackField.setFont(FontManager.getFont("SSB12"));
            InspectorPanelRoom.this.ivRackField.setDisabledTextColor(Color.black);
            InspectorPanelRoom.this.ivRackField.setMargin(new Insets(UIDef.getScaled(4), UIDef.getScaled(4), UIDef.getScaled(4), UIDef.getScaled(4)));
            JScrollPane jsp = new JScrollPane(InspectorPanelRoom.this.ivRackField);
            mp = new JPanel(new BorderLayout());
            mp.setOpaque(false);
            mp.add((Component)new JScrollPane(jsp), "Center");
            this.ivAP_Racks_ETC.add(new BorderPanel(mp, Babel.get("RACKS")));
            mp = new JPanel(new BorderLayout());
            mp.setOpaque(false);
            mp.add("Center", new JScrollPane(InspectorPanelRoom.this.ivBaubesonderheitenField));
            this.ivAP_Racks_ETC.add(new BorderPanel(mp, Babel.get("RES_TS_WB_AKT_BESONDERHEITEN")));
            this.ivAP_Racks_ETC.setResizeWeight(0.6);
            this.ivAP_Racks_ETC.setOpaque(false);
            this.add(this.ivAP_Racks_ETC);
        }

        public void layoutContainer(Container parent) {
            Dimension d = parent.getSize();
            int x = Inspector.INTER_BUT;
            int w = d.width - 2 * Inspector.INTER_BUT;
            int y = Inspector.INTER_BUT;
            if (this.ivAP_Status != null) {
                this.ivAP_Status.setBounds(x, y, w, STATUS_HEIGHT);
                y += STATUS_HEIGHT + Inspector.RAND;
            }
            int sh = InspectorPanelRoom.this.ivSensitiveTable.getPreferredSize().height;
            InspectorPanelRoom.this.ivSensitiveTable.setBounds(x, y, w, sh);
            int lw = (w - Inspector.INTER_BUT) / 2;
            int rw = w - Inspector.INTER_BUT - lw;
            int rh = d.height - 2 * Inspector.INTER_BUT - (y += sh + Inspector.RAND);
            this.ivAP_Comment.setBounds(x, y, lw, rh);
            this.ivAP_Racks_ETC.setBounds(x + Inspector.INTER_BUT + lw, y, rw, rh);
        }

        public void adapt(Vector idObjects, Vector mice, Vector changeSensitives) {
            super.adapt(idObjects, mice, changeSensitives);
            if (idObjects == null || idObjects.isEmpty()) {
                InspectorPanelRoom.this.ivRackField.setText("");
                InspectorPanelRoom.this.ivRackField.setBackground(null);
                InspectorPanelRoom.this.ivRackField.setOpaque(false);
            } else if (idObjects.size() == 1) {
                Room room = (Room)InspectorPanelRoom.this.ivSelObjects.elementAt(0);
                InspectorPanelRoom.this.ivNameField.setState(Privileges.hasPrivilege("ROM_CH_NAME") && !room.isSharedWithOtherGroups());
                InspectorPanelRoom.this.ivCommentField.setState(Privileges.hasPrivilege("ROM_CH_DESCRIPRION") && !room.isSharedWithOtherGroups());
                InspectorPanelRoom.this.ivBaubesonderheitenField.setState(Privileges.hasPrivilege("ROM_CH_DESCRIPRION") && !room.isSharedWithOtherGroups());
                InspectorPanelRoom.this.ivSecurityButton.setState(Privileges.hasPrivilege("ROM_CHANGE_SECURITY") && !room.isSharedWithOtherGroups());
                if (InspectorPanelRoom.this.ivAccesible != null) {
                    InspectorPanelRoom.this.ivAccesible.setState(Privileges.hasPrivilege("ROM_CH_ACCESIBILITY") && room.isServiceGroupObject());
                }
                long rid = room.getID();
                StringBuffer msb = new StringBuffer();
                Vector v = RackManager.getRacksInRoom(rid);
                if (v != null) {
                    Collections.sort(v, IDObject.SORTER_BY_NAME);
                    int i = 0;
                    while (i < v.size()) {
                        Rack rck = (Rack)v.elementAt(i);
                        msb.append(rck.getName()).append("\n");
                        ++i;
                    }
                }
                InspectorPanelRoom.this.ivRackField.setText(msb.toString());
                InspectorPanelRoom.this.ivRackField.setBackground(Color.white);
                InspectorPanelRoom.this.ivRackField.setOpaque(true);
            } else {
                InspectorPanelRoom.this.ivRackField.setText("");
                InspectorPanelRoom.this.ivRackField.setBackground(null);
                InspectorPanelRoom.this.ivRackField.setOpaque(false);
                this.disableAllSensitives(InspectorPanelRoom.this.ivChangeSensitives);
            }
        }
    }
}

