/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector.actions.cage;

import de.hannse.netobjects.objectstore.CommandManagerExecutive;
import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.util.Babel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.alert.Alert;
import mausoleum.cage.Cage;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.actions.cage.CageAction;
import mausoleum.inspector.util.InspectorCommandSender;
import mausoleum.mouse.Mouse;
import mausoleum.requester.MoreTextRequester;

public class CACommentAdd
extends CageAction {
    public String getBabel() {
        return "ADDCOMMENT";
    }

    public boolean checkAction(Vector idObjects, boolean withExecution, String commonGroup, boolean touchable) {
        boolean res = false;
        if (idObjects != null && !idObjects.isEmpty() && touchable && Privileges.hasPrivilege("CAG_CH_COMMENT")) {
            String commentToAdd;
            res = true;
            if (withExecution && (commentToAdd = MoreTextRequester.getText(Inspector.getInspector(), Babel.get("ENTER_ADD_COMMENT"))) != null && commentToAdd.trim().length() != 0) {
                boolean alsoToMice = Alert.showAlert(Babel.get("ADD_COMMENT_TO_MICE"), Babel.get("YES"), Babel.get("NO"), false);
                commentToAdd = Base64Manager.encodeBase64(commentToAdd.trim());
                HashMap obsByGroup = IDObject.sortByGroup(idObjects);
                if (obsByGroup != null) {
                    Iterator iter = obsByGroup.keySet().iterator();
                    while (iter.hasNext()) {
                        String group = (String)iter.next();
                        Vector obs = (Vector)obsByGroup.get(group);
                        StringBuffer msb = new StringBuffer();
                        int j = 0;
                        while (j < obs.size()) {
                            Cage cage = (Cage)obs.elementAt(j);
                            msb.append(CommandManagerExecutive.getServiceRoomTag(cage, ""));
                            msb.append("CADDC").append(" ");
                            msb.append(cage.getID()).append(" ");
                            msb.append(commentToAdd).append("\n");
                            if (alsoToMice) {
                                Vector v = new Vector();
                                cage.addActualMice(v);
                                int i = 0;
                                while (i < v.size()) {
                                    Mouse mouse = (Mouse)v.elementAt(i);
                                    if (mouse != null) {
                                        msb.append(CommandManagerExecutive.getServiceRoomTag(mouse, ""));
                                        msb.append("MADDC").append(" ");
                                        msb.append(mouse.getID()).append(" ");
                                        msb.append(commentToAdd).append("\n");
                                    }
                                    ++i;
                                }
                                v.clear();
                                v = null;
                            }
                            ++j;
                        }
                        InspectorCommandSender.executeCommand(msb.toString(), group);
                    }
                }
            }
        }
        return res;
    }
}

