/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector.actions.cage;

import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.user.User;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.Log;
import de.hannse.netobjects.util.MyDate;
import java.awt.Frame;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.alert.Alert;
import mausoleum.cage.Cage;
import mausoleum.helper.ExportHelper;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.actions.cage.CageAction;
import mausoleum.inspector.util.InspectorCommandSender;
import mausoleum.mail.Mail;
import mausoleum.main.MausoleumClient;
import mausoleum.rack.Rack;
import mausoleum.rack.RackManager;
import mausoleum.rack.RackPos;
import mausoleum.reports.TrafficReport;
import mausoleum.requester.mouse.MouseGroupTransferRequester;
import mausoleum.requester.pope.PopeAlert;
import mausoleum.room.RoomManager;

public class CAGroupTransfer
extends CageAction {
    static /* synthetic */ Class class$0;

    private static boolean checkPresenceOfObjects(HashSet locusIDs, HashSet lineIDs, HashSet strainIDs, String group) {
        return CAGroupTransfer.checkPresenceOfObjects(locusIDs, 14, group) && CAGroupTransfer.checkPresenceOfObjects(lineIDs, 7, group) && CAGroupTransfer.checkPresenceOfObjects(strainIDs, 8, group);
    }

    private static boolean checkPresenceOfObjects(HashSet ids, int type, String group) {
        if (ids != null) {
            Iterator iterator = ids.iterator();
            while (iterator.hasNext()) {
                Long id = (Long)iterator.next();
                if (ObjectStore.getObjectDeadOrAlive(type, id, group, null, false) != null) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean checkCommonRack(Vector cages, Rack[] target) {
        Cage cage = (Cage)cages.firstElement();
        target[0] = cage.getRack();
        if (cages.size() > 1) {
            int i = 1;
            while (i < cages.size()) {
                cage = (Cage)cages.elementAt(i);
                if (target[0] == null ? cage.getRack() != null : !target[0].equals(cage.getRack())) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private static boolean checkCagesForExport1(Vector cages) {
        Iterator iter = cages.iterator();
        while (iter.hasNext()) {
            Cage cage = (Cage)iter.next();
            if (!cage.isAliveAndVisible()) {
                return false;
            }
            if (!cage.hasSuperCage() && !cage.hasSubCages()) continue;
            return false;
        }
        return true;
    }

    private static boolean checkCagesForExport2(Vector cages, String targetGroup) {
        Iterator iter = cages.iterator();
        while (iter.hasNext()) {
            long serviceID;
            Cage cage = (Cage)iter.next();
            RackPos rp = (RackPos)cage.get("CAG_POS");
            if (rp == null) continue;
            Rack targetRack = null;
            Rack sourceRack = (Rack)ObjectStore.getObjectDeadOrAlive(3, rp.ivRackID, cage.getGroup(), null, false);
            if (sourceRack != null && (serviceID = sourceRack.getLong("IDO_SERVID", -1L)) != -1L) {
                Vector trv = RackManager.cvInstance.getActualObjectVector(targetGroup);
                Iterator iterator = trv.iterator();
                while (iterator.hasNext()) {
                    Rack pRack = (Rack)iterator.next();
                    if (pRack.getLong("IDO_SERVID", -1L) != serviceID) continue;
                    targetRack = pRack;
                    break;
                }
            }
            if (targetRack != null) continue;
            return false;
        }
        return true;
    }

    public String getBabel() {
        return "TRANSFER_TO_GROUP";
    }

    public boolean checkAction(Vector idObjects, boolean withExecution, String commonGroup, boolean touchable) {
        Vector groups;
        boolean res = false;
        Rack[] commonRack = new Rack[1];
        if (idObjects != null && !idObjects.isEmpty() && touchable && commonGroup != null && MausoleumClient.isServiceCaretaker() && Privileges.hasPrivilege("CAG_GROUP_TRANSFER") && CAGroupTransfer.checkCagesForExport1(idObjects) && CAGroupTransfer.checkCommonRack(idObjects, commonRack) && !(groups = UserManager.getGroupNamesWithoutServiceInServiceRoom(commonGroup, commonRack[0])).isEmpty()) {
            res = true;
            if (withExecution) {
                int anzCages = 0;
                int anzMice = 0;
                int anzLines = 0;
                int anzLoci = 0;
                int anzStrains = 0;
                MouseGroupTransferRequester mtr = new MouseGroupTransferRequester((Frame)Inspector.getInspector(), null, MyDate.getMyDate(System.currentTimeMillis()), groups);
                mtr.setVisible(true);
                if (mtr.ivWarOK) {
                    if (mtr.getTargetGroup().equals(commonGroup)) {
                        return false;
                    }
                    if (!CAGroupTransfer.checkCagesForExport2(idObjects, mtr.getTargetGroup())) {
                        Alert.showAlert(Babel.get("RACK NOT_ACCESSIBLE_FOR_TARGET_GROUP"), true);
                        return false;
                    }
                    if (PopeAlert.getAnswer(Babel.get("TRANSFER_MIT_PETZE"))) {
                        String targetGroup = mtr.getTargetGroup();
                        Date datum = mtr.getDate();
                        User aktUser = UserManager.getUser();
                        if (aktUser != null) {
                            Iterator iter = idObjects.iterator();
                            while (iter.hasNext()) {
                                ++anzCages;
                                Cage cage = (Cage)iter.next();
                                Vector mice = cage.getActualMice();
                                if (mice == null || mice.isEmpty()) continue;
                                anzMice += mice.size();
                                HashSet locusIDs = new HashSet();
                                HashSet lineIDs = new HashSet();
                                HashSet strainIDs = new HashSet();
                                ExportHelper.collectObjectIDs(mice, locusIDs, lineIDs, strainIDs, commonGroup);
                                anzLines += lineIDs.size();
                                anzLoci += locusIDs.size();
                                anzStrains += strainIDs.size();
                                if (!CAGroupTransfer.checkPresenceOfObjects(locusIDs, lineIDs, strainIDs, commonGroup)) {
                                    Alert.showAlert(Babel.get("ALERT_GROUP_TRANSFER_IMPOSSIBLE"), true);
                                    return false;
                                }
                                String attachment = ExportHelper.createExportContent(mice, locusIDs, lineIDs, strainIDs, commonGroup, true);
                                if (attachment == null) {
                                    Class<?> clazz = class$0;
                                    if (clazz == null) {
                                        try {
                                            clazz = class$0 = Class.forName("mausoleum.inspector.actions.mouse.MAExport");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                    }
                                    Log.error("Attachment missing", null, clazz);
                                    Alert.showAlert(Babel.get("ALERTREQUESTFAILED"), true);
                                    return false;
                                }
                                String importCommand = "MAI_IMPORT_WITH_ROOM_OR_RACKPOS " + attachment + " " + cage.getID() + " ";
                                long targetRoomID = RoomManager.getGROUPRoomIDForServiceRoom(targetGroup);
                                if (targetRoomID == -1L) continue;
                                RackPos rp = (RackPos)cage.get("CAG_POS");
                                importCommand = rp == null ? String.valueOf(importCommand) + targetRoomID + " " + "0" + " " + "0" + " " + "0" + " " + "0" + " " : String.valueOf(importCommand) + "0 " + rp.ivRackID + " " + rp.ivSide + " " + rp.ivColumn + " " + rp.ivRow + " ";
                                importCommand = String.valueOf(importCommand) + commonGroup;
                                importCommand = String.valueOf(importCommand) + " " + mtr.getOwnerID(-1L);
                                StringBuffer msb = new StringBuffer(importCommand);
                                TrafficReport.appendTrafficInfoClientSide(null, -1L, "TRD_CAGE_GROUP_TRANSFER", msb);
                                importCommand = msb.toString();
                                String exportCommannd = ExportHelper.getRemoveMiceCommand(mice, datum.getTime(), 9, null, Base64Manager.encodeBase64("MGN:" + targetGroup), "TRD_CAGE_GROUP_TRANSFER");
                                res = InspectorCommandSender.executeCommand(new String[]{importCommand, exportCommannd}, null, new String[]{targetGroup, commonGroup}, null);
                            }
                            try {
                                String text = "User " + UserManager.getNameOfUser() + " transferred " + (anzMice == 1 ? "1 mouse, " : String.valueOf(anzMice) + " mice, ") + (anzCages == 1 ? "1 cage, " : String.valueOf(anzCages) + " cages, ") + (anzLoci == 1 ? "1 locus, " : String.valueOf(anzLoci) + " loci, ") + (anzLines == 1 ? "1 line, " : String.valueOf(anzLines) + " lines, ") + (anzStrains == 1 ? "1 strain " : String.valueOf(anzStrains) + " strains ") + "from group '" + commonGroup + "' to group '" + targetGroup + "'";
                                Mail brief = Mail.getSystemMail();
                                brief.set("MAI_TEXT", text);
                                brief.set("MAI_ATTINFO", null);
                                brief.set("MAI_ATTACHMENT", null);
                                brief.set("MAI_SUBJECT", "Cage group transfer");
                                brief.versendeDichAnGurus(new String[]{commonGroup, targetGroup, "service"}, "PETZ_CAGE_GROUP_TRANSFER");
                            }
                            catch (Exception eeex) {
                                Log.warn("Could not write Mouse export mail ", eeex, this);
                            }
                        }
                    }
                }
            }
            return true;
        }
        return res;
    }
}

