/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector.actions.cage;

import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.ArrayHelper;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.MyDate;
import de.hannse.netobjects.util.RequestManager;
import java.util.Date;
import java.util.Vector;
import mausoleum.alert.Alert;
import mausoleum.cage.Cage;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.actions.cage.CageAction;
import mausoleum.inspector.util.InspectorCommandSender;
import mausoleum.main.MausoleumClient;
import mausoleum.mouse.TaskExtended;
import mausoleum.reports.TrafficReport;
import mausoleum.requester.cage.TransferCageRequester;
import mausoleum.requester.pope.PopeAlert;
import mausoleum.room.RoomManager;

public class CATransfer
extends CageAction {
    public String getBabel() {
        return "TRANSFER_TO_ROOM";
    }

    public boolean checkAction(Vector idObjects, boolean withExecution, String commonGroup, boolean touchable) {
        boolean res = false;
        if (idObjects != null && !idObjects.isEmpty() && touchable && MausoleumClient.cvMoreServiceRoomsAvailable && commonGroup != null) {
            Vector[] roomArr;
            res = true;
            if (withExecution && (roomArr = (Vector[])RequestManager.createSendAndGetObjectIfFinished((byte)46, null, "service")) != null) {
                Vector names = roomArr[0];
                Vector ids = roomArr[1];
                Vector groupNames = roomArr[2];
                Vector groupIDs = roomArr[3];
                Vector choiceGroupIDs = new Vector();
                Vector choiceNames = new Vector();
                long[] restictedServiceRoomIds = MausoleumClient.isServiceCaretaker() ? (long[])UserManager.getUser().get("USR_R_ROOMS") : null;
                int i = 0;
                while (i < ids.size()) {
                    Long rid = (Long)ids.elementAt(i);
                    if (!rid.equals(MausoleumClient.cvServiceCTRoomID) && (restictedServiceRoomIds == null || ArrayHelper.findLongInArray(rid, restictedServiceRoomIds) != -1) && groupNames.elementAt(i) instanceof Vector && groupIDs.elementAt(i) instanceof Vector) {
                        Vector gnv = (Vector)groupNames.elementAt(i);
                        Vector giv = (Vector)groupIDs.elementAt(i);
                        int gind = gnv.indexOf(commonGroup);
                        if (gind != -1) {
                            choiceNames.add(names.elementAt(i));
                            choiceGroupIDs.add(giv.elementAt(gind));
                        }
                    }
                    ++i;
                }
                if (choiceNames.isEmpty()) {
                    Alert.showAlert(Babel.get("NO_OTHER_ROOM_AVAILABLE"), true);
                } else {
                    TransferCageRequester tcf = new TransferCageRequester(Inspector.getInspector(), null, MyDate.getMyDate(System.currentTimeMillis()), choiceNames, choiceGroupIDs);
                    if (tcf.ivWarOK) {
                        Date d = tcf.getDate();
                        long groupRoomID = tcf.getRoomID();
                        int actionDate = (int)(d.getTime() / 86400000L);
                        if (d != null && groupRoomID != -1L) {
                            Vector changingMice = new Vector();
                            if (PopeAlert.checkForRoomSecurity(null, idObjects, null, null, RoomManager.getRoom(groupRoomID, commonGroup), changingMice)) {
                                StringBuffer msb = new StringBuffer();
                                int j = 0;
                                while (j < idObjects.size()) {
                                    if (msb.length() != 0) {
                                        msb.append("\n");
                                    }
                                    Cage cage = (Cage)idObjects.elementAt(j);
                                    cage = cage.getSuperCageIfThere();
                                    msb.append("CTRR");
                                    msb.append(" ").append(Long.toString(cage.getID()));
                                    msb.append(" ").append(groupRoomID);
                                    msb.append(" ").append(d.getTime());
                                    ++j;
                                }
                                TrafficReport.appendTrafficInfoClientSide(idObjects, d.getTime(), "TRD_CAGE_ROOM_TRANSFER", msb);
                                TaskExtended.getRoomTransferTaskCommand(changingMice, msb, actionDate);
                                InspectorCommandSender.executeCommand(msb.toString(), commonGroup);
                            }
                        }
                    }
                }
            }
        }
        return res;
    }
}

