/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector.actions.locus;

import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.util.Babel;
import java.util.Vector;
import mausoleum.alert.Alert;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.actions.locus.LocusAction;
import mausoleum.inspector.util.InspectorCommandSender;
import mausoleum.locus.Locus;
import mausoleum.main.MausoleumClient;
import mausoleum.requester.TextRequester;

public class LOAAllelAdd
extends LocusAction {
    public String getBabel() {
        return "ADDALLEL";
    }

    public boolean checkAction(Vector idObjects, boolean withExecution, String commonGroup, boolean touchable) {
        Locus locus;
        boolean res = false;
        if (idObjects != null && idObjects.size() == 1 && (MausoleumClient.isRegularOrTGService() || MausoleumClient.isHeadOfService()) && Privileges.hasPrivilege("ADD_ALLEL") && (locus = LOAAllelAdd.getAliveSelectedLocus(idObjects)) != null && locus.mayAttributeBeChangedByCommand()) {
            if (withExecution) {
                try {
                    String inputValue = TextRequester.displayTextRequester(Inspector.getInspector(), Babel.get("ENTERALLELTOADD"));
                    if (inputValue != null) {
                        String[] alleles;
                        inputValue = inputValue.trim();
                        if ((inputValue = StringHelper.gSub(inputValue, " ", "")).length() != 0 && (alleles = (String[])locus.get("LOC_ALLELES")) != null) {
                            boolean schonda = false;
                            int i = 0;
                            while (i < alleles.length) {
                                if (alleles[i].equals(inputValue)) {
                                    schonda = true;
                                }
                                ++i;
                            }
                            if (schonda) {
                                Alert.showAlert(Babel.get("ALLELALREADYPRESENT"), true);
                            } else {
                                StringBuffer msb = new StringBuffer();
                                msb.append("LOCADDALLEL").append(" ");
                                msb.append(Long.toString(locus.getID())).append(" ");
                                msb.append(Base64Manager.encodeBase64(inputValue));
                                InspectorCommandSender.executeCommand(msb.toString(), locus.getGroup());
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            res = true;
        }
        return res;
    }
}

