/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector.actions.locus;

import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.util.Babel;
import java.util.Vector;
import mausoleum.alert.Alert;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.actions.locus.LocusAction;
import mausoleum.inspector.util.InspectorCommandSender;
import mausoleum.locus.Locus;
import mausoleum.main.MausoleumClient;
import mausoleum.requester.TextRequester;

public class LOAAllelsAlias
extends LocusAction {
    public String getBabel() {
        return "CHANGEALLELNAME";
    }

    public boolean checkAction(Vector idObjects, boolean withExecution, String commonGroup, boolean touchable) {
        boolean res = false;
        Locus locus = LOAAllelsAlias.getAliveSelectedLocus(idObjects);
        if ((MausoleumClient.isRegularOrTGService() || MausoleumClient.isHeadOfService()) && locus != null && locus.mayAttributeBeChangedByCommand() && cvSelectedAllel != null && Privileges.hasPrivilege("CHANGE_ALLEL_NAME")) {
            if (withExecution) {
                long locusID = locus.getID();
                String inputValue = TextRequester.displayTextRequester(Inspector.getInspector(), Babel.get("ENTERALLELNAME"), locus.getAlias(cvSelectedAllel));
                if (inputValue != null) {
                    inputValue = inputValue.trim();
                    if ((inputValue = StringHelper.gSub(inputValue, " ", "")).length() != 0) {
                        if (locus.getAlias(cvSelectedAllel).equals(inputValue)) {
                            return false;
                        }
                        if (!inputValue.equals(cvSelectedAllel)) {
                            String[] aliases;
                            String[] alleles = (String[])locus.get("LOC_ALLELES");
                            if (alleles != null) {
                                int i = 0;
                                while (i < alleles.length) {
                                    if (alleles[i].equals(inputValue)) {
                                        Alert.showAlert(Babel.get("ALLELALREADYPRESENT"), true);
                                        return false;
                                    }
                                    ++i;
                                }
                            }
                            if ((aliases = (String[])locus.get("LOC_ALLEL_DICT")) != null) {
                                int i = 0;
                                while (i < aliases.length) {
                                    if (aliases[i].equals(inputValue)) {
                                        Alert.showAlert(Babel.get("ALLELALREADYPRESENT"), true);
                                        return false;
                                    }
                                    ++i;
                                }
                            }
                        }
                        StringBuffer msb = new StringBuffer();
                        msb.append("LOCSETALIAS").append(" ");
                        msb.append(Long.toString(locusID)).append(" ");
                        msb.append(Base64Manager.encodeBase64(cvSelectedAllel)).append(" ");
                        msb.append(Base64Manager.encodeBase64(inputValue));
                        InspectorCommandSender.executeCommand(msb.toString(), locus.getGroup());
                    }
                }
            }
            res = true;
        }
        return res;
    }

    public boolean availableForInspectorTables() {
        return false;
    }
}

