/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector.actions.mouse;

import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.user.User;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.Log;
import de.hannse.netobjects.util.MyDate;
import java.awt.Frame;
import java.util.Date;
import java.util.HashSet;
import java.util.Vector;
import mausoleum.alert.Alert;
import mausoleum.definitionlists.ListDefinition;
import mausoleum.helper.ClipboardObject;
import mausoleum.helper.ExportHelper;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.actions.mouse.MouseAction;
import mausoleum.inspector.util.InspectorCommandSender;
import mausoleum.mail.Mail;
import mausoleum.mail.NewMailRequester;
import mausoleum.main.MausoleumClient;
import mausoleum.mouse.Mouse;
import mausoleum.reports.TrafficReport;
import mausoleum.requester.AllgChoiceRequester;
import mausoleum.requester.calendar.CalendarRequester;
import mausoleum.requester.mouse.MouseGroupTransferRequester;
import mausoleum.requester.pope.PopeAlert;
import mausoleum.room.RoomManager;

public class MAExport
extends MouseAction {
    public static final String START_EXPORT_LABEL = "START_OF_EXTRACT";
    public static final String END_EXPORT_LABEL = "END_OF_EXTRACT";
    private static String cvExportMeldung = Babel.get("HOWEXPORTMICE");
    private static String[] cvExportChoices = new String[]{Babel.get("BYMAUSOLEUMMAIL"), Babel.get("BYREGULARMAIL")};
    static /* synthetic */ Class class$0;

    public String getBabel() {
        if (MausoleumClient.isServiceCaretaker()) {
            return "TRANSFER_TO_GROUP";
        }
        return "EXPORT";
    }

    public static boolean getTargetAddress(String commonGroup, boolean withEmptyDef, String[] target) {
        Vector adressen = ListDefinition.getItems(UserManager.getGroupAndService(commonGroup), 6, true, withEmptyDef, true);
        if (adressen != null && !adressen.isEmpty()) {
            int ind = AllgChoiceRequester.getIndexAnswer((Frame)Inspector.getInspector(), Babel.get("CHOOSE_ADRESS"), adressen, true);
            if (ind == -1) {
                return false;
            }
            if (withEmptyDef && ind > 0 || !withEmptyDef && ind >= 0) {
                ListDefinition ld = (ListDefinition)adressen.elementAt(ind);
                if (ld.ivID > 0) {
                    target[0] = ld.ivID > 10000 ? Base64Manager.encodeBase64("MGN:" + ld.ivName) : Base64Manager.encodeBase64("EA:" + ld.ivID);
                }
            }
        }
        return true;
    }

    public boolean checkAction(Vector idObjects, boolean withExecution, String commonGroup, boolean touchable) {
        if (MausoleumClient.isServiceCaretaker()) {
            return this.mouseGroupTransfer(withExecution, idObjects, commonGroup, touchable);
        }
        if (touchable && !idObjects.isEmpty() && MausoleumClient.isRegularOrTGService() && Privileges.hasPrivilege("EXPORT_MICE") && commonGroup != null) {
            Date datum;
            User aktUser;
            if (withExecution && (aktUser = UserManager.getUser()) != null && this.checkMiceForExport(idObjects) && (datum = CalendarRequester.getDate(Inspector.getInspector())) != null) {
                HashSet locusIDs = new HashSet();
                HashSet lineIDs = new HashSet();
                HashSet strainIDs = new HashSet();
                ExportHelper.collectObjectIDs(idObjects, locusIDs, lineIDs, strainIDs, commonGroup);
                String attachmentInfo = ExportHelper.createExportInformation(idObjects.size(), locusIDs, lineIDs, strainIDs);
                String attachment = ExportHelper.createExportContent(idObjects, locusIDs, lineIDs, strainIDs, commonGroup, false);
                if (attachment == null) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("mausoleum.inspector.actions.mouse.MAExport");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Log.error("Attachment missing", null, clazz);
                    Alert.showAlert(Babel.get("ALERTREQUESTFAILED"), true);
                    return false;
                }
                String targetAddress = null;
                int aind = AllgChoiceRequester.getIndexAnswer((Frame)Inspector.getInspector(), cvExportMeldung, cvExportChoices);
                if (aind == 0) {
                    String receiverGroup = NewMailRequester.createExportMailAndGetTargetGroup(attachmentInfo, attachment, "***");
                    if (receiverGroup == null) {
                        return false;
                    }
                    if (!"***".equals(receiverGroup)) {
                        targetAddress = Base64Manager.encodeBase64("MGN:" + receiverGroup);
                    }
                } else if (aind == 1) {
                    StringBuffer zeilen = new StringBuffer();
                    zeilen.append(attachmentInfo).append("\r\n");
                    zeilen.append("-----------------------------------------------\r\n");
                    zeilen.append(START_EXPORT_LABEL).append("\r\n");
                    while (attachment.length() > 50) {
                        zeilen.append(attachment.substring(0, 50)).append("\r\n");
                        attachment = attachment.substring(50, attachment.length());
                    }
                    if (attachment.length() != 0) {
                        zeilen.append(attachment).append("\r\n");
                    }
                    zeilen.append(END_EXPORT_LABEL).append("\r\n");
                    zeilen.append("-----------------------------------------------\r\n");
                    String[] target = new String[]{null};
                    if (!MAExport.getTargetAddress(commonGroup, true, target)) {
                        return false;
                    }
                    targetAddress = target[0];
                    ClipboardObject.manageCopy(null, zeilen.toString());
                    if (!Alert.showAlert(Babel.get("INFOTOCLIPBOARD"), false)) {
                        return false;
                    }
                } else {
                    return true;
                }
                InspectorCommandSender.executeCommand(ExportHelper.getRemoveMiceCommand(idObjects, datum.getTime(), 6, null, targetAddress, "TRD_EXPORT"), commonGroup);
                try {
                    Mail brief = Mail.getSystemMail();
                    brief.set("MAI_SUBJECT", "Mouse export");
                    brief.set("MAI_TEXT", "User " + UserManager.getNameOfUser() + " exported " + attachmentInfo);
                    brief.set("MAI_ATTINFO", null);
                    brief.set("MAI_ATTACHMENT", null);
                    brief.versendeDichAnGurus(new String[]{commonGroup}, "PETZ_EXPORT_MICE");
                }
                catch (Exception eeex) {
                    Log.warn("Could not write Mouse export mail ", eeex, this);
                }
            }
            return true;
        }
        return false;
    }

    private boolean checkMiceForExport(Vector selObjects) {
        int i = 0;
        while (i < selObjects.size()) {
            Mouse mausi = (Mouse)selObjects.elementAt(i);
            if (mausi.isDead()) {
                Alert.showAlert(Babel.get("ALERTEXPORTDEAD"), true);
                return false;
            }
            if (!mausi.itsMine(null) && !Privileges.hasPrivilege("EXPORT_FOREIGN_MICE")) {
                Alert.showAlert(Babel.get("ALERTEXPORTFOREIGNMICE"), true);
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean mouseGroupTransfer(boolean withExecution, Vector selObjects, String commonGroup, boolean touchable) {
        Vector groups;
        if (MausoleumClient.isServiceCaretaker() && Privileges.hasPrivilege("MOS_GROUP_TRANSFER") && !selObjects.isEmpty() && commonGroup != null && touchable && !(groups = UserManager.getGroupNamesWithoutServiceInServiceRoom(commonGroup, null)).isEmpty()) {
            if (withExecution && this.checkMiceForExport(selObjects)) {
                MouseGroupTransferRequester mtr = new MouseGroupTransferRequester((Frame)Inspector.getInspector(), null, MyDate.getMyDate(System.currentTimeMillis()), groups);
                mtr.setVisible(true);
                if (mtr.ivWarOK) {
                    String targetGroup = mtr.getTargetGroup();
                    Date datum = mtr.getDate();
                    User aktUser = UserManager.getUser();
                    if (aktUser != null) {
                        HashSet locusIDs = new HashSet();
                        HashSet lineIDs = new HashSet();
                        HashSet strainIDs = new HashSet();
                        ExportHelper.collectObjectIDs(selObjects, locusIDs, lineIDs, strainIDs, commonGroup);
                        long serviceRoomID = RoomManager.getGROUPRoomIDForServiceRoom(targetGroup);
                        if (serviceRoomID != -1L) {
                            String attachment = ExportHelper.createExportContent(selObjects, locusIDs, lineIDs, strainIDs, commonGroup, true);
                            if (attachment == null) {
                                Class<?> clazz = class$0;
                                if (clazz == null) {
                                    try {
                                        clazz = class$0 = Class.forName("mausoleum.inspector.actions.mouse.MAExport");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                Log.error("Attachment missing", null, clazz);
                                Alert.showAlert(Babel.get("ALERTREQUESTFAILED"), true);
                                return false;
                            }
                            String importCommand = "MAI_IMPORT_WITH_ROOM " + attachment + " " + serviceRoomID + " " + mtr.getOwnerID(-1L);
                            if (PopeAlert.getAnswer(Babel.get("TRANSFER_MIT_PETZE"))) {
                                StringBuffer msb = new StringBuffer(importCommand);
                                TrafficReport.appendTrafficInfoClientSide(null, -1L, "TRD_MOUSE_GROUP_TRANSFER", msb);
                                importCommand = msb.toString();
                                InspectorCommandSender.executeCommand(ExportHelper.getRemoveMiceCommand(selObjects, datum.getTime(), 9, null, Base64Manager.encodeBase64("MGN:" + targetGroup), "TRD_MOUSE_GROUP_TRANSFER"), commonGroup);
                                InspectorCommandSender.executeCommand(importCommand, targetGroup);
                                try {
                                    String text = "User " + UserManager.getNameOfUser() + " transferred " + ExportHelper.createExportInformation(selObjects.size(), locusIDs, lineIDs, strainIDs) + " from group '" + commonGroup + "' to group '" + targetGroup + "'";
                                    Mail brief = Mail.getSystemMail();
                                    brief.set("MAI_TEXT", text);
                                    brief.set("MAI_ATTINFO", null);
                                    brief.set("MAI_ATTACHMENT", null);
                                    brief.set("MAI_SUBJECT", "Mouse group transfer");
                                    brief.versendeDichAnGurus(new String[]{commonGroup, targetGroup, "service"}, "PETZ_MOUSE_GROUP_TRANSFER");
                                }
                                catch (Exception eeex) {
                                    Log.warn("Could not write Mouse export mail ", eeex, this);
                                }
                            }
                        }
                    }
                }
            }
            return true;
        }
        return false;
    }
}

