/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector.actions.mouse;

import de.hannse.netobjects.objectstore.CommandManagerExecutive;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.user.User;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import java.awt.Frame;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import mausoleum.idobjectgroup.IDObjectGroup;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.actions.mouse.MouseAction;
import mausoleum.inspector.util.InspectorCommandSender;
import mausoleum.mouse.Mouse;
import mausoleum.requester.AllgChoiceRequester;

public class MAOwnerRemove
extends MouseAction {
    private final StringBuilder ivSB = new StringBuilder();

    public boolean availableForInspectorTables() {
        return false;
    }

    public boolean availableForPopup() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkAction(Vector idObjects, boolean withExecution, String commonGroup, boolean touchable) {
        boolean res = false;
        if (idObjects != null && !idObjects.isEmpty() && UserManager.isRealUser() && Privileges.hasPrivilege("CHANGE_OWNERSHIP") && commonGroup != null && UserOrUGInfo.ownerPresent(idObjects) && UserManager.getUser() != null && UserManager.getUser().getGroup().equals(commonGroup) && touchable && !commonGroup.equals("tgservice")) {
            UserOrUGInfo selInfo;
            Vector subMice;
            int ind;
            Vector uinfos;
            res = true;
            if (withExecution && !(uinfos = UserOrUGInfo.getOwnerInfos(idObjects)).isEmpty() && (ind = AllgChoiceRequester.getIndexAnswer((Frame)Inspector.getInspector(), Babel.get("SELECT_OWNER_TO_REMOVE"), uinfos)) != -1 && !(subMice = UserOrUGInfo.getMouseSubset(idObjects, selInfo = (UserOrUGInfo)uinfos.elementAt(ind))).isEmpty()) {
                String com = null;
                StringBuilder stringBuilder = this.ivSB;
                synchronized (stringBuilder) {
                    this.ivSB.setLength(0);
                    Iterator iter = subMice.iterator();
                    while (iter.hasNext()) {
                        Mouse maus = (Mouse)iter.next();
                        this.ivSB.append(CommandManagerExecutive.getServiceRoomTag(maus, ""));
                        this.ivSB.append("MREMOWN").append(" ");
                        this.ivSB.append(Long.toString(maus.getID())).append(" ");
                        this.ivSB.append(selInfo.ivObjectType == 6 ? "0" : "1").append(" ");
                        this.ivSB.append(Long.toString(selInfo.ivID)).append("\n");
                    }
                    com = this.ivSB.toString().trim();
                }
                InspectorCommandSender.executeCommand(com, commonGroup);
            }
        }
        return res;
    }

    public String getBabel() {
        return "REMOVE_OWNER";
    }

    private static class UserOrUGInfo
    implements Comparable {
        public final String ivDisplay;
        public final int ivObjectType;
        public final long ivID;

        public static boolean ownerPresent(Vector mice) {
            Iterator iterator = mice.iterator();
            while (iterator.hasNext()) {
                Mouse mouse = (Mouse)iterator.next();
                long[] oArr = (long[])mouse.get("MOS_OWNER");
                if (oArr != null && oArr.length != 0) {
                    return true;
                }
                oArr = (long[])mouse.get("MOS_OWNERGROUPS");
                if (oArr == null || oArr.length == 0) continue;
                return true;
            }
            return false;
        }

        public static Vector getOwnerInfos(Vector mice) {
            Vector res = new Vector();
            TreeSet<UserOrUGInfo> ts = new TreeSet<UserOrUGInfo>();
            Iterator iterator = mice.iterator();
            while (iterator.hasNext()) {
                int i;
                Mouse mouse = (Mouse)iterator.next();
                long[] oArr = (long[])mouse.get("MOS_OWNER");
                if (oArr != null && oArr.length != 0) {
                    i = 0;
                    while (i < oArr.length) {
                        User usi = (User)ObjectStore.getClientObject(6, oArr[i], mouse.getGroup());
                        if (usi != null) {
                            ts.add(new UserOrUGInfo(usi.getName(), usi.getID(), 6));
                        }
                        ++i;
                    }
                }
                if ((oArr = (long[])mouse.get("MOS_OWNERGROUPS")) == null || oArr.length == 0) continue;
                i = 0;
                while (i < oArr.length) {
                    IDObjectGroup iog = (IDObjectGroup)ObjectStore.getClientObject(19, oArr[i], mouse.getGroup());
                    if (iog != null) {
                        ts.add(new UserOrUGInfo(iog.getName(), iog.getID(), 19));
                    }
                    ++i;
                }
            }
            res.addAll(ts);
            return res;
        }

        public static Vector getMouseSubset(Vector mice, UserOrUGInfo info) {
            Vector<Mouse> res = new Vector<Mouse>();
            String tag = info.ivObjectType == 6 ? "MOS_OWNER" : "MOS_OWNERGROUPS";
            Iterator iterator = mice.iterator();
            while (iterator.hasNext()) {
                Mouse mouse = (Mouse)iterator.next();
                long[] oArr = (long[])mouse.get(tag);
                boolean takeIt = false;
                if (oArr != null && oArr.length != 0) {
                    int i = 0;
                    while (i < oArr.length && !takeIt) {
                        if (oArr[i] == info.ivID) {
                            takeIt = true;
                        }
                        ++i;
                    }
                }
                if (!takeIt) continue;
                res.add(mouse);
            }
            return res;
        }

        public UserOrUGInfo(String name, long id, int typ) {
            this.ivID = id;
            this.ivDisplay = " " + (typ == 6 ? name : "[" + name + "]") + " ";
            this.ivObjectType = typ;
        }

        public int compareTo(Object o) {
            if (o instanceof UserOrUGInfo) {
                UserOrUGInfo uoui = (UserOrUGInfo)o;
                return this.ivDisplay.compareToIgnoreCase(uoui.ivDisplay);
            }
            return 0;
        }

        public String toString() {
            return this.ivDisplay;
        }
    }
}

