/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector.actions.mouse;

import de.hannse.netobjects.objectstore.CommandManagerExecutive;
import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.util.Babel;
import java.awt.Frame;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.idobjectgroup.IDObjectGroupManager;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.actions.mouse.MouseAction;
import mausoleum.inspector.util.InspectorCommandSender;
import mausoleum.main.MausoleumClient;
import mausoleum.mouse.Mouse;
import mausoleum.requester.AllgChoiceRequester;
import mausoleum.requester.mouse.ShareMouseRequester;

public class MAOwnerSet
extends MouseAction {
    private final int ivObjectType;
    private final String ivTitle;
    private final String ivCommand;
    private final StringBuilder ivSB = new StringBuilder();
    private final Vector ivNames = new Vector();
    private final Vector ivObjectIDs = new Vector();

    public MAOwnerSet(int objectType) {
        this.ivObjectType = objectType;
        this.ivTitle = this.ivObjectType == 6 ? Babel.get("CHOOSE_USER") : Babel.get("CHOOSE_OWNER_GROUP");
        this.ivCommand = this.ivObjectType == 6 ? "MSETOWN" : "MSETOWNGROUP";
    }

    public boolean availableForInspectorTables() {
        return false;
    }

    public boolean availableForPopup() {
        return false;
    }

    public boolean checkAction(Vector idObjects, boolean withExecution, String commonGroup, boolean touchable) {
        boolean res = false;
        if (idObjects != null && !idObjects.isEmpty() && Privileges.hasPrivilege("CHANGE_OWNERSHIP") && commonGroup != null && touchable && IDObjectGroupManager.ownerGruppenDaOderUninteressant(this.ivObjectType, commonGroup) && this.extraBerechtigung(idObjects) && !commonGroup.equals("tgservice")) {
            String com;
            res = true;
            if (withExecution && (com = this.getCommand(idObjects, commonGroup)) != null) {
                InspectorCommandSender.executeCommand(com, commonGroup);
            }
        }
        return res;
    }

    public String getBabel() {
        return this.ivObjectType == 6 ? "SETUSER" : "SETOWNERGROUP";
    }

    private boolean extraBerechtigung(Vector mice) {
        if (MausoleumClient.isRegular()) {
            return true;
        }
        if (MausoleumClient.isServiceCaretaker()) {
            Iterator iterator = mice.iterator();
            while (iterator.hasNext()) {
                Mouse mouse = (Mouse)iterator.next();
                if (mouse.get("MOS_OWNER") == null && mouse.get("MOS_OWNERGROUPS") == null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private synchronized String getCommand(Vector idObjects, String commonGroup) {
        String res = null;
        this.ivObjectIDs.clear();
        this.ivNames.clear();
        ShareMouseRequester.fillNamesAndIDs(this.ivNames, this.ivObjectIDs, this.ivObjectType, commonGroup, true);
        if (!this.ivNames.isEmpty()) {
            this.ivSB.setLength(0);
            int ind = AllgChoiceRequester.getIndexAnswer((Frame)Inspector.getInspector(), this.ivTitle, this.ivNames);
            if (ind >= 0 && ind < this.ivObjectIDs.size()) {
                long wantedID = (Long)this.ivObjectIDs.elementAt(ind);
                Iterator iter = idObjects.iterator();
                while (iter.hasNext()) {
                    Mouse maus = (Mouse)iter.next();
                    this.ivSB.append(CommandManagerExecutive.getServiceRoomTag(maus, ""));
                    this.ivSB.append(this.ivCommand).append(" ");
                    this.ivSB.append(maus.getID()).append(" ");
                    this.ivSB.append(wantedID).append("\n");
                }
                res = this.ivSB.toString().trim();
            }
        }
        return res;
    }
}

