/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector.actions.mouse;

import de.hannse.netobjects.objectstore.CommandManagerExecutive;
import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.user.Privileges;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.actions.mouse.MouseAction;
import mausoleum.inspector.util.InspectorCommandSender;
import mausoleum.mouse.Mouse;
import mausoleum.mouse.TaskExtended;
import mausoleum.requester.mouse.PlugDayRequester;

public class MAPlugDateSet
extends MouseAction {
    public String getBabel() {
        return "SETPLUGDAY";
    }

    public boolean checkAction(Vector idObjects, boolean withExecution, String commonGroup, boolean touchable) {
        if (!idObjects.isEmpty() && Privileges.hasPrivilege("MOS_SET_PLUGDATE") && touchable && MAPlugDateSet.miceOKForSetPlugdate(idObjects)) {
            if (withExecution) {
                PlugDayRequester pdr = new PlugDayRequester(Inspector.getInspector());
                pdr.toFront();
                pdr.setVisible(true);
                if (pdr.ivWarOK) {
                    Date date = pdr.getDate();
                    int alert = pdr.getAlertDay();
                    if (date != null) {
                        String dateString = Long.toString(date.getTime());
                        String alertString = Integer.toString(alert);
                        int actionDate = (int)(date.getTime() / 86400000L);
                        HashMap obsByGroup = IDObject.sortByGroup(idObjects);
                        if (obsByGroup != null) {
                            Iterator iter = obsByGroup.keySet().iterator();
                            while (iter.hasNext()) {
                                String group = (String)iter.next();
                                Vector obs = (Vector)obsByGroup.get(group);
                                StringBuffer msb = new StringBuffer();
                                int i = 0;
                                while (i < obs.size()) {
                                    Mouse mausi = (Mouse)obs.elementAt(i);
                                    msb.append(CommandManagerExecutive.getServiceRoomTag(mausi, ""));
                                    msb.append("MSPLUGD").append(" ");
                                    msb.append(mausi.getID()).append(" ").append(dateString);
                                    msb.append(" ").append(alertString).append("\n");
                                    ++i;
                                }
                                TaskExtended.addTaskFinishsToMiceComBuff(obs, "TASK_AC_PLUGDATE", msb, actionDate);
                                InspectorCommandSender.executeCommand(msb.toString(), group);
                            }
                        }
                    }
                }
            }
            return true;
        }
        return false;
    }

    private static boolean miceOKForSetPlugdate(Vector v) {
        Iterator iter = v.iterator();
        while (iter.hasNext()) {
            Mouse maus = (Mouse)iter.next();
            if (maus.isDead()) {
                return false;
            }
            if (maus.getSex() == 2 && maus.isSexActive() && !maus.isRoomAccesibilityRestricted()) continue;
            return false;
        }
        return true;
    }
}

