/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector.actions.mouse;

import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.user.User;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.RequestManager;
import java.awt.GridLayout;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import mausoleum.inspector.actions.mouse.MouseAction;
import mausoleum.mail.Mail;
import mausoleum.mail.NewMailRequester;
import mausoleum.mail.RecipientRequester;
import mausoleum.mouse.Mouse;
import mausoleum.requester.AllgRequester;
import mausoleum.ui.UIDef;

public class MASendOwnerMail
extends MouseAction {
    private static final JCheckBox OWNER_CHECK = new JCheckBox(Babel.get("SEND_MAIL_TO_OWNERS"));
    private static final JCheckBox VETERINARY_CHECK = new JCheckBox(Babel.get("SEND_MAIL_TO_VETERINARIES"));
    private static final JPanel CHECK_PANEL = new JPanel(new GridLayout(2, 1, UIDef.INNER_RAND, UIDef.INNER_RAND));
    private static AllgRequester cvDialog = null;
    private HashMap ivVeterinaryIDsByGroup = new HashMap();

    static {
        OWNER_CHECK.setFocusPainted(false);
        CHECK_PANEL.add(OWNER_CHECK);
        VETERINARY_CHECK.setFocusPainted(false);
        CHECK_PANEL.add(VETERINARY_CHECK);
        OWNER_CHECK.setOpaque(false);
        VETERINARY_CHECK.setOpaque(false);
        CHECK_PANEL.setOpaque(false);
        cvDialog = new AllgRequester(null, Babel.get("SEND_MAIL"), CHECK_PANEL);
    }

    public String getBabel() {
        return "SEND_MAIL";
    }

    private Vector getVetsForGroup(String group) {
        Vector<Long> vets = (Vector<Long>)this.ivVeterinaryIDsByGroup.get(group);
        if (vets == null) {
            vets = new Vector<Long>();
            this.ivVeterinaryIDsByGroup.put(group, vets);
            Vector v = (Vector)RequestManager.createSendAndGetObjectIfFinished((byte)42, group, null);
            if (v != null) {
                Iterator iterator = v.iterator();
                while (iterator.hasNext()) {
                    RecipientRequester.RecInfo recInfo = new RecipientRequester.RecInfo((String)iterator.next(), group);
                    if (!recInfo.ivIsVeterinary) continue;
                    vets.add(recInfo.ivID);
                }
            }
        }
        return vets;
    }

    public boolean checkAction(Vector idObjects, boolean withExecution, String commonGroup, boolean touchable) {
        boolean res = false;
        if (!idObjects.isEmpty() && Privileges.hasPrivilege("MOS_SEND_MAIL_TO_OWNERS")) {
            boolean hasOwners;
            long myID = UserManager.getIDOFUser();
            String myGroup = UserManager.getFirstGroup();
            Vector serviceVetIDs = this.getVetsForGroup("service");
            boolean hasVets = !serviceVetIDs.isEmpty();
            HashMap miceByGroupAndPrimaryOwner = new HashMap();
            Iterator iterator = idObjects.iterator();
            while (iterator.hasNext()) {
                Long idKey;
                Vector<Mouse> mice;
                Mouse mouse = (Mouse)iterator.next();
                String group = mouse.getGroup();
                hasVets |= !this.getVetsForGroup(group).isEmpty();
                long primaryOwnerID = mouse.getPrimaryOwnerIDAlsoOwnerGroup(-1L);
                if (group == null || primaryOwnerID == -1L || group.equals(myGroup) && primaryOwnerID == myID) continue;
                HashMap<Long, Vector<Mouse>> miceByPrimaryOwner = (HashMap<Long, Vector<Mouse>>)miceByGroupAndPrimaryOwner.get(group);
                if (miceByPrimaryOwner == null) {
                    miceByPrimaryOwner = new HashMap<Long, Vector<Mouse>>();
                    miceByGroupAndPrimaryOwner.put(group, miceByPrimaryOwner);
                }
                if ((mice = (Vector<Mouse>)miceByPrimaryOwner.get(idKey = new Long(primaryOwnerID))) == null) {
                    mice = new Vector<Mouse>();
                    miceByPrimaryOwner.put(idKey, mice);
                }
                mice.add(mouse);
            }
            boolean bl = hasOwners = !miceByGroupAndPrimaryOwner.isEmpty();
            if (hasOwners || hasVets) {
                if (withExecution) {
                    OWNER_CHECK.setEnabled(hasOwners);
                    VETERINARY_CHECK.setEnabled(hasVets);
                    OWNER_CHECK.setSelected(hasOwners);
                    VETERINARY_CHECK.setSelected(hasVets && !hasOwners);
                    cvDialog.setVisible(true);
                    if (MASendOwnerMail.cvDialog.ivWarOK) {
                        Mail model;
                        boolean mitOwners = OWNER_CHECK.isSelected();
                        boolean mitVets = VETERINARY_CHECK.isSelected();
                        if ((mitOwners || mitVets) && (model = NewMailRequester.createMouseOwnerMail(idObjects)) != null) {
                            boolean tres;
                            Vector mice;
                            if (mitOwners) {
                                Iterator iterator2 = miceByGroupAndPrimaryOwner.keySet().iterator();
                                while (iterator2.hasNext()) {
                                    String mausGroup = (String)iterator2.next();
                                    HashMap miceByPrimaryOwner = (HashMap)miceByGroupAndPrimaryOwner.get(mausGroup);
                                    Iterator iterator22 = miceByPrimaryOwner.keySet().iterator();
                                    while (iterator22.hasNext()) {
                                        Long primaryOwnerID = (Long)iterator22.next();
                                        mice = (Vector)miceByPrimaryOwner.get(primaryOwnerID);
                                        try {
                                            tres = MASendOwnerMail.sendMail(model, mausGroup, primaryOwnerID, mice, mausGroup);
                                            if (tres) continue;
                                            return false;
                                        }
                                        catch (Exception e) {
                                            return false;
                                        }
                                    }
                                }
                            }
                            if (mitVets) {
                                Vector gruppenMaeuse = new Vector();
                                Iterator iterator3 = miceByGroupAndPrimaryOwner.keySet().iterator();
                                while (iterator3.hasNext()) {
                                    Vector groupVetIds;
                                    String mausGroup = (String)iterator3.next();
                                    gruppenMaeuse.clear();
                                    HashMap miceByPrimaryOwner = (HashMap)miceByGroupAndPrimaryOwner.get(mausGroup);
                                    Iterator<Object> iterator2 = miceByPrimaryOwner.values().iterator();
                                    while (iterator2.hasNext()) {
                                        mice = (Vector)iterator2.next();
                                        gruppenMaeuse.addAll(mice);
                                    }
                                    if (gruppenMaeuse.isEmpty()) continue;
                                    if (serviceVetIDs != null && !serviceVetIDs.isEmpty()) {
                                        iterator2 = serviceVetIDs.iterator();
                                        while (iterator2.hasNext()) {
                                            Long idL = (Long)iterator2.next();
                                            try {
                                                tres = MASendOwnerMail.sendMail(model, "service", idL, gruppenMaeuse, mausGroup);
                                                if (tres) continue;
                                                return false;
                                            }
                                            catch (Exception e) {
                                                return false;
                                            }
                                        }
                                    }
                                    if ((groupVetIds = this.getVetsForGroup(mausGroup)) == null || groupVetIds.isEmpty()) continue;
                                    Iterator iterator23 = groupVetIds.iterator();
                                    while (iterator23.hasNext()) {
                                        Long idL = (Long)iterator23.next();
                                        try {
                                            boolean tres2 = MASendOwnerMail.sendMail(model, mausGroup, idL, gruppenMaeuse, mausGroup);
                                            if (tres2) continue;
                                            return false;
                                        }
                                        catch (Exception e) {
                                            return false;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                res = true;
            }
        }
        return res;
    }

    private static boolean sendMail(Mail model, String receiverGroup, Long receiverID, Vector mice, String mouseGroup) {
        User receiver = (User)ObjectStore.getObjectDeadOrAlive(6, receiverID, receiverGroup, null, false);
        if (receiver != null) {
            StringBuilder msb = new StringBuilder(mice.size() * 20);
            Iterator iterator = mice.iterator();
            while (iterator.hasNext()) {
                Mouse maus = (Mouse)iterator.next();
                if (msb.length() != 0) {
                    msb.append(", ");
                }
                msb.append(maus.getLink());
                msb.append(" [Cage: ").append(maus.getCageString()).append(" Position: ").append(maus.getRackAndPosName()).append("]");
            }
            String lang = receiver.getString("USR_LANGUAGE", "en");
            String body = "<html><body>" + Babel.get(mice.size() == 1 ? "MAIL_REGARDING_MOUSE" : "MAIL_REGARDING_MICE", lang) + " " + (receiverGroup.equals(mouseGroup) ? "" : "(group: " + mouseGroup + ") ") + msb.toString() + "<hr>" + model.getString("MAI_TEXT") + "</body></html>";
            Mail brief = new Mail();
            brief.set("MAI_RECEIVER", receiver.getName());
            brief.set("MAI_RGROUP", receiverGroup);
            brief.set("MAI_RECEIVER_ID", receiver.getLongID());
            brief.set("MAI_SUBJECT", model.get("MAI_SUBJECT", "no subject"));
            brief.set("MAI_TEXT", body);
            brief.set("MAI_ATTINFO", null);
            brief.set("MAI_ATTACHMENT", null);
            brief.set("MAI_SENDER", model.get("MAI_SENDER"));
            brief.set("MAI_SGROUP", model.get("MAI_SGROUP"));
            brief.set("MAI_SENDER_ID", model.get("MAI_SENDER_ID"));
            brief.set("MAI_WANTSREC", model.get("MAI_WANTSREC"));
            return brief.versendeDich(receiverGroup);
        }
        return false;
    }
}

