/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector.actions.mouse;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.SwingUtilities;
import mausoleum.cage.Cage;
import mausoleum.inspector.actions.mouse.MouseAction;
import mausoleum.main.MausoleumClient;
import mausoleum.mouse.Mouse;
import mausoleum.rack.Rack;
import mausoleum.rack.frame.RackFrame;

public class MAShowPos
extends MouseAction {
    public static final Runnable RUNNABLE = new Runnable(){

        public void run() {
            RackFrame.ensureSelVisInRackTable();
        }
    };

    public String getBabel() {
        return "SHOWPOS";
    }

    public boolean checkAction(Vector idObjects, boolean withExecution, String commonGroup, boolean touchable) {
        boolean res = false;
        HashSet cages = new HashSet();
        Rack rack = MAShowPos.getCommonRack(idObjects, cages);
        if (rack != null) {
            boolean doit = true;
            if (MausoleumClient.isServiceCaretaker() && (MausoleumClient.cvServiceCTRoomID == null || !MausoleumClient.cvServiceCTRoomID.equals(rack.getServiceRoomID()))) {
                doit = false;
            }
            if (doit) {
                if (withExecution) {
                    RackFrame.showCagePositionsForShowPosAction(new Vector(cages), idObjects);
                    SwingUtilities.invokeLater(RUNNABLE);
                }
                res = true;
            }
        }
        cages.clear();
        cages = null;
        return res;
    }

    public static Rack getCommonRack(Vector idObjects, HashSet cages) {
        Rack commonRack = null;
        if (idObjects != null && !idObjects.isEmpty()) {
            Iterator iterator = idObjects.iterator();
            while (iterator.hasNext()) {
                Rack rack = null;
                Object ido = iterator.next();
                if (ido instanceof Mouse) {
                    Mouse mouse = (Mouse)ido;
                    rack = mouse.getRack();
                    if (cages != null) {
                        cages.add(mouse.getActCage());
                    }
                } else if (ido instanceof Cage) {
                    Cage cage = (Cage)ido;
                    rack = cage.getRack();
                    if (cages != null) {
                        cages.add(cage);
                    }
                }
                if (rack == null) {
                    return null;
                }
                if (commonRack == null) {
                    commonRack = rack;
                    continue;
                }
                if (commonRack == rack) continue;
                return null;
            }
        }
        return commonRack;
    }
}

