/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector.actions.rack;

import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.util.Babel;
import java.awt.Point;
import java.util.Date;
import java.util.Vector;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.actions.rack.RackAction;
import mausoleum.main.MausoleumClient;
import mausoleum.rack.Rack;
import mausoleum.requester.calendar.CalendarRequester;
import mausoleum.result.rackhealthreport.RResHealthReport;
import mausoleum.room.Room;

public class RARackHealth
extends RackAction {
    public String getBabel() {
        return "RACK_HEALTH_REPORTS";
    }

    public boolean checkAction(Vector idObjects, boolean withExecution, String commonGroup, boolean touchable) {
        boolean res = false;
        if (MausoleumClient.isHeadOfService() && Privileges.hasPrivilege("RCK_VIEW_HEALTHREPORT") && idObjects != null && !idObjects.isEmpty()) {
            if (idObjects.firstElement() instanceof Rack) {
                Point p;
                res = true;
                if (withExecution && (p = RARackHealth.getDates()) != null) {
                    RResHealthReport.makeReport(null, idObjects, p.x, p.y);
                }
            } else if (idObjects.size() == 1 && idObjects.firstElement() instanceof Room) {
                Point p;
                Room room = (Room)idObjects.firstElement();
                res = true;
                if (withExecution && (p = RARackHealth.getDates()) != null) {
                    RResHealthReport.makeReport(room, null, p.x, p.y);
                }
            }
        }
        return res;
    }

    private static Point getDates() {
        Date end;
        Date start = CalendarRequester.getDate(Inspector.getInspector(), Babel.get("SELECT_START_DATE"));
        if (start != null && (end = CalendarRequester.getDate(Inspector.getInspector(), Babel.get("SELECT_END_DATE"))) != null) {
            return new Point((int)(start.getTime() / 86400000L), (int)(end.getTime() / 86400000L));
        }
        return null;
    }
}

