/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector.actions.task;

import de.hannse.netobjects.objectstore.CommandManagerExecutive;
import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.RequestManager;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.actions.IAManager;
import mausoleum.inspector.actions.InspectorAction;
import mausoleum.inspector.actions.task.TAAddComment;
import mausoleum.inspector.actions.task.TAChangeDate;
import mausoleum.inspector.actions.task.TAChangeDescr;
import mausoleum.inspector.actions.task.TADelete;
import mausoleum.inspector.actions.task.TADone;
import mausoleum.inspector.actions.task.TAPerform;
import mausoleum.inspector.actions.task.TAReject;
import mausoleum.inspector.actions.task.TARevive;
import mausoleum.inspector.actions.task.TASetBimbo;
import mausoleum.inspector.actions.task.TAShowPosition;
import mausoleum.inspector.actions.task.TAStartWorking;
import mausoleum.inspector.actions.task.TAWithdraw;
import mausoleum.main.MausoleumClient;
import mausoleum.mouse.Mouse;
import mausoleum.mouse.TaskExtended;
import mausoleum.requester.MoreTextRequester;
import mausoleum.task.DisplayTask;

public abstract class TaskAction
implements InspectorAction {
    public static final String COM_TASK_START_WORKING = "TASK_COM_START_WORKING";
    public static final String COM_TASK_DONE = "TASK_COM_TASK_DONE";
    public static final String COM_TASK_PERFORM = "TASK_COM_PERFORM";
    public static final String COM_TASK_REJECT = "TASK_COM_REJECT";
    public static final String COM_TASK_WITHDRAW = "TASK_COM_WITHDRAW";
    public static final String COM_TASK_DELETE = "TASK_COM_DELETE";
    public static final String COM_TASK_SHOW_POSITION = "TASK_COM_SHOW_POSITION";
    public static final String COM_TASK_ADD_COMMENT = "TASK_COM_ADD_COMMENT";
    public static final String COM_TASK_CHANGE_DATE = "TASK_COM_CHANGE_DATE";
    public static final String COM_TASK_SET_BIMBO = "TASK_COM_SET_BIMBO";
    public static final String COM_TASK_CHANGE_DESCR = "TASK_COM_CHANGE_DESCR";
    public static final String COM_TASK_REVIVE = "TASK_COM_REVIVE";
    public static final HashMap ALLOWED_STATUS = new HashMap();
    public static final int DATE_TYPE_PURE_PERIOD = 1;
    public static final int DATE_TYPE_PURE_SINGLE_DATE = 2;
    public static final int DATE_TYPE_MIXED_OR_JUNK = 3;
    static /* synthetic */ Class class$0;

    public static void init() {
        ALLOWED_STATUS.put(COM_TASK_START_WORKING, TaskExtended.NONSTARTED_STATUS);
        ALLOWED_STATUS.put(COM_TASK_DONE, TaskExtended.UNFINISHED_STATUS);
        ALLOWED_STATUS.put(COM_TASK_PERFORM, TaskExtended.UNFINISHED_STATUS);
        ALLOWED_STATUS.put(COM_TASK_REJECT, TaskExtended.UNFINISHED_STATUS);
        ALLOWED_STATUS.put(COM_TASK_WITHDRAW, TaskExtended.NONSTARTED_STATUS);
        ALLOWED_STATUS.put(COM_TASK_DELETE, TaskExtended.FINISHED_STATUS);
        ALLOWED_STATUS.put(COM_TASK_SHOW_POSITION, TaskExtended.ALL_STATUS);
        ALLOWED_STATUS.put(COM_TASK_ADD_COMMENT, TaskExtended.ALL_STATUS);
        ALLOWED_STATUS.put(COM_TASK_CHANGE_DATE, TaskExtended.NONSTARTED_STATUS);
        ALLOWED_STATUS.put(COM_TASK_SET_BIMBO, TaskExtended.NONSTARTED_STATUS);
        ALLOWED_STATUS.put(COM_TASK_CHANGE_DESCR, TaskExtended.UNFINISHED_STATUS);
        ALLOWED_STATUS.put(COM_TASK_REVIVE, TaskExtended.REVIVABLE_STATUS);
        IAManager.register(COM_TASK_SHOW_POSITION, new TAShowPosition());
        IAManager.register(COM_TASK_START_WORKING, new TAStartWorking());
        IAManager.register(COM_TASK_DONE, new TADone());
        IAManager.register(COM_TASK_PERFORM, new TAPerform());
        IAManager.register(COM_TASK_REJECT, new TAReject());
        IAManager.register(COM_TASK_WITHDRAW, new TAWithdraw());
        IAManager.register(COM_TASK_DELETE, new TADelete());
        IAManager.register(COM_TASK_ADD_COMMENT, new TAAddComment());
        IAManager.register(COM_TASK_CHANGE_DATE, new TAChangeDate());
        IAManager.register(COM_TASK_SET_BIMBO, new TASetBimbo());
        IAManager.register(COM_TASK_CHANGE_DESCR, new TAChangeDescr());
        IAManager.register(COM_TASK_REVIVE, new TARevive());
    }

    public static String[] getTaskActions() {
        return new String[]{COM_TASK_START_WORKING, COM_TASK_DONE, COM_TASK_PERFORM, COM_TASK_REJECT, COM_TASK_WITHDRAW, COM_TASK_DELETE, COM_TASK_SHOW_POSITION, COM_TASK_ADD_COMMENT, COM_TASK_CHANGE_DATE, COM_TASK_REVIVE, COM_TASK_SET_BIMBO, COM_TASK_CHANGE_DESCR};
    }

    public static int determinePureDateType(Vector displayTasks) {
        if (displayTasks != null && !displayTasks.isEmpty()) {
            int sumPeriod = 0;
            Iterator iter = displayTasks.iterator();
            while (iter.hasNext()) {
                DisplayTask dt = (DisplayTask)iter.next();
                if (!dt.ivTask.isPeriodTask()) continue;
                ++sumPeriod;
            }
            int sumNonPeriod = displayTasks.size() - sumPeriod;
            if (sumPeriod == displayTasks.size()) {
                return 1;
            }
            if (sumNonPeriod == displayTasks.size()) {
                return 2;
            }
        }
        return 3;
    }

    public static boolean isAllowed(String comm, Vector idObjects, boolean fixedDateAllowed, boolean periodAllowed) {
        boolean allowed = false;
        if (idObjects != null && !idObjects.isEmpty()) {
            int[] allowedStatus = (int[])ALLOWED_STATUS.get(comm);
            if (allowedStatus != null) {
                allowed = TaskExtended.statusAllowed(idObjects, allowedStatus);
            }
            if (allowed) {
                allowed = TaskAction.privilegeCheck(idObjects, comm, fixedDateAllowed, periodAllowed);
            }
        }
        return allowed;
    }

    private static boolean privilegeCheck(Vector idObjects, String command, boolean fixedDateAllowed, boolean periodAllowed) {
        Iterator iter = idObjects.iterator();
        while (iter.hasNext()) {
            DisplayTask dt = (DisplayTask)iter.next();
            if (!TaskAction.privilegeCheck(dt, command)) {
                return false;
            }
            if (dt.ivTask.isFixedDayTask() && !fixedDateAllowed) {
                return false;
            }
            if (!dt.ivTask.isPeriodTask() || periodAllowed) continue;
            return false;
        }
        return true;
    }

    public static boolean privilegeCheck(DisplayTask dt, String command) {
        if (command.equals(COM_TASK_START_WORKING)) {
            return !TaskAction.isTaskRoomRestricted(dt);
        }
        if (command.equals(COM_TASK_DONE) || command.equals(COM_TASK_PERFORM)) {
            return !TaskAction.isTaskRoomRestricted(dt);
        }
        if (command.equals(COM_TASK_REJECT)) {
            return Privileges.hasPrivilege("TSK_REJECT") && !TaskAction.isTaskRoomRestricted(dt);
        }
        if (command.equals(COM_TASK_WITHDRAW)) {
            return TaskAction.isIssuerOrGuruOrAllowed(dt, "CHANGE_FOREIGN_TASKS");
        }
        if (command.equals(COM_TASK_DELETE)) {
            return TaskAction.isIssuerOrGuruOrAllowed(dt, "CHANGE_FOREIGN_TASKS");
        }
        if (command.equals(COM_TASK_SHOW_POSITION)) {
            return true;
        }
        if (command.equals(COM_TASK_ADD_COMMENT)) {
            return Privileges.hasPrivilege("TSK_CH_COMMENT");
        }
        if (command.equals(COM_TASK_CHANGE_DATE)) {
            return TaskAction.isIssuerOrGuruOrAllowed(dt, "CHANGE_DATE_OF_FOREIGN_TASKS");
        }
        if (command.equals(COM_TASK_SET_BIMBO)) {
            return TaskAction.isIssuerOrGuruOrAllowed(dt, "CHANGE_FOREIGN_TASKS");
        }
        if (command.equals(COM_TASK_CHANGE_DESCR)) {
            return TaskAction.isIssuerOrGuruOrAllowed(dt, "CHANGE_FOREIGN_TASKS");
        }
        if (command.equals(COM_TASK_REVIVE)) {
            return TaskAction.isIssuerOrGuruOrAllowed(dt, "REVIVE_TASKS");
        }
        return false;
    }

    private static boolean isTaskRoomRestricted(DisplayTask dt) {
        IDObject ido;
        if (MausoleumClient.isRegularOrTGService() && (ido = dt.getUnderlying()) != null) {
            if (ido instanceof Mouse) {
                return ((Mouse)ido).isRoomAccesibilityRestricted();
            }
            if (ido instanceof Cage) {
                return ((Cage)ido).isRoomAccesibilityRestricted();
            }
        }
        return false;
    }

    private static boolean isIssuerOrGuruOrAllowed(DisplayTask dt, String foreignPrivilege) {
        if (foreignPrivilege != null && Privileges.hasPrivilege(foreignPrivilege)) {
            return true;
        }
        if (dt != null && dt.ivTask != null) {
            String userGrup = UserManager.getGroupOfUser();
            String taskGroup = dt.ivTask.getIssuerGroup(dt.getGroup());
            if (userGrup != null && taskGroup != null) {
                return userGrup.equals(taskGroup) && UserManager.getIDOFUser() == dt.ivTask.ivIssuerID;
            }
        }
        return false;
    }

    public static void setStatus(String command, Vector displayTaskObjects, int neuerStatus, String commentToAppend, Date newDate, int startPeriod, int endPeriod, int frequency, int knipsDate, int knipsActionTageIfDifferent, HashMap commandCollectorByGroup) {
        HashMap obsByGroup;
        if (commentToAppend != null && TaskExtended.statusAllowed(displayTaskObjects, (int[])ALLOWED_STATUS.get(command)) && (obsByGroup = IDObject.sortByGroup(displayTaskObjects)) != null) {
            Iterator iter = obsByGroup.keySet().iterator();
            while (iter.hasNext()) {
                String group = (String)iter.next();
                Vector obs = (Vector)obsByGroup.get(group);
                StringBuilder msb = new StringBuilder();
                int i = 0;
                while (i < obs.size()) {
                    if (msb.length() != 0) {
                        msb.append("\n");
                    }
                    DisplayTask displayTask = (DisplayTask)obs.elementAt(i);
                    msb.append(CommandManagerExecutive.getServiceRoomTag(group, displayTask.ivComeFromType, displayTask.ivComeFromID, ""));
                    msb.append("MALTERTASK").append(" ");
                    msb.append(displayTask.ivComeFromID).append(" ");
                    msb.append(displayTask.ivComeFromType).append(" ");
                    msb.append(Base64Manager.encodeBase64(displayTask.ivTask.getInitString(neuerStatus, commentToAppend, newDate, Integer.MAX_VALUE, startPeriod, endPeriod, frequency, knipsDate, knipsActionTageIfDifferent)));
                    ++i;
                }
                if (commandCollectorByGroup != null) {
                    String s = (String)commandCollectorByGroup.get(group);
                    if (s != null) {
                        commandCollectorByGroup.put(group, String.valueOf(s) + "\n" + msb.toString());
                        continue;
                    }
                    commandCollectorByGroup.put(group, msb.toString());
                    continue;
                }
                RequestManager.sendCommandRequestAndGetAnswer(msb.toString(), group);
            }
        }
    }

    public Class getObjectClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("mausoleum.task.DisplayTask");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public boolean availableForInspectorTables() {
        return true;
    }

    public boolean availableForPopup() {
        return true;
    }

    public String getTooltipBabel() {
        return null;
    }

    public String getActionComment() {
        int role = UserManager.getRoleOfUser();
        boolean eingabeZwang = role == 30 || role == 550;
        String res = MoreTextRequester.getText(Inspector.getInspector(), Babel.get("EXPLAIN_REASON"), eingabeZwang);
        return res == null ? null : res.trim();
    }
}

