/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector.actions.usergroup;

import de.hannse.netobjects.tools.Base64Manager;
import mausoleum.helper.Zeile;

public class BasicObjectMerker
implements Comparable {
    public static final int COL_ID_IN_GROUP = 0;
    public static final int COL_NAME_IN_GROUP = 1;
    public static final int COL_DOC_INFO = 2;
    public static final int COL_SERVICE_ID = 3;
    public static final int COL_SERVICE_IMPORTABLE = 4;
    public final long ivIDInGroup;
    public final String ivNameInGroup;
    public final String ivDocumentInfo;
    public final long ivServiceID;
    public final boolean ivServiceImportable;

    public BasicObjectMerker(String line) {
        Zeile z = new Zeile(line, '|');
        this.ivIDInGroup = z.getLong(0, -1L);
        this.ivNameInGroup = Base64Manager.getDecodedString(z.getString(1, ""));
        this.ivDocumentInfo = Base64Manager.getDecodedString(z.getString(2, ""));
        this.ivServiceID = z.getLong(3, -1L);
        this.ivServiceImportable = z.getBoolean(4, "1", "0", false);
    }

    public String toString() {
        return " " + (this.ivServiceID != -1L ? "[S] " : "") + this.ivNameInGroup + " ";
    }

    public String toLongString() {
        StringBuilder msb = new StringBuilder();
        msb.append(" ").append(this.ivServiceID != -1L ? "[S] " : "").append(this.ivNameInGroup).append("\n");
        msb.append("    ivIDInGroup: ").append(this.ivIDInGroup).append("\n");
        msb.append("    ivDocumentInfo: ").append(this.ivDocumentInfo).append("\n");
        msb.append("    ivServiceID: ").append(this.ivServiceID).append("\n");
        msb.append("    ivServiceImportable:").append(this.ivServiceImportable).append("\n");
        return msb.toString();
    }

    public int compareTo(Object arg0) {
        if (arg0 instanceof BasicObjectMerker) {
            BasicObjectMerker bom = (BasicObjectMerker)arg0;
            return this.ivNameInGroup.compareToIgnoreCase(bom.ivNameInGroup);
        }
        return 0;
    }
}

