/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector.actions.usergroup;

import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Log;
import de.hannse.netobjects.util.RequestManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.inspector.actions.IAManager;
import mausoleum.inspector.actions.InspectorAction;
import mausoleum.inspector.actions.usergroup.BasicObjectMerker;
import mausoleum.inspector.actions.usergroup.RackMerker;
import mausoleum.inspector.actions.usergroup.UGAGeneralImport;
import mausoleum.inspector.actions.usergroup.UGAImportRack;
import mausoleum.inspector.actions.usergroup.UGASwitchToGroup;

public abstract class UsergroupAction
implements InspectorAction {
    public static final String COM_IMPORT_RACK = "UGA_IMPORT_RACK";
    public static final String COM_IMPORT_STRAIN = "UGA_IMPORT_STRAIN";
    public static final String COM_IMPORT_LICENSE = "UGA_IMPORT_LICENSE";
    public static final String COM_IMPORT_LINE = "UGA_IMPORT_LINE";
    public static final String COM_IMPORT_LOCUS = "UGA_IMPORT_LOCUS";
    public static final String COM_SWITCH_GROUP = "UGA_SWITCH_GROUP";
    private static final HashMap RACK_MERKER_BY_GROUP = new HashMap();
    private static final HashMap SELECTED_BASIC_OBJECTMERKERS_BY_TYPE = new HashMap();
    private static final HashMap TYPES_BY_COMMAND = new HashMap();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static void init() {
        IAManager.register(COM_IMPORT_RACK, new UGAImportRack());
        IAManager.register(COM_IMPORT_STRAIN, new UGAImportStrain());
        IAManager.register(COM_IMPORT_LICENSE, new UGAImportLicense());
        IAManager.register(COM_IMPORT_LINE, new UGAImportLine());
        IAManager.register(COM_IMPORT_LOCUS, new UGAImportLocus());
        IAManager.register(COM_SWITCH_GROUP, new UGASwitchToGroup());
        TYPES_BY_COMMAND.put(COM_IMPORT_RACK, new Integer(3));
        TYPES_BY_COMMAND.put(COM_IMPORT_STRAIN, UGAImportStrain.TYPE);
        TYPES_BY_COMMAND.put(COM_IMPORT_LICENSE, UGAImportLicense.TYPE);
        TYPES_BY_COMMAND.put(COM_IMPORT_LINE, UGAImportLine.TYPE);
        TYPES_BY_COMMAND.put(COM_IMPORT_LOCUS, UGAImportLocus.TYPE);
        RACK_MERKER_BY_GROUP.clear();
        SELECTED_BASIC_OBJECTMERKERS_BY_TYPE.clear();
    }

    public static void setSelectedMerker(Integer type, Object[] bomv) {
        if (bomv != null) {
            SELECTED_BASIC_OBJECTMERKERS_BY_TYPE.put(type, bomv);
        } else {
            SELECTED_BASIC_OBJECTMERKERS_BY_TYPE.remove(type);
        }
    }

    public static Integer getTypeForCommand(String command) {
        return (Integer)TYPES_BY_COMMAND.get(command);
    }

    public static Object[] getSelectedMerkers(Integer type) {
        return (Object[])SELECTED_BASIC_OBJECTMERKERS_BY_TYPE.get(type);
    }

    public static void invalidateRackStatus(String group) {
        RACK_MERKER_BY_GROUP.remove(group);
    }

    public static Vector getRackMerkers(String group, boolean withMiceInfo) {
        Vector<RackMerker> merkersOfGroup = (Vector<RackMerker>)RACK_MERKER_BY_GROUP.get(group);
        if (merkersOfGroup == null) {
            merkersOfGroup = new Vector<RackMerker>();
            Vector lines = UsergroupAction.getBOMLinesFromSever(group, "3|" + (withMiceInfo ? "1" : "0"));
            if (lines != null) {
                Iterator iter = lines.iterator();
                while (iter.hasNext()) {
                    String line = (String)iter.next();
                    try {
                        merkersOfGroup.add(new RackMerker(line));
                    }
                    catch (Exception e) {
                        System.out.println("Problem bei RackMerker " + line);
                    }
                }
            }
            RACK_MERKER_BY_GROUP.put(group, merkersOfGroup);
            HashMap<Long, RackMerker> rackMerkerByRackServiceID = new HashMap<Long, RackMerker>();
            Iterator iterator = merkersOfGroup.iterator();
            while (iterator.hasNext()) {
                RackMerker rm = (RackMerker)iterator.next();
                if (rm.ivServiceID <= 0L) continue;
                Long key = new Long(rm.ivServiceID);
                RackMerker formerRM = (RackMerker)rackMerkerByRackServiceID.get(key);
                if (formerRM != null) {
                    String string = "Duplicate Rack in service ID --- group: " + group + " Rack Service ID:" + key + "\nact Rack 1: " + rm.toLongString() + "\nformer Rack 2: " + formerRM.toLongString();
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("mausoleum.inspector.actions.usergroup.UsergroupAction");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Log.error(string, null, clazz);
                    continue;
                }
                rackMerkerByRackServiceID.put(key, rm);
            }
        }
        return merkersOfGroup;
    }

    public static Vector getBasicObjectMerkers(String group, int objectTyp) {
        Vector<BasicObjectMerker> merkers = new Vector<BasicObjectMerker>();
        Vector lines = UsergroupAction.getBOMLinesFromSever(group, Integer.toString(objectTyp));
        Iterator iter = lines.iterator();
        while (iter.hasNext()) {
            String line = (String)iter.next();
            try {
                merkers.add(new BasicObjectMerker(line));
            }
            catch (Exception e) {
                System.out.println("Problem bei RackMerker " + line);
            }
        }
        return merkers;
    }

    private static Vector getBOMLinesFromSever(String group, String extraObject) {
        String boms = (String)RequestManager.createSendAndGetObjectIfFinished((byte)67, group, UserManager.getFirstGroup(), extraObject);
        return boms == null ? null : StringHelper.splitStringByAny(boms, "\n");
    }

    public Class getObjectClass() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("mausoleum.usergroup.UserGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public boolean availableForInspectorTables() {
        return false;
    }

    public boolean availableForPopup() {
        return true;
    }

    public String getTooltipBabel() {
        return null;
    }

    public static class UGAImportLicense
    extends UGAGeneralImport {
        public static final Integer TYPE = new Integer(16);

        public UGAImportLicense() {
            super(TYPE);
        }
    }

    public static class UGAImportLine
    extends UGAGeneralImport {
        public static final Integer TYPE = new Integer(7);

        public UGAImportLine() {
            super(TYPE);
        }
    }

    public static class UGAImportLocus
    extends UGAGeneralImport {
        public static final Integer TYPE = new Integer(14);

        public UGAImportLocus() {
            super(TYPE);
        }
    }

    public static class UGAImportStrain
    extends UGAGeneralImport {
        public static final Integer TYPE = new Integer(8);

        public UGAImportStrain() {
            super(TYPE);
        }
    }
}

