/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector.panels;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JComboBox;
import mausoleum.gui.RequesterPane;
import mausoleum.gui.SimpleLayoutManager;
import mausoleum.inspector.panels.IPTabPanel;
import mausoleum.main.DefaultManager;
import mausoleum.printing.PreviewFrame;
import mausoleum.printing.labelprinters.LabelPrinter;
import mausoleum.ui.UIDef;

public class CageCardPane
extends RequesterPane
implements IPTabPanel {
    private static final long serialVersionUID = 1122323L;
    private JComboBox ivPrintersCombo = new JComboBox<String>(LabelPrinter.getNamesWithSpace(true));
    private PreviewFrame.MausoleumPrinterPreviewPanel ivPreviewPanel = new PreviewFrame.MausoleumPrinterPreviewPanel(null);
    private final Vector ivActCages = new Vector();

    public CageCardPane() {
        super(null);
        this.setLayout(new SimpleLayoutManager(){

            public void layoutContainer(Container parent) {
                Dimension d = parent.getSize();
                int y = 0;
                CageCardPane.this.ivPrintersCombo.setBounds(0, y, d.width, UIDef.LINE_HEIGHT);
                int uh = d.height - UIDef.INNER_RAND - UIDef.LINE_HEIGHT;
                CageCardPane.this.ivPreviewPanel.setBounds(0, y += UIDef.LINE_HEIGHT + UIDef.INNER_RAND, d.width, uh);
            }
        });
        this.ivPrintersCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CageCardPane.this.printerChanged();
            }
        });
        String s = DefaultManager.getLabelPrinter();
        if (s != null && s.trim().length() != 0) {
            this.ivPrintersCombo.setSelectedItem(" " + s + " ");
        } else {
            this.ivPrintersCombo.setSelectedIndex(0);
        }
        this.add(this.ivPrintersCombo);
        this.ivPreviewPanel.setFullMatch(true);
        this.ivPreviewPanel.setDrawFrame(true);
        this.add(this.ivPreviewPanel);
    }

    private void printerChanged() {
        String selPri = (String)this.ivPrintersCombo.getSelectedItem();
        LabelPrinter lp = LabelPrinter.get(selPri.trim(), true);
        if (lp != null) {
            lp.distributeCageLabels(this.ivActCages);
        }
        this.ivPreviewPanel.setPrinter(lp);
        this.ivPreviewPanel.repaint();
    }

    public void adapt(Vector idObjects, Vector mice, Vector changeSensitives) {
        this.ivActCages.clear();
        this.ivActCages.addAll(idObjects);
        LabelPrinter lp = (LabelPrinter)this.ivPreviewPanel.getPrinter();
        if (lp != null) {
            lp.distributeCageLabels(idObjects);
            this.ivPreviewPanel.setPrinter(lp);
        }
    }
}

