/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector.panels;

import de.hannse.netobjects.objectstore.CommandManagerExecutive;
import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.RequestManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.panels.MouseInspSpecResultPanel;
import mausoleum.mouse.Mouse;
import mausoleum.requester.pope.PopeAlert;
import mausoleum.result.MResultWrapper;
import mausoleum.result.SpecialResult;
import mausoleum.result.embryotransfer.AddResultForDefinedExperimentRequester;
import mausoleum.result.embryotransfer.EnterEmbryoTransferPanel;
import mausoleum.result.embryotransfer.MResEmbryoTransfer;
import mausoleum.tables.models.MTSpecResEmbryoTransferInMouseInspector;

public class MouseInspEmbryoTransferPanel
extends MouseInspSpecResultPanel {
    private static final long serialVersionUID = 112323435L;

    private static void addResult(Vector mice, String group) {
        if (mice != null && mice.size() == 1) {
            EnterEmbryoTransferPanel panel = new EnterEmbryoTransferPanel((Mouse)mice.firstElement(), null);
            AddResultForDefinedExperimentRequester arr = new AddResultForDefinedExperimentRequester(Inspector.getInspector(), Mouse.getBirthDayMinimumDate(mice), mice, -46L, 3001, panel, true, "EMBRYO_TRANSFER", Integer.MIN_VALUE);
            if (arr.ivWarOK && arr.ivCommands != null && PopeAlert.checkForSecondEmbryoTransfer(arr.getSelectedDate(), (Mouse)mice.firstElement())) {
                RequestManager.sendCommandRequestAndGetAnswer(arr.ivCommands, arr.ivGroups, arr.ivExtraObjects);
                Inspector.refreshInspector();
            }
        }
    }

    private static void editResult(Vector mice, String group, MResultWrapper wrapper) {
        String rep;
        if (mice != null && mice.size() == 1 && wrapper != null && (rep = (String)wrapper.ivMresult.ivResult) != null && rep.length() != 0) {
            MResEmbryoTransfer embTr = new MResEmbryoTransfer(rep);
            EnterEmbryoTransferPanel panel = new EnterEmbryoTransferPanel((Mouse)mice.firstElement(), embTr);
            AddResultForDefinedExperimentRequester arr = new AddResultForDefinedExperimentRequester(Inspector.getInspector(), Mouse.getBirthDayMinimumDate(mice), mice, -46L, 3001, panel, true, "EMBRYO_TRANSFER", wrapper != null ? wrapper.ivMresult.ivDate : Integer.MIN_VALUE);
            if (arr.ivWarOK && arr.ivCommands != null) {
                StringBuilder msb = new StringBuilder();
                msb.setLength(0);
                msb.append(CommandManagerExecutive.getServiceRoomTag(ObjectStore.getClientObject(1, wrapper.ivMouseID, wrapper.ivGroup), ""));
                msb.append("MRES_REMOVE");
                msb.append(" ");
                msb.append(wrapper.ivMouseID);
                msb.append(" ");
                msb.append(wrapper.ivMresult.ivPseudoID);
                RequestManager.sendCommandRequestAndGetAnswer(msb.toString(), wrapper.ivGroup);
                RequestManager.sendCommandRequestAndGetAnswer(arr.ivCommands, arr.ivGroups, arr.ivExtraObjects);
                Inspector.refreshInspector();
            }
        }
    }

    public MouseInspEmbryoTransferPanel() {
        super(new long[]{-46L}, "MOS_ADD_EMBRYO_TRANSFER", "MOS_DELETE_EMBRYO_TRANSFER", "MOS_EDIT_EMBRYO_TRANSFER", new MTSpecResEmbryoTransferInMouseInspector());
    }

    public SpecialResult getSpecialResultInstanceForAddRequester() {
        return null;
    }

    public SpecialResult getSpecialResultInstanceForAddRequester(long expID, int resType) {
        return null;
    }

    public Object[] getTableDetails(MResultWrapper wrapper) {
        String rep = (String)wrapper.ivMresult.ivResult;
        if (rep != null && rep.length() != 0) {
            MResEmbryoTransfer embTr = new MResEmbryoTransfer(rep);
            return embTr.getTableRepresentation(wrapper.ivGroup, Babel.cvUserLangue);
        }
        return null;
    }

    public void manageTooltip(MouseEvent e) {
        String tooltip = null;
        int row = this.ivResultTable.ivJTable.rowAtPoint(e.getPoint());
        if (row != -1 && row < this.ivResultTable.ivModel.ivObjects.size()) {
            MResultWrapper wrapper = (MResultWrapper)this.ivResultTable.ivModel.ivObjects.elementAt(row);
            String rep = (String)wrapper.ivMresult.ivResult;
            if (rep != null && rep.length() != 0) {
                MResEmbryoTransfer embTr = new MResEmbryoTransfer(rep);
                tooltip = MouseInspEmbryoTransferPanel.getTooltip(embTr.getTableRepresentation(wrapper.ivGroup, Babel.cvUserLangue));
            }
        }
        this.ivResultTable.ivJTable.setToolTipText(tooltip);
    }

    public boolean isAddReallyAllowed(boolean addEnabledSoFar, Vector mice) {
        if (addEnabledSoFar && mice != null && mice.size() == 1) {
            Iterator iterator = mice.iterator();
            while (iterator.hasNext()) {
                Mouse mouse = (Mouse)iterator.next();
                if (mouse.getSex() == 2) continue;
                return false;
            }
            return IDObject.commonGroup(mice) != null;
        }
        return false;
    }

    public void actionPerformed(ActionEvent e) {
        String comm = e.getActionCommand();
        if (comm.equals("ADDRES")) {
            String group;
            if (this.ivMaeuse != null && !this.ivMaeuse.isEmpty() && (group = IDObject.commonGroup(this.ivMaeuse)) != null) {
                MouseInspEmbryoTransferPanel.addResult(this.ivMaeuse, group);
            }
        } else if (comm.equals("EDITRES")) {
            Vector v;
            String group;
            if (this.ivMaeuse != null && this.ivMaeuse.size() == 1 && (group = IDObject.commonGroup(this.ivMaeuse)) != null && (v = this.ivResultTable.getSelectedObjects()) != null && v.size() == 1) {
                MResultWrapper wrapper = (MResultWrapper)v.firstElement();
                MouseInspEmbryoTransferPanel.editResult(this.ivMaeuse, group, wrapper);
            }
        } else {
            super.actionPerformed(e);
        }
    }
}

