/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector.panels;

import de.hannse.netobjects.objectstore.CommandManagerExecutive;
import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectConsumer;
import de.hannse.netobjects.objectstore.ObjectStoreClient;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.MyDate;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mausoleum.alert.Alert;
import mausoleum.factsheets.FactSheetFrame;
import mausoleum.factsheets.FactSheetMouse;
import mausoleum.gui.MGButton;
import mausoleum.gui.RequesterPane;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.MousePlugDateObject;
import mausoleum.inspector.panels.IPTabPanel;
import mausoleum.inspector.util.InspectorCommandSender;
import mausoleum.mouse.Mouse;
import mausoleum.requester.calendar.CalendarRequester;
import mausoleum.tables.models.MTPlugDate;
import mausoleum.ui.UIDef;

public class MousePlugDatePanel
extends RequesterPane
implements LayoutManager,
ActionListener,
ListSelectionListener,
ObjectConsumer,
IPTabPanel {
    private static final long serialVersionUID = 6987705981716935926L;
    private static final int RAND = UIDef.getScaled(6);
    private static final int BUT_HEIGHT = UIDef.getScaled(20);
    private final MGButton ivAddButton = MGButton.getInspectorActionButton(Babel.get("ADD_PLUG_DATE"), "ADD_PLUG_DATE");
    private final MGButton ivDelButton = MGButton.getInspectorActionButton(Babel.get("DEL_PLUG_DATE"), "DEL_PLUG_DATE");
    private final MGButton ivReportButton = MGButton.getInspectorActionButton(Babel.get("PLUG_REPORT"), "PLUG_REPORT");
    private Vector ivMaeuse = null;
    private MTPlugDate ivPlugDateTable = new MTPlugDate();
    static /* synthetic */ Class class$0;

    public MousePlugDatePanel() {
        super(null, "inspectorBack");
        this.setLayout(this);
        this.ivPlugDateTable.getSelectionModel().addListSelectionListener(this);
        this.add(this.ivPlugDateTable.ivScrollPane);
        this.add(this.ivAddButton);
        this.add(this.ivDelButton);
        this.add(this.ivReportButton);
        this.ivAddButton.addActionListener(this);
        this.ivDelButton.addActionListener(this);
        this.ivReportButton.addActionListener(this);
        this.ivAddButton.setEnabled(false);
        this.ivDelButton.setEnabled(false);
        ObjectStoreClient.addConsumer((ObjectConsumer)this, 1);
    }

    public void adapt(Vector idObjects, Vector mice, Vector changeSensitives) {
        this.ivMaeuse = idObjects;
        Vector dates = new Vector();
        if (idObjects != null && !idObjects.isEmpty()) {
            Iterator iter = idObjects.iterator();
            while (iter.hasNext()) {
                MousePlugDateObject.addPlugDates((Mouse)iter.next(), dates);
            }
        }
        this.ivPlugDateTable.setObjects(dates);
        boolean addEnabled = false;
        boolean plugReportEnabled = false;
        if (this.ivMaeuse != null) {
            Iterator iter = this.ivMaeuse.iterator();
            while (iter.hasNext()) {
                Mouse mouse = (Mouse)iter.next();
                if (mouse.getSex() == 1) {
                    plugReportEnabled = true;
                }
                if (mouse.getSex() != 2 || this.ivMaeuse.size() != 1) continue;
                addEnabled = Mouse.areMiceTouchable(this.ivMaeuse);
            }
        }
        boolean bl = IDObject.commonGroup(this.ivMaeuse) != null;
        this.ivReportButton.setEnabled(plugReportEnabled);
        this.ivAddButton.setEnabled(addEnabled &= bl);
        this.ivDelButton.setEnabled(false);
    }

    public void actionPerformed(ActionEvent e) {
        String comm = e.getActionCommand();
        if (comm.equals("ADD_PLUG_DATE")) {
            Date datum;
            Mouse mouse;
            if (this.ivMaeuse != null && this.ivMaeuse.size() == 1 && (mouse = (Mouse)this.ivMaeuse.firstElement()).getSex() == 2 && (datum = CalendarRequester.getDate(Inspector.getInspector())) != null) {
                StringBuilder msb = new StringBuilder();
                msb.append(CommandManagerExecutive.getServiceRoomTag(mouse, ""));
                msb.append("MSADDPLUGDATE").append(" ");
                msb.append(mouse.getID()).append(" ");
                msb.append(MyDate.getTage(datum.getTime()));
                InspectorCommandSender.executeCommand(msb.toString(), mouse.getGroup());
            }
        } else if (comm.equals("DEL_PLUG_DATE")) {
            Vector selecteds = this.ivPlugDateTable.getSelectedObjects();
            if (selecteds != null && selecteds.size() == 1) {
                MousePlugDateObject mpo = (MousePlugDateObject)selecteds.firstElement();
                if (mpo.ivIsCurrentPlugAlert) {
                    if (Alert.showAlert(Babel.get("DOYOUWANNADELETEACTUALPLUGALERT"), false)) {
                        StringBuffer msb = new StringBuffer();
                        msb.append("MSREMPLUGDATE").append(" ");
                        msb.append(mpo.ivMouseID).append(" ");
                        msb.append(mpo.ivDatum);
                        msb.append("\n");
                        msb.append("MSPLUGD").append(" ");
                        msb.append(mpo.ivMouseID).append(" 0 0");
                        InspectorCommandSender.executeCommand(msb.toString(), mpo.ivGroup);
                    }
                } else if (Alert.showAlert(Babel.get("DOYOUWANNADELETEPLUGDTE"), false)) {
                    StringBuffer msb = new StringBuffer();
                    msb.append("MSREMPLUGDATE").append(" ");
                    msb.append(mpo.ivMouseID).append(" ");
                    msb.append(mpo.ivDatum);
                    InspectorCommandSender.executeCommand(msb.toString(), mpo.ivGroup);
                }
            }
        } else if (comm.equals("PLUG_REPORT")) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("mausoleum.mouse.Mouse");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            FactSheetFrame.showTab(this.ivMaeuse, clazz.getName(), FactSheetMouse.SEL_PLUG_REPORT, Babel.get("PLUG_REPORT"), Babel.get("PLUG_REPORT"));
        }
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    public Dimension preferredLayoutSize(Container parent) {
        return new Dimension(300, 500);
    }

    public Dimension minimumLayoutSize(Container parent) {
        return new Dimension(150, 300);
    }

    public void layoutContainer(Container parent) {
        Dimension d = parent.getSize();
        int innerheight = d.height - 2 * RAND;
        int innerwidth = d.width - 2 * RAND;
        int oheight = innerheight - BUT_HEIGHT - RAND;
        int y = RAND;
        this.ivPlugDateTable.ivScrollPane.setBounds(RAND, y, innerwidth, oheight);
        int anzButs = 3;
        int lbw = (innerwidth - (anzButs - 1) * RAND) / anzButs;
        int rbw = innerwidth - (anzButs - 1) * (RAND + lbw);
        int x = RAND;
        this.ivDelButton.setBounds(x, y += oheight + RAND, lbw, BUT_HEIGHT);
        this.ivAddButton.setBounds(x += lbw + RAND, y, lbw, BUT_HEIGHT);
        this.ivReportButton.setBounds(x += lbw + RAND, y, rbw, BUT_HEIGHT);
    }

    public void objectLeftServiceRoom(int objectTyp, String group, HashSet objectIDs) {
        Mouse maus;
        if (objectTyp == 1 && this.ivMaeuse != null && this.ivMaeuse.size() == 1 && (maus = (Mouse)this.ivMaeuse.elementAt(0)).getGroup() == group && objectIDs.contains(maus.get("IDO_ID"))) {
            this.ivMaeuse.clear();
            this.adapt(this.ivMaeuse, null, null);
        }
    }

    public void handleNewObjects(Vector idObjects) {
    }

    public void handleNewObject(IDObject obj) {
    }

    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            boolean delEnabled = false;
            Vector v = this.ivPlugDateTable.getSelectedObjects();
            if (v.size() == 1) {
                MousePlugDateObject mpdo = (MousePlugDateObject)v.firstElement();
                delEnabled = mpdo.ivItsMine || UserManager.cvTouchForeignMice;
            }
            this.ivDelButton.setEnabled(delEnabled);
        }
    }
}

