/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector.panels;

import de.hannse.netobjects.objectstore.CommandManagerExecutive;
import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectConsumer;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.MilliSpender;
import de.hannse.netobjects.util.MyDate;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mausoleum.alert.Alert;
import mausoleum.definitionlists.ListDefinition;
import mausoleum.gui.BorderPanel;
import mausoleum.gui.FlexGridLayout;
import mausoleum.gui.MGButton;
import mausoleum.gui.RequesterPane;
import mausoleum.gui.SimpleLayoutManager;
import mausoleum.helper.ClipboardObject;
import mausoleum.helper.FontManager;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.panels.IPTabPanel;
import mausoleum.inspector.util.InspectorCommandSender;
import mausoleum.mouse.Mouse;
import mausoleum.mouse.MouseManager;
import mausoleum.mouse.TissueSample;
import mausoleum.requester.mouse.TissueSampleRequester;
import mausoleum.tables.models.MTTissueSample;
import mausoleum.ui.UIDef;

public class MouseTissuePanel
extends RequesterPane
implements ActionListener,
ObjectConsumer,
IPTabPanel {
    private static final long serialVersionUID = 6987705981716935926L;
    private static final int RAND = UIDef.getScaled(6);
    private static final int BUT_HEIGHT = UIDef.getScaled(20);
    private static final int TABLE_HEIGHT = UIDef.getScaled(130);
    private SingleTissuePanel ivSingleTissuePanel = new SingleTissuePanel();
    private BorderPanel ivBorderPanel = new BorderPanel(this.ivSingleTissuePanel, Babel.get("SAMPLEDETAILS"));
    private MGButton ivAddButton = MGButton.getInspectorActionButton(Babel.get("TISSUE_ADD"), "ADDSAMPLE");
    private MGButton ivDelButton = MGButton.getInspectorActionButton(Babel.get("TISSUE_REMOVE"), "DELSAMPLE");
    private MGButton ivEditButton = MGButton.getInspectorActionButton(Babel.get("TISSUE_EDIT"), "EDITSAMPLE");
    private MGButton ivCopyButton = MGButton.getInspectorActionButton(Babel.get("COPY"), "COPYTABLE");
    private final Vector ivVisibleTissueSamples = new Vector();
    private Vector ivMaeuse = null;
    private MTTissueSample ivTissueSampleTable = new MTTissueSample();
    private boolean ivAddEnabled = false;
    private boolean ivTouchable = false;
    private String ivCommonGroup = null;

    public MouseTissuePanel() {
        super(null, "inspectorBack");
        this.setLayout(new SimpleLayoutManager(){

            public void layoutContainer(Container parent) {
                Dimension d = parent.getSize();
                int innerheight = d.height - 2 * RAND;
                int innerwidth = d.width - 2 * RAND;
                int uheight = innerheight - TABLE_HEIGHT - BUT_HEIGHT - 2 * RAND;
                int y = RAND;
                ((MouseTissuePanel)MouseTissuePanel.this).ivTissueSampleTable.ivScrollPane.setBounds(RAND, y, innerwidth, TABLE_HEIGHT);
                MouseTissuePanel.this.ivBorderPanel.setBounds(RAND, y += TABLE_HEIGHT + RAND, innerwidth, uheight);
                int lw = (innerwidth - 3 * RAND) / 4;
                int rw = innerwidth - 3 * RAND - 3 * lw;
                int x = RAND;
                MouseTissuePanel.this.ivAddButton.setBounds(x, y += uheight + RAND, lw, BUT_HEIGHT);
                MouseTissuePanel.this.ivEditButton.setBounds(x += lw + RAND, y, lw, BUT_HEIGHT);
                MouseTissuePanel.this.ivDelButton.setBounds(x += lw + RAND, y, lw, BUT_HEIGHT);
                MouseTissuePanel.this.ivCopyButton.setBounds(x += lw + RAND, y, rw, BUT_HEIGHT);
            }
        });
        this.ivTissueSampleTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent arg0) {
                MouseTissuePanel.this.selectionChanged();
            }
        });
        this.add(this.ivTissueSampleTable.ivScrollPane);
        this.add(this.ivBorderPanel);
        this.add(this.ivAddButton);
        this.add(this.ivEditButton);
        this.add(this.ivDelButton);
        this.add(this.ivCopyButton);
        this.ivAddButton.addActionListener(this);
        this.ivDelButton.addActionListener(this);
        this.ivCopyButton.addActionListener(this);
        this.ivEditButton.addActionListener(this);
        this.ivSingleTissuePanel.clear();
        this.checkButs();
    }

    public void adapt(Vector idObjects, Vector mice, Vector changeSensitives) {
        this.ivMaeuse = idObjects;
        this.ivSingleTissuePanel.clear();
        TissueSample.getTissueSamples(idObjects, this.ivVisibleTissueSamples);
        this.ivAddEnabled = false;
        this.ivCommonGroup = null;
        this.ivTouchable = false;
        if (idObjects != null && !idObjects.isEmpty()) {
            this.ivCommonGroup = IDObject.commonGroup(this.ivMaeuse);
            this.ivTouchable = Mouse.areMiceTouchableInclDeads(this.ivMaeuse);
            if (this.ivCommonGroup != null && this.ivTouchable) {
                this.ivAddEnabled = ListDefinition.hasValues(this.ivCommonGroup, 2);
            }
        }
        this.ivTissueSampleTable.setObjects(this.ivVisibleTissueSamples);
        this.selectionChanged();
    }

    private void selectionChanged() {
        Vector v = this.ivTissueSampleTable.getSelectedObjects();
        if (v.size() == 1) {
            this.ivSingleTissuePanel.adapt((TissueSample)v.firstElement());
        } else {
            this.ivSingleTissuePanel.adapt(null);
        }
        this.checkButs();
    }

    private void checkButs() {
        Vector v = this.ivTissueSampleTable.getSelectedObjects();
        this.ivAddButton.setEnabled(this.ivAddEnabled && Privileges.hasPrivilege("MOS_ADD_TISSUE"));
        this.ivEditButton.setEnabled(this.ivTouchable && v.size() == 1 && Privileges.hasPrivilege("MOS_EDIT_TISSUE"));
        this.ivDelButton.setEnabled(this.ivTouchable && v.size() > 0 && Privileges.hasPrivilege("MOS_REMOVE_TISSUE"));
        this.ivCopyButton.setEnabled(!this.ivVisibleTissueSamples.isEmpty());
    }

    public void actionPerformed(ActionEvent e) {
        String comm = e.getActionCommand();
        if (comm.equals("ADDSAMPLE")) {
            String group;
            if (this.ivMaeuse != null && !this.ivMaeuse.isEmpty() && (group = IDObject.commonGroup(this.ivMaeuse)) != null) {
                TissueSampleRequester tsr = new TissueSampleRequester((Frame)Inspector.getInspector(), MouseTissuePanel.getMinDate(this.ivMaeuse), group, null);
                tsr.setVisible(true);
                if (tsr.ivWarOK) {
                    TissueSample model = tsr.getTissueSample();
                    Vector<TissueSample> sammler = new Vector<TissueSample>();
                    StringBuilder msb = new StringBuilder();
                    Iterator iterator = this.ivMaeuse.iterator();
                    while (iterator.hasNext()) {
                        Mouse mouse = (Mouse)iterator.next();
                        sammler.clear();
                        TissueSample.getTissueSamples(mouse, sammler);
                        model.ivID = MilliSpender.getMillis();
                        sammler.add(model);
                        MouseTissuePanel.appendCommand(msb, mouse, sammler);
                    }
                    if (msb != null && msb.length() != 0) {
                        InspectorCommandSender.executeCommand(msb.toString(), group);
                        Inspector.refreshInspector();
                    }
                }
            }
        } else if (comm.equals("DELSAMPLE")) {
            Vector selres = this.ivTissueSampleTable.getSelectedObjects();
            if (selres != null && !selres.isEmpty()) {
                HashMap<String, TreeSet<Long>> sampleIDsByMouseID = new HashMap<String, TreeSet<Long>>();
                Iterator iterator = selres.iterator();
                while (iterator.hasNext()) {
                    TissueSample ts = (TissueSample)iterator.next();
                    String key = String.valueOf(ts.ivGroup) + "_" + ts.ivMouseID;
                    TreeSet<Long> set = (TreeSet<Long>)sampleIDsByMouseID.get(key);
                    if (set == null) {
                        set = new TreeSet<Long>();
                        sampleIDsByMouseID.put(key, set);
                    }
                    set.add(new Long(ts.ivID));
                }
                HashMap obsByGroup = IDObject.sortByGroup(this.ivMaeuse);
                if (obsByGroup != null) {
                    Iterator iter = obsByGroup.keySet().iterator();
                    while (iter.hasNext()) {
                        String group = (String)iter.next();
                        Vector obs = (Vector)obsByGroup.get(group);
                        StringBuilder msb = new StringBuilder();
                        Vector target = new Vector();
                        Iterator iterator2 = obs.iterator();
                        while (iterator2.hasNext()) {
                            Mouse mouse = (Mouse)iterator2.next();
                            String key = String.valueOf(mouse.getGroup()) + "_" + mouse.getID();
                            TreeSet unwantedIDs = (TreeSet)sampleIDsByMouseID.get(key);
                            if (unwantedIDs == null) continue;
                            target.clear();
                            TissueSample.getTissueSamplesWithoutSpecifiedIDs(mouse, target, unwantedIDs);
                            MouseTissuePanel.appendCommand(msb, mouse, target);
                        }
                        if (msb.length() == 0) continue;
                        InspectorCommandSender.executeCommand(msb.toString(), group);
                    }
                }
                Inspector.refreshInspector();
            }
        } else if (comm.equals("EDITSAMPLE")) {
            Vector selres = this.ivTissueSampleTable.getSelectedObjects();
            if (selres.size() == 1) {
                TissueSample original = (TissueSample)selres.firstElement();
                Mouse mouse = MouseManager.getMouse(original.ivMouseID, original.ivGroup);
                if (mouse != null) {
                    TissueSample model;
                    Vector<Mouse> v = new Vector<Mouse>();
                    v.add(mouse);
                    TissueSampleRequester tsr = new TissueSampleRequester((Frame)Inspector.getInspector(), MouseTissuePanel.getMinDate(v), original.ivGroup, original);
                    tsr.setVisible(true);
                    if (tsr.ivWarOK && original.changed(model = tsr.getTissueSample())) {
                        TreeSet<Long> unwantedIDs = new TreeSet<Long>();
                        unwantedIDs.add(new Long(original.ivID));
                        Vector<TissueSample> target = new Vector<TissueSample>();
                        TissueSample.getTissueSamplesWithoutSpecifiedIDs(mouse, target, unwantedIDs);
                        original.takeEditableValues(model);
                        target.add(original);
                        StringBuilder msb = new StringBuilder();
                        MouseTissuePanel.appendCommand(msb, mouse, target);
                        if (msb.length() != 0) {
                            InspectorCommandSender.executeCommand(msb.toString(), original.ivGroup);
                            Inspector.refreshInspector();
                        }
                    }
                }
            }
        } else if (comm.equals("COPYTABLE")) {
            ClipboardObject.manageCopy(null, TissueSample.getCopyString(this.ivTissueSampleTable.ivObjects));
            Alert.showAlert(Babel.get("DATAINCLIPBOARD"), true);
        }
    }

    private static MyDate getMinDate(Vector mice) {
        MyDate minimum = null;
        long minMillis = -1L;
        Iterator iterator = mice.iterator();
        while (iterator.hasNext()) {
            Mouse maus = (Mouse)iterator.next();
            Date d = maus.getDate("MOS_BIRTHDAY");
            if (d == null || d.getTime() <= minMillis) continue;
            minMillis = d.getTime();
        }
        if (minMillis > 0L) {
            minimum = MyDate.getMyDate(minMillis);
        }
        return minimum;
    }

    private static void appendCommand(StringBuilder msb, Mouse mouse, Vector samples) {
        if (msb.length() != 0) {
            msb.append("\n");
        }
        msb.append(CommandManagerExecutive.getServiceRoomTag(mouse, ""));
        msb.append("MSETTISSUESSAMPLE").append(" ");
        msb.append(mouse.getID()).append(" ");
        msb.append(Base64Manager.encodeBase64(TissueSample.getTransport(samples)));
    }

    public void objectLeftServiceRoom(int objectTyp, String group, HashSet objectIDs) {
        Mouse maus;
        if (objectTyp == 1 && this.ivMaeuse != null && this.ivMaeuse.size() == 1 && (maus = (Mouse)this.ivMaeuse.elementAt(0)).getGroup() == group && objectIDs.contains(maus.get("IDO_ID"))) {
            this.ivMaeuse.clear();
            this.adapt(this.ivMaeuse, null, null);
        }
    }

    public void handleNewObjects(Vector idObjects) {
        Iterator iterator = idObjects.iterator();
        while (iterator.hasNext()) {
            this.handleNewObject((IDObject)iterator.next());
        }
    }

    public void handleNewObject(IDObject obj) {
    }

    class SingleTissuePanel
    extends JPanel {
        private static final long serialVersionUID = 5059129708388511262L;
        private JLabel ivSampleIDField = new JLabel();
        private JLabel ivDateField = new JLabel();
        private JLabel ivTissueField = new JLabel();
        private JLabel ivPreparationField = new JLabel();
        private JLabel ivFixationField = new JLabel();
        private JLabel ivEmbeddingField = new JLabel();
        private JLabel ivLocationField = new JLabel();
        private JTextPane ivCommentPane = new JTextPane();
        private JScrollPane ivCommentSPane = new JScrollPane(this.ivCommentPane);

        public SingleTissuePanel() {
            this.setLayout(new FlexGridLayout(8, 2, 2, 2, true, true));
            this.setOpaque(false);
            this.addLabel(Babel.get("TISSUE_SAMPLE_ID"));
            this.add(this.ivSampleIDField);
            this.addLabel(Babel.get("DATE"));
            this.add(this.ivDateField);
            this.addLabel(Babel.get("TISSUE"));
            this.add(this.ivTissueField);
            this.addLabel(Babel.get("TISSUE_PREP"));
            this.add(this.ivPreparationField);
            this.addLabel(Babel.get("TISSUE_FIXATION"));
            this.add(this.ivFixationField);
            this.addLabel(Babel.get("TISSUE_EMBEDDING"));
            this.add(this.ivEmbeddingField);
            this.addLabel(Babel.get("SAMPLE_LOCATION"));
            this.add(this.ivLocationField);
            this.addLabel(Babel.get("COMMENT"));
            this.add(this.ivCommentSPane);
            this.ivCommentSPane.setOpaque(false);
            this.ivCommentPane.setOpaque(false);
        }

        private void addLabel(String s) {
            JLabel lab = new JLabel(s);
            lab.setFont(FontManager.getFont("SSP11"));
            lab.setVerticalAlignment(1);
            this.add(lab);
        }

        public void clear() {
            this.ivSampleIDField.setText("");
            this.ivDateField.setText("");
            this.ivTissueField.setText("");
            this.ivPreparationField.setText("");
            this.ivFixationField.setText("");
            this.ivEmbeddingField.setText("");
            this.ivLocationField.setText("");
            this.ivCommentPane.setText("");
        }

        public void adapt(TissueSample ts) {
            if (ts != null) {
                this.ivSampleIDField.setText(ts.getSpecimenID(""));
                this.ivDateField.setText(ts.getDate(""));
                this.ivTissueField.setText(ts.getTissue(""));
                this.ivPreparationField.setText(ts.getPreparation(""));
                this.ivFixationField.setText(ts.getFixation(""));
                this.ivEmbeddingField.setText(ts.getEmbedding(""));
                this.ivLocationField.setText(ts.getLocation(""));
                this.ivCommentPane.setText(ts.getComment(""));
                this.ivCommentPane.setCaretPosition(0);
            } else {
                this.clear();
            }
        }
    }
}

