/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector.panels;

import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.util.Babel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import mausoleum.building.Building;
import mausoleum.gui.MGButton;
import mausoleum.gui.RequesterPane;
import mausoleum.gui.SimpleLayoutManager;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.panels.IPTabPanel;
import mausoleum.inspector.util.InspectorCommandSender;
import mausoleum.main.MausoleumClient;
import mausoleum.objectstore.QuotableIDObject;
import mausoleum.requester.Requester;
import mausoleum.room.Room;
import mausoleum.ui.UIDef;
import mausoleum.ui.table.SortableTable;
import mausoleum.usergroup.UserGroup;
import mausoleum.usergroup.UsergroupManager;

public class QuotaPane
extends RequesterPane
implements IPTabPanel {
    private static final long serialVersionUID = 1234345L;
    private QuotaTable ivQuotaTable = new QuotaTable();
    private JScrollPane ivScrollPane = new JScrollPane(this.ivQuotaTable);
    private MGButton ivSetButton = new MGButton(Babel.get("QUOTA_SET"));
    private MGButton ivClearButton = new MGButton(Babel.get("QUOTA_CLEAR"));
    private long ivObjectID = 0L;
    private int ivObjectType = 0;
    static /* synthetic */ Class class$0;

    public QuotaPane() {
        super(null, "inspectorBack");
        this.add(this.ivScrollPane);
        this.add(this.ivSetButton);
        this.add(this.ivClearButton);
        this.setLayout(new SimpleLayoutManager(){

            public void layoutContainer(Container arg0) {
                Dimension d = arg0.getSize();
                int r = UIDef.INNER_RAND;
                int bh = UIDef.BUT_HEIGHT;
                int w = d.width - 2 * r;
                int h = d.height - 2 * r - bh - r;
                int x = r;
                int y = r;
                QuotaPane.this.ivScrollPane.setBounds(r, r, w, h);
                int lbw = (w - r) / 2;
                int rbw = w - r - lbw;
                QuotaPane.this.ivSetButton.setBounds(x, y += h + r, lbw, bh);
                QuotaPane.this.ivClearButton.setBounds(x + r + lbw, y, rbw, bh);
            }
        });
        this.ivQuotaTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent arg0) {
                if (!arg0.getValueIsAdjusting()) {
                    QuotaPane.this.checkButtons();
                }
            }
        });
        this.ivSetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                int sel = QuotaPane.this.ivQuotaTable.getSelectedRow();
                if (sel != -1) {
                    Integer inti;
                    String group = (String)((QuotaPane)QuotaPane.this).ivQuotaTable.ivObjects.elementAt(sel);
                    int val = Requester.getInt(Inspector.getInspector(), Babel.get("QUOTA"), 0, false, -1, false, null);
                    if (val >= 0 && !(inti = new Integer(val)).equals(QuotaPane.this.ivQuotaTable.ivQuotaByGroupname.get(group))) {
                        InspectorCommandSender.executeCommand("QUOTA_SET " + QuotaPane.this.ivObjectID + " " + QuotaPane.this.ivObjectType + " " + Base64Manager.encodeBase64(group) + " " + (inti < 0 ? 0 : inti), "service");
                    }
                }
            }
        });
        this.ivClearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                int sel = QuotaPane.this.ivQuotaTable.getSelectedRow();
                if (sel != -1) {
                    String group = (String)((QuotaPane)QuotaPane.this).ivQuotaTable.ivObjects.elementAt(sel);
                    if (QuotaPane.this.ivQuotaTable.ivQuotaByGroupname.get(group) != null) {
                        InspectorCommandSender.executeCommand("QUOTA_SET " + QuotaPane.this.ivObjectID + " " + QuotaPane.this.ivObjectType + " " + Base64Manager.encodeBase64(group) + " " + "-1", "service");
                    }
                }
            }
        });
        this.adapt(null, null, null);
    }

    public void adapt(Vector selObjects, Vector mice, Vector changeSensitives) {
        if (selObjects == null || selObjects.isEmpty() || selObjects.size() != 1 || !MausoleumClient.isHeadOfService()) {
            this.ivQuotaTable.adapt(null);
            this.ivQuotaTable.clearSelection();
            this.ivQuotaTable.setEnabled(false);
            this.ivQuotaTable.setOpaque(false);
            this.ivScrollPane.setOpaque(false);
            this.ivObjectID = 0L;
            this.ivObjectType = 0;
        } else {
            QuotableIDObject qio = (QuotableIDObject)selObjects.firstElement();
            this.ivObjectID = qio.getID();
            this.ivObjectType = qio.getTyp();
            this.ivQuotaTable.adapt(qio);
            int sel = this.ivQuotaTable.getSelectedRow();
            if (sel == -1) {
                this.ivQuotaTable.clearSelection();
            } else {
                this.ivQuotaTable.getSelectionModel().setSelectionInterval(sel, sel);
            }
            this.ivQuotaTable.setEnabled(true);
            this.ivQuotaTable.setOpaque(true);
            this.ivScrollPane.setOpaque(true);
        }
        this.checkButtons();
    }

    private void checkButtons() {
        if (this.ivQuotaTable.isEnabled()) {
            int sel = this.ivQuotaTable.getSelectedRow();
            if (sel == -1) {
                this.ivSetButton.setEnabled(false);
                this.ivClearButton.setEnabled(false);
            } else {
                String group = (String)this.ivQuotaTable.ivObjects.elementAt(sel);
                boolean drin = this.ivQuotaTable.ivDefinedGroups.contains(group);
                this.ivSetButton.setEnabled(drin);
                this.ivClearButton.setEnabled(drin && this.ivQuotaTable.ivQuotaByGroupname.get(group) != null);
            }
        } else {
            this.ivSetButton.setEnabled(false);
            this.ivClearButton.setEnabled(false);
        }
    }

    class QuotaTable
    extends SortableTable
    implements TableCellRenderer {
        private static final long serialVersionUID = 123423L;
        private MGButton ivHeaderButton = MGButton.getInspectorActionButton("", "");
        private JLabel ivListLabel = new JLabel("QqyA");
        private final HashMap ivQuotaByGroupname = new HashMap();
        private final HashSet ivDefinedGroups = new HashSet();

        public QuotaTable() {
            Vector<String> groupNames = new Vector<String>();
            if (UsergroupManager.cvInstance != null) {
                Vector v = UsergroupManager.cvInstance.getActualObjectVectorAllGroups();
                if (v != null) {
                    Iterator iter = v.iterator();
                    while (iter.hasNext()) {
                        UserGroup ug = (UserGroup)iter.next();
                        groupNames.add(ug.getName());
                    }
                }
                Collections.sort(groupNames, StringHelper.CASE_INSENSITIVE_COMPARER);
            }
            this.setObjects(groupNames);
            this.getColumnModel().getColumn(0).setPreferredWidth(100);
            this.getColumnModel().getColumn(1).setPreferredWidth(30);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.setDefaultRenderer(clazz, this);
            this.getSelectionModel().setSelectionMode(0);
            this.setColumnSelectionAllowed(false);
            this.getTableHeader().setDefaultRenderer(new TableCellRenderer(this){
                final /* synthetic */ QuotaTable this$1;
                {
                    this.this$1 = quotaTable;
                }

                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    QuotaTable.access$0(this.this$1).setLabel(" " + this.this$1.getColumnName(column) + " ");
                    return QuotaTable.access$0(this.this$1);
                }
            });
            this.ivListLabel.setBackground(UIDef.SELECTED_BACKGROUND);
            this.setRowHeight(this.ivListLabel.getPreferredSize().height);
        }

        public void adaptAlt(QuotableIDObject qio) {
            this.ivQuotaByGroupname.clear();
            this.ivDefinedGroups.clear();
            if (qio != null) {
                int i;
                String[] groups = (String[])qio.get("QIO_GNAMES");
                int[] quota = (int[])qio.get("QIO_QUOTA");
                if (groups != null) {
                    i = 0;
                    while (i < quota.length) {
                        this.ivQuotaByGroupname.put(groups[i], new Integer(quota[i]));
                        ++i;
                    }
                }
                if ((groups = (String[])qio.get("IDO_UGROUPS")) != null) {
                    i = 0;
                    while (i < groups.length) {
                        this.ivDefinedGroups.add(groups[i]);
                        ++i;
                    }
                }
            }
            this.repaint();
        }

        public void adapt(QuotableIDObject qio) {
            this.ivQuotaByGroupname.clear();
            this.ivDefinedGroups.clear();
            if (qio != null) {
                int i;
                String[] groups = (String[])qio.get("QIO_GNAMES");
                int[] quota = (int[])qio.get("QIO_QUOTA");
                if (groups != null) {
                    i = 0;
                    while (i < quota.length) {
                        this.ivQuotaByGroupname.put(groups[i], new Integer(quota[i]));
                        ++i;
                    }
                }
                if (qio instanceof Building) {
                    Building building = (Building)qio;
                    Long bid = building.getLongID();
                    Iterator iter = ObjectStore.getActualObjectsITER(10, "service");
                    while (iter.hasNext()) {
                        Room room = (Room)iter.next();
                        if (!bid.equals(room.get("ROM_BUILDING")) || (groups = (String[])room.get("IDO_UGROUPS")) == null) continue;
                        int i2 = 0;
                        while (i2 < groups.length) {
                            this.ivDefinedGroups.add(groups[i2]);
                            ++i2;
                        }
                    }
                } else {
                    groups = (String[])qio.get("IDO_UGROUPS");
                    if (groups != null) {
                        i = 0;
                        while (i < groups.length) {
                            this.ivDefinedGroups.add(groups[i]);
                            ++i;
                        }
                    }
                }
            }
            this.repaint();
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return Babel.get("GROUP");
                }
                case 1: {
                    return Babel.get("QUOTA");
                }
            }
            return "";
        }

        public int getRowCount() {
            if (this.ivObjects != null) {
                return this.ivObjects.size();
            }
            return 0;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            if (rowIndex >= 0 && this.ivObjects != null && rowIndex < this.ivObjects.size()) {
                switch (columnIndex) {
                    case 0: {
                        return this.ivObjects.elementAt(rowIndex);
                    }
                    case 1: {
                        Integer quota = (Integer)this.ivQuotaByGroupname.get(this.ivObjects.elementAt(rowIndex));
                        if (quota == null) break;
                        return quota.toString();
                    }
                }
            }
            return "";
        }

        public Vector fillSortablesVector(int col) {
            return null;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.ivListLabel.setIcon(null);
            this.ivListLabel.setHorizontalAlignment(column == 1 ? 4 : 2);
            this.ivListLabel.setText(" " + value + " ");
            this.ivListLabel.setOpaque(isSelected);
            return UIDef.highlightLabelIf(this.ivListLabel, this.ivDefinedGroups.contains(this.ivObjects.elementAt(row)), false);
        }

        static /* synthetic */ MGButton access$0(QuotaTable quotaTable) {
            return quotaTable.ivHeaderButton;
        }
    }
}

