/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector.sensitives;

import de.hannse.netobjects.util.Babel;
import java.awt.event.ActionEvent;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.InspectorPanel;
import mausoleum.inspector.sensitives.CSAllg;
import mausoleum.requester.Requester;
import mausoleum.requester.pope.PopeAlert;

public class CSCageNumber
extends CSAllg {
    private int ivValue;
    private int ivRememberValue;

    public CSCageNumber(InspectorPanel ip) {
        super(ip, Babel.get("CAGENUMBER"));
    }

    public int getValue() {
        return this.ivValue;
    }

    public Vector getAffecteds(Vector selectedObjects) {
        return selectedObjects;
    }

    public void actionPerformed(ActionEvent e) {
        int val = Requester.getInt(Inspector.getInspector(), Babel.get("CAGENUMBER"), 0, false, -1, false, null);
        if (val != -1 && val != this.ivValue) {
            this.ivValue = val;
            InspectorPanel ip = this.getMatchingPanel();
            if (ip != null && ip.ivSelObjects.size() == 1) {
                Cage c = (Cage)ip.ivSelObjects.firstElement();
                if (PopeAlert.checkForCageNumberCollision(c = c.getSuperCageIfThere(), this.ivValue)) {
                    this.ivStatus = -3;
                    this.setTextAccordingly();
                    this.changed(this.ivRememberValue != this.ivValue);
                }
            }
        }
    }

    public void adaptToVector(Vector v) {
        if (v == null || v.size() != 1) {
            this.setToNonApplicable();
        }
        this.getCommonCageNumber(v);
        this.setTextAccordingly();
        this.ivRememberValue = this.ivValue;
        this.changed(false);
    }

    public String getValueLabel() {
        return Integer.toString(this.ivValue);
    }

    private void getCommonCageNumber(Vector v) {
        this.ivValue = 0;
        this.ivStatus = -1;
        if (v != null && !v.isEmpty()) {
            boolean first = true;
            int i = 0;
            while (i < v.size()) {
                Cage cage = (Cage)v.elementAt(i);
                if (first) {
                    this.ivValue = cage.getInt("CAG_PSEUDOID");
                    if (this.ivValue != 0) {
                        this.ivStatus = -3;
                    }
                    first = false;
                } else if (this.ivValue == cage.getInt("CAG_PSEUDOID")) {
                    this.ivStatus = -2;
                }
                ++i;
            }
        }
    }
}

