/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector.sensitives;

import de.hannse.netobjects.util.Babel;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.Vector;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.InspectorPanel;
import mausoleum.inspector.sensitives.CSAllg;
import mausoleum.mouse.Mouse;
import mausoleum.requester.AllgChoiceRequester;

public class CSGeneration
extends CSAllg {
    private static final int NOTHING = -3;
    private static final String[] STRING_CHOICES = new String[]{"", Babel.get("DELETE_GENERATION_MARKER"), Babel.get("CLEAR_MANUAL_GENERATION_MARKER"), "P / N1", "F1 / N2", "F2 / N3", "F3 / N4", "F4 / N5", "F5 / N6", "F6 / N7", "F7 / N8", "F8 / N9", "F9 / N10", "F10 / N11", "F11 / N12", "F12 / N13", "F13 / N14", "F14 / N15", "F15 / N16", "F16 / N17", "F17 / N18", "F18 / N19", "F19 / N20", "F20 / N21"};
    private static final int[] INT_CHOICES = new int[]{-3, -1, -2, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21};
    private int ivValue;
    private int ivRememberValue;

    public CSGeneration(InspectorPanel ip) {
        super(ip, Babel.get("GENERATION"));
    }

    public int getValue() {
        return this.ivValue;
    }

    public void actionPerformed(ActionEvent e) {
        int generation;
        int ind = AllgChoiceRequester.getIndexAnswer((Frame)Inspector.getInspector(), Babel.get("GENERATION"), STRING_CHOICES);
        if (ind != -1 && (generation = INT_CHOICES[ind]) != -3) {
            this.ivValue = generation;
            this.ivStatus = -3;
            this.setTextAccordingly();
            this.changed(this.ivRememberValue != this.ivValue);
        }
    }

    public void adaptToVector(Vector v) {
        if (v == null || v.isEmpty()) {
            this.setToNonApplicable();
        }
        this.getCommonGeneration(v);
        this.setTextAccordingly();
        this.ivRememberValue = this.ivValue;
        this.changed(false);
    }

    public String getValueLabel() {
        return Mouse.getGenerationString(this.ivValue, true);
    }

    public Vector getAffecteds(Vector selectedObjects) {
        return selectedObjects;
    }

    private void getCommonGeneration(Vector v) {
        this.ivValue = 0;
        this.ivStatus = -1;
        if (v != null) {
            boolean first = true;
            int i = 0;
            while (i < v.size()) {
                Mouse mausi = (Mouse)v.elementAt(i);
                if (first) {
                    this.ivValue = mausi.getGeneration(0, false);
                    if (this.ivValue != 0) {
                        this.ivStatus = -3;
                    }
                    first = false;
                } else if (this.ivValue != mausi.getGeneration(0, false)) {
                    this.ivStatus = -2;
                }
                ++i;
            }
        }
    }
}

