/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector.sensitives;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.util.Babel;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.alert.Alert;
import mausoleum.helper.AllgUtils;
import mausoleum.inspector.InspectorPanel;
import mausoleum.inspector.sensitives.CSAllg;
import mausoleum.license.License;
import mausoleum.license.LicenseManager;
import mausoleum.mouse.Mouse;
import mausoleum.requester.pope.PopeAlert;

public class CSLicense
extends CSAllg {
    public static final int MODE_MOUSE_LIZENZ_1 = 1;
    public static final int MODE_MOUSE_LIZENZ_2 = 2;
    public static final int MODE_LINE_LIZENZ = 3;
    public static final int MODE_MOUSE_LINE_LIZENZ = 4;
    private long ivCommonLicenseID = 0L;
    private long ivRememberValue = 0L;
    public License ivSelectedLicense = null;
    public final int ivMode;
    public boolean ivSetActMice = false;

    private static String getLabel(int mode) {
        switch (mode) {
            case 1: {
                return String.valueOf(Babel.get("LICENSE")) + " 1";
            }
            case 2: {
                return String.valueOf(Babel.get("LICENSE")) + " 2";
            }
            case 3: {
                return Babel.get("LICENSE");
            }
            case 4: {
                return Babel.get("LINE_LICENSE");
            }
        }
        return "?";
    }

    public CSLicense(InspectorPanel ip, int modus) {
        super(ip, CSLicense.getLabel(modus));
        this.ivMode = modus;
    }

    public Vector getAffecteds(Vector selectedObjects) {
        return selectedObjects;
    }

    public String getCommandValue() {
        if (this.ivMode == 3) {
            return String.valueOf(Long.toString(this.ivCommonLicenseID)) + " " + (this.ivSetActMice ? "1" : "0");
        }
        return Long.toString(this.ivCommonLicenseID);
    }

    public long getValue() {
        return this.ivCommonLicenseID;
    }

    public int getLizenzNummer() {
        if (this.ivMode == 1) {
            return 1;
        }
        if (this.ivMode == 2) {
            return 2;
        }
        return 0;
    }

    public void adaptToVector(Vector v) {
        this.ivSelectedLicense = null;
        String group = IDObject.commonGroup(v);
        if (group == null) {
            this.setToNonApplicable();
            return;
        }
        long licenseID = this.getLicenseID(v, group);
        if (licenseID == -1L) {
            this.ivCommonLicenseID = 0L;
            this.ivStatus = -1;
        } else if (licenseID == -2L) {
            this.ivCommonLicenseID = 0L;
            this.ivStatus = -2;
        } else {
            License license = (License)ObjectStore.getClientObject(16, licenseID, group);
            if (license != null) {
                this.ivSelectedLicense = license;
            }
            this.ivCommonLicenseID = licenseID;
            this.ivStatus = -3;
        }
        this.setTextAccordingly();
        this.ivRememberValue = this.ivCommonLicenseID;
        this.changed(false);
    }

    public String getValueLabel() {
        return this.ivSelectedLicense != null ? this.ivSelectedLicense.getBrowseNameInclServicePrefix() : Babel.get("UNKNOWN");
    }

    private long getLicenseID(Vector idObjects, String group) {
        if (this.ivMode == 1) {
            return IDObject.getCommonMouseRefID(idObjects, Mouse.getLicenseTag(1), -1L, -2L);
        }
        if (this.ivMode == 2) {
            return IDObject.getCommonMouseRefID(idObjects, Mouse.getLicenseTag(2), -1L, -2L);
        }
        if (this.ivMode == 3) {
            return IDObject.getCommonMouseRefID(idObjects, "LIN_LIC", -1L, -2L);
        }
        if (this.ivMode == 4) {
            return IDObject.getCommonMouseRefID(idObjects, "MOS_LINLICID", -1L, -2L);
        }
        return -1L;
    }

    public static String getAppropriateSelectionValues(Vector idObjects, int status, long idSoFar, String selNoneBabel) {
        if (status == -2) {
            return Babel.get(selNoneBabel);
        }
        if (status == -1) {
            return null;
        }
        if (idObjects != null && !idObjects.isEmpty()) {
            Vector<IDObject> tv = new Vector<IDObject>(idObjects.size());
            Iterator iterator = idObjects.iterator();
            while (iterator.hasNext()) {
                IDObject ido = (IDObject)iterator.next();
                if (ido.getID() == idSoFar) continue;
                tv.add(ido);
            }
            idObjects.clear();
            idObjects.addAll(tv);
        }
        return Babel.get(selNoneBabel);
    }

    public void actionPerformed(ActionEvent e) {
        Vector v;
        InspectorPanel ip;
        if ((this.ivMode == 1 || this.ivMode == 2 || this.ivMode == 3) && (ip = this.getMatchingPanel()) != null && (v = LicenseManager.getAllowedLicenses(IDObject.commonGroup(ip.ivSelObjects), this.ivMode == 1 || this.ivMode == 2)) != null) {
            String selNone = CSLicense.getAppropriateSelectionValues(v, this.ivStatus, this.ivCommonLicenseID, "INSP_MOUSE_SELD_NO_LICENSE");
            if (v.isEmpty() && selNone == null) {
                Alert.showAlert(Babel.get("NO_SELECTABLE_VALUE"), true);
            } else {
                IDObject[] retVal = new IDObject[1];
                long licenseID = AllgUtils.select(v, selNone, Babel.get("SETLICENSE"), retVal, false);
                if (licenseID != AllgUtils.ABBRUCH && this.checkSelection(licenseID)) {
                    if (licenseID == AllgUtils.SEL_NONE) {
                        this.ivSelectedLicense = null;
                        this.ivCommonLicenseID = 0L;
                        this.ivStatus = -1;
                    } else {
                        this.ivSelectedLicense = (License)retVal[0];
                        this.ivCommonLicenseID = licenseID;
                        this.ivStatus = -3;
                    }
                    this.setTextAccordingly();
                    this.changed(this.ivRememberValue != this.ivCommonLicenseID);
                }
            }
        }
    }

    private boolean checkSelection(long selectedLicenseID) {
        if (this.ivMode == 3) {
            this.ivSetActMice = false;
            if (selectedLicenseID == AllgUtils.SEL_NONE) {
                boolean res = PopeAlert.getAnswer(Babel.get("ALERT_CHANGE_LINE_LICENSE_TO_NULL"));
                if (res) {
                    int cres = Alert.showAlert(Babel.get("ALERT_CHANGE_LINE_LICENSE_TO_NULL_2"), Babel.get("YES"), Babel.get("NO"), Babel.get("CANCEL"), 3, false);
                    if (cres == 3) {
                        res = false;
                    } else if (cres == 1) {
                        this.ivSetActMice = true;
                    } else if (cres == 2) {
                        this.ivSetActMice = false;
                    }
                }
                return res;
            }
            this.ivSetActMice = true;
            return PopeAlert.getAnswer(Babel.get("ALERT_CHANGE_LINE_LICENSE"));
        }
        return true;
    }
}

