/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector.sensitives;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.util.Babel;
import java.awt.event.ActionEvent;
import java.util.Vector;
import mausoleum.alert.Alert;
import mausoleum.helper.AllgUtils;
import mausoleum.inspector.InspectorPanel;
import mausoleum.inspector.sensitives.CSAllg;
import mausoleum.inspector.sensitives.CSLicense;
import mausoleum.line.Line;
import mausoleum.line.LineManager;
import mausoleum.mouse.Mouse;

public class CSLine
extends CSAllg {
    private long ivCommonLineID = 0L;
    private long ivRememberValue = 0L;
    public Line ivSelectedLine = null;

    public CSLine(InspectorPanel ip) {
        super(ip, Babel.get("LINE"));
    }

    public String getCommandValue() {
        return Long.toString(this.ivCommonLineID);
    }

    public long getValue() {
        return this.ivCommonLineID;
    }

    public Vector getAffecteds(Vector selectedObjects) {
        return selectedObjects;
    }

    public void adaptToVector(Vector v) {
        this.ivSelectedLine = null;
        long lineid = Mouse.getCommonMouseRefID(v, "MOS_LINEID", -1L, -2L);
        if (lineid == -1L) {
            this.ivCommonLineID = 0L;
            this.ivStatus = -1;
            this.setLabel(Babel.get("NOTSET"));
        } else if (lineid == -2L) {
            this.ivCommonLineID = 0L;
            this.ivStatus = -2;
            this.setLabel(Babel.get("MULTIPLE"));
        } else {
            this.ivCommonLineID = lineid;
            this.ivStatus = -3;
            this.ivSelectedLine = ((Mouse)v.firstElement()).getLine();
            if (this.ivSelectedLine != null) {
                this.setLabel(this.ivSelectedLine.getBrowseName());
            } else {
                this.setLabel(Babel.get("UNKNOWN"));
            }
        }
        this.ivRememberValue = this.ivCommonLineID;
        this.changed(false);
    }

    public void actionPerformed(ActionEvent e) {
        Vector v;
        String commonGroup;
        InspectorPanel ip = this.getMatchingPanel();
        if (ip != null && (commonGroup = IDObject.commonGroup(ip.ivSelObjects)) != null && (v = LineManager.cvInstance.getActualObjectVector(commonGroup, true, true)) != null) {
            String selNone = CSLicense.getAppropriateSelectionValues(v, this.ivStatus, this.ivCommonLineID, "INSP_MOUSE_SELD_NO_LINE");
            if (v.isEmpty() && selNone == null) {
                Alert.showAlert(Babel.get("NO_SELECTABLE_VALUE"), true);
            } else {
                IDObject[] retVal = new IDObject[1];
                long lineID = AllgUtils.select(v, selNone, Babel.get("SETLINE"), retVal, true);
                if (lineID != AllgUtils.ABBRUCH) {
                    if (lineID == AllgUtils.SEL_NONE) {
                        this.ivSelectedLine = null;
                        this.ivCommonLineID = 0L;
                        this.ivStatus = -1;
                        this.setLabel(Babel.get("NOTSET"));
                    } else {
                        this.ivCommonLineID = lineID;
                        this.ivStatus = -3;
                        this.ivSelectedLine = (Line)retVal[0];
                        if (this.ivSelectedLine != null) {
                            this.setLabel(this.ivSelectedLine.getBrowseName());
                        } else {
                            this.setLabel(Babel.get("UNKNOWN"));
                        }
                    }
                    this.changed(this.ivRememberValue != this.ivCommonLineID);
                }
            }
        }
    }
}

