/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector.sensitives;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.util.Babel;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.Vector;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.InspectorPanel;
import mausoleum.inspector.sensitives.CSAllg;
import mausoleum.line.Line;
import mausoleum.mouse.tierschutz.Stress;
import mausoleum.requester.AllgChoiceRequester;

public class CSStressLevelLine
extends CSAllg {
    public static final int NULL_VALUE = -2;
    public static final int MULTIPLE_VALUE = -1;
    public static final int DELETE_VALUE = 0;
    private int ivStressLevel;
    private int ivRememberValue;
    private final boolean ivShowMinimum;

    public CSStressLevelLine(InspectorPanel ip, boolean showMinimum) {
        super(ip, Babel.get(showMinimum ? "LINE_MINIMAL_STRESS_LEVEL" : "LINE_MAXIMAL_STRESS_LEVEL"));
        this.ivShowMinimum = showMinimum;
    }

    public String getCommandValue() {
        return Integer.toString(this.ivStressLevel);
    }

    public int getValue() {
        return this.ivStressLevel;
    }

    public Vector getAffecteds(Vector selectedObjects) {
        return selectedObjects;
    }

    public void adaptToVector(Vector v) {
        this.ivStressLevel = IDObject.getCommonIntValue(v, "LIN_DEFSTR", -2, -1);
        if (this.ivStressLevel != -1 && !this.ivShowMinimum) {
            int ruleLevel = -2;
            int i = 0;
            while (i < v.size() && ruleLevel != -1) {
                Line line = (Line)v.elementAt(i);
                int lev = line.getMaxStressLevelFromRules(-2);
                if (i == 0) {
                    ruleLevel = lev;
                } else if (lev != ruleLevel) {
                    ruleLevel = -1;
                }
                ++i;
            }
            if (this.ivStressLevel == -2 || ruleLevel > this.ivStressLevel) {
                this.ivStressLevel = ruleLevel;
            }
        }
        this.ivStatus = this.ivStressLevel == -1 ? -2 : (this.ivStressLevel == -2 ? -1 : -3);
        this.setTextAccordingly();
        this.ivRememberValue = this.ivStressLevel;
        this.changed(false);
    }

    public String getValueLabel() {
        return this.ivStressLevel > 0 ? StringHelper.getStringForInt(this.ivStressLevel, Stress.STRESS_INTS, Stress.STRESS_BABELS, true, "") : "";
    }

    public void actionPerformed(ActionEvent e) {
        int ind;
        if (this.ivShowMinimum && (ind = AllgChoiceRequester.getIndexAnswer((Frame)Inspector.getInspector(), Babel.get("STRESS_LEVEL"), Stress.getLineStressChoices())) != -1) {
            this.ivStressLevel = Stress.STRESS_INTS_OHNE_NOT_DEF[ind];
            this.ivStatus = -3;
            this.setTextAccordingly();
            this.changed(this.ivStressLevel != this.ivRememberValue);
        }
    }
}

