/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector.sensitives;

import de.hannse.netobjects.objectstore.IDObject;
import java.awt.Color;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import mausoleum.helper.FontManager;
import mausoleum.inspector.InspectorPanel;
import mausoleum.inspector.SensitiveTable;
import mausoleum.inspector.sensitives.ChangeSensitive;
import mausoleum.ui.UIDef;

public class CSTextArea
extends JTextArea
implements DocumentListener,
ChangeSensitive {
    private static final long serialVersionUID = -2529464771475864221L;
    private String ivRememberString;
    private InspectorPanel ivPanel;
    private boolean ivChanged = false;
    private final String ivTag;

    public CSTextArea(InspectorPanel ip, String tag) {
        super("");
        this.ivPanel = ip;
        this.ivPanel.addChangeSensitive(this);
        this.getDocument().addDocumentListener(this);
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
        this.setFont(FontManager.getFont("SSB12"));
        this.setMargin(new Insets(4, 4, 4, 4));
        this.ivTag = tag;
    }

    public Vector getAffecteds(Vector selectedObjects) {
        return selectedObjects;
    }

    public void adaptToVector(Vector v) {
        String s = "";
        if (v != null && v.size() == 1 && v.firstElement() instanceof IDObject) {
            IDObject ido = (IDObject)v.firstElement();
            s = ido.getString(this.ivTag, "");
        }
        this.setText(s);
    }

    public void setText(String text) {
        if (text == null) {
            text = "";
        }
        this.ivRememberString = text;
        this.ivChanged = false;
        super.setText(text);
        this.setCaretPosition(0);
    }

    public void setForeground(Color fg) {
        this.setDisabledTextColor(fg);
        super.setForeground(fg);
    }

    public void textValueChanged() {
        if (!this.isEnabled()) {
            return;
        }
        if (this.ivRememberString == null) {
            if (this.getText().length() != 0) {
                this.changed(true);
            } else {
                this.changed(false);
            }
        } else if (this.ivRememberString.equals(this.getText())) {
            this.changed(false);
        } else {
            this.changed(true);
        }
    }

    private void changed(boolean val) {
        if (val) {
            this.ivChanged = true;
            this.setBackground(UIDef.CHANGED_BACKGROUND);
            this.setForeground(UIDef.CHANGED_FOREGROUND);
        } else {
            this.ivChanged = false;
            this.setBackground(SensitiveTable.ENABLED_COLOR);
            this.setForeground(Color.black);
        }
        this.ivPanel.somethingChanged();
    }

    public boolean didYouChange() {
        return this.ivChanged;
    }

    public void setState(boolean active) {
        if (active) {
            this.setToActive();
        } else {
            this.setToPassive();
        }
    }

    public void setToActive() {
        this.setEditable(true);
        this.setEnabled(true);
        this.setForeground(Color.black);
        this.setBackground(SensitiveTable.ENABLED_COLOR);
        this.setOpaque(true);
        this.repaint();
    }

    public void setToPassive() {
        this.setEditable(false);
        this.setEnabled(false);
        this.setForeground(Color.black);
        this.setBackground(Color.white);
        this.setOpaque(true);
        this.ivChanged = false;
    }

    public void setToNonApplicable() {
        this.ivRememberString = null;
        this.setText("");
        this.setEditable(false);
        this.setEnabled(false);
        this.setForeground(Color.black);
        this.setBackground(SensitiveTable.NA_COLOR);
        this.setOpaque(true);
        this.ivChanged = false;
    }

    public String getPrefixText() {
        return null;
    }

    public String getValueText() {
        return this.getText();
    }

    public boolean isActive() {
        return this.isEnabled();
    }

    public boolean isPassive() {
        return !this.isEnabled();
    }

    public boolean isNonApplicable() {
        return !this.isEnabled() && this.ivRememberString == null;
    }

    public int getStatus() {
        return 0;
    }

    public void insertUpdate(DocumentEvent e) {
        this.textValueChanged();
    }

    public void removeUpdate(DocumentEvent e) {
        this.textValueChanged();
    }

    public void changedUpdate(DocumentEvent e) {
        this.textValueChanged();
    }
}

