/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.line;

import de.hannse.netobjects.datalayer.DataLayer;
import de.hannse.netobjects.objectstore.CommandManagerExecutive;
import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.IDObjectXMLHandler;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.ArrayHelper;
import de.hannse.netobjects.util.Babel;
import java.awt.Color;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import mausoleum.alert.Alert;
import mausoleum.gui.ColorManager;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.util.InspectorCommandSender;
import mausoleum.locus.Locus;
import mausoleum.locus.LocusAndAlleles;
import mausoleum.locus.LocusManager;
import mausoleum.mouse.tierschutz.StressRule;
import mausoleum.requester.SelectIDObjectRequester;
import mausoleum.util.InstallationType;

public class Line
extends IDObject {
    private static final long serialVersionUID = 4568198735435L;
    public static final Color BREEDER_COLOR = new Color(200, 200, 200);
    private static final String LIN_PREFIX = "LIN_";
    public static final String NAME = "LIN_NAME";
    public static final String LOCIALLELES = "LIN_LOCIALLELES";
    public static final String COLOR = "LIN_COLOR";
    public static final String ENTERERID = "LIN_ENTERER";
    public static final String DESCRIPTION = "LIN_DESCRIPTION";
    public static final String CHANGEABLE = "LIN_CHANGE";
    public static final String MAT_LIMIT = "LIN_MATLIM";
    public static final String AN_TAG = "LIN_TAG";
    public static final String EARTAG_PREFIX = "LIN_ETPREFIX";
    public static final String AUTO_GENOTYPE_OK = "LIN_AUTOGTOK";
    public static final String ALWAYS_PRALINE = "LIN_ALPRAL";
    public static final String DEFAULT_STRESS = "LIN_DEFSTR";
    public static final String STRESS_RULES = "LIN_STRRUL";
    public static final String LICENSEID = "LIN_LIC";
    public static final String EVALUATION = "LIN_EVAL";
    public static final String EXPECTED_PROPS = "LIN_EXPROPS";
    public static final String[] ATTRIBUTES_LINE;
    public static final String[] ORDERED_ATTRIBUTES;
    private static final String[] MERGE_ATTRIBUTES_FROM_SERVICE_TO_EXISTING_GROUP_OBJECT;
    private static final HashSet EXPORT_ATTRIBUTES;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;

    static {
        String[] stringArray = new String[32];
        stringArray[0] = NAME;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[1] = clazz.getName();
        stringArray[2] = COLOR;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.awt.Color");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[3] = clazz2.getName();
        stringArray[4] = ENTERERID;
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[5] = clazz3.getName();
        stringArray[6] = DESCRIPTION;
        Class<?> clazz4 = class$0;
        if (clazz4 == null) {
            try {
                clazz4 = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[7] = clazz4.getName();
        stringArray[8] = CHANGEABLE;
        Class<?> clazz5 = class$3;
        if (clazz5 == null) {
            try {
                clazz5 = class$3 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[9] = clazz5.getName();
        stringArray[10] = LOCIALLELES;
        Class<?> clazz6 = class$4;
        if (clazz6 == null) {
            try {
                clazz6 = class$4 = Class.forName("[Lmausoleum.locus.LocusAndAlleles;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[11] = clazz6.getName();
        stringArray[12] = MAT_LIMIT;
        Class<?> clazz7 = class$5;
        if (clazz7 == null) {
            try {
                clazz7 = class$5 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[13] = clazz7.getName();
        stringArray[14] = AN_TAG;
        Class<?> clazz8 = class$0;
        if (clazz8 == null) {
            try {
                clazz8 = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[15] = clazz8.getName();
        stringArray[16] = EARTAG_PREFIX;
        Class<?> clazz9 = class$0;
        if (clazz9 == null) {
            try {
                clazz9 = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[17] = clazz9.getName();
        stringArray[18] = AUTO_GENOTYPE_OK;
        Class<?> clazz10 = class$3;
        if (clazz10 == null) {
            try {
                clazz10 = class$3 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[19] = clazz10.getName();
        stringArray[20] = ALWAYS_PRALINE;
        Class<?> clazz11 = class$3;
        if (clazz11 == null) {
            try {
                clazz11 = class$3 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[21] = clazz11.getName();
        stringArray[22] = DEFAULT_STRESS;
        Class<?> clazz12 = class$5;
        if (clazz12 == null) {
            try {
                clazz12 = class$5 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[23] = clazz12.getName();
        stringArray[24] = STRESS_RULES;
        Class<?> clazz13 = class$6;
        if (clazz13 == null) {
            try {
                clazz13 = class$6 = Class.forName("[Lmausoleum.mouse.tierschutz.StressRule;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[25] = clazz13.getName();
        stringArray[26] = LICENSEID;
        Class<?> clazz14 = class$2;
        if (clazz14 == null) {
            try {
                clazz14 = class$2 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[27] = clazz14.getName();
        stringArray[28] = EVALUATION;
        Class<?> clazz15 = class$5;
        if (clazz15 == null) {
            try {
                clazz15 = class$5 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[29] = clazz15.getName();
        stringArray[30] = EXPECTED_PROPS;
        Class<?> clazz16 = class$0;
        if (clazz16 == null) {
            try {
                clazz16 = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[31] = clazz16.getName();
        ATTRIBUTES_LINE = stringArray;
        ORDERED_ATTRIBUTES = new String[]{"IDO_ID", "IDO_START_DATE", "IDO_END_DATE", "IDO_VERSION", "IDO_UNIQUELONG", "IDO_VISIBLE", "IDO_NEVER_EXISTED", "IDO_OGROUP", "IDO_FKEY", "IDO_DOK", "IDO_SERVID", "IDO_UGROUPS", "IDO_UGROUPIDS", "IDO_SUBTYP", NAME, COLOR, ENTERERID, DESCRIPTION, CHANGEABLE, LOCIALLELES, MAT_LIMIT, AN_TAG, EARTAG_PREFIX, AUTO_GENOTYPE_OK, ALWAYS_PRALINE, DEFAULT_STRESS, STRESS_RULES, LICENSEID, EVALUATION, EXPECTED_PROPS};
        MERGE_ATTRIBUTES_FROM_SERVICE_TO_EXISTING_GROUP_OBJECT = new String[]{NAME, COLOR, DESCRIPTION, MAT_LIMIT, AN_TAG, EARTAG_PREFIX, AUTO_GENOTYPE_OK, ALWAYS_PRALINE, DEFAULT_STRESS, STRESS_RULES, EVALUATION, EXPECTED_PROPS, "IDO_VISIBLE"};
        EXPORT_ATTRIBUTES = ArrayHelper.createHashSet(new String[]{"IDO_SERVID", NAME, LOCIALLELES, COLOR, CHANGEABLE, DESCRIPTION, AUTO_GENOTYPE_OK, ALWAYS_PRALINE, DEFAULT_STRESS, STRESS_RULES, EVALUATION, EXPECTED_PROPS});
    }

    public static Line getBreederLine(String groupname) {
        Line breeder = new Line();
        breeder.set("IDO_START_DATE", new Date());
        breeder.setBoolean(CHANGEABLE, false);
        breeder.setLong(ENTERERID, 0L);
        breeder.set(NAME, "breeder");
        breeder.set(COLOR, BREEDER_COLOR);
        breeder.set("IDO_GROUP", groupname);
        DataLayer.cvDataLayer.provideNewIDToIDObject(breeder);
        breeder.commit(true);
        return breeder;
    }

    public static Line mixLines(Line line1, Line line2) {
        if (line1 == null || line1.isBreeder()) {
            return line2;
        }
        if (line2 == null || line2.isBreeder()) {
            return line1;
        }
        Vector<Line> lines = new Vector<Line>(2);
        lines.add(line1);
        lines.add(line2);
        String group = IDObject.commonGroup(lines);
        if (group == null) {
            return null;
        }
        Line resLine = new Line();
        resLine.setBoolean(CHANGEABLE, true);
        resLine.set(NAME, String.valueOf(line1.getString(NAME, "")) + "/" + line2.getString(NAME, ""));
        Color mixc = Color.white;
        Color col1 = (Color)line1.get(COLOR);
        Color col2 = (Color)line2.get(COLOR);
        if (col1 != null && col2 != null) {
            mixc = ColorManager.mix(col1, col2);
        } else if (col1 != null) {
            mixc = col1;
        } else if (col2 != null) {
            mixc = col2;
        }
        resLine.set(COLOR, mixc);
        Hashtable neededAllelesByLocusID = new Hashtable();
        line1.collectYourData(neededAllelesByLocusID);
        line2.collectYourData(neededAllelesByLocusID);
        if (!neededAllelesByLocusID.isEmpty()) {
            LocusAndAlleles[] laaArray = new LocusAndAlleles[neededAllelesByLocusID.size()];
            int ap = 0;
            Enumeration en = neededAllelesByLocusID.keys();
            while (en.hasMoreElements()) {
                Long locusID = (Long)en.nextElement();
                Vector allelStrings = (Vector)neededAllelesByLocusID.get(locusID);
                Locus locus = (Locus)ObjectStore.getClientObject(14, locusID, group);
                if (locus == null) continue;
                laaArray[ap] = new LocusAndAlleles(locus, allelStrings);
                ++ap;
            }
            resLine.set(LOCIALLELES, laaArray);
        }
        return resLine;
    }

    public static Line getMatchingLineIfThere(Line line1, Line line2, Vector allLines) {
        Line selLine;
        if (line1 == null) {
            return line2;
        }
        if (line2 == null) {
            return line1;
        }
        if (line1.getID() == line2.getID()) {
            return line1;
        }
        if (line1.isBreeder()) {
            return line2;
        }
        if (line2.isBreeder()) {
            return line1;
        }
        Hashtable neededAllelesByLocusID = new Hashtable();
        line1.collectYourData(neededAllelesByLocusID);
        line2.collectYourData(neededAllelesByLocusID);
        if (neededAllelesByLocusID.isEmpty()) {
            return line1;
        }
        Vector<Line> matchingLines = new Vector<Line>();
        int i = 0;
        while (i < allLines.size()) {
            Line line = (Line)allLines.elementAt(i);
            if (line.doYouMatch(neededAllelesByLocusID)) {
                matchingLines.add(line);
            }
            ++i;
        }
        if (matchingLines.size() == 1) {
            return (Line)matchingLines.firstElement();
        }
        if (matchingLines.size() > 1 && (selLine = SelectIDObjectRequester.getSelectedLine(Inspector.getInspector(), matchingLines, true)) != null) {
            return selLine;
        }
        return null;
    }

    public static void createLineOnServer(Line newLine) {
        boolean res;
        if (newLine != null && (res = Alert.showAlert(String.valueOf(Babel.get("ALERTWANTADDNEWLINE")) + " " + newLine.getString(NAME) + "?", "YES", "NO", false))) {
            StringBuffer msb = new StringBuffer();
            msb.append("LINNEW");
            msb.append(" ").append(Base64Manager.encodeBase64(newLine.getString(NAME)));
            Color col = (Color)newLine.get(COLOR);
            msb.append(" ").append(CommandManagerExecutive.convertColor(col));
            String locandalleles = LocusAndAlleles.getTransportString((LocusAndAlleles[])newLine.get(LOCIALLELES));
            msb.append(" ").append(Base64Manager.encodeBase64(locandalleles));
            msb.append(" ").append(Long.toString(UserManager.getIDOFUser()));
            msb.append(" ").append(newLine.getLong("IDO_UNIQUELONG", 0L));
            InspectorCommandSender.executeCommand(msb.toString(), newLine.getGroup());
        }
    }

    public void propagateAttributeInSubObject(String key, Object val) {
        StressRule[] arr;
        boolean erledigt = false;
        if (key.equals(LOCIALLELES)) {
            LocusAndAlleles[] sarr;
            if (val instanceof LocusAndAlleles[] && (sarr = (LocusAndAlleles[])val).length != 0) {
                Vector allLociInGroup = ObjectStore.getActualObjects(14, this.getGroup());
                LocusAndAlleles[] tarr = new LocusAndAlleles[sarr.length];
                int i = 0;
                while (i < tarr.length) {
                    tarr[i] = new LocusAndAlleles();
                    tarr[i].ivAllele = sarr[i].ivAllele;
                    Locus groupLocus = Locus.findLocusWithServiceID(sarr[i].ivLocusID, allLociInGroup);
                    if (groupLocus == null) {
                        throw new IllegalArgumentException("Corresponding Locus to Service Locus (ID=" + sarr[i].ivLocusID + ") not found in Group " + this.getGroup() + " while propagating LocusAndAllel-Array");
                    }
                    tarr[i].ivLocusID = groupLocus.getID();
                    ++i;
                }
                this.set(key, tarr);
                erledigt = true;
            }
        } else if (key.equals(STRESS_RULES) && val != null && val instanceof StressRule[] && (arr = (StressRule[])val).length != 0) {
            StressRule[] res = new StressRule[arr.length];
            int i = 0;
            while (i < arr.length) {
                StressRule rule = arr[i];
                res[i] = StressRule.getCopyFromService(rule, this.getGroup());
                ++i;
            }
            if (res != null) {
                this.set(key, res);
                erledigt = true;
            }
        }
        if (!erledigt) {
            super.propagateAttributeInSubObject(key, val);
        }
    }

    public String getName(String nullVal) {
        return this.isBreeder() ? this.getString(NAME, nullVal) : InstallationType.obfuscate(this.getString(NAME, nullVal));
    }

    public String getName() {
        return this.getName(null);
    }

    public String getBrowseName() {
        return this.getName("Line " + this.getID());
    }

    public boolean isFullServicableObject() {
        return true;
    }

    public void addBrowserLines(Vector target, String group, HashSet wantedObjectTypes) {
        String s;
        int matlim;
        LocusAndAlleles[] arr;
        Color c;
        long l;
        super.addBrowserLines(target, group, wantedObjectTypes);
        target.add("Name = " + this.getString(NAME, ""));
        if ((wantedObjectTypes == null || wantedObjectTypes.contains(new Integer(6))) && (l = this.getLong(ENTERERID, 0L)) != 0L) {
            IDObject ido = ObjectStore.getObjectDeadOrAlive(6, l, group, null, false);
            target.add("Enterer: " + ido.getBrowseName() + "\t" + "object|" + group + "|" + 6 + "|" + l);
        }
        if ((c = (Color)this.get(COLOR)) != null) {
            target.add("Color = (" + c.getRed() + "," + c.getGreen() + "," + c.getBlue() + ")");
        }
        if (this.getBoolean(CHANGEABLE, false)) {
            target.add("Changeable");
        }
        if ((wantedObjectTypes == null || wantedObjectTypes.contains(new Integer(14))) && (arr = (LocusAndAlleles[])this.get(LOCIALLELES)) != null) {
            int i = 0;
            while (i < arr.length) {
                if (arr[i].ivAllele != null) {
                    int j = 0;
                    while (j < arr[i].ivAllele.length) {
                        IDObject ido = ObjectStore.getObjectDeadOrAlive(14, arr[i].ivLocusID, group, null, false);
                        target.add("Allel: \"" + arr[i].ivAllele[j] + "\" from Locus: " + ido.getBrowseName() + "\t" + "object|" + group + "|" + 14 + "|" + arr[i].ivLocusID);
                        ++j;
                    }
                }
                ++i;
            }
        }
        if ((matlim = this.getInt(MAT_LIMIT, 0)) != 0) {
            target.add("Maturity limit [days] = " + matlim);
        }
        if ((s = this.getString(AN_TAG, null)) != null) {
            target.add("Tag = " + s);
        }
        if ((s = this.getString(EARTAG_PREFIX, null)) != null) {
            target.add("Eartag Prefix = " + s);
        }
        if ((s = this.getString(DESCRIPTION, null)) != null && s.trim().length() != 0) {
            target.add("Description\t\t" + Base64Manager.encodeBase64(s));
        }
    }

    public Color getForegroundColor() {
        return ColorManager.getForegroundColorForBackground((Color)this.get(COLOR));
    }

    public boolean isChangeable() {
        return !this.isBreeder();
    }

    public int getMaxStressLevel(boolean withRules, int nullValue) {
        int ruleLevel;
        int defLevel = this.getInt(DEFAULT_STRESS, nullValue);
        if (withRules && (ruleLevel = this.getMaxStressLevelFromRules(nullValue)) > defLevel) {
            defLevel = ruleLevel;
        }
        return defLevel;
    }

    public int getMaxStressLevelFromRules(int nullValue) {
        int level = nullValue;
        StressRule[] arr = (StressRule[])this.get(STRESS_RULES);
        if (arr != null && arr.length != 0) {
            level = 0;
            int i = 0;
            while (i < arr.length) {
                if (arr[i].ivStress > level) {
                    level = arr[i].ivStress;
                }
                ++i;
            }
            return level;
        }
        return nullValue;
    }

    public boolean isBreeder() {
        return !this.getBoolean(CHANGEABLE, true);
    }

    public boolean isLocusContained(long locusID) {
        LocusAndAlleles[] lal = (LocusAndAlleles[])this.get(LOCIALLELES);
        if (lal != null) {
            int i = 0;
            while (i < lal.length) {
                if (lal[i].ivLocusID == locusID) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public HashSet getLocusIDs() {
        LocusAndAlleles[] lal;
        HashSet<Long> erg = new HashSet<Long>();
        if (!this.isBreeder() && (lal = (LocusAndAlleles[])this.get(LOCIALLELES)) != null) {
            int i = 0;
            while (i < lal.length) {
                erg.add(new Long(lal[i].ivLocusID));
                ++i;
            }
        }
        return erg;
    }

    public void collectYourData(Hashtable neededAllelesByLocusID) {
        LocusAndAlleles[] lal;
        if (!this.isBreeder() && (lal = (LocusAndAlleles[])this.get(LOCIALLELES)) != null) {
            int i = 0;
            while (i < lal.length) {
                Long key = new Long(lal[i].ivLocusID);
                Vector<String> allels = (Vector<String>)neededAllelesByLocusID.get(key);
                if (allels == null) {
                    allels = new Vector<String>();
                    neededAllelesByLocusID.put(key, allels);
                }
                int ai = 0;
                while (ai < lal[i].ivAllele.length) {
                    if (!allels.contains(lal[i].ivAllele[ai])) {
                        allels.addElement(lal[i].ivAllele[ai]);
                    }
                    ++ai;
                }
                ++i;
            }
        }
    }

    public String getExportString() {
        return IDObjectXMLHandler.getExportXML(this, EXPORT_ATTRIBUTES);
    }

    public boolean isObjectIdenticalForGroupTransfer(IDObject idObject) {
        if (idObject instanceof Line) {
            Line line = (Line)idObject;
            Hashtable neededAllelesByLocusID = new Hashtable();
            this.collectYourData(neededAllelesByLocusID);
            if (line.doYouMatch(neededAllelesByLocusID)) {
                return true;
            }
        }
        return false;
    }

    public Hashtable getExtendableAlleles() {
        LocusAndAlleles[] lalArray = (LocusAndAlleles[])this.get(LOCIALLELES);
        if (lalArray != null) {
            Hashtable erg = new Hashtable(lalArray.length);
            int i = 0;
            while (i < lalArray.length) {
                String[] alleles;
                Locus locus = (Locus)ObjectStore.getClientObject(14, lalArray[i].ivLocusID, this.getGroup());
                if (locus != null && (alleles = (String[])locus.get("LOC_ALLELES")) != null) {
                    HashSet<String> laHS = new HashSet<String>();
                    int ai = 0;
                    while (ai < alleles.length) {
                        if (locus.isAlleleAvailable(alleles[ai])) {
                            laHS.add(alleles[ai]);
                        }
                        ++ai;
                    }
                    if (lalArray[i].ivAllele != null) {
                        ai = 0;
                        while (ai < lalArray[i].ivAllele.length) {
                            laHS.remove(lalArray[i].ivAllele[ai]);
                            ++ai;
                        }
                    }
                    if (!laHS.isEmpty()) {
                        Vector eav = new Vector(laHS.size());
                        Iterator iter = laHS.iterator();
                        while (iter.hasNext()) {
                            eav.add(iter.next());
                        }
                        erg.put(locus, eav);
                    }
                }
                ++i;
            }
            if (!erg.isEmpty()) {
                return erg;
            }
        }
        return null;
    }

    public Hashtable getRemovableAlleles() {
        LocusAndAlleles[] lalArray = (LocusAndAlleles[])this.get(LOCIALLELES);
        if (lalArray != null) {
            Hashtable erg = new Hashtable(lalArray.length);
            int i = 0;
            while (i < lalArray.length) {
                Locus locus;
                if (lalArray[i].ivAllele.length > 1 && (locus = (Locus)ObjectStore.getClientObject(14, lalArray[i].ivLocusID, this.getGroup())) != null) {
                    Vector<String> v = new Vector<String>(lalArray[i].ivAllele.length);
                    int j = 0;
                    while (j < lalArray[i].ivAllele.length) {
                        v.add(lalArray[i].ivAllele[j]);
                        ++j;
                    }
                    erg.put(locus, v);
                }
                ++i;
            }
            if (!erg.isEmpty()) {
                return erg;
            }
        }
        return null;
    }

    public void addOverviewInfo(TreeMap target) {
        LocusAndAlleles[] lalArr;
        if (this.isAliveAndVisible() && !this.isBreeder() && (lalArr = (LocusAndAlleles[])this.get(LOCIALLELES)) != null && lalArr.length != 0) {
            TreeMap<String, String> locusTM = new TreeMap<String, String>();
            int i = 0;
            while (i < lalArr.length) {
                Locus locus = (Locus)ObjectStore.getObjectDeadOrAlive(14, lalArr[i].ivLocusID, this.getGroup(), null, false);
                if (locus != null) {
                    StringBuffer msb = new StringBuffer();
                    int j = 0;
                    while (j < lalArr[i].ivAllele.length) {
                        if (j != 0) {
                            msb.append(", ");
                        }
                        msb.append(locus.getAlias(lalArr[i].ivAllele[j]));
                        ++j;
                    }
                    locusTM.put(locus.getName(), msb.toString());
                }
                ++i;
            }
            target.put(this.getName(), locusTM);
        }
    }

    public boolean hasLicense() {
        Long licID = (Long)this.get(LICENSEID);
        return licID != null && licID > 0L;
    }

    public String getTableLocusString() {
        StringBuilder msb = new StringBuilder();
        LocusAndAlleles[] larr = (LocusAndAlleles[])this.get(LOCIALLELES);
        if (larr != null) {
            int i = 0;
            while (i < larr.length) {
                Locus locus;
                if (msb.length() != 0) {
                    msb.append(", ");
                }
                if ((locus = LocusManager.getLocus(larr[i].ivLocusID, this.getGroup())) != null) {
                    msb.append(locus.getName());
                    msb.append(" [").append(locus.getAllelString(larr[i])).append("]");
                } else {
                    msb.append("???");
                }
                ++i;
            }
        }
        return msb.toString();
    }

    public boolean doYouMatch(Hashtable neededAllelesByLocusID) {
        LocusAndAlleles[] laaArray = (LocusAndAlleles[])this.get(LOCIALLELES);
        if (neededAllelesByLocusID == null || neededAllelesByLocusID.isEmpty()) {
            return laaArray == null || laaArray.length == 0;
        }
        if (laaArray == null) {
            return false;
        }
        if (laaArray.length != neededAllelesByLocusID.size()) {
            return false;
        }
        int i = 0;
        while (i < laaArray.length) {
            if (laaArray[i].ivAllele == null) {
                return false;
            }
            long arrlid = laaArray[i].ivLocusID;
            Vector neededAlleles = (Vector)neededAllelesByLocusID.get(new Long(arrlid));
            if (neededAlleles == null) {
                return false;
            }
            HashSet gelieferte = new HashSet(neededAlleles);
            HashSet<String> meine = new HashSet<String>();
            int ai = 0;
            while (ai < laaArray[i].ivAllele.length) {
                meine.add(laaArray[i].ivAllele[ai]);
                ++ai;
            }
            if (meine.size() != gelieferte.size()) {
                return false;
            }
            Iterator iterator = meine.iterator();
            while (iterator.hasNext()) {
                if (gelieferte.contains(iterator.next())) continue;
                return false;
            }
            ++i;
        }
        return true;
    }

    public String[] getMergeAttributesFromServiceToExistingGroupObject() {
        return MERGE_ATTRIBUTES_FROM_SERVICE_TO_EXISTING_GROUP_OBJECT;
    }

    public String getBrowseNameInclServicePrefixAndEarTagPrefix() {
        String prefix = this.getString(EARTAG_PREFIX, null);
        return String.valueOf(this.getBrowseNameInclServicePrefix()) + (prefix != null ? " (" + prefix + ")" : "");
    }
}

