/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.line;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.RequestManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import mausoleum.alert.Alert;
import mausoleum.gui.BorderPanel;
import mausoleum.gui.MGButton;
import mausoleum.helper.AllgUtils;
import mausoleum.helper.FontManager;
import mausoleum.line.Line;
import mausoleum.line.LineManager;
import mausoleum.locus.EditLocusAllelesRequester;
import mausoleum.locus.Locus;
import mausoleum.locus.LocusAndAlleles;
import mausoleum.locus.LocusManager;
import mausoleum.locus.SelectLocusAndAllelesRequester;
import mausoleum.main.MausoleumClient;
import mausoleum.requester.BasicRequester;
import mausoleum.requester.color.ColorRequester;
import mausoleum.requester.color.ColorTestLabel;
import mausoleum.ui.UIDef;

public class LineAddRequester
extends BasicRequester
implements TableModel {
    private static final long serialVersionUID = 14564486135L;
    private static final int BREITE = UIDef.getScaled(600);
    private static final int HOEHE = UIDef.getScaled(300);
    private JTextField ivNameField = new JTextField("", 5);
    private ColorTestLabel ivColorLabel = new ColorTestLabel();
    private MGButton ivAddLocusButton = MGButton.getRequesterButton(Babel.get("ADDLOCUS"));
    private MGButton ivRemoveLocusButton = MGButton.getRequesterButton(Babel.get("REMOVELOCUS"));
    private MGButton ivEditLocusButton = MGButton.getRequesterButton(Babel.get("EDITLOCUS"));
    private MGButton ivMoveLocusUpButton = MGButton.getRequesterButton(Babel.get("MOVEUPLOCUS"));
    private MGButton ivMoveLocusDownButton = MGButton.getRequesterButton(Babel.get("MOVEDOWNLOCUS"));
    private JTable ivLocusTable = new JTable(this);
    private JLabel ivLocusLabel = new JLabel("QqyW");
    private MGButton ivHeaderButton = MGButton.getInspectorActionButton("", "");
    private Color ivLineColor = Color.yellow;
    private LocusAndAlleles[] ivLineLoci = null;
    private Frame ivSender;
    private LocusAndAlleles ivSelectedLocus = null;
    private final String ivGroup;
    static /* synthetic */ Class class$0;

    public static Line createMixtureLine(Frame sender, Line line1, Line line2) {
        String commonGroup;
        if (line1 != null && line2 != null && (commonGroup = IDObject.commonGroup(AllgUtils.getVec(line1, line2))) != null) {
            LineAddRequester lar = new LineAddRequester(sender, commonGroup);
            Line mixLine = Line.mixLines(line1, line2);
            lar.ivNameField.setText(mixLine.getString("LIN_NAME", ""));
            lar.ivLineColor = (Color)mixLine.get("LIN_COLOR");
            lar.ivColorLabel.setBackground(lar.ivLineColor);
            lar.ivLineLoci = (LocusAndAlleles[])mixLine.get("LIN_LOCIALLELES");
            lar.adaptButtons();
            lar.listChanged();
            return LineAddRequester.displayNewLineRequester(lar);
        }
        return null;
    }

    public static Line getNewLine(Frame sender, String group) {
        return LineAddRequester.displayNewLineRequester(new LineAddRequester(sender, group));
    }

    private static Line displayNewLineRequester(LineAddRequester lar) {
        lar.setVisible(true);
        if (lar.ivWarOK) {
            Line l = new Line();
            l.setBoolean("LIN_CHANGE", true);
            l.set("IDO_GROUP", lar.ivGroup);
            l.set("LIN_NAME", lar.ivNameField.getText().trim());
            l.set("LIN_COLOR", lar.ivLineColor);
            l.set("LIN_LOCIALLELES", lar.ivLineLoci);
            Object o = RequestManager.createSendAndGetObjectIfFinished((byte)25, null, lar.ivGroup);
            if (o != null) {
                l.set("IDO_UNIQUELONG", o);
            }
            return l;
        }
        return null;
    }

    private LineAddRequester(Frame sender, String group) {
        super(sender, BREITE, HOEHE);
        this.ivSender = sender;
        this.ivGroup = group;
        this.setTitle(Babel.get("NEWLINE"));
        int y = UIDef.RAND;
        int height = UIDef.getScaled(50);
        int namewidth = UIDef.getScaled(300);
        int okwidth = BREITE - 3 * UIDef.RAND - namewidth;
        JPanel mp = new JPanel(new BorderLayout());
        mp.setOpaque(false);
        this.ivNameField.setFont(FontManager.getFont("SSB14"));
        this.ivNameField.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent arg0) {
                LineAddRequester.this.adaptButtons();
            }
        });
        mp.add("Center", this.ivNameField);
        BorderPanel mbp = new BorderPanel(mp, Babel.get("LINENAME"));
        this.addAndApplyBounds(mbp, UIDef.RAND, y, namewidth, height);
        this.ivOkButton.setEnabled(false);
        this.applyBounds(this.ivOkButton, 2 * UIDef.RAND + namewidth, y, okwidth, height);
        y += height + UIDef.RAND;
        height = UIDef.getScaled(55);
        mp = new JPanel();
        mp.setOpaque(false);
        mp.setLayout(new GridLayout(1, 2, UIDef.getScaled(4), UIDef.getScaled(4)));
        MGButton changeColorButton = MGButton.getRequesterButton(Babel.get("CHANGECOLOR"));
        changeColorButton.setActionCommand("CHCOL");
        changeColorButton.addActionListener(this);
        changeColorButton.setFont(FontManager.getFont("SSB14"));
        mp.add(changeColorButton);
        this.ivColorLabel.setOpaque(true);
        this.ivColorLabel.setBackground(this.ivLineColor);
        this.ivColorLabel.setBorder(new BevelBorder(1, Color.white, Color.lightGray, Color.black, Color.darkGray));
        mp.add(this.ivColorLabel);
        mbp = new BorderPanel(mp, Babel.get("COLOR"));
        this.addAndApplyBounds(mbp, UIDef.RAND, y, BREITE - 2 * UIDef.RAND, height);
        y += height + UIDef.RAND;
        height = HOEHE - y - UIDef.RAND;
        mp = new JPanel(new BorderLayout(5, 5));
        mp.setOpaque(false);
        JPanel mp2 = new JPanel(new GridLayout(5, 1, UIDef.getScaled(4), UIDef.getScaled(4)));
        mp2.setOpaque(false);
        mp2.setPreferredSize(new Dimension(UIDef.getScaled(200), UIDef.getScaled(100)));
        this.ivAddLocusButton.setFont(FontManager.getFont("SSB14"));
        this.ivAddLocusButton.setActionCommand("ADDLOCUS");
        this.ivAddLocusButton.addActionListener(this);
        this.ivRemoveLocusButton.setFont(FontManager.getFont("SSB14"));
        this.ivRemoveLocusButton.setActionCommand("REMOVELOCUS");
        this.ivRemoveLocusButton.addActionListener(this);
        this.ivEditLocusButton.setFont(FontManager.getFont("SSB14"));
        this.ivEditLocusButton.setActionCommand("EDITLOCUS");
        this.ivEditLocusButton.addActionListener(this);
        this.ivEditLocusButton.setEnabled(false);
        this.ivMoveLocusUpButton.setFont(FontManager.getFont("SSB14"));
        this.ivMoveLocusUpButton.setActionCommand("MOVEUPLOCUS");
        this.ivMoveLocusUpButton.addActionListener(this);
        this.ivMoveLocusUpButton.setEnabled(false);
        this.ivMoveLocusDownButton.setFont(FontManager.getFont("SSB14"));
        this.ivMoveLocusDownButton.setActionCommand("MOVEDOWNLOCUS");
        this.ivMoveLocusDownButton.addActionListener(this);
        this.ivMoveLocusDownButton.setEnabled(false);
        mp2.add(this.ivAddLocusButton);
        mp2.add(this.ivRemoveLocusButton);
        mp2.add(this.ivEditLocusButton);
        mp2.add(this.ivMoveLocusUpButton);
        mp2.add(this.ivMoveLocusDownButton);
        mp.add("West", mp2);
        this.ivLocusTable.getSelectionModel().setSelectionMode(0);
        this.ivLocusTable.getTableHeader().setPreferredSize(new Dimension(UIDef.getScaled(100), UIDef.getScaled(20)));
        this.ivLocusTable.getColumnModel().getColumn(0).setPreferredWidth(UIDef.getScaled(80));
        this.ivLocusTable.getColumnModel().getColumn(1).setPreferredWidth(UIDef.getScaled(200));
        this.ivLocusTable.getTableHeader().setDefaultRenderer(new TableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                LineAddRequester.this.ivHeaderButton.setLabel(" " + LineAddRequester.this.getColumnName(column) + " ");
                return LineAddRequester.this.ivHeaderButton;
            }
        });
        this.ivLocusTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent arg0) {
                if (!arg0.getValueIsAdjusting()) {
                    int selind = LineAddRequester.this.ivLocusTable.getSelectedRow();
                    if (selind == -1 || LineAddRequester.this.ivLineLoci == null || selind > LineAddRequester.this.ivLineLoci.length) {
                        LineAddRequester.this.ivSelectedLocus = null;
                    } else {
                        LineAddRequester.this.ivSelectedLocus = LineAddRequester.this.ivLineLoci[selind];
                    }
                    LineAddRequester.this.adaptButtons();
                }
            }
        });
        this.ivLocusLabel.setFont(FontManager.getFont("SSB12"));
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.ivLocusTable.setDefaultRenderer(clazz, new TableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                LineAddRequester.this.ivLocusLabel.setText(" " + value + " ");
                if (isSelected) {
                    LineAddRequester.this.ivLocusLabel.setOpaque(true);
                    LineAddRequester.this.ivLocusLabel.setBackground(UIDef.SELECTED_BACKGROUND);
                } else {
                    LineAddRequester.this.ivLocusLabel.setOpaque(false);
                    LineAddRequester.this.ivLocusLabel.setBackground(null);
                }
                return LineAddRequester.this.ivLocusLabel;
            }
        });
        this.ivLocusTable.setRowHeight(this.ivLocusLabel.getPreferredSize().height);
        mp.add("Center", new JScrollPane(this.ivLocusTable));
        mbp = new BorderPanel(mp, Babel.get("LOCIANDALLELES"));
        this.addAndApplyBounds(mbp, UIDef.RAND, y, BREITE - 2 * UIDef.RAND, height);
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent e) {
                LineAddRequester.this.ivNameField.requestFocus();
            }
        });
    }

    public boolean okAndNoWanted() {
        return false;
    }

    public boolean onlyOKWanted() {
        return true;
    }

    public void OKPressed() {
        if (MausoleumClient.isRegularOrTGService()) {
            String wantedName = this.ivNameField.getText().trim();
            Vector existingLines = LineManager.cvInstance.getActualObjectVector(UserManager.getFirstGroup());
            int i = 0;
            while (i < existingLines.size()) {
                Line line = (Line)existingLines.elementAt(i);
                if (wantedName.equalsIgnoreCase(line.getString("LIN_NAME", ""))) {
                    Alert.showAlert(Babel.get("LINENAMEINUSE"), true);
                    return;
                }
                ++i;
            }
        }
        super.OKPressed();
    }

    private void adaptButtons() {
        boolean oken = true;
        if (this.ivNameField.getText().trim().length() == 0) {
            oken = false;
        }
        if (this.ivLineLoci == null || this.ivLineLoci.length == 0) {
            oken = false;
        }
        this.ivOkButton.setEnabled(oken);
        this.ivRemoveLocusButton.setEnabled(this.ivSelectedLocus != null);
        this.ivEditLocusButton.setEnabled(this.ivSelectedLocus != null);
        boolean mupen = false;
        boolean mdnen = false;
        if (this.ivSelectedLocus != null) {
            int iosl = this.getIndexOfSelectedLocus();
            if (iosl > 0) {
                mupen = true;
            }
            if (iosl != -1 && this.ivLineLoci != null && iosl < this.ivLineLoci.length - 1) {
                mdnen = true;
            }
        }
        this.ivMoveLocusUpButton.setEnabled(mupen);
        this.ivMoveLocusDownButton.setEnabled(mdnen);
    }

    private void listChanged() {
        this.ivLocusTable.tableChanged(new TableModelEvent(this));
    }

    private int getIndexOfSelectedLocus() {
        if (this.ivSelectedLocus == null) {
            return -1;
        }
        if (this.ivLineLoci == null || this.ivLineLoci.length == 0) {
            return -1;
        }
        int i = 0;
        while (i < this.ivLineLoci.length) {
            if (this.ivLineLoci[i] == this.ivSelectedLocus) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        String comm = e.getActionCommand();
        if (comm.equals("CHCOL")) {
            Color c = ColorRequester.getNewColor(this.ivLineColor, true);
            if (c != null) {
                this.ivLineColor = c;
                this.ivColorLabel.setBackground(this.ivLineColor);
                this.ivColorLabel.repaint();
            }
        } else if (comm.equals("REMOVELOCUS")) {
            if (this.ivSelectedLocus != null) {
                if (this.ivLineLoci != null) {
                    if (this.ivLineLoci.length == 1) {
                        this.ivLineLoci = null;
                    } else {
                        LocusAndAlleles[] neue = new LocusAndAlleles[this.ivLineLoci.length - 1];
                        int np = 0;
                        int i = 0;
                        while (i < this.ivLineLoci.length) {
                            if (this.ivLineLoci[i] != this.ivSelectedLocus) {
                                neue[np] = this.ivLineLoci[i];
                                ++np;
                            }
                            ++i;
                        }
                        this.ivLineLoci = neue;
                        this.ivSelectedLocus = null;
                    }
                }
                this.ivLocusTable.clearSelection();
                this.adaptButtons();
                this.listChanged();
                this.repaint();
            }
        } else if (comm.equals("ADDLOCUS")) {
            LocusAndAlleles laa = SelectLocusAndAllelesRequester.selectLocusAndAlleles(this.ivSender);
            if (laa != null) {
                this.ivLineLoci = LocusAndAlleles.addToArray(laa, this.ivLineLoci);
                this.adaptButtons();
                this.listChanged();
                this.repaint();
            }
        } else if (comm.equals("EDITLOCUS")) {
            LocusAndAlleles laa = EditLocusAllelesRequester.editLocusAndAlleles(this.ivSender, this.ivSelectedLocus, false, this.ivGroup);
            if (laa != null) {
                int i = 0;
                while (i < this.ivLineLoci.length) {
                    if (this.ivLineLoci[i] == this.ivSelectedLocus) {
                        this.ivLineLoci[i] = laa;
                        this.ivSelectedLocus = laa;
                    }
                    ++i;
                }
                this.adaptButtons();
                this.listChanged();
                this.repaint();
            }
        } else if (comm.equals("MOVEUPLOCUS")) {
            int ind = this.getIndexOfSelectedLocus();
            if (ind > 0) {
                LocusAndAlleles drueber = this.ivLineLoci[ind - 1];
                this.ivLineLoci[ind - 1] = this.ivSelectedLocus;
                this.ivLineLoci[ind] = drueber;
                this.ivLocusTable.clearSelection();
                this.ivLocusTable.addRowSelectionInterval(ind - 1, ind - 1);
                this.adaptButtons();
                this.repaint();
            }
        } else if (comm.equals("MOVEDOWNLOCUS")) {
            int ind = this.getIndexOfSelectedLocus();
            if (this.ivLineLoci != null && ind < this.ivLineLoci.length - 1) {
                LocusAndAlleles drunter = this.ivLineLoci[ind + 1];
                this.ivLineLoci[ind + 1] = this.ivSelectedLocus;
                this.ivLineLoci[ind] = drunter;
                this.ivLocusTable.clearSelection();
                this.ivLocusTable.addRowSelectionInterval(ind + 1, ind + 1);
                this.adaptButtons();
                this.repaint();
            }
        }
    }

    public int getRowCount() {
        if (this.ivLineLoci != null) {
            return this.ivLineLoci.length;
        }
        return 0;
    }

    public int getColumnCount() {
        return 2;
    }

    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return Babel.get("LOCUS");
            }
            case 1: {
                return Babel.get("ALLELES");
            }
        }
        return "";
    }

    public Class getColumnClass(int arg0) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public Object getValueAt(int row, int column) {
        if (this.ivLineLoci != null && row < this.ivLineLoci.length) {
            if (column == 0) {
                Locus locus = LocusManager.getLocus(this.ivLineLoci[row].ivLocusID, this.ivGroup);
                if (locus != null) {
                    return locus.getString("LOC_NAME", "");
                }
            } else if (column == 1) {
                StringBuffer msb = new StringBuffer();
                int i = 0;
                while (i < this.ivLineLoci[row].ivAllele.length) {
                    if (i != 0) {
                        msb.append(" / ");
                    }
                    String wtapp = "";
                    Locus locus = LocusManager.getLocus(this.ivLineLoci[row].ivLocusID, this.ivGroup);
                    if (locus != null) {
                        if (locus.getString("LOC_WT_ALLEL", "").equals(this.ivLineLoci[row].ivAllele[i])) {
                            wtapp = " [wt]";
                        }
                        msb.append(String.valueOf(locus.getAlias(this.ivLineLoci[row].ivAllele[i])) + wtapp);
                    }
                    ++i;
                }
                return msb.toString();
            }
        }
        return null;
    }

    public void setValueAt(Object arg0, int arg1, int arg2) {
    }

    public void addTableModelListener(TableModelListener arg0) {
    }

    public void removeTableModelListener(TableModelListener arg0) {
    }
}

