/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.line.intercross;

import de.hannse.netobjects.objectstore.ObjectRequest;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.RequestManager;
import java.awt.Container;
import java.awt.Dimension;
import javax.swing.JLabel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mausoleum.gui.SimpleLayoutManager;
import mausoleum.helper.FontManager;
import mausoleum.line.intercross.InterCrossResultTable;
import mausoleum.locus.LocusAndAlleles;
import mausoleum.mouse.Mouse;
import mausoleum.tables.MausoleumTable;
import mausoleum.tables.MausoleumTableFrame;
import mausoleum.tables.models.MTMouse;
import mausoleum.ui.UIDef;

public class InterCrossResultFrame
extends MausoleumTableFrame
implements Runnable {
    private static final long serialVersionUID = 14568123L;
    private InterCrossResultTable ivResultTable = null;
    private JLabel ivGTLabelMom = null;
    private JLabel ivGTLabelDad = null;
    private Mouse ivMomModel = null;
    private Mouse ivDadModel = null;
    private boolean ivShouldRun = true;
    private String ivCommand = null;

    public InterCrossResultFrame(Mouse momModel, boolean momBreederAllowed, boolean momUnknownAllowed, Mouse dadModel, boolean dadBreederAllowed, boolean dadUnknownAllowed) {
        super(new MausoleumTable(new MTMouse(), false));
        this.setTitle(String.valueOf(Babel.get("INTERCROSSREPORT")) + " " + Babel.get("WAITFORINFO"));
        this.ivMomModel = momModel;
        this.ivDadModel = dadModel;
        StringBuilder msb = new StringBuilder(Babel.get("MOTHER"));
        msb.append(" ").append(Babel.get("LINE")).append(": ").append(this.ivMomModel.getCLLWLineString());
        msb.append(" ").append(Babel.get("GENOTYPE")).append(": ").append(this.ivMomModel.getGenotype());
        if (momBreederAllowed) {
            msb.append(" ").append(Babel.get("BREEDERALLOWED"));
        }
        if (momUnknownAllowed) {
            msb.append(" ").append(Babel.get("UNKNOWNALLOWED"));
        }
        this.ivGTLabelMom = new JLabel(msb.toString());
        this.ivGTLabelMom.setFont(FontManager.getFont("SSB12"));
        this.getContentPane().add(this.ivGTLabelMom);
        msb = new StringBuilder(Babel.get("FATHER"));
        msb.append(" ").append(Babel.get("LINE")).append(": ").append(this.ivDadModel.getCLLWLineString());
        msb.append(" ").append(Babel.get("GENOTYPE")).append(": ").append(this.ivDadModel.getGenotype());
        if (dadBreederAllowed) {
            msb.append(" ").append(Babel.get("BREEDERALLOWED"));
        }
        if (dadUnknownAllowed) {
            msb.append(" ").append(Babel.get("UNKNOWNALLOWED"));
        }
        this.ivGTLabelDad = new JLabel(msb.toString());
        this.ivGTLabelDad.setFont(FontManager.getFont("SSB12"));
        this.getContentPane().add(this.ivGTLabelDad);
        this.getContentPane().setLayout(new SimpleLayoutManager(){

            public void layoutContainer(Container parent) {
                Dimension d = parent.getSize();
                int iw = d.width - 2 * UIDef.RAND;
                int y = UIDef.RAND;
                int x = UIDef.RAND;
                InterCrossResultFrame.this.ivGTLabelMom.setBounds(x, y, iw, UIDef.LINE_HEIGHT);
                InterCrossResultFrame.this.ivGTLabelDad.setBounds(x, y += UIDef.LINE_HEIGHT + UIDef.INNER_RAND, iw, UIDef.LINE_HEIGHT);
                int rh = d.height - UIDef.RAND - (y += UIDef.LINE_HEIGHT + UIDef.INNER_RAND);
                int uh = (rh - UIDef.INNER_RAND) / 2;
                int lh = rh - UIDef.INNER_RAND - uh;
                ((InterCrossResultFrame)InterCrossResultFrame.this).ivResultTable.ivScrollPane.setBounds(x, y, iw, uh);
                InterCrossResultFrame.this.ivMausoleumTable.setBounds(x, y += uh + UIDef.INNER_RAND, iw, lh);
            }
        });
        this.ivResultTable = new InterCrossResultTable();
        this.getContentPane().add(this.ivResultTable.ivScrollPane);
        this.ivResultTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    InterCrossResultFrame.this.ivMausoleumTable.ivModel.setTable(InterCrossResultFrame.this.ivResultTable.getSelectMice());
                }
            }
        });
        this.ivMausoleumTable.setIsSubdisplay();
        this.getContentPane().setBackground(UIDef.BACKGROUND_SUB);
        msb = new StringBuilder();
        msb.append("LINSICR").append(" ");
        msb.append(this.ivMomModel.getLong("MOS_LINEID", 0L)).append(" ");
        String s = LocusAndAlleles.getTransportString((LocusAndAlleles[])this.ivMomModel.get("MOS_LOCUSGENOTYPES"));
        if (s == null || s.trim().length() == 0) {
            s = "@";
        }
        msb.append(s).append(" ");
        if (momBreederAllowed) {
            msb.append("1 ");
        } else {
            msb.append("0 ");
        }
        if (momUnknownAllowed) {
            msb.append("1 ");
        } else {
            msb.append("0 ");
        }
        msb.append(this.ivDadModel.getLong("MOS_LINEID", 0L)).append(" ");
        s = LocusAndAlleles.getTransportString((LocusAndAlleles[])this.ivDadModel.get("MOS_LOCUSGENOTYPES"));
        if (s == null || s.trim().length() == 0) {
            s = "@";
        }
        msb.append(s).append(" ");
        if (dadBreederAllowed) {
            msb.append("1 ");
        } else {
            msb.append("0 ");
        }
        if (dadUnknownAllowed) {
            msb.append("1");
        } else {
            msb.append("0");
        }
        this.ivCommand = msb.toString();
        new Thread(this).start();
        this.setBounds(UIDef.getScaled(10), UIDef.getScaled(10), UIDef.getScaled(600), UIDef.getScaled(500));
        this.setVisible(true);
    }

    public Dimension getDefaultSize() {
        return new Dimension(UIDef.getScaled(600), UIDef.getScaled(500));
    }

    public void setVisible(boolean b) {
        if (!b) {
            this.ivShouldRun = false;
        }
        super.setVisible(b);
    }

    public void run() {
        if (this.ivMomModel == null) {
            return;
        }
        ObjectRequest or = RequestManager.sendCommandRequestAndGetAnswer(this.ivCommand, UserManager.getFirstGroup());
        String ticket = (String)or.ivExtraObject;
        StringBuilder msb = new StringBuilder();
        msb.append("LINGICR").append(" ").append(ticket);
        String comm = msb.toString();
        String res = null;
        while (res == null) {
            if (!this.ivShouldRun) {
                return;
            }
            or = RequestManager.sendCommandRequestAndGetAnswer(comm, UserManager.getFirstGroup());
            res = (String)or.ivExtraObject;
            if (res != null) {
                if (res.equalsIgnoreCase("XXX")) {
                    res = null;
                    try {
                        Thread.sleep(300L);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if (!res.equalsIgnoreCase("NIX")) continue;
                res = "";
                continue;
            }
            res = "";
        }
        this.ivResultTable.digestResult(res);
        this.setTitle(Babel.get("INTERCROSSREPORT"));
    }
}

