/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.line.intercross;

import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import java.awt.Component;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellRenderer;
import mausoleum.gui.MGButton;
import mausoleum.helper.FontManager;
import mausoleum.helper.Zeile;
import mausoleum.line.Line;
import mausoleum.locus.LocusAndAlleles;
import mausoleum.mouse.Mouse;
import mausoleum.mouse.MouseManager;
import mausoleum.ui.UIDef;
import mausoleum.ui.table.SortableTable;
import mausoleum.ui.table.TableSortable;

public class InterCrossResultTable
extends SortableTable
implements TableCellRenderer {
    private static final long serialVersionUID = 1789416513L;
    private static final String TRENNER = "\u00a7";
    public MGButton ivColHeaderLabel = MGButton.getInspectorActionButton("", "");
    public JLabel ivListLabel = new JLabel("QqyA");
    private Hashtable ivMouseVectorsByLineGTKey = null;
    private final String ivGroup = UserManager.getFirstGroup();
    static /* synthetic */ Class class$0;

    public InterCrossResultTable() {
        this.ivListLabel.setBackground(UIDef.NEW_BACKGROUND);
        this.setObjects(new Vector());
        this.getTableHeader().setDefaultRenderer(new TableCellRenderer(){

            public Component getTableCellRendererComponent(JTable arg0, Object value, boolean arg2, boolean arg3, int arg4, int arg5) {
                InterCrossResultTable.this.ivColHeaderLabel.setText((String)value);
                return InterCrossResultTable.this.ivColHeaderLabel;
            }
        });
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setDefaultRenderer(clazz, this);
        this.getSelectionModel().setSelectionMode(0);
        this.setColumnSelectionAllowed(false);
        this.getColumnModel().getColumn(0).setPreferredWidth(200);
        this.getColumnModel().getColumn(1).setPreferredWidth(60);
        this.ivListLabel.setFont(FontManager.getTableFont(true, true, 1.0));
        this.setRowHeight(this.ivListLabel.getPreferredSize().height);
    }

    public void digestResult(String res) {
        Vector<String> keys = new Vector<String>(10);
        this.ivMouseVectorsByLineGTKey = new Hashtable(10);
        if (res != null && res.length() != 0) {
            Mouse mouse = new Mouse();
            mouse.set("IDO_GROUP", this.ivGroup);
            Vector v = StringHelper.splitStringByAny(res, "@");
            Iterator iter = v.iterator();
            while (iter.hasNext()) {
                String key;
                Vector<Long> ids;
                Line line;
                Zeile z = new Zeile((String)iter.next(), '|');
                String lineIDGTKey = Base64Manager.getDecodedString(z.getString(0, ""));
                String lineName = "";
                String genotype = "";
                long lineID = 0L;
                int ind = lineIDGTKey.indexOf(":");
                if (ind != -1) {
                    try {
                        lineID = Long.parseLong(lineIDGTKey.substring(0, ind).trim());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (lineID != 0L && (line = (Line)ObjectStore.getObjectDeadOrAlive(7, lineID, this.ivGroup, null, false)) != null) {
                    lineName = line.getBrowseName();
                    if (line.isBreeder()) {
                        genotype = "wt";
                    } else {
                        String gtPart = lineIDGTKey.substring(ind + 1, lineIDGTKey.length());
                        mouse.setLong("MOS_LINEID", lineID);
                        mouse.set("MOS_LOCUSGENOTYPES", LocusAndAlleles.decodeFromTransportString(gtPart));
                        genotype = mouse.getGenotype();
                    }
                }
                if ((ids = (Vector<Long>)this.ivMouseVectorsByLineGTKey.get(key = String.valueOf(lineName) + TRENNER + genotype)) == null) {
                    ids = new Vector<Long>();
                    this.ivMouseVectorsByLineGTKey.put(key, ids);
                    keys.addElement(key);
                }
                int i = 1;
                while (i < z.size()) {
                    ids.add(new Long(z.getLong(i, 0L)));
                    ++i;
                }
            }
        }
        Collections.sort(keys);
        this.setObjects(keys);
        this.tableChanged(new TableModelEvent(this));
        this.repaint();
    }

    public int getColumnCount() {
        return 3;
    }

    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Babel.get("LINE");
            }
            case 1: {
                return Babel.get("GENOTYPE");
            }
            case 2: {
                return Babel.get("COUNT");
            }
        }
        return "";
    }

    public int getRowCount() {
        if (this.ivObjects == null) {
            return 0;
        }
        return this.ivObjects.size();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        String key = (String)this.getObjectAtRow(rowIndex);
        if (key != null) {
            int ind = key.indexOf(TRENNER);
            switch (columnIndex) {
                case 0: {
                    return key.substring(0, ind);
                }
                case 1: {
                    return key.substring(ind + 1, key.length());
                }
                case 2: {
                    Vector v = (Vector)this.ivMouseVectorsByLineGTKey.get(key);
                    if (v == null) break;
                    return Integer.toString(v.size());
                }
            }
            return "";
        }
        return "";
    }

    public Vector fillSortablesVector(int col) {
        if (this.getRowCount() <= 1) {
            return null;
        }
        Vector<TableSortable> erg = new Vector<TableSortable>();
        int row = 0;
        while (row < this.getRowCount()) {
            String key = (String)this.getObjectAtRow(row);
            int ind = key.indexOf(TRENNER);
            switch (col) {
                case 0: {
                    erg.addElement(new TableSortable(row, (Comparable)((Object)key.substring(0, ind))));
                    break;
                }
                case 1: {
                    erg.addElement(new TableSortable(row, (Comparable)((Object)key.substring(ind + 1, key.length()))));
                    break;
                }
                case 2: {
                    int anz = 0;
                    Vector v = (Vector)this.ivMouseVectorsByLineGTKey.get(key);
                    if (v != null) {
                        anz = v.size();
                    }
                    erg.addElement(new TableSortable(row, anz));
                    break;
                }
            }
            ++row;
        }
        return erg;
    }

    public Vector getSelectMice() {
        Vector v;
        String gt;
        Vector<Mouse> mice = new Vector<Mouse>();
        int row = this.getSelectedRow();
        if (row != -1 && (gt = (String)this.getObjectAtRow(row)) != null && (v = (Vector)this.ivMouseVectorsByLineGTKey.get(gt)) != null) {
            Iterator iter = v.iterator();
            while (iter.hasNext()) {
                Long mid = (Long)iter.next();
                Mouse mouse = MouseManager.getMouse(mid, this.ivGroup);
                if (mouse == null) continue;
                mice.addElement(mouse);
            }
        }
        return mice;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.ivListLabel.setIcon(null);
        if (column == 2) {
            this.ivListLabel.setHorizontalAlignment(4);
        } else {
            this.ivListLabel.setHorizontalAlignment(2);
        }
        StringBuffer msb = new StringBuffer();
        msb.append(" ").append(value).append(" ");
        this.ivListLabel.setText(msb.toString());
        this.ivListLabel.setOpaque(isSelected);
        return this.ivListLabel;
    }
}

