/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.locus;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.IDObjectXMLHandler;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.util.ArrayHelper;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.locus.LocusAndAlleles;
import mausoleum.util.InstallationType;

public class Locus
extends IDObject
implements Comparable {
    private static final long serialVersionUID = 1789784683513L;
    public static final String LOC_PREFIX = "LOC_";
    public static final String NAME = "LOC_NAME";
    public static final String ENSEMBL_NAME = "LOC_ENSEMBL_NAME";
    public static final String MGI_NAME = "LOC_MGI_NAME";
    public static final String ENTERERID = "LOC_ENTERER";
    public static final String AUTOSOMAL = "LOC_AUTOSOMAL";
    public static final String ALLELES = "LOC_ALLELES";
    public static final String DESCRIPTION = "LOC_DESCRIPTION";
    public static final String ALLEL_DESC = "LOC_ALLEL_DESC";
    public static final String WT_ALLEL = "LOC_WT_ALLEL";
    public static final String ALLEL_DICT = "LOC_ALLEL_DICT";
    public static final String AUTO_GENOTYPE_OK = "LOC_AUTOGTOK";
    public static final String BLOCKED_ALLELES = "LOC_BLOCKED_ALLELES";
    public static final String[] ATTRIBUTES_LOCUS;
    public static final String[] ORDERED_ATTRIBUTES;
    private static final String[] MERGE_ATTRIBUTES_FROM_SERVICE_TO_EXISTING_GROUP_OBJECT;
    public static final String[] DEFAULT_ALLELES;
    public static final String MALE_Y_LINK_MARK = "Y";
    public static final int ONLY_MALES = 1;
    public static final int ONLY_FEMALES = 2;
    public static final int SEX_UNCLEAR = 3;
    public static final int SEX_ALLES = 4;
    private static final HashSet EXPORT_ATTRIBUTES;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static {
        String[] stringArray = new String[24];
        stringArray[0] = NAME;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[1] = clazz.getName();
        stringArray[2] = ENSEMBL_NAME;
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[3] = clazz2.getName();
        stringArray[4] = MGI_NAME;
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[5] = clazz3.getName();
        stringArray[6] = ENTERERID;
        Class<?> clazz4 = class$1;
        if (clazz4 == null) {
            try {
                clazz4 = class$1 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[7] = clazz4.getName();
        stringArray[8] = AUTOSOMAL;
        Class<?> clazz5 = class$2;
        if (clazz5 == null) {
            try {
                clazz5 = class$2 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[9] = clazz5.getName();
        stringArray[10] = ALLELES;
        Class<?> clazz6 = class$3;
        if (clazz6 == null) {
            try {
                clazz6 = class$3 = Class.forName("[Ljava.lang.String;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[11] = clazz6.getName();
        stringArray[12] = DESCRIPTION;
        Class<?> clazz7 = class$0;
        if (clazz7 == null) {
            try {
                clazz7 = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[13] = clazz7.getName();
        stringArray[14] = ALLEL_DESC;
        Class<?> clazz8 = class$0;
        if (clazz8 == null) {
            try {
                clazz8 = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[15] = clazz8.getName();
        stringArray[16] = WT_ALLEL;
        Class<?> clazz9 = class$0;
        if (clazz9 == null) {
            try {
                clazz9 = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[17] = clazz9.getName();
        stringArray[18] = ALLEL_DICT;
        Class<?> clazz10 = class$3;
        if (clazz10 == null) {
            try {
                clazz10 = class$3 = Class.forName("[Ljava.lang.String;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[19] = clazz10.getName();
        stringArray[20] = AUTO_GENOTYPE_OK;
        Class<?> clazz11 = class$2;
        if (clazz11 == null) {
            try {
                clazz11 = class$2 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[21] = clazz11.getName();
        stringArray[22] = BLOCKED_ALLELES;
        Class<?> clazz12 = class$3;
        if (clazz12 == null) {
            try {
                clazz12 = class$3 = Class.forName("[Ljava.lang.String;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[23] = clazz12.getName();
        ATTRIBUTES_LOCUS = stringArray;
        ORDERED_ATTRIBUTES = new String[]{"IDO_ID", "IDO_START_DATE", "IDO_END_DATE", "IDO_VERSION", "IDO_UNIQUELONG", "IDO_VISIBLE", "IDO_NEVER_EXISTED", "IDO_OGROUP", "IDO_FKEY", "IDO_DOK", "IDO_SERVID", "IDO_UGROUPS", "IDO_UGROUPIDS", "IDO_SUBTYP", NAME, ENSEMBL_NAME, MGI_NAME, ENTERERID, AUTOSOMAL, ALLELES, DESCRIPTION, ALLEL_DESC, WT_ALLEL, ALLEL_DICT, AUTO_GENOTYPE_OK, BLOCKED_ALLELES};
        MERGE_ATTRIBUTES_FROM_SERVICE_TO_EXISTING_GROUP_OBJECT = new String[]{NAME, ENSEMBL_NAME, MGI_NAME, AUTOSOMAL, ALLELES, DESCRIPTION, ALLEL_DESC, WT_ALLEL, ALLEL_DICT, AUTO_GENOTYPE_OK, BLOCKED_ALLELES, "IDO_VISIBLE"};
        DEFAULT_ALLELES = new String[]{"+", "-"};
        EXPORT_ATTRIBUTES = ArrayHelper.createHashSet(new String[]{"IDO_SERVID", NAME, ENSEMBL_NAME, MGI_NAME, AUTOSOMAL, WT_ALLEL, ALLELES, DESCRIPTION, ALLEL_DESC, ALLEL_DICT, AUTO_GENOTYPE_OK});
    }

    public static String getAllelDescriptionString(Hashtable allelComments, Vector alleles) {
        StringBuffer msb = new StringBuffer();
        Enumeration en = allelComments.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            if (!alleles.contains(key)) continue;
            String val = (String)allelComments.get(key);
            if (msb.length() != 0) {
                msb.append("|");
            }
            msb.append(Base64Manager.encodeBase64(String.valueOf(key) + "|" + Base64Manager.encodeBase64(val)));
        }
        return msb.toString();
    }

    public static Hashtable getAllelDescriptionHashtable(Locus locus) {
        Hashtable<String, String> erg = new Hashtable<String, String>();
        String allelDesc = locus.getString(ALLEL_DESC, null);
        if (allelDesc != null) {
            Vector lines = StringHelper.splitStringByAny(allelDesc, "|");
            int i = 0;
            while (i < lines.size()) {
                String line = (String)lines.elementAt(i);
                int strind = (line = Base64Manager.getDecodedString(line)).indexOf("|");
                if (strind != -1) {
                    String key = line.substring(0, strind);
                    String val = line.substring(strind + 1, line.length());
                    val = Base64Manager.getDecodedString(val);
                    erg.put(key, val);
                }
                ++i;
            }
        }
        return erg;
    }

    public static Locus findLocusWithServiceID(long serviceID, Vector allLociInGroup) {
        Object groupLocus = null;
        Iterator iterator = allLociInGroup.iterator();
        while (iterator.hasNext() && groupLocus == null) {
            Locus locus = (Locus)iterator.next();
            if (locus.getLong("IDO_SERVID", 0L) != serviceID) continue;
            return locus;
        }
        return null;
    }

    private static boolean isAllelContained(String allel, String[] possibleAlleles) {
        if (possibleAlleles == null) {
            return true;
        }
        int i = 0;
        while (i < possibleAlleles.length) {
            if (possibleAlleles[i].equals(allel)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Locus() {
        this.set(ALLELES, DEFAULT_ALLELES);
        this.setBoolean(AUTOSOMAL, true);
        this.commit(true);
    }

    public String getName(String nullVal) {
        return InstallationType.obfuscate(this.getString(NAME, nullVal));
    }

    public boolean isFullServicableObject() {
        return true;
    }

    public String getName() {
        return this.getName(null);
    }

    public String getBrowseName() {
        return this.getName("Locus " + this.getID());
    }

    public void addBrowserLines(Vector target, String group, HashSet wantedObjectTypes) {
        long l;
        super.addBrowserLines(target, group, wantedObjectTypes);
        target.add("Name = " + this.getString(NAME, ""));
        String s = this.getString(ENSEMBL_NAME, null);
        if (s != null && s.trim().length() != 0) {
            target.add("ENSEMBL = " + s);
        }
        if ((s = this.getString(MGI_NAME, null)) != null && s.trim().length() != 0) {
            target.add("MGI = " + s);
        }
        if ((wantedObjectTypes == null || wantedObjectTypes.contains(new Integer(6))) && (l = this.getLong(ENTERERID, 0L)) != 0L) {
            IDObject ido = ObjectStore.getObjectDeadOrAlive(6, l, group, null, false);
            target.add("Enterer: " + ido.getBrowseName() + "\t" + "object|" + group + "|" + 6 + "|" + l);
        }
        if (this.getBoolean(AUTOSOMAL, false)) {
            target.add("Autosomal or X-chromosome");
        } else {
            target.add("Y-chromosome");
        }
        String wt = this.getString(WT_ALLEL, "");
        String[] arr = (String[])this.get(ALLELES);
        if (arr != null) {
            int i = 0;
            while (i < arr.length) {
                String allel = arr[i];
                if (allel.equals(wt)) {
                    target.add("WT-Allel: " + this.getAlias(arr[i]));
                } else {
                    target.add("Allel: " + this.getAlias(arr[i]));
                }
                ++i;
            }
        }
        if ((s = this.getString(DESCRIPTION, null)) != null && s.trim().length() != 0) {
            target.add("Description\t\t" + Base64Manager.encodeBase64(s));
        }
    }

    public void afterInit() {
        String[] alleles = (String[])this.get(ALLELES);
        if (alleles != null) {
            int i = 0;
            while (i < alleles.length) {
                if (alleles[i].equalsIgnoreCase("@at@mi@at@")) {
                    alleles[i] = "-";
                } else if (alleles[i].equalsIgnoreCase("@mi@")) {
                    alleles[i] = "-";
                } else if (alleles[i].equalsIgnoreCase("@at@pl@at@")) {
                    alleles[i] = "+";
                } else if (alleles[i].equalsIgnoreCase("@pl@")) {
                    alleles[i] = "+";
                }
                ++i;
            }
        }
    }

    public String getExportString() {
        return IDObjectXMLHandler.getExportXML(this, EXPORT_ATTRIBUTES);
    }

    public Vector getAllAlleles() {
        Vector<String> erg = new Vector<String>();
        String[] alleles = (String[])this.get(ALLELES);
        if (alleles != null) {
            int i = 0;
            while (i < alleles.length) {
                erg.addElement(alleles[i]);
                ++i;
            }
            Collections.sort(erg);
        }
        return erg;
    }

    public void addAllAlleles(Vector v, boolean forceShowAll, boolean sortIt) {
        String[] alleles = (String[])this.get(ALLELES);
        if (alleles != null) {
            int i = 0;
            while (i < alleles.length) {
                if (forceShowAll || this.isAlleleAvailable(alleles[i])) {
                    v.addElement(alleles[i]);
                }
                ++i;
            }
            if (sortIt) {
                Collections.sort(v);
            }
        }
    }

    public Vector getListOfGenotypes(int sexMode, String[] possibleAlleles, boolean alsoIncludeUnset) {
        Vector<LocusAndAlleles> erg;
        block17: {
            long locusID;
            String[] alleles;
            block20: {
                block19: {
                    block18: {
                        erg = new Vector<LocusAndAlleles>();
                        alleles = (String[])this.get(ALLELES);
                        locusID = this.getID();
                        if (alleles == null) break block17;
                        if (alsoIncludeUnset) {
                            erg.add(new LocusAndAlleles(locusID));
                        }
                        if (!this.getBoolean(AUTOSOMAL, true)) break block18;
                        int i = 0;
                        while (i < alleles.length) {
                            if (Locus.isAllelContained(alleles[i], possibleAlleles)) {
                                int j = i;
                                while (j < alleles.length) {
                                    if (Locus.isAllelContained(alleles[j], possibleAlleles)) {
                                        erg.addElement(new LocusAndAlleles(locusID, alleles[i], alleles[j]));
                                    }
                                    ++j;
                                }
                            }
                            ++i;
                        }
                        break block17;
                    }
                    if (sexMode != 1) break block19;
                    int i = 0;
                    while (i < alleles.length) {
                        if (Locus.isAllelContained(alleles[i], possibleAlleles)) {
                            erg.addElement(new LocusAndAlleles(locusID, alleles[i], MALE_Y_LINK_MARK));
                        }
                        ++i;
                    }
                    break block17;
                }
                if (sexMode != 2) break block20;
                int i = 0;
                while (i < alleles.length) {
                    if (Locus.isAllelContained(alleles[i], possibleAlleles)) {
                        int j = i;
                        while (j < alleles.length) {
                            if (Locus.isAllelContained(alleles[j], possibleAlleles)) {
                                erg.addElement(new LocusAndAlleles(locusID, alleles[i], alleles[j]));
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
                break block17;
            }
            if (sexMode != 4) break block17;
            int i = 0;
            while (i < alleles.length) {
                if (Locus.isAllelContained(alleles[i], possibleAlleles)) {
                    erg.addElement(new LocusAndAlleles(locusID, alleles[i], MALE_Y_LINK_MARK));
                }
                ++i;
            }
            i = 0;
            while (i < alleles.length) {
                if (Locus.isAllelContained(alleles[i], possibleAlleles)) {
                    int j = i;
                    while (j < alleles.length) {
                        if (Locus.isAllelContained(alleles[j], possibleAlleles)) {
                            erg.addElement(new LocusAndAlleles(locusID, alleles[i], alleles[j]));
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return erg;
    }

    public int getIndexOfAllel(String allel, int defVal) {
        if (allel.equalsIgnoreCase(MALE_Y_LINK_MARK)) {
            return defVal;
        }
        String[] alleles = (String[])this.get(ALLELES);
        if (alleles != null) {
            int i = 0;
            while (i < alleles.length) {
                if (allel.equals(alleles[i])) {
                    return i;
                }
                ++i;
            }
        }
        return defVal;
    }

    public void setAllelAlias(String allel, String alias) {
        if (allel == null || allel.trim().length() == 0) {
            return;
        }
        int ind = this.getIndexOfAllel(allel = allel.trim(), -1);
        if (ind == -1) {
            return;
        }
        if (alias == null || alias.trim().length() == 0 || allel.equals(alias)) {
            String[] dict = (String[])this.get(ALLEL_DICT);
            if (dict != null) {
                if (dict.length == 2) {
                    if (dict[0].equals(allel)) {
                        this.set(ALLEL_DICT, null);
                        return;
                    }
                    return;
                }
                int i = 0;
                while (i < dict.length) {
                    if (dict[i].equals(allel)) {
                        String[] ndict = new String[dict.length - 2];
                        int pos = 0;
                        int j = 0;
                        while (j < dict.length) {
                            if (j != i) {
                                ndict[pos] = dict[j];
                                ndict[pos + 1] = dict[j + 1];
                            }
                            pos += 2;
                            j += 2;
                        }
                        this.set(ALLEL_DICT, ndict);
                        return;
                    }
                    i += 2;
                }
            }
        } else {
            String[] dict = (String[])this.get(ALLEL_DICT);
            if (dict == null) {
                dict = new String[]{allel, alias};
                this.set(ALLEL_DICT, dict);
            } else {
                int i = 0;
                while (i < dict.length) {
                    if (dict[i].equals(allel)) {
                        dict[i] = allel;
                        dict[i + 1] = alias;
                        this.set(ALLEL_DICT, null);
                        this.commit(false);
                        this.set(ALLEL_DICT, dict);
                        return;
                    }
                    i += 2;
                }
                String[] ndict = new String[dict.length + 2];
                int i2 = 0;
                while (i2 < dict.length) {
                    ndict[i2] = dict[i2];
                    ++i2;
                }
                ndict[ndict.length - 2] = allel;
                ndict[ndict.length - 1] = alias;
                this.set(ALLEL_DICT, ndict);
            }
        }
    }

    public String getAlias(String allel) {
        String[] dict;
        if (allel != null && (dict = (String[])this.get(ALLEL_DICT)) != null) {
            int i = 0;
            while (i < dict.length) {
                if (dict[i].equals(allel)) {
                    return dict[i + 1];
                }
                i += 2;
            }
        }
        return allel;
    }

    public boolean isAlleleAvailable(String allel) {
        if (allel != null) {
            String[] blockeds = (String[])this.get(BLOCKED_ALLELES);
            if (blockeds != null) {
                int i = 0;
                while (i < blockeds.length) {
                    if (allel.equals(blockeds[i])) {
                        return false;
                    }
                    ++i;
                }
            }
            return true;
        }
        return false;
    }

    public void setAllelActivity(String allel, boolean active) {
        int ind = -1;
        String[] altArr = (String[])this.get(BLOCKED_ALLELES);
        if (altArr != null) {
            int i = 0;
            while (i < altArr.length) {
                if (altArr[i].equals(allel)) {
                    ind = i;
                }
                ++i;
            }
        }
        if (active) {
            if (ind != -1) {
                String[] neuArr = null;
                if (altArr != null && altArr.length != 1) {
                    neuArr = new String[altArr.length - 1];
                    int pos = 0;
                    int i = 0;
                    while (i < altArr.length) {
                        if (i != ind) {
                            neuArr[pos++] = altArr[i];
                        }
                        ++i;
                    }
                }
                this.set(BLOCKED_ALLELES, neuArr);
            }
        } else if (ind == -1) {
            String[] neuArr = null;
            if (altArr == null) {
                neuArr = new String[]{allel};
            } else {
                neuArr = new String[altArr.length + 1];
                int i = 0;
                while (i < altArr.length) {
                    neuArr[i] = altArr[i];
                    ++i;
                }
                neuArr[neuArr.length - 1] = allel;
                this.set(BLOCKED_ALLELES, neuArr);
            }
            this.set(BLOCKED_ALLELES, neuArr);
        }
    }

    public String getWTString() {
        return this.getAlias(this.getString(WT_ALLEL, null));
    }

    public String getAllelString(LocusAndAlleles laa) {
        StringBuilder msb = new StringBuilder();
        int i = 0;
        while (i < laa.ivAllele.length) {
            String allelOderAlias;
            if (i != 0) {
                msb.append(" / ");
            }
            if ((allelOderAlias = laa.ivAllele[i]) != null) {
                allelOderAlias = this.getAlias(allelOderAlias);
            }
            msb.append(allelOderAlias);
            ++i;
        }
        return msb.toString();
    }

    public String getLocusAllelString() {
        StringBuilder msb = new StringBuilder();
        String[] alleles = (String[])this.get(ALLELES);
        if (alleles != null) {
            int i = 0;
            while (i < alleles.length) {
                String allelOderAlias;
                if (i != 0) {
                    msb.append(", ");
                }
                if ((allelOderAlias = alleles[i]) != null) {
                    allelOderAlias = this.getAlias(allelOderAlias);
                }
                msb.append(allelOderAlias);
                ++i;
            }
        }
        return msb.toString();
    }

    public boolean isObjectIdenticalForGroupTransfer(IDObject idObject) {
        if (idObject instanceof Locus) {
            Locus tlocus = (Locus)idObject;
            boolean ensemblOK = StringHelper.checkForIdentity(this.getString(ENSEMBL_NAME), tlocus.getString(ENSEMBL_NAME));
            boolean mgiOK = StringHelper.checkForIdentity(this.getString(MGI_NAME), tlocus.getString(MGI_NAME));
            if (!ensemblOK || !mgiOK) {
                return false;
            }
            if (!this.getString(NAME).equals(tlocus.getString(NAME))) {
                return false;
            }
            if (!this.get(AUTOSOMAL).equals(tlocus.get(AUTOSOMAL))) {
                return false;
            }
            String[] meineAllele = (String[])this.get(ALLELES);
            String[] seineAllele = (String[])tlocus.get(ALLELES);
            if (meineAllele == null && seineAllele != null) {
                return false;
            }
            if (seineAllele == null && meineAllele != null) {
                return false;
            }
            if (seineAllele == null && meineAllele == null) {
                return true;
            }
            if (meineAllele.length != seineAllele.length) {
                return false;
            }
            int i = 0;
            while (i < meineAllele.length) {
                if (!StringHelper.isIn(meineAllele[i], seineAllele, true)) {
                    return false;
                }
                ++i;
            }
            if (!StringHelper.checkForIdentity(this.getString(WT_ALLEL, null), tlocus.getString(WT_ALLEL, null))) {
                return false;
            }
            String[] meinDict = (String[])this.get(ALLEL_DICT);
            String[] seinDict = (String[])tlocus.get(ALLEL_DICT);
            if (meinDict == null && seinDict != null) {
                return false;
            }
            if (meinDict != null && seinDict == null) {
                return false;
            }
            if (meinDict != null && seinDict != null) {
                HashMap<String, String> hm = new HashMap<String, String>();
                int i2 = 0;
                while (i2 < meinDict.length) {
                    hm.put(meinDict[i2], meinDict[i2 + 1]);
                    i2 += 2;
                }
                i2 = 0;
                while (i2 < seinDict.length) {
                    if (!seinDict[i2 + 1].equals(hm.get(seinDict[i2]))) {
                        return false;
                    }
                    i2 += 2;
                }
            }
            return true;
        }
        return false;
    }

    public void mergeNecessAtrrsToServiceObject(IDObject serviceObject, Hashtable objectBag) {
        Locus serviceLocus = (Locus)serviceObject;
        Vector myAlleles = this.getAllAlleles();
        Vector tdAlleles = serviceLocus.getAllAlleles();
        Vector<String> allelesToAdd = new Vector<String>();
        int i = 0;
        while (i < myAlleles.size()) {
            String mtAllel = (String)myAlleles.elementAt(i);
            if (tdAlleles.indexOf(mtAllel) == -1) {
                allelesToAdd.addElement(mtAllel);
            }
            ++i;
        }
        if (!allelesToAdd.isEmpty()) {
            Iterator<Object> iterator;
            String[] oldAlleles = (String[])serviceLocus.get(ALLELES);
            String[] newAlleles = new String[oldAlleles.length + allelesToAdd.size()];
            int i2 = 0;
            while (i2 < oldAlleles.length) {
                newAlleles[i2] = oldAlleles[i2];
                ++i2;
            }
            HashMap<String, String> aliasHM = new HashMap<String, String>();
            String[] serviceAliasDict = (String[])serviceLocus.get(ALLEL_DICT);
            if (serviceAliasDict != null) {
                int i3 = 0;
                while (i3 < serviceAliasDict.length) {
                    aliasHM.put(serviceAliasDict[i3], serviceAliasDict[i3 + 1]);
                    i3 += 2;
                }
            }
            HashSet<String> blockedSet = new HashSet<String>();
            String[] serviceBlockeds = (String[])serviceLocus.get(BLOCKED_ALLELES);
            if (serviceBlockeds != null) {
                int i4 = 0;
                while (i4 < serviceBlockeds.length) {
                    blockedSet.add(serviceBlockeds[i4]);
                    ++i4;
                }
            }
            String[] groupBlockeds = (String[])this.get(BLOCKED_ALLELES);
            int i5 = 0;
            while (i5 < allelesToAdd.size()) {
                String allel;
                newAlleles[oldAlleles.length + i5] = allel = (String)allelesToAdd.elementAt(i5);
                String alias = this.getAlias(allel);
                if (!allel.equals(alias)) {
                    aliasHM.put(allel, alias);
                }
                if (StringHelper.isIn(allel, groupBlockeds, true)) {
                    blockedSet.add(allel);
                }
                ++i5;
            }
            serviceLocus.setAndPropagateAttributes(objectBag, null, ALLELES, newAlleles);
            if (serviceAliasDict == null && !aliasHM.isEmpty() || serviceAliasDict != null && aliasHM.size() * 2 != serviceAliasDict.length) {
                String[] newAliasArr = new String[aliasHM.size() * 2];
                int pos = 0;
                iterator = aliasHM.keySet().iterator();
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    newAliasArr[pos++] = key;
                    newAliasArr[pos++] = (String)aliasHM.get(key);
                }
                serviceLocus.setAndPropagateAttributes(objectBag, null, ALLEL_DICT, newAliasArr);
            }
            if (serviceBlockeds == null && !blockedSet.isEmpty() || serviceBlockeds != null && blockedSet.size() != serviceBlockeds.length) {
                String[] newBlockedsArr = new String[blockedSet.size()];
                int pos = 0;
                iterator = blockedSet.iterator();
                while (iterator.hasNext()) {
                    newBlockedsArr[pos++] = (String)iterator.next();
                }
                serviceLocus.setAndPropagateAttributes(objectBag, null, BLOCKED_ALLELES, newBlockedsArr);
            }
            tdAlleles = serviceLocus.getAllAlleles();
            Hashtable oldComments = Locus.getAllelDescriptionHashtable(serviceLocus);
            Hashtable thisComments = Locus.getAllelDescriptionHashtable(this);
            int i6 = 0;
            while (i6 < allelesToAdd.size()) {
                String allel = (String)allelesToAdd.elementAt(i6);
                String comment = (String)thisComments.get(allel);
                if (comment != null) {
                    oldComments.put(allel, comment);
                }
                ++i6;
            }
            serviceLocus.setAndPropagateAttributes(objectBag, null, ALLEL_DESC, Locus.getAllelDescriptionString(oldComments, tdAlleles));
        }
    }

    public boolean isAutosomal() {
        return this.getBoolean(AUTOSOMAL, true);
    }

    public String[] getMergeAttributesFromServiceToExistingGroupObject() {
        return MERGE_ATTRIBUTES_FROM_SERVICE_TO_EXISTING_GROUP_OBJECT;
    }

    public int compareTo(Object obj) {
        if (obj instanceof Locus) {
            Locus l2 = (Locus)obj;
            String n1 = this.getString(NAME, "");
            String n2 = l2.getString(NAME, "");
            return n1.compareToIgnoreCase(n2);
        }
        return 0;
    }
}

