/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.locus;

import de.hannse.netobjects.util.Babel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mausoleum.gui.BorderPanel;
import mausoleum.gui.MGButton;
import mausoleum.helper.FontManager;
import mausoleum.helper.ImageProvider;
import mausoleum.locus.Locus;
import mausoleum.locus.LocusAndAlleles;
import mausoleum.locus.LocusManager;
import mausoleum.requester.BasicRequester;
import mausoleum.ui.UIDef;

public class SelectLocusAndAllelesRequester
extends BasicRequester
implements ListCellRenderer {
    private static final long serialVersionUID = 7894561231L;
    private static final int BREITE = UIDef.getScaled(700);
    private static final int HOEHE = UIDef.getScaled(600);
    private JList ivLocusList = null;
    private JList ivAllelList = null;
    private JLabel ivLocusLabel = new JLabel();
    private JLabel ivAllelLabel = new JLabel();
    private Locus ivSelectedLocus = null;
    private Vector ivAlleles = new Vector();
    private Vector ivSelectedAlleles = new Vector();

    public static LocusAndAlleles selectLocusAndAlleles(Frame sender) {
        SelectLocusAndAllelesRequester saar = new SelectLocusAndAllelesRequester(sender);
        if (saar.ivWarOK && saar.ivSelectedLocus != null && !saar.ivSelectedAlleles.isEmpty()) {
            return new LocusAndAlleles(saar.ivSelectedLocus, saar.ivSelectedAlleles);
        }
        return null;
    }

    private SelectLocusAndAllelesRequester(Frame sender) {
        super(sender, BREITE, HOEHE);
        this.setTitle(Babel.get("SELECTLOCUSANDALLELES"));
        int lbr = (BREITE - 3 * UIDef.RAND) / 2;
        int rbr = BREITE - 3 * UIDef.RAND - lbr;
        int oh = HOEHE - 3 * UIDef.RAND - UIDef.BUT_HEIGHT;
        this.ivLocusLabel.setFont(FontManager.getFont("SSB12"));
        this.ivLocusLabel.setHorizontalTextPosition(4);
        Vector loci = LocusManager.cvInstance.getActualObjectVectorAllGroups();
        Vector<Locus> loci2 = new Vector<Locus>(loci.size());
        int i = 0;
        while (i < loci.size()) {
            Locus loc = (Locus)loci.elementAt(i);
            if (loc.getBoolean("IDO_VISIBLE", true)) {
                loci2.addElement(loc);
            }
            ++i;
        }
        Collections.sort(loci2);
        this.ivLocusList = new JList(loci2);
        this.ivLocusList.getSelectionModel().setSelectionMode(0);
        this.ivLocusList.setCellRenderer(this);
        this.ivLocusList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent arg0) {
                SelectLocusAndAllelesRequester.this.ivSelectedLocus = (Locus)SelectLocusAndAllelesRequester.this.ivLocusList.getSelectedValue();
                SelectLocusAndAllelesRequester.this.ivAlleles.clear();
                SelectLocusAndAllelesRequester.this.ivSelectedAlleles.clear();
                if (SelectLocusAndAllelesRequester.this.ivSelectedLocus != null) {
                    SelectLocusAndAllelesRequester.this.ivSelectedLocus.addAllAlleles(SelectLocusAndAllelesRequester.this.ivAlleles, false, true);
                    SelectLocusAndAllelesRequester.this.ivSelectedLocus.addAllAlleles(SelectLocusAndAllelesRequester.this.ivSelectedAlleles, false, true);
                }
                SelectLocusAndAllelesRequester.this.ivAllelList.setListData(SelectLocusAndAllelesRequester.this.ivAlleles);
                SelectLocusAndAllelesRequester.this.checkButton();
            }
        });
        JPanel mp = new JPanel(new BorderLayout());
        mp.setOpaque(false);
        mp.add("Center", new JScrollPane(this.ivLocusList));
        BorderPanel mbp = new BorderPanel(mp, Babel.get("LOCI"));
        this.addAndApplyBounds(mbp, UIDef.RAND, UIDef.RAND, lbr, oh);
        this.ivAllelList = new JList(this.ivAlleles);
        this.ivAllelLabel.setFont(FontManager.getFont("SSB12"));
        this.ivAllelLabel.setHorizontalTextPosition(4);
        this.ivAllelList.setCellRenderer(this);
        this.ivAllelList.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent arg0) {
                int selind = SelectLocusAndAllelesRequester.this.ivAllelList.locationToIndex(arg0.getPoint());
                if (selind != -1) {
                    String selallel = (String)SelectLocusAndAllelesRequester.this.ivAllelList.getModel().getElementAt(selind);
                    if (SelectLocusAndAllelesRequester.this.ivSelectedAlleles.contains(selallel)) {
                        SelectLocusAndAllelesRequester.this.ivSelectedAlleles.remove(selallel);
                    } else {
                        SelectLocusAndAllelesRequester.this.ivSelectedAlleles.addElement(selallel);
                    }
                    SelectLocusAndAllelesRequester.this.checkButton();
                    SelectLocusAndAllelesRequester.this.repaint();
                }
            }
        });
        mp = new JPanel(new BorderLayout(UIDef.INNER_RAND, UIDef.INNER_RAND));
        mp.setOpaque(false);
        mp.add("Center", new JScrollPane(this.ivAllelList));
        JPanel ubutpan = new JPanel(new GridLayout(1, 2, UIDef.INNER_RAND, UIDef.INNER_RAND));
        MGButton but = new MGButton(Babel.get("APR_SELECT_ALL"));
        but.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (SelectLocusAndAllelesRequester.this.ivAlleles != null && !SelectLocusAndAllelesRequester.this.ivAlleles.isEmpty()) {
                    SelectLocusAndAllelesRequester.this.ivSelectedAlleles.clear();
                    SelectLocusAndAllelesRequester.this.ivSelectedAlleles.addAll(SelectLocusAndAllelesRequester.this.ivAlleles);
                    SelectLocusAndAllelesRequester.this.checkButton();
                    SelectLocusAndAllelesRequester.this.repaint();
                }
            }
        });
        ubutpan.add(but);
        but = new MGButton(Babel.get("APR_SELECT_NONE"));
        but.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SelectLocusAndAllelesRequester.this.ivSelectedAlleles.clear();
                SelectLocusAndAllelesRequester.this.checkButton();
                SelectLocusAndAllelesRequester.this.repaint();
            }
        });
        ubutpan.add(but);
        mp.add("South", ubutpan);
        mbp = new BorderPanel(mp, Babel.get("ALLELES"));
        this.addAndApplyBounds(mbp, 2 * UIDef.RAND + lbr, UIDef.RAND, rbr, oh);
        this.ivOkButton.setEnabled(false);
        this.applyBounds(this.ivOkButton, UIDef.RAND, HOEHE - UIDef.RAND - UIDef.BUT_HEIGHT, BREITE - 2 * UIDef.RAND, UIDef.BUT_HEIGHT);
        this.setVisible(true);
    }

    public boolean okAndNoWanted() {
        return false;
    }

    public boolean onlyOKWanted() {
        return true;
    }

    private void checkButton() {
        this.ivOkButton.setEnabled(this.ivSelectedLocus != null && !this.ivSelectedAlleles.isEmpty());
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (list == this.ivLocusList) {
            Locus locus = (Locus)value;
            this.ivLocusLabel.setText(" " + locus.getString("LOC_NAME") + " ");
            if (isSelected) {
                this.ivLocusLabel.setOpaque(true);
                this.ivLocusLabel.setBackground(UIDef.SELECTED_BACKGROUND);
                this.ivLocusLabel.setIcon(ImageProvider.HAKEN_ICON);
            } else {
                this.ivLocusLabel.setOpaque(false);
                this.ivLocusLabel.setBackground(null);
                this.ivLocusLabel.setIcon(ImageProvider.EMPTY_HAKEN_ICON);
            }
            return this.ivLocusLabel;
        }
        if (list == this.ivAllelList) {
            String allel = (String)value;
            String wtapp = "";
            if (this.ivSelectedLocus != null && allel.equals(this.ivSelectedLocus.getString("LOC_WT_ALLEL", ""))) {
                wtapp = " [wt]";
            }
            this.ivAllelLabel.setText(" " + this.ivSelectedLocus.getAlias(allel) + wtapp + " ");
            if (this.ivSelectedAlleles.contains(allel)) {
                this.ivAllelLabel.setOpaque(true);
                this.ivAllelLabel.setBackground(UIDef.SELECTED_BACKGROUND);
                this.ivAllelLabel.setIcon(ImageProvider.HAKEN_ICON);
            } else {
                this.ivAllelLabel.setOpaque(false);
                this.ivAllelLabel.setBackground(null);
                this.ivAllelLabel.setIcon(ImageProvider.EMPTY_HAKEN_ICON);
            }
            return this.ivAllelLabel;
        }
        return null;
    }
}

