/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.locus;

import de.hannse.netobjects.util.Babel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mausoleum.gui.BorderPanel;
import mausoleum.helper.FontManager;
import mausoleum.helper.ImageProvider;
import mausoleum.locus.Locus;
import mausoleum.locus.LocusAndAlleles;
import mausoleum.locus.LocusManager;
import mausoleum.requester.BasicRequester;
import mausoleum.ui.UIDef;

public class SelectLocusAndGenotypesRequester
extends BasicRequester
implements ListCellRenderer {
    private static final long serialVersionUID = -7853866629460151109L;
    private static final int BREITE = 500;
    private static final int HOEHE = 500;
    private static final int RAND = 10;
    private static final int OKBUT_HEIGHT = 30;
    private static final int LINE_HEIGHT = 25;
    private JList ivLocusList = null;
    private JList ivGenotypeList = null;
    private JLabel ivLocusLabel = new JLabel();
    private JLabel ivGenotypListLabel = new JLabel();
    private JLabel ivGesamtGenotypLabel = new JLabel();
    private final HashSet ivSelectedLoci = new HashSet();
    private HashSet ivSelectedGenotypes = new HashSet();
    private HashMap ivSelectedGenotypesByLocus = new HashMap();
    private Locus ivAktSelectedLocus = null;
    private final Vector ivGenotypesForList = new Vector();
    private final String ivGroup;
    private boolean ivAlsoUnset = false;

    public static LocusAndAlleles[] selectLocusAndAlleles(Frame sender, String group, boolean alsoUnset) {
        SelectLocusAndGenotypesRequester saar = new SelectLocusAndGenotypesRequester(sender, group, alsoUnset);
        if (saar.ivWarOK && saar.ivSelectedGenotypes.size() != 0) {
            LocusAndAlleles[] res = new LocusAndAlleles[saar.ivSelectedGenotypes.size()];
            int pos = 0;
            Iterator iter = saar.ivSelectedGenotypes.iterator();
            while (iter.hasNext()) {
                LocusAndAlleles lal = (LocusAndAlleles)iter.next();
                res[pos++] = lal;
            }
            return res;
        }
        return null;
    }

    private SelectLocusAndGenotypesRequester(Frame sender, String group, boolean alsoUnset) {
        super(sender, 500, 500);
        this.ivGroup = group;
        this.ivAlsoUnset = alsoUnset;
        this.setTitle(Babel.get("SELECTLOCUSANDALLELES"));
        int y = 10;
        this.ivGesamtGenotypLabel.setFont(FontManager.getFont("SSB16"));
        this.ivGesamtGenotypLabel.setText("GT: ");
        this.addAndApplyBounds(this.ivGesamtGenotypLabel, 10, y, 480, 25);
        y += 35;
        int lbr = 235;
        int rbr = 470 - lbr;
        int oh = 405;
        this.ivLocusLabel.setFont(FontManager.getFont("SSB12"));
        this.ivLocusLabel.setHorizontalTextPosition(4);
        Vector loci = LocusManager.cvInstance.getActualObjectVectorAllGroups();
        Collections.sort(loci);
        this.ivLocusList = new JList(loci);
        this.ivLocusList.getSelectionModel().setSelectionMode(0);
        this.ivLocusList.setCellRenderer(this);
        this.ivLocusList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                SelectLocusAndGenotypesRequester.this.ivAktSelectedLocus = (Locus)SelectLocusAndGenotypesRequester.this.ivLocusList.getSelectedValue();
                SelectLocusAndGenotypesRequester.this.ivSelectedLoci.add(SelectLocusAndGenotypesRequester.this.ivAktSelectedLocus);
                SelectLocusAndGenotypesRequester.this.ivGenotypesForList.clear();
                if (SelectLocusAndGenotypesRequester.this.ivAktSelectedLocus != null) {
                    SelectLocusAndGenotypesRequester.this.ivGenotypesForList.addAll(SelectLocusAndGenotypesRequester.this.ivAktSelectedLocus.getListOfGenotypes(4, null, SelectLocusAndGenotypesRequester.this.ivAlsoUnset));
                }
                SelectLocusAndGenotypesRequester.this.ivGenotypeList.setListData(SelectLocusAndGenotypesRequester.this.ivGenotypesForList);
                SelectLocusAndGenotypesRequester.this.checkButton();
            }
        });
        JPanel mp = new JPanel(new BorderLayout());
        mp.setOpaque(false);
        mp.add("Center", new JScrollPane(this.ivLocusList));
        BorderPanel mbp = new BorderPanel(mp, Babel.get("LOCI"));
        this.addAndApplyBounds(mbp, 10, y, lbr, oh);
        this.ivGenotypeList = new JList(this.ivGenotypesForList);
        this.ivGenotypListLabel.setFont(FontManager.getFont("SSB12"));
        this.ivGenotypListLabel.setHorizontalTextPosition(4);
        this.ivGenotypeList.setCellRenderer(this);
        this.ivGenotypeList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    SelectLocusAndGenotypesRequester.this.OKPressed();
                }
            }
        });
        this.ivGenotypeList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent arg0) {
                if (SelectLocusAndGenotypesRequester.this.ivAktSelectedLocus != null) {
                    LocusAndAlleles jetztLal;
                    LocusAndAlleles bisherLal = (LocusAndAlleles)SelectLocusAndGenotypesRequester.this.ivSelectedGenotypesByLocus.get(SelectLocusAndGenotypesRequester.this.ivAktSelectedLocus);
                    if (bisherLal != null) {
                        SelectLocusAndGenotypesRequester.this.ivSelectedGenotypes.remove(bisherLal);
                    }
                    if ((jetztLal = (LocusAndAlleles)SelectLocusAndGenotypesRequester.this.ivGenotypeList.getSelectedValue()) != null) {
                        SelectLocusAndGenotypesRequester.this.ivSelectedGenotypes.add(jetztLal);
                        SelectLocusAndGenotypesRequester.this.ivSelectedGenotypesByLocus.put(SelectLocusAndGenotypesRequester.this.ivAktSelectedLocus, jetztLal);
                    }
                    SelectLocusAndGenotypesRequester.this.checkButton();
                }
            }
        });
        mp = new JPanel(new BorderLayout());
        mp.add("Center", new JScrollPane(this.ivGenotypeList));
        mbp = new BorderPanel(mp, Babel.get("GENOTYPES"));
        this.addAndApplyBounds(mbp, 20 + lbr, y, rbr, oh);
        y += oh + 10;
        lbr = 153;
        rbr = 460 - 2 * lbr;
        this.ivOkButton.setEnabled(false);
        this.applyBounds(this.ivOkButton, 10, 460, 480, 30);
        this.setVisible(true);
    }

    public boolean okAndNoWanted() {
        return false;
    }

    public boolean onlyOKWanted() {
        return true;
    }

    private void checkButton() {
        StringBuffer msb = new StringBuffer();
        Iterator iter = this.ivSelectedGenotypes.iterator();
        while (iter.hasNext()) {
            LocusAndAlleles lal = (LocusAndAlleles)iter.next();
            if (msb.length() != 0) {
                msb.append(";");
            }
            msb.append(lal.toGenotypeString(this.ivGroup));
        }
        this.ivGesamtGenotypLabel.setText("GT: " + msb.toString());
        this.ivOkButton.setEnabled(!this.ivSelectedGenotypes.isEmpty());
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (list == this.ivLocusList) {
            Locus locus = (Locus)value;
            this.ivLocusLabel.setText(" " + locus.getName() + " ");
            if (isSelected) {
                this.ivLocusLabel.setOpaque(true);
                this.ivLocusLabel.setBackground(UIDef.SELECTED_BACKGROUND);
            } else {
                this.ivLocusLabel.setOpaque(false);
                this.ivLocusLabel.setBackground(null);
            }
            if (this.ivSelectedLoci.contains(locus) && this.ivSelectedGenotypesByLocus.get(locus) != null) {
                this.ivLocusLabel.setIcon(ImageProvider.HAKEN_ICON);
            } else {
                this.ivLocusLabel.setIcon(ImageProvider.EMPTY_HAKEN_ICON);
            }
            return this.ivLocusLabel;
        }
        if (list == this.ivGenotypeList) {
            LocusAndAlleles lal = (LocusAndAlleles)value;
            this.ivGenotypListLabel.setText(" " + lal.getAlleleString(this.ivGroup) + " ");
            if (isSelected) {
                this.ivGenotypListLabel.setOpaque(true);
                this.ivGenotypListLabel.setBackground(UIDef.SELECTED_BACKGROUND);
            } else {
                this.ivGenotypListLabel.setOpaque(false);
                this.ivGenotypListLabel.setBackground(null);
            }
            if (this.ivSelectedGenotypes.contains(lal)) {
                this.ivGenotypListLabel.setIcon(ImageProvider.HAKEN_ICON);
            } else {
                this.ivGenotypListLabel.setIcon(ImageProvider.EMPTY_HAKEN_ICON);
            }
            return this.ivGenotypListLabel;
        }
        return null;
    }
}

