/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.mail;

import de.hannse.netobjects.user.User;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.RequestManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import mausoleum.exceptions.NoGroupsException;
import mausoleum.helper.FontManager;
import mausoleum.helper.Zeile;
import mausoleum.requester.BasicRequester;
import mausoleum.usergroup.UsergroupManager;

public class RecipientRequester
extends BasicRequester {
    private static final long serialVersionUID = 1L;
    private static final int RAND = 10;
    private static final int INTER_LINE = 5;
    private static final int LINE_HEIGHT = 26;
    private static final int BUT_HEIGHT = 34;
    private static final int LABEL_WIDTH = 80;
    private static final int BREITE = 500;
    private static final int HOEHE = 116;
    private static final int COMBO_WIDTH = 390;
    private JComboBox ivReceiverGroupCombo = null;
    private JComboBox ivReceiverUserCombo = null;

    public RecipientRequester(JDialog sender, boolean istFuerExport) throws NoGroupsException {
        super(sender, 500, 116);
        String[] existingGroupNames = UsergroupManager.getGroupNames(true);
        if (existingGroupNames == null || existingGroupNames.length == 0) {
            throw new NoGroupsException();
        }
        String myGroup = UserManager.getGroupOfUser();
        Vector<String> zwv = new Vector<String>();
        int i = 0;
        while (i < existingGroupNames.length) {
            if (istFuerExport) {
                if (!existingGroupNames[i].equals("service") && !existingGroupNames[i].equals(myGroup)) {
                    zwv.add(existingGroupNames[i]);
                }
            } else {
                zwv.add(existingGroupNames[i]);
            }
            ++i;
        }
        if (zwv.isEmpty()) {
            throw new NoGroupsException();
        }
        existingGroupNames = new String[zwv.size()];
        i = 0;
        while (i < existingGroupNames.length) {
            existingGroupNames[i] = (String)zwv.elementAt(i);
            ++i;
        }
        this.ivReceiverGroupCombo = new JComboBox<String>(existingGroupNames);
        this.ivReceiverGroupCombo.setFont(FontManager.getFont("SSB14"));
        if (!istFuerExport) {
            this.ivReceiverGroupCombo.setSelectedItem(myGroup);
        }
        this.ivReceiverGroupCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RecipientRequester.this.adaptToGroup((String)RecipientRequester.this.ivReceiverGroupCombo.getSelectedItem());
            }
        });
        this.ivReceiverUserCombo = new JComboBox();
        this.ivReceiverUserCombo.setFont(FontManager.getFont("SSB14"));
        this.adaptToGroup((String)this.ivReceiverGroupCombo.getSelectedItem());
        this.setTitle(Babel.get("ADD_RECIPIENT"));
        int y = 10;
        int x1 = 10;
        int x2 = x1 + 80 + 5;
        this.addPermanentLabel(Babel.get("GROUP"), x1, y, 26);
        this.addAndApplyBounds(this.ivReceiverGroupCombo, x2, y, 390, 26);
        this.addPermanentLabel(Babel.get("USER"), x1, y += 31, 26);
        this.addAndApplyBounds(this.ivReceiverUserCombo, x2, y, 390, 26);
        this.applyBounds(this.ivOkButton, 10, y += 31, 480, 34);
        y += 44;
        this.setVisible(true);
    }

    public static Vector getUserRecInfos(String group) {
        Vector<RecInfo> recInfos = null;
        Vector v = (Vector)RequestManager.createSendAndGetObjectIfFinished((byte)42, group, null);
        if (v != null) {
            boolean ownGroup = group.equalsIgnoreCase(UserManager.getGroupOfUser());
            recInfos = new Vector<RecInfo>(v.size());
            Iterator iter = v.iterator();
            while (iter.hasNext()) {
                RecInfo recInfo = new RecInfo((String)iter.next(), group);
                if (ownGroup && recInfo.binsIch()) continue;
                recInfos.add(recInfo);
            }
            Collections.sort(recInfos);
        }
        return recInfos;
    }

    private void adaptToGroup(String group) {
        Vector recInfos = RecipientRequester.getUserRecInfos(group);
        if (recInfos == null) {
            this.ivReceiverUserCombo.setModel(new DefaultComboBoxModel(new Vector()));
            this.ivReceiverUserCombo.setEnabled(false);
        } else {
            this.ivReceiverUserCombo.setModel(new DefaultComboBoxModel(recInfos));
            this.ivReceiverUserCombo.setEnabled(true);
        }
    }

    public void OKPressed() {
        super.OKPressed();
    }

    public boolean okAndNoWanted() {
        return false;
    }

    public boolean onlyOKWanted() {
        return true;
    }

    public RecInfo getAddress() {
        if (this.ivReceiverUserCombo != null && this.ivReceiverGroupCombo != null) {
            return (RecInfo)this.ivReceiverUserCombo.getSelectedItem();
        }
        return null;
    }

    public static class RecInfo
    implements Comparable {
        public final String ivName;
        public final String ivGroup;
        public final Long ivID;
        public final boolean ivIsVeterinary;

        public RecInfo(String group, String userName, Long userID, boolean isVeterinary) {
            this.ivName = userName;
            this.ivGroup = group;
            this.ivID = userID;
            this.ivIsVeterinary = isVeterinary;
        }

        public RecInfo(String line, String group) {
            Zeile z = new Zeile(line, '|');
            this.ivName = z.getString(0);
            this.ivGroup = group;
            this.ivID = new Long(z.getLong(2, -1L));
            this.ivIsVeterinary = "1".equalsIgnoreCase(z.getString(4, ""));
        }

        public String toString() {
            return this.ivName;
        }

        public boolean binsIch() {
            User ich = UserManager.getUser();
            return ich.getGroup().equals(this.ivGroup) && ich.getLongID().equals(this.ivID);
        }

        public int compareTo(Object arg0) {
            if (arg0 instanceof RecInfo) {
                RecInfo recInfo = (RecInfo)arg0;
                return this.ivName.compareToIgnoreCase(recInfo.ivName);
            }
            return 0;
        }

        public boolean equals(RecInfo recInfo) {
            return this.ivGroup.equals(recInfo.ivGroup) && this.ivID.equals(recInfo.ivID);
        }
    }
}

