/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.main;

import de.hannse.netobjects.network.client.ClientCommunicator;
import de.hannse.netobjects.network.client.TimeMachine;
import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectManager;
import de.hannse.netobjects.objectstore.ObjectRequest;
import de.hannse.netobjects.objectstore.ObjectStoreClient;
import de.hannse.netobjects.user.User;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.Log;
import de.hannse.netobjects.util.RequestManager;
import java.awt.Frame;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JFrame;
import javax.swing.JTable;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import mausoleum.administrator.AdministratorWindow;
import mausoleum.alert.Alert;
import mausoleum.building.BuildingManager;
import mausoleum.cage.CageManager;
import mausoleum.cage.colors.CageColorManager;
import mausoleum.datalayer.MiscHandler;
import mausoleum.definitionlists.ListDefinition;
import mausoleum.experiment.ExperimentManager;
import mausoleum.factsheets.FactSheetFrame;
import mausoleum.factsheets.groupreport.GroupStatistics;
import mausoleum.factsheets.multidimreport.MultiDimReportFrame;
import mausoleum.gui.GuiPropertiesMausoleum;
import mausoleum.gui.WindowMinimalSizer;
import mausoleum.helper.WindowUtils;
import mausoleum.idobjectgroup.IDObjectGroupManager;
import mausoleum.inspector.DormantPanel;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.actions.IAManager;
import mausoleum.inspector.sensitives.CSEartag;
import mausoleum.license.LicenseManager;
import mausoleum.line.LineManager;
import mausoleum.locus.LocusManager;
import mausoleum.mail.MailManager;
import mausoleum.main.DefaultManager;
import mausoleum.main.ProcessDefinition;
import mausoleum.main.TaskCounterDialog;
import mausoleum.mouse.MouseIDCard;
import mausoleum.mouse.MouseManager;
import mausoleum.printing.PreviewFrame;
import mausoleum.rack.RackManager;
import mausoleum.rack.frame.RackFrame;
import mausoleum.rack.frame.RackOverview;
import mausoleum.rack.frame.cagecard.RackCageCardFrame;
import mausoleum.requester.InitializationProgress;
import mausoleum.requester.LoginRequester;
import mausoleum.requester.rack.RackServiceDisplayFrame;
import mausoleum.result.rackhealthreport.RResHealthReport;
import mausoleum.room.RoomManager;
import mausoleum.search.SearchFrame;
import mausoleum.strain.StrainManager;
import mausoleum.tables.MausoleumTableFrame;
import mausoleum.tables.MausoleumTableModel;
import mausoleum.tables.TableFrameTasks;
import mausoleum.task.DisplayTask;
import mausoleum.task.TaskCounter;
import mausoleum.task.standards.StandardTask;
import mausoleum.task.standards.StandardTaskPanel;
import mausoleum.usergroup.UsergroupManager;
import mausoleum.util.calendar.InstituteHolidays;

public class MausoleumClient {
    public static final int MODE_UNKNOWN = 0;
    public static final int MODE_REGULAR = 1;
    public static final int MODE_ADMINISTRATOR = 2;
    public static final int MODE_HEAD_OF_SERVICE = 3;
    public static final int MODE_SERVICE_MEMBER = 4;
    public static final int MODE_HEAD_OF_TGSERVICE = 5;
    public static final int MODE_TGSERVICE_MEMBER = 6;
    public static final int MAX_INIT_STEPS_REGULAR = 21;
    public static final int MAX_INIT_STEPS_HEAD_OF_SERVICE = 7;
    public static final int MAX_INIT_STEPS_SERVICE_CT = 21;
    private static int cvMaxInitSteps = 21;
    private static int cvInitStep = 0;
    private static String cvInitMessage = null;
    private static boolean cvExiting = false;
    public static boolean cvManagerInitialized = false;
    protected static int cvClientMode = 0;
    public static Long cvServiceCTRoomID = null;
    public static String cvServiceCTRoomName = null;
    public static boolean cvMoreServiceRoomsAvailable = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static void main(String[] args) {
        Class<?> clazz;
        Class<?> clazz2;
        ProcessDefinition.setProcessType(4);
        Log.init();
        InitializationProgress.showUp("Setting up...", false);
        InitializationProgress.setMessage("", 0, 0);
        DefaultManager.init();
        IDObject.init();
        try {
            UIManager.setLookAndFeel("mausoleum.ui.MausoleumLookAndFeel");
        }
        catch (Exception e) {
            System.out.println("Could not set UI " + e);
        }
        GuiPropertiesMausoleum.setDefaultProperties();
        DefaultManager.setDesign("MARBLE");
        ToolTipManager.sharedInstance().setInitialDelay(200);
        ToolTipManager.sharedInstance().setDismissDelay(2000000);
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("mausoleum.main.MausoleumClient");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Log.log("Starting up Communicator to Server", clazz3);
        ClientCommunicator.init();
        if (ClientCommunicator.getCommunicator() == null) {
            MausoleumClient.initCrashed("The Network connection is down or the licenses are exhausted [4832]. Try again later...");
        }
        InitializationProgress.setMainMessage("Check connection");
        if (!ClientCommunicator.getCommunicator().isUp()) {
            MausoleumClient.initCrashed("The Network connection is down or the licenses are exhausted [7327]. Try again later...");
        }
        try {
            Class<?> clazz4 = class$0;
            if (clazz4 == null) {
                try {
                    clazz4 = class$0 = Class.forName("mausoleum.main.MausoleumClient");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.log("First communication test to server", clazz4);
            RequestManager.createSendAndGetAnswer((byte)68);
            Class<?> clazz5 = class$0;
            if (clazz5 == null) {
                try {
                    clazz5 = class$0 = Class.forName("mausoleum.main.MausoleumClient");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.log("Retreived Server answer info successfully", clazz5);
        }
        catch (Exception e) {
            MausoleumClient.initCrashed("The Network connection is down or the licenses are exhausted [5587]. Try again later...");
        }
        if ((clazz2 = class$0) == null) {
            try {
                clazz2 = class$0 = Class.forName("mausoleum.main.MausoleumClient");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Log.log("Start checking client and server version", clazz2);
        try {
            if (!"6.9.8 \u03b23".equals(RequestManager.createSendAndGetObjectIfFinished((byte)57))) {
                MausoleumClient.initCrashed("Server and Client use different program versions. Please follow the installation instructions and always start the Client via Mausoleum.jar!");
            }
        }
        catch (Exception e) {
            Class<?> clazz6 = class$0;
            if (clazz6 == null) {
                try {
                    clazz6 = class$0 = Class.forName("mausoleum.main.MausoleumClient");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.error("Exception while checking version", e, clazz6);
            MausoleumClient.initCrashed("Could not check Server program version.");
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("mausoleum.main.MausoleumClient");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Log.log("Show login dialog", clazz);
        if (args.length >= 3) {
            UserManager.setUser(LoginRequester.login(args[0], args[1], args[2]));
        } else {
            UserManager.setUser(LoginRequester.login());
        }
        if (UserManager.getUser() == null) {
            RequestManager.sendLogoutRequest();
            System.exit(0);
        }
        InitializationProgress.appear();
        MausoleumClient.loginAfterUser();
    }

    private static void initCrashed(String alert) {
        InitializationProgress.dismiss();
        Alert.showAlert(alert, null, null, true);
        System.exit(0);
    }

    public static void makeHosGuruClient(String group) {
        User alterUser;
        if (MausoleumClient.isHeadOfService() && (alterUser = UserManager.getUser()) != null && alterUser.getInt("USR_MODE", 0) == 500) {
            boolean schlummer = Inspector.getInspector().isInSchlummer();
            UserManager.setOriginalUser(alterUser);
            RequestManager.createSendAndGetAnswer((byte)81, group, "service");
            MausoleumClient.clearClient();
            UserManager.setGroup(group);
            UserManager.setUser(UserManager.getPseudoGuru(alterUser, group));
            InitializationProgress.showUp("Setting up...", true);
            ObjectManager.setAcceptObjectModifications(true);
            MausoleumClient.loginAfterUser();
            StandardTaskPanel.adaptForGroupChange();
            if (schlummer) {
                Inspector.getInspector().goToSleepInner();
            }
        }
    }

    public static void returnFromHosGuru() {
        User alterUser;
        if (MausoleumClient.isRegular() && (alterUser = UserManager.getOriginalUser()) != null) {
            boolean schlummer = Inspector.getInspector().isInSchlummer();
            UserManager.setOriginalUser(null);
            RequestManager.createSendAndGetAnswer((byte)81, null, "service");
            MausoleumClient.clearClient();
            UserManager.setGroup("service");
            UserManager.setUser(alterUser);
            InitializationProgress.showUp("Setting up...", true);
            ObjectManager.setAcceptObjectModifications(true);
            MausoleumClient.loginAfterUser();
            StandardTaskPanel.adaptForGroupChange();
            Inspector.userChanged();
            if (schlummer) {
                Inspector.getInspector().goToSleepInner();
            }
        }
    }

    private static void loginAfterUser() {
        TimeMachine.startUp();
        DefaultManager.reinitWithUser(true);
        InstituteHolidays.clearCache();
        RResHealthReport.init();
        int usermode = UserManager.getUser().getInt("USR_MODE", 0);
        switch (usermode) {
            case 1000: 
            case 1001: {
                InitializationProgress.dismiss();
                cvClientMode = 2;
                DefaultManager.setDesign(DefaultManager.getDesign());
                AdministratorWindow aw = AdministratorWindow.getAdminWindow(usermode == 1000);
                aw.setVisible(true);
                break;
            }
            case 500: {
                cvClientMode = 3;
                cvMaxInitSteps = 7;
                CageColorManager.startUpClient1();
                MausoleumClient.loginHeadOfService();
                DormantPanel.startWatchDog();
                CageColorManager.startUpClient2();
                break;
            }
            case 550: {
                cvClientMode = 4;
                cvMaxInitSteps = 21;
                CageColorManager.startUpClient1();
                MausoleumClient.loginServiceCaretaker();
                DormantPanel.startWatchDog();
                CageColorManager.startUpClient2();
                break;
            }
            case 660: {
                cvClientMode = 6;
                cvMaxInitSteps = 21;
                CageColorManager.startUpClient1();
                MausoleumClient.loginTGServiceCaretaker();
                DormantPanel.startWatchDog();
                CageColorManager.startUpClient2();
                break;
            }
            case 600: {
                cvClientMode = 5;
                cvMaxInitSteps = 21;
                CageColorManager.startUpClient1();
                MausoleumClient.loginHeadOfTGService();
                DormantPanel.startWatchDog();
                CageColorManager.startUpClient2();
                break;
            }
            default: {
                cvClientMode = 1;
                cvMaxInitSteps = 21;
                CageColorManager.startUpClient1();
                MausoleumClient.loginRegular();
                DormantPanel.startWatchDog();
                CageColorManager.startUpClient2();
            }
        }
    }

    public static boolean isRegular() {
        return cvClientMode == 1;
    }

    public static boolean isRegularOrTGService() {
        return MausoleumClient.isRegular() || MausoleumClient.isTGService();
    }

    public static boolean isTGService() {
        return cvClientMode == 6 || cvClientMode == 5;
    }

    public static boolean isHeadOfService() {
        return cvClientMode == 3;
    }

    public static boolean isHeadOfTGService() {
        return cvClientMode == 5;
    }

    public static boolean isAdministrator() {
        return cvClientMode == 2;
    }

    public static boolean isServiceCaretaker() {
        return cvClientMode == 4;
    }

    public static boolean isTGServiceCaretaker() {
        return cvClientMode == 6;
    }

    private static void clearClient() {
        ObjectManager.setAcceptObjectModifications(false);
        MouseIDCard.hideIt();
        WindowMinimalSizer.cleanUp();
        HashSet<JFrame> frames = new HashSet<JFrame>();
        HashSet hs = ObjectStoreClient.getAllMausoleumTables();
        Iterator iterator = hs.iterator();
        while (iterator.hasNext()) {
            JFrame jf;
            MausoleumTableModel mtm = (MausoleumTableModel)iterator.next();
            JTable jTable = mtm.getJTable();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = Class.forName("javax.swing.JFrame");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!((jf = (JFrame)WindowUtils.getParent(jTable, clazz)) == null || jf instanceof Inspector || jf instanceof MultiDimReportFrame || MausoleumTableFrame.isMainFrame(jf))) {
                frames.add(jf);
            }
            mtm.mDispose();
        }
        iterator = frames.iterator();
        while (iterator.hasNext()) {
            JFrame frame = (JFrame)iterator.next();
            if (frame.isVisible()) {
                frame.setVisible(false);
            }
            frame.dispose();
        }
        RackFrame.destroyIt();
        MausoleumTableFrame.removeMainFrame();
        MultiDimReportFrame.closeOpenFrames();
        FactSheetFrame.closeOpenFrames();
        PreviewFrame.closeOpenFrames();
        RackOverview.destroyIt();
        RackCageCardFrame.destroyIt();
        RackServiceDisplayFrame.destroyIt();
        SearchFrame.destroyIt();
        MiscHandler.clearCollecteds();
        StandardTask.clearGroupHashMaps();
        ListDefinition.clearGroupHashMaps();
        InitializationProgress.showUp(Babel.get("FINALIZING"), false);
        String vorne = String.valueOf(Babel.get("SAVING")) + " ";
        if (MausoleumClient.isRegularOrTGService() || MausoleumClient.isServiceCaretaker()) {
            InitializationProgress.setMessage(String.valueOf(vorne) + Babel.get("RACKS"), 0, 10);
            RackManager.exit();
            InitializationProgress.setMessage(String.valueOf(vorne) + Babel.get("STRAINS"), 1, 10);
            StrainManager.exit();
            InitializationProgress.setMessage(String.valueOf(vorne) + Babel.get("LINES"), 2, 10);
            LineManager.exit();
            InitializationProgress.setMessage(String.valueOf(vorne) + Babel.get("LOCI"), 3, 10);
            LocusManager.exit();
            InitializationProgress.setMessage(String.valueOf(vorne) + Babel.get("USERS"), 4, 10);
            UserManager.exit();
            InitializationProgress.setMessage(String.valueOf(vorne) + Babel.get("MICE"), 5, 10);
            MouseManager.exit();
            InitializationProgress.setMessage(String.valueOf(vorne) + Babel.get("CAGES"), 6, 10);
            CageManager.exit();
            InitializationProgress.setMessage(String.valueOf(vorne) + Babel.get("MAIL"), 7, 10);
            MailManager.exit();
            InitializationProgress.setMessage(String.valueOf(vorne) + Babel.get("ROOMS"), 8, 10);
            RoomManager.exit();
            InitializationProgress.setMessage(String.valueOf(vorne) + Babel.get("EXPERIMENTS"), 9, 10);
            ExperimentManager.exit();
            InitializationProgress.setMessage(String.valueOf(vorne) + Babel.get("LICENSES"), 10, 10);
            LicenseManager.exit();
            IDObjectGroupManager.exit();
        } else if (MausoleumClient.isHeadOfService()) {
            InitializationProgress.setMessage(String.valueOf(vorne) + Babel.get("RACKS"), 0, 10);
            RackManager.exit();
            InitializationProgress.setMessage(String.valueOf(vorne) + Babel.get("USERS"), 1, 10);
            UserManager.exit();
            InitializationProgress.setMessage(String.valueOf(vorne) + Babel.get("ROOMS"), 2, 10);
            RoomManager.exit();
            InitializationProgress.setMessage(String.valueOf(vorne) + Babel.get("BUILDINGS"), 3, 10);
            BuildingManager.exit();
            InitializationProgress.setMessage(String.valueOf(vorne) + Babel.get("MAIL"), 4, 10);
            MailManager.exit();
            InitializationProgress.setMessage(String.valueOf(vorne) + Babel.get("GROUPS"), 5, 10);
            UsergroupManager.exit();
            InitializationProgress.setMessage(String.valueOf(vorne) + Babel.get("STRAINS"), 6, 10);
            StrainManager.exit();
            InitializationProgress.setMessage(String.valueOf(vorne) + Babel.get("LOCI"), 7, 10);
            LocusManager.exit();
            InitializationProgress.setMessage(String.valueOf(vorne) + Babel.get("LINES"), 8, 10);
            LineManager.exit();
            InitializationProgress.setMessage(String.valueOf(vorne) + Babel.get("LICENSES"), 9, 10);
            LicenseManager.exit();
            InitializationProgress.setMessage(String.valueOf(vorne) + Babel.get("EXPERIMENTS"), 10, 10);
            ExperimentManager.exit();
        }
        Inspector.getInspector().disableButtons();
        Inspector.removeInspector();
        IAManager.exit();
        CageColorManager.destroy();
    }

    private static void loginHeadOfService() {
        DefaultManager.setDesign(DefaultManager.getDesign());
        InitializationProgress.setMainMessage(Babel.get("INITIALIZING"), true);
        String vorne = String.valueOf(Babel.get("LOADING")) + " ";
        cvInitStep = -1;
        MausoleumClient.setRegMessage(String.valueOf(vorne) + Babel.get("RACKS"));
        RackManager.init();
        MausoleumClient.setRegMessage(String.valueOf(vorne) + Babel.get("USERS"));
        UserManager.init();
        MausoleumClient.setRegMessage(String.valueOf(vorne) + Babel.get("ROOMS"));
        RoomManager.init();
        MausoleumClient.setRegMessage(String.valueOf(vorne) + Babel.get("BUILDINGS"));
        BuildingManager.init();
        MausoleumClient.setRegMessage(String.valueOf(vorne) + Babel.get("GROUPS"));
        UsergroupManager.init();
        MausoleumClient.setRegMessage(String.valueOf(vorne) + Babel.get("MAIL"));
        MailManager.init();
        MausoleumClient.setRegMessage(String.valueOf(vorne) + Babel.get("STRAINS"));
        StrainManager.init();
        MausoleumClient.setRegMessage(String.valueOf(vorne) + Babel.get("LOCI"));
        LocusManager.init();
        MausoleumClient.setRegMessage(String.valueOf(vorne) + Babel.get("LINES"));
        LineManager.init();
        MausoleumClient.setRegMessage(String.valueOf(vorne) + Babel.get("LICENSES"));
        LicenseManager.init();
        MausoleumClient.setRegMessage(String.valueOf(vorne) + Babel.get("EXPERIMENTS"));
        ExperimentManager.init();
        StandardTask.init("service");
        ListDefinition.init("service");
        cvManagerInitialized = true;
        ClientCommunicator.send(new ObjectRequest(15, null, null, null));
        MausoleumClient.setRegMessage(Babel.get("INIT_DEFAULTS"));
        DefaultManager.reinitWithUser(true);
        Inspector.getInspector().disableButtons();
        MausoleumClient.setRegMessage(Babel.get("INIT_MAIN_TABLES"));
        MausoleumTableFrame.initMainTables();
        MausoleumClient.setRegMessage(Babel.get("PREPARE_INSPECTOR"));
        Inspector.adjustToTable(null);
        Inspector.getInspector().setVisible(true);
        Inspector.getInspector().enableButtons();
        InitializationProgress.dismiss();
    }

    private static void loginServiceCaretaker() {
        DefaultManager.setDesign(DefaultManager.getDesign());
        ObjectRequest mor = RequestManager.createSendAndGetAnswer((byte)46, TaskCounter.COM_GET_TASK_COUNTER, "service", UserManager.getUser().getIdentifierString());
        if (!mor.isFinished()) {
            Alert.showAlert(Babel.get("NO_ROOMS_AVAILABLE"), true);
            RequestManager.sendLogoutRequest();
            System.exit(0);
        } else {
            HashMap taskCounters = (HashMap)mor.ivExtraObject;
            if (taskCounters == null || taskCounters.isEmpty()) {
                Alert.showAlert(Babel.get("NO_ROOMS_AVAILABLE"), true);
                RequestManager.sendLogoutRequest();
                System.exit(0);
            } else {
                cvMoreServiceRoomsAvailable = taskCounters.size() > 1;
                TaskCounter selTC = TaskCounterDialog.selectRoom(new Frame(), taskCounters);
                if (selTC == null) {
                    Alert.showAlert(Babel.get("NO_ROOMS_AVAILABLE"), true);
                    RequestManager.sendLogoutRequest();
                    System.exit(0);
                } else {
                    cvServiceCTRoomID = new Long(selTC.ivRoomServiceID);
                    cvServiceCTRoomName = selTC.ivRoomname;
                }
                ObjectManager.cvServiceCareTakerIDsByGroupName = (HashMap)RequestManager.createSendAndGetObjectIfFinished((byte)47, cvServiceCTRoomID, "service", UserManager.getUser().getLongID());
                if (ObjectManager.cvServiceCareTakerIDsByGroupName == null) {
                    Alert.showAlert(Babel.get("NO_OBJECTS_AVAILABLE"), true);
                    RequestManager.sendLogoutRequest();
                    System.exit(0);
                } else {
                    Iterator iter = ObjectManager.cvServiceCareTakerIDsByGroupName.keySet().iterator();
                    while (iter.hasNext()) {
                        UserManager.addGroup((String)iter.next());
                    }
                    MausoleumClient.loginRegular();
                }
            }
        }
    }

    private static void loginHeadOfTGService() {
        MausoleumClient.loginRegular();
    }

    private static void loginTGServiceCaretaker() {
        MausoleumClient.loginRegular();
    }

    private static void loginRegular() {
        DefaultManager.setDesign(DefaultManager.getDesign());
        InitializationProgress.setMainMessage(Babel.get("INITIALIZING"), true);
        String vorne = String.valueOf(Babel.get("LOADING")) + " ";
        cvInitStep = -1;
        MausoleumClient.setRegMessage(String.valueOf(vorne) + Babel.get("RACKS"));
        RackManager.init();
        MausoleumClient.setRegMessage(String.valueOf(vorne) + Babel.get("STRAINS"));
        StrainManager.init();
        MausoleumClient.setRegMessage(String.valueOf(vorne) + Babel.get("LOCI"));
        LocusManager.init();
        MausoleumClient.setRegMessage(String.valueOf(vorne) + Babel.get("LINES"));
        LineManager.init();
        MausoleumClient.setRegMessage(String.valueOf(vorne) + Babel.get("USERS"));
        UserManager.init();
        MausoleumClient.setRegMessage(String.valueOf(vorne) + Babel.get("MICE"));
        MouseManager.init();
        MausoleumClient.setRegMessage(String.valueOf(vorne) + Babel.get("CAGES"));
        CageManager.init();
        MausoleumClient.setRegMessage(String.valueOf(vorne) + Babel.get("LICENSES"));
        LicenseManager.init();
        if (UserManager.isRealUser()) {
            MausoleumClient.setRegMessage(String.valueOf(vorne) + Babel.get("MAIL"));
            MailManager.init();
        }
        MausoleumClient.setRegMessage(String.valueOf(vorne) + Babel.get("ROOMS"));
        RoomManager.init();
        MausoleumClient.setRegMessage(String.valueOf(vorne) + Babel.get("EXPERIMENTS"));
        ExperimentManager.init();
        MausoleumClient.setRegMessage(String.valueOf(vorne) + Babel.get("OBJECTGROUPS"));
        IDObjectGroupManager.init();
        MausoleumClient.setRegMessage(String.valueOf(vorne) + Babel.get("GROUPS"));
        UsergroupManager.init();
        Enumeration en = UserManager.getGroupsEnumeration();
        while (en.hasMoreElements()) {
            String group = (String)en.nextElement();
            StandardTask.init(group);
            ListDefinition.init(group);
        }
        StandardTask.init("service");
        ListDefinition.init("service");
        ListDefinition.initGroupAddresses();
        cvManagerInitialized = true;
        ClientCommunicator.send(new ObjectRequest(15, null, null, null));
        MausoleumClient.setRegMessage(Babel.get("INIT_DEFAULTS"));
        DefaultManager.reinitWithUser(true);
        Inspector.getInspector().disableButtons();
        MausoleumClient.setRegMessage(Babel.get("CHECK_MATINGS"));
        CageManager.checkWeddingStatusOfAllCages();
        MausoleumClient.setRegMessage(Babel.get("INIT_MAIN_TABLES"));
        MausoleumTableFrame.initMainTables();
        MausoleumClient.setRegMessage(Babel.get("CHECK_PLUG_ALERTS"));
        MouseManager.performPlugAlertControl(false);
        MausoleumClient.setRegMessage(Babel.get("CHECK_WEANING"));
        CageManager.performWeanControl(false);
        MausoleumClient.setRegMessage(Babel.get("CHECK_RACKS"));
        RackManager.eliminateGhostCages();
        MausoleumClient.setRegMessage(Babel.get("INIT_TASKS"));
        DisplayTask.init();
        MausoleumClient.setRegMessage(Babel.get("PREPARE_INSPECTOR"));
        Inspector.adjustToTable(null);
        Inspector.getInspector().setVisible(true);
        Inspector.getInspector().enableButtons();
        InitializationProgress.dismiss();
        CSEartag.readLastUsedEartag();
        TableFrameTasks.showWindowIfNecessary();
        new Thread(new Runnable(){

            public void run() {
                GroupStatistics.saveStatisticsFromClient();
            }
        }).start();
    }

    private static void setRegMessage(String message) {
        cvInitMessage = message;
        InitializationProgress.setMessage(message, ++cvInitStep, cvMaxInitSteps);
    }

    public static void setSubMessage(int ist, int soll) {
        if (cvInitMessage != null) {
            InitializationProgress.setMessage(cvInitMessage, cvInitStep, cvMaxInitSteps, ist, soll);
        }
    }

    public static void setSubMessage(int ist, int soll, String subText) {
        if (cvInitMessage != null) {
            InitializationProgress.setMessage(String.valueOf(cvInitMessage) + (subText != null ? " (" + subText + ")" : ""), cvInitStep, cvMaxInitSteps, ist, soll);
        }
    }

    public static void exit() {
        if (!cvExiting && ClientCommunicator.getCommunicator().isUp()) {
            cvExiting = true;
            Inspector.getInspector().disableButtons();
            TimeMachine.sayGoodBye();
            MausoleumClient.clearClient();
            System.exit(0);
        }
    }
}

