/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.main;

import de.hannse.netobjects.datalayer.DataLayer;
import de.hannse.netobjects.network.server.ServerPortal;
import de.hannse.netobjects.objectstore.CommandManager;
import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectPortal;
import de.hannse.netobjects.server.http.HTTPServerPortal;
import de.hannse.netobjects.tools.FileManager;
import de.hannse.netobjects.util.Log;
import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import mausoleum.factsheets.groupreport.GroupStatistics;
import mausoleum.main.ArmisLink;
import mausoleum.main.DefaultManager;
import mausoleum.main.ProcessDefinition;
import mausoleum.main.StatusHTMLWriter;
import mausoleum.sonderreports.SonderReports;
import mausoleum.util.PathStore;

public abstract class MausoleumServer {
    private static final String SERVER_DIR_ARG = "serverdir=";
    private static boolean cvInitialized = false;
    private static boolean cvHasArmis = false;
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        ProcessDefinition.setProcessType(1);
        Log.init();
        if (args != null) {
            int i = 0;
            while (i < args.length) {
                if (args[i].startsWith(SERVER_DIR_ARG)) {
                    PathStore.setServerDir(args[i].substring(SERVER_DIR_ARG.length(), args[i].length()).trim());
                }
                ++i;
            }
        }
        Properties props = System.getProperties();
        StringBuilder msb = new StringBuilder();
        msb.append("********************************\n");
        msb.append("* Starting up Mausoleum Server *\n");
        msb.append("********************************\n");
        msb.append("Version " + DefaultManager.getLongServerVersionInfo() + "\n");
        msb.append("*********************\n");
        msb.append("* SYSTEM PROPERTIES *\n");
        msb.append("*********************\n");
        Vector<Object> v = new Vector<Object>();
        Iterator<Object> iter = props.keySet().iterator();
        while (iter.hasNext()) {
            v.add(iter.next());
        }
        Collections.sort(v);
        iter = v.iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String val = props.getProperty(key);
            msb.append("----------------------------------\n");
            msb.append(key).append("\n");
            msb.append(val).append("\n");
        }
        msb.append("\n");
        msb.append("==================================\n");
        String string = msb.toString();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("mausoleum.main.MausoleumServer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Log.log(string, clazz);
        MausoleumServer.umbugsieren("Client.jar", "HTML", false);
        IDObject.init();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("mausoleum.main.MausoleumServer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Log.log("IDObject initialisiert", clazz2);
        DataLayer.init(DataLayer.getAppropriateDatalayer());
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("mausoleum.main.MausoleumServer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Log.log("DataLayer initialisiert", clazz3);
        ObjectPortal.init();
        Class<?> clazz4 = class$0;
        if (clazz4 == null) {
            try {
                clazz4 = class$0 = Class.forName("mausoleum.main.MausoleumServer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Log.log("ObjectPortal initialisiert", clazz4);
        CommandManager.init();
        Class<?> clazz5 = class$0;
        if (clazz5 == null) {
            try {
                clazz5 = class$0 = Class.forName("mausoleum.main.MausoleumServer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Log.log("CommandManger initialisiert", clazz5);
        HTTPServerPortal.start();
        ServerPortal.start();
        Class<?> clazz6 = class$0;
        if (clazz6 == null) {
            try {
                clazz6 = class$0 = Class.forName("mausoleum.main.MausoleumServer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Log.log("ServerPortal initialisiert", clazz6);
        GroupStatistics.saveStatisticsFromServerAllGroups();
        Class<?> clazz7 = class$0;
        if (clazz7 == null) {
            try {
                clazz7 = class$0 = Class.forName("mausoleum.main.MausoleumServer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Log.log("Server Startup completed", clazz7);
        cvInitialized = true;
        SonderReports.makeStartUpReport();
        StatusHTMLWriter.start();
        if (new File("Armis.jar").exists()) {
            cvHasArmis = ArmisLink.install();
        }
    }

    public static boolean isInitialized() {
        return cvInitialized;
    }

    public static boolean hasArmis() {
        return cvHasArmis;
    }

    private static void umbugsieren(String filename, String realDir, boolean deleteInMain) {
        String string = "Checking " + filename + " in main directory";
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("mausoleum.main.MausoleumServer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Log.log(string, clazz);
        String realPath = String.valueOf(realDir) + "/" + filename;
        File mdf = new File(filename);
        if (mdf.exists()) {
            String string2 = "Detected " + filename + " in main directory";
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("mausoleum.main.MausoleumServer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.log(string2, clazz2);
            File hdf = new File(realPath);
            if (hdf.exists()) {
                if (mdf.lastModified() < hdf.lastModified()) {
                    if (deleteInMain) {
                        String string3 = String.valueOf(filename) + " in directory " + realDir + " is older. File will be moved.";
                        Class<?> clazz3 = class$0;
                        if (clazz3 == null) {
                            try {
                                clazz3 = class$0 = Class.forName("mausoleum.main.MausoleumServer");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        Log.log(string3, clazz3);
                        FileManager.deleteFile(realPath);
                        FileManager.move(filename, realPath);
                    } else {
                        String string4 = String.valueOf(filename) + " in directory " + realDir + " is older. File will be copied.";
                        Class<?> clazz4 = class$0;
                        if (clazz4 == null) {
                            try {
                                clazz4 = class$0 = Class.forName("mausoleum.main.MausoleumServer");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        Log.log(string4, clazz4);
                        FileManager.deleteFile(realPath);
                        FileManager.copy(filename, realPath);
                    }
                } else if (deleteInMain) {
                    String string5 = String.valueOf(filename) + " in main directory is older. File will be deleted";
                    Class<?> clazz5 = class$0;
                    if (clazz5 == null) {
                        try {
                            clazz5 = class$0 = Class.forName("mausoleum.main.MausoleumServer");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Log.log(string5, clazz5);
                    FileManager.deleteFile(filename);
                }
            } else if (deleteInMain) {
                String string6 = String.valueOf(filename) + " is missing in directory " + realDir + ". File will be moved.";
                Class<?> clazz6 = class$0;
                if (clazz6 == null) {
                    try {
                        clazz6 = class$0 = Class.forName("mausoleum.main.MausoleumServer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.log(string6, clazz6);
                FileManager.move(filename, realPath);
            } else {
                String string7 = String.valueOf(filename) + " is missing in directory " + realDir + ". File will be copied.";
                Class<?> clazz7 = class$0;
                if (clazz7 == null) {
                    try {
                        clazz7 = class$0 = Class.forName("mausoleum.main.MausoleumServer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.log(string7, clazz7);
                FileManager.copy(filename, realPath);
            }
        }
    }
}

