/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.mouse;

import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.ArrayHelper;
import de.hannse.netobjects.util.Babel;
import java.awt.Color;
import java.util.HashMap;
import mausoleum.gui.ColorManager;
import mausoleum.gui.MusterColor;
import mausoleum.main.ProcessDefinition;

public abstract class CoatColor {
    public static final int CC_BLACK = 1;
    public static final int CC_WHITE = 2;
    public static final int CC_LIGHT_BROWN = 3;
    public static final int CC_BROWN = 4;
    public static final int CC_DARK_BROWN = 5;
    public static final int CC_LIGHT_GRAY = 6;
    public static final int CC_GRAY = 7;
    public static final int CC_DARK_GRAY = 8;
    public static final int CC_AGOUTI = 9;
    public static final int CC_CHIMAERA = 10;
    public static final int CC_NUDE = 11;
    public static final int NO_COLOR_DEFINED = Integer.MIN_VALUE;
    public static final int[] COAT_COLORS = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
    public static final int[] COAT_COLORS_STRAIN = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 11};
    public static final String[] NAME_BABELS = new String[]{"CC_BLACK", "CC_WHITE", "CC_LIGHT_BROWN", "CC_BROWN", "CC_DARK_BROWN", "CC_LIGHT_GRAY", "CC_GRAY", "CC_DARK_GRAY", "CC_AGOUTI", "CC_CHIMAERA", "CC_NUDE"};
    public static final Color[] COLORS = new Color[]{ColorManager.getColorFromString("black"), ColorManager.getColorFromString("white"), ColorManager.getColorFromString("moccasin"), ColorManager.getColorFromString("burlywood"), ColorManager.getColorFromString("saddlebrown"), ColorManager.getColorFromString("lightgrey"), ColorManager.getColorFromString("darkgray"), ColorManager.getColorFromString("dimgray"), ColorManager.getColorFromString("rosybrown"), new MusterColor(ColorManager.getColorFromString("white"), ColorManager.getColorFromString("lightgrey"), 17), ColorManager.getColorFromString("mistyrose")};
    private static final HashMap CHOICES_BY_LANG = new HashMap();
    private static final HashMap CHOICES_STRAIN_BY_LANG = new HashMap();

    public static String[] getColorChoices(boolean forMouse) {
        String lang = "en";
        if (ProcessDefinition.isClient()) {
            lang = UserManager.getUser().getString("USR_LANGUAGE", "en");
        }
        String[] choices = null;
        choices = forMouse ? (String[])CHOICES_BY_LANG.get(lang) : (String[])CHOICES_STRAIN_BY_LANG.get(lang);
        if (choices == null) {
            int[] masterArray = forMouse ? COAT_COLORS : COAT_COLORS_STRAIN;
            choices = new String[masterArray.length + 1];
            choices[0] = Babel.get("CLEAR_COAT_COLOR");
            int i = 0;
            while (i < masterArray.length) {
                int ind = ArrayHelper.findIndexInArray(masterArray[i], COAT_COLORS);
                choices[i + 1] = Babel.get(NAME_BABELS[ind]);
                ++i;
            }
            if (forMouse) {
                CHOICES_BY_LANG.put(lang, choices);
            } else {
                CHOICES_STRAIN_BY_LANG.put(lang, choices);
            }
        }
        return choices;
    }

    public static int getSelectedCoatColor(int ind, boolean forMouse, int nullVal) {
        if (ind > 0) {
            int[] masterArray = forMouse ? COAT_COLORS : COAT_COLORS_STRAIN;
            return masterArray[ind - 1];
        }
        return nullVal;
    }

    public static Color getColor(int coatColor) {
        int checki = coatColor > 0 ? coatColor : -coatColor;
        int i = 0;
        while (i < COAT_COLORS.length) {
            if (COAT_COLORS[i] == checki) {
                return COLORS[i];
            }
            ++i;
        }
        return null;
    }

    public static String getDescr(int coatColor, boolean indicateIfStrain, String defVal) {
        if (coatColor != Integer.MIN_VALUE) {
            if (coatColor < 0) {
                if (indicateIfStrain) {
                    return "(" + StringHelper.getStringForInt(-coatColor, COAT_COLORS, NAME_BABELS, true, "") + ")";
                }
                return StringHelper.getStringForInt(-coatColor, COAT_COLORS, NAME_BABELS, true, "");
            }
            return StringHelper.getStringForInt(coatColor, COAT_COLORS, NAME_BABELS, true, "");
        }
        return defVal;
    }
}

