/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.mouse;

import de.hannse.netobjects.network.client.TimeMachine;
import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.IDObjectXMLHandler;
import de.hannse.netobjects.objectstore.IndexObject;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.user.User;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.user.UserRoomRestriction;
import de.hannse.netobjects.util.ArrayHelper;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.Log;
import de.hannse.netobjects.util.MyDate;
import java.awt.Color;
import java.awt.Font;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.definitionlists.ListDefinition;
import mausoleum.gui.MFLabel;
import mausoleum.helper.DatumFormat;
import mausoleum.helper.FontManager;
import mausoleum.helper.LongPunkt;
import mausoleum.idobjectgroup.IDObjectGroup;
import mausoleum.idobjectgroup.IDObjectGroupManager;
import mausoleum.license.License;
import mausoleum.line.Line;
import mausoleum.line.LineManager;
import mausoleum.locus.Locus;
import mausoleum.locus.LocusAndAlleles;
import mausoleum.main.DefaultManager;
import mausoleum.main.MausoleumClient;
import mausoleum.main.ProcessDefinition;
import mausoleum.mouse.MouseManager;
import mausoleum.mouse.TaskExtended;
import mausoleum.mouse.tierschutz.StressRule;
import mausoleum.printing.util.Wurf;
import mausoleum.rack.Rack;
import mausoleum.rack.RackPos;
import mausoleum.result.MResult;
import mausoleum.room.Room;
import mausoleum.search.profisearch.searcher.MausoSearcherObject;
import mausoleum.strain.Strain;
import mausoleum.strain.StrainManager;
import mausoleum.task.standards.StandardTask;
import mausoleum.ui.UIDef;
import mausoleum.util.Standards;
import mausoleum.visit.Visit;

public class Mouse
extends IDObject {
    public static final long serialVersionUID = -9083185963290878852L;
    public static final int NOSEX = 0;
    public static final int MALE = 1;
    public static final int FEMALE = 2;
    public static final int NORMAL_SEXES = 3;
    public static final int VASECTOMIZED = 64;
    public static final int STERILE = 128;
    public static final int SEX_VARIANTS = 192;
    public static final long NO_OTHER_PARENT = -3L;
    public static final String MOS_PREFIX = "MOS_";
    public static final String BIRTHDAY = "MOS_BIRTHDAY";
    public static final String STARTMODE = "MOS_STARTMODE";
    public static final String ENDMODE = "MOS_ENDMODE";
    public static final String OWNERS = "MOS_OWNER";
    public static final String OWNER_GROUPS = "MOS_OWNERGROUPS";
    public static final String VISITS = "MOS_VISIT";
    public static final String KIDS = "MOS_KID";
    public static final String KID_BIRTHDAYS = "MOS_KID_BD";
    public static final String KID_SEXES = "MOS_KID_SX";
    public static final String KID_OTHER_PARENT = "MOS_KID_OP";
    public static final String STRAINS = "MOS_STRAIN";
    public static final String LINEID = "MOS_LINEID";
    public static final String COMMENT = "MOS_COMMENT";
    public static final String ACTCAGES = "MOS_ACTCAGE";
    public static final String EARTAG = "MOS_EARTAG";
    public static final String SEX = "MOS_SEX";
    public static final String FATHER = "MOS_FATHER";
    public static final String MOTHER = "MOS_MOTHER";
    public static final String LOCUSGENOTYPES = "MOS_LOCUSGENOTYPES";
    public static final String FLAG = "MOS_FLAG";
    public static final String PLUG_DATE = "MOS_PLUGDATE";
    public static final String PLUG_ALERT = "MOS_PLUGALERT";
    public static final String ALL_PLUG_DATES = "MOS_ALLPLUGDATES";
    public static final String OLDTASKS = "MOS_TASKS";
    public static final String TASKS_EXT = "MOS_TASKSEXT";
    public static final String AN_TAG = "MOS_ANTAG";
    public static final String MAT_LIMIT = "MOS_MATLIM";
    public static final String LICENSEID = "MOS_LICID";
    public static final String LICENSEID2 = "MOS_LICID2";
    public static final String LINE_LICENSEID = "MOS_LINLICID";
    public static final String GEN_FATHER = "MOS_GENFA";
    public static final String GEN_MOTHER = "MOS_GENMO";
    public static final String GEN_MANUAL = "MOS_GENMAN";
    public static final String COHORTS = "MOS_COHORTS";
    public static final String ABGESETZT = "MOS_ABGES";
    public static final String ABGESETZT_MANUAL = "MOS_ABGESMAN";
    public static final String ROOM = "MOS_ROOM";
    public static final String COAT_COLOR = "MOS_COAT_COLOR";
    public static final String TISSUE_SAMPLES = "MOS_TISSUE";
    public static final String MRESULTS = "MOS_MRESULTS";
    public static final String PREGNANT_DATE = "MOS_PREGNANT";
    public static final String CAME_FROM = "MOS_CAME";
    public static final String WENT_TO = "MOS_WENT";
    public static final String EARTAG_PREFIX = "MOS_ETPF";
    public static final String SPECIAL_DATE = "MOS_SPDAT";
    public static final String STRESS_LEVELS = "MOS_STRLEV";
    public static final String FOSTER_ID = "MOS_FOSTID";
    public static final String WAS_FOSTER = "MOS_WFOST";
    public static final String SHIPMENT_ID = "MOS_SHIPID";
    public static final String[] ATTRIBUTES_MOUSE;
    public static final String[] ORDERED_ATTRIBUTES;
    public static final int POS_LINE;
    public static final int POS_GT;
    private static final HashSet EXPORT_ATTRIBUTES;
    private static final HashSet EXPORT_ATTRIBUTES_IN_INSTITUTE;
    public static final String TO_OR_FROM_ADDRESS_LIST = "EA:";
    public static final String TO_OR_FROM_MAUSO_GROUP_NAME = "MGN:";
    public static final String TO_OR_FROM_MAUSO_GROUP_FULL = "MGI:";
    public static final String[] LICENSE_TAGS;
    public static final int GENERATION_STOP_SIGNAL = -1;
    public static final int GENERATION_CLEAR_MANUAL_ENTRY = -2;
    public static final int GENERATION_F0 = -42;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;
    static /* synthetic */ Class class$13;
    static /* synthetic */ Class class$14;

    static {
        String[] stringArray = new String[98];
        stringArray[0] = BIRTHDAY;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.util.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[1] = clazz.getName();
        stringArray[2] = STARTMODE;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[3] = clazz2.getName();
        stringArray[4] = ENDMODE;
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[5] = clazz3.getName();
        stringArray[6] = OWNERS;
        Class<?> clazz4 = class$2;
        if (clazz4 == null) {
            try {
                clazz4 = class$2 = Class.forName("[J");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[7] = clazz4.getName();
        stringArray[8] = OWNER_GROUPS;
        Class<?> clazz5 = class$2;
        if (clazz5 == null) {
            try {
                clazz5 = class$2 = Class.forName("[J");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[9] = clazz5.getName();
        stringArray[10] = VISITS;
        Class<?> clazz6 = class$3;
        if (clazz6 == null) {
            try {
                clazz6 = class$3 = Class.forName("[Lmausoleum.visit.Visit;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[11] = clazz6.getName();
        stringArray[12] = KIDS;
        Class<?> clazz7 = class$2;
        if (clazz7 == null) {
            try {
                clazz7 = class$2 = Class.forName("[J");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[13] = clazz7.getName();
        stringArray[14] = STRAINS;
        Class<?> clazz8 = class$4;
        if (clazz8 == null) {
            try {
                clazz8 = class$4 = Class.forName("[Lde.hannse.netobjects.objectstore.IndexObject;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[15] = clazz8.getName();
        stringArray[16] = LINEID;
        Class<?> clazz9 = class$5;
        if (clazz9 == null) {
            try {
                clazz9 = class$5 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[17] = clazz9.getName();
        stringArray[18] = LICENSEID;
        Class<?> clazz10 = class$5;
        if (clazz10 == null) {
            try {
                clazz10 = class$5 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[19] = clazz10.getName();
        stringArray[20] = LICENSEID2;
        Class<?> clazz11 = class$5;
        if (clazz11 == null) {
            try {
                clazz11 = class$5 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[21] = clazz11.getName();
        stringArray[22] = LINE_LICENSEID;
        Class<?> clazz12 = class$5;
        if (clazz12 == null) {
            try {
                clazz12 = class$5 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[23] = clazz12.getName();
        stringArray[24] = COMMENT;
        Class<?> clazz13 = class$6;
        if (clazz13 == null) {
            try {
                clazz13 = class$6 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[25] = clazz13.getName();
        stringArray[26] = ACTCAGES;
        Class<?> clazz14 = class$5;
        if (clazz14 == null) {
            try {
                clazz14 = class$5 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[27] = clazz14.getName();
        stringArray[28] = EARTAG;
        Class<?> clazz15 = class$1;
        if (clazz15 == null) {
            try {
                clazz15 = class$1 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[29] = clazz15.getName();
        stringArray[30] = SEX;
        Class<?> clazz16 = class$1;
        if (clazz16 == null) {
            try {
                clazz16 = class$1 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[31] = clazz16.getName();
        stringArray[32] = FATHER;
        Class<?> clazz17 = class$5;
        if (clazz17 == null) {
            try {
                clazz17 = class$5 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[33] = clazz17.getName();
        stringArray[34] = MOTHER;
        Class<?> clazz18 = class$5;
        if (clazz18 == null) {
            try {
                clazz18 = class$5 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[35] = clazz18.getName();
        stringArray[36] = LOCUSGENOTYPES;
        Class<?> clazz19 = class$7;
        if (clazz19 == null) {
            try {
                clazz19 = class$7 = Class.forName("[Lmausoleum.locus.LocusAndAlleles;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[37] = clazz19.getName();
        stringArray[38] = FLAG;
        Class<?> clazz20 = class$8;
        if (clazz20 == null) {
            try {
                clazz20 = class$8 = Class.forName("java.lang.Character");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[39] = clazz20.getName();
        stringArray[40] = PLUG_DATE;
        Class<?> clazz21 = class$0;
        if (clazz21 == null) {
            try {
                clazz21 = class$0 = Class.forName("java.util.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[41] = clazz21.getName();
        stringArray[42] = ALL_PLUG_DATES;
        Class<?> clazz22 = class$9;
        if (clazz22 == null) {
            try {
                clazz22 = class$9 = Class.forName("[I");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[43] = clazz22.getName();
        stringArray[44] = PLUG_ALERT;
        Class<?> clazz23 = class$1;
        if (clazz23 == null) {
            try {
                clazz23 = class$1 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[45] = clazz23.getName();
        stringArray[46] = TASKS_EXT;
        Class<?> clazz24 = class$10;
        if (clazz24 == null) {
            try {
                clazz24 = class$10 = Class.forName("[Lmausoleum.mouse.TaskExtended;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[47] = clazz24.getName();
        stringArray[48] = AN_TAG;
        Class<?> clazz25 = class$6;
        if (clazz25 == null) {
            try {
                clazz25 = class$6 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[49] = clazz25.getName();
        stringArray[50] = MAT_LIMIT;
        Class<?> clazz26 = class$1;
        if (clazz26 == null) {
            try {
                clazz26 = class$1 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[51] = clazz26.getName();
        stringArray[52] = GEN_FATHER;
        Class<?> clazz27 = class$1;
        if (clazz27 == null) {
            try {
                clazz27 = class$1 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[53] = clazz27.getName();
        stringArray[54] = GEN_MOTHER;
        Class<?> clazz28 = class$1;
        if (clazz28 == null) {
            try {
                clazz28 = class$1 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[55] = clazz28.getName();
        stringArray[56] = GEN_MANUAL;
        Class<?> clazz29 = class$1;
        if (clazz29 == null) {
            try {
                clazz29 = class$1 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[57] = clazz29.getName();
        stringArray[58] = ABGESETZT;
        Class<?> clazz30 = class$11;
        if (clazz30 == null) {
            try {
                clazz30 = class$11 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[59] = clazz30.getName();
        stringArray[60] = ABGESETZT_MANUAL;
        Class<?> clazz31 = class$11;
        if (clazz31 == null) {
            try {
                clazz31 = class$11 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[61] = clazz31.getName();
        stringArray[62] = ROOM;
        Class<?> clazz32 = class$5;
        if (clazz32 == null) {
            try {
                clazz32 = class$5 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[63] = clazz32.getName();
        stringArray[64] = COHORTS;
        Class<?> clazz33 = class$2;
        if (clazz33 == null) {
            try {
                clazz33 = class$2 = Class.forName("[J");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[65] = clazz33.getName();
        stringArray[66] = KID_BIRTHDAYS;
        Class<?> clazz34 = class$9;
        if (clazz34 == null) {
            try {
                clazz34 = class$9 = Class.forName("[I");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[67] = clazz34.getName();
        stringArray[68] = KID_SEXES;
        Class<?> clazz35 = class$9;
        if (clazz35 == null) {
            try {
                clazz35 = class$9 = Class.forName("[I");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[69] = clazz35.getName();
        stringArray[70] = KID_OTHER_PARENT;
        Class<?> clazz36 = class$2;
        if (clazz36 == null) {
            try {
                clazz36 = class$2 = Class.forName("[J");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[71] = clazz36.getName();
        stringArray[72] = COAT_COLOR;
        Class<?> clazz37 = class$1;
        if (clazz37 == null) {
            try {
                clazz37 = class$1 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[73] = clazz37.getName();
        stringArray[74] = TISSUE_SAMPLES;
        Class<?> clazz38 = class$6;
        if (clazz38 == null) {
            try {
                clazz38 = class$6 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[75] = clazz38.getName();
        stringArray[76] = MRESULTS;
        Class<?> clazz39 = class$12;
        if (clazz39 == null) {
            try {
                clazz39 = class$12 = Class.forName("java.util.Vector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[77] = clazz39.getName();
        stringArray[78] = PREGNANT_DATE;
        Class<?> clazz40 = class$1;
        if (clazz40 == null) {
            try {
                clazz40 = class$1 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[79] = clazz40.getName();
        stringArray[80] = CAME_FROM;
        Class<?> clazz41 = class$6;
        if (clazz41 == null) {
            try {
                clazz41 = class$6 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[81] = clazz41.getName();
        stringArray[82] = WENT_TO;
        Class<?> clazz42 = class$6;
        if (clazz42 == null) {
            try {
                clazz42 = class$6 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[83] = clazz42.getName();
        stringArray[84] = EARTAG_PREFIX;
        Class<?> clazz43 = class$6;
        if (clazz43 == null) {
            try {
                clazz43 = class$6 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[85] = clazz43.getName();
        stringArray[86] = SPECIAL_DATE;
        Class<?> clazz44 = class$1;
        if (clazz44 == null) {
            try {
                clazz44 = class$1 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[87] = clazz44.getName();
        stringArray[88] = STRESS_LEVELS;
        Class<?> clazz45 = class$9;
        if (clazz45 == null) {
            try {
                clazz45 = class$9 = Class.forName("[I");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[89] = clazz45.getName();
        stringArray[90] = FOSTER_ID;
        Class<?> clazz46 = class$5;
        if (clazz46 == null) {
            try {
                clazz46 = class$5 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[91] = clazz46.getName();
        stringArray[92] = WAS_FOSTER;
        Class<?> clazz47 = class$11;
        if (clazz47 == null) {
            try {
                clazz47 = class$11 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[93] = clazz47.getName();
        stringArray[94] = SHIPMENT_ID;
        Class<?> clazz48 = class$6;
        if (clazz48 == null) {
            try {
                clazz48 = class$6 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[95] = clazz48.getName();
        stringArray[96] = OLDTASKS;
        Class<?> clazz49 = class$13;
        if (clazz49 == null) {
            try {
                clazz49 = class$13 = Class.forName("[Lmausoleum.mouse.Task;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[97] = clazz49.getName();
        ATTRIBUTES_MOUSE = stringArray;
        ORDERED_ATTRIBUTES = new String[]{"IDO_ID", "IDO_START_DATE", "IDO_END_DATE", "IDO_VERSION", "IDO_UNIQUELONG", "IDO_VISIBLE", "IDO_NEVER_EXISTED", "IDO_OGROUP", "IDO_FKEY", "IDO_DOK", "IDO_SERVID", "IDO_UGROUPS", "IDO_UGROUPIDS", "IDO_SUBTYP", BIRTHDAY, STARTMODE, ENDMODE, OWNERS, OWNER_GROUPS, VISITS, KIDS, STRAINS, LINEID, LICENSEID, COMMENT, ACTCAGES, EARTAG, SEX, FATHER, MOTHER, LOCUSGENOTYPES, FLAG, PLUG_DATE, ALL_PLUG_DATES, PLUG_ALERT, TASKS_EXT, AN_TAG, MAT_LIMIT, GEN_FATHER, GEN_MOTHER, GEN_MANUAL, ABGESETZT, ABGESETZT_MANUAL, ROOM, COHORTS, KID_BIRTHDAYS, KID_SEXES, KID_OTHER_PARENT, COAT_COLOR, TISSUE_SAMPLES, MRESULTS, PREGNANT_DATE, OLDTASKS, LICENSEID2, CAME_FROM, WENT_TO, EARTAG_PREFIX, SPECIAL_DATE, STRESS_LEVELS, LINE_LICENSEID, FOSTER_ID, WAS_FOSTER, SHIPMENT_ID};
        POS_LINE = ArrayHelper.findStringInArray(LINEID, ORDERED_ATTRIBUTES);
        POS_GT = ArrayHelper.findStringInArray(LOCUSGENOTYPES, ORDERED_ATTRIBUTES);
        EXPORT_ATTRIBUTES = ArrayHelper.createHashSet(new String[]{"IDO_FKEY", BIRTHDAY, STARTMODE, ENDMODE, STRAINS, LINEID, COMMENT, EARTAG, SEX, LOCUSGENOTYPES, FLAG, PLUG_DATE, PREGNANT_DATE, PLUG_ALERT, ALL_PLUG_DATES, AN_TAG, MAT_LIMIT, GEN_FATHER, GEN_MOTHER, GEN_MANUAL, COAT_COLOR, CAME_FROM, EARTAG_PREFIX, SPECIAL_DATE});
        EXPORT_ATTRIBUTES_IN_INSTITUTE = ArrayHelper.createHashSet(new String[]{"IDO_FKEY", BIRTHDAY, STARTMODE, ENDMODE, STRAINS, LINEID, COMMENT, EARTAG, SEX, LOCUSGENOTYPES, FLAG, PLUG_DATE, PREGNANT_DATE, PLUG_ALERT, ALL_PLUG_DATES, AN_TAG, MAT_LIMIT, GEN_FATHER, GEN_MOTHER, GEN_MANUAL, COAT_COLOR, CAME_FROM, EARTAG_PREFIX, TASKS_EXT, SPECIAL_DATE});
        LICENSE_TAGS = new String[]{LICENSEID, LICENSEID2, LINE_LICENSEID};
    }

    public static Vector getLastVisits(Vector mice) {
        Vector<Visit> erg = new Vector<Visit>();
        if (mice != null) {
            Iterator iter = mice.iterator();
            while (iter.hasNext()) {
                Mouse mouse = (Mouse)iter.next();
                Visit[] visits = (Visit[])mouse.get(VISITS);
                if (visits == null) continue;
                erg.addElement(visits[visits.length - 1]);
            }
        }
        return erg;
    }

    public static boolean areMiceTouchable(Vector mice) {
        if (mice == null || mice.isEmpty() || !(mice.elementAt(0) instanceof Mouse)) {
            return false;
        }
        Iterator iter = mice.iterator();
        while (iter.hasNext()) {
            Room room;
            Mouse mouse = (Mouse)iter.next();
            if (UserRoomRestriction.isObjectRestricted(mouse) || mouse.isDead() || !mouse.itsMine(null) && !UserManager.cvTouchForeignMice) {
                return false;
            }
            if (!MausoleumClient.isServiceCaretaker() || (room = mouse.getRoom()) != null && MausoleumClient.cvServiceCTRoomID != null && MausoleumClient.cvServiceCTRoomID.equals(room.getServiceRoomID())) continue;
            return false;
        }
        return true;
    }

    public static boolean areMiceTouchableInclDeads(Vector mice) {
        if (mice == null || mice.isEmpty() || !(mice.elementAt(0) instanceof Mouse)) {
            return false;
        }
        Iterator iter = mice.iterator();
        while (iter.hasNext()) {
            Mouse mouse = (Mouse)iter.next();
            if (!UserRoomRestriction.isObjectRestricted(mouse) && (mouse.itsMine(null) || UserManager.cvTouchForeignMice)) continue;
            return false;
        }
        return true;
    }

    public static boolean areMiceRoomAccesibilityRestricted(Vector mice) {
        if (MausoleumClient.isRegularOrTGService() && mice != null && !mice.isEmpty() && mice.elementAt(0) instanceof Mouse) {
            Iterator iter = mice.iterator();
            while (iter.hasNext()) {
                Mouse mouse = (Mouse)iter.next();
                if (!mouse.isRoomAccesibilityRestricted()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isParentSettable(Vector selectedObjects, boolean father) {
        String commonGroup;
        if (Privileges.hasPrivilege("MOS_SET_PARENTS") && (commonGroup = IDObject.commonGroup(selectedObjects)) != null) {
            Iterator iterator = selectedObjects.iterator();
            while (iterator.hasNext()) {
                Mouse mouse = (Mouse)iterator.next();
                if (!mouse.isVisible() || mouse.get(father ? FATHER : MOTHER) != null) continue;
                return true;
            }
        }
        return false;
    }

    public static void separateMiceBySex(Vector mice, Vector males, Vector females) {
        males.clear();
        females.clear();
        Iterator iterator = mice.iterator();
        while (iterator.hasNext()) {
            Mouse mouse = (Mouse)iterator.next();
            int sex = mouse.getSex();
            if (sex == 1) {
                males.add(mouse);
                continue;
            }
            if (sex != 2) continue;
            females.add(mouse);
        }
    }

    public static MyDate getBirthDayMinimumDate(Vector mice) {
        MyDate minimum = null;
        if (mice != null && !mice.isEmpty()) {
            long minMillis = -1L;
            int i = 0;
            while (i < mice.size()) {
                Mouse maus = (Mouse)mice.elementAt(i);
                Date d = maus.getDate(BIRTHDAY);
                if (d != null && d.getTime() > minMillis) {
                    minMillis = d.getTime();
                }
                ++i;
            }
            if (minMillis > 0L) {
                minimum = MyDate.getMyDate(minMillis);
            }
        }
        return minimum;
    }

    public static boolean isGenotypeComplete(Mouse mouse, long singleCheckLocusID) {
        Line line = mouse.getLine();
        if (line == null || line.isBreeder()) {
            return true;
        }
        LocusAndAlleles[] lalarr = (LocusAndAlleles[])mouse.get(LOCUSGENOTYPES);
        if (lalarr != null) {
            int i = 0;
            while (i < lalarr.length) {
                if (singleCheckLocusID == -1L || lalarr[i].ivLocusID == singleCheckLocusID) {
                    if (lalarr[i].ivAllele == null) {
                        return false;
                    }
                    int j = 0;
                    while (j < lalarr[i].ivAllele.length) {
                        if (lalarr[i].ivAllele[j] == null || lalarr[i].ivAllele[j].trim().length() == 0) {
                            return false;
                        }
                        ++j;
                    }
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static String getLicenseTag(int lizenzNummer) {
        switch (lizenzNummer) {
            case 1: {
                return LICENSEID;
            }
            case 2: {
                return LICENSEID2;
            }
        }
        return null;
    }

    public long getLicenseID(int lizenzNummer, long defVal) {
        return this.getLong(Mouse.getLicenseTag(lizenzNummer), defVal);
    }

    public Long getLongLicenseID(int lizenzNummer) {
        return (Long)this.get(Mouse.getLicenseTag(lizenzNummer));
    }

    public int getMouseLifeStressLevel() {
        return this.getStressLevel(0);
    }

    public int getMouseDeathStressLevel() {
        return this.getStressLevel(1);
    }

    public int getStoredMouseLineStressLevel() {
        return this.getStressLevel(2);
    }

    public int getStressLevel(int arrPos) {
        int[] stressArr = (int[])this.get(STRESS_LEVELS);
        return stressArr == null ? 0 : stressArr[arrPos];
    }

    public int getMaxStoredStressLevel() {
        int res = 0;
        int[] stressArr = (int[])this.get(STRESS_LEVELS);
        if (stressArr != null) {
            int i = 0;
            while (i < stressArr.length) {
                if (stressArr[i] > res) {
                    res = stressArr[i];
                }
                ++i;
            }
        }
        return res;
    }

    public int getAktLineStressLevel() {
        return StressRule.getStress(this.getLine(), this);
    }

    public boolean isTouchable() {
        if (this.isDead() || UserRoomRestriction.isObjectRestricted(this)) {
            return false;
        }
        if (UserManager.cvTouchForeignMice) {
            return true;
        }
        return this.itsMine(null);
    }

    public boolean isTouchable(User user) {
        if (this.isDead()) {
            return false;
        }
        if (Privileges.hasPrivilege(user, "TOUCH_FOREIGN_MICE")) {
            return true;
        }
        return this.itsMine(user);
    }

    public boolean isRoomAccesibilityRestricted() {
        Room room;
        if (MausoleumClient.isRegularOrTGService() && (room = this.getRoom()) != null) {
            return !room.isAccessibleForGroups();
        }
        return false;
    }

    public static String translateSex(int sex) {
        switch (sex) {
            case 0: {
                return Babel.get("NOTSET");
            }
            case 1: {
                return Babel.get("MALE");
            }
            case 2: {
                return Babel.get("FEMALE");
            }
        }
        return Babel.get("UNKNOWN");
    }

    public String getTaskKey() {
        return TASKS_EXT;
    }

    public String getBrowseName() {
        return this.getCLLWEartagString("[without Eartag]", true, true);
    }

    public void addBrowserLines(Vector target, String group, HashSet wantedObjectTypes) {
        int matlim;
        int[] iarr;
        Integer pregdate;
        Date pd;
        IndexObject[] ioarr;
        LocusAndAlleles[] lalarr;
        IDObject ido;
        Visit[] varr;
        long[] arr2;
        long l;
        IDObject ido2;
        long[] arr;
        Date bd;
        String s;
        super.addBrowserLines(target, group, wantedObjectTypes);
        target.add("Sex = " + Mouse.translateSex(this.getInt(SEX, 0)));
        char c = this.getChar(FLAG);
        if (c == '\u0001') {
            target.add("Mark = \u261e");
        } else if (c != '\u0000') {
            char[] ica = new char[]{c};
            target.add("Mark = " + new String(ica));
        }
        int i = this.getInt(EARTAG, 0);
        if (i != 0) {
            target.add("Eartag = " + i);
        }
        if ((s = this.getString(AN_TAG, null)) != null) {
            target.add("Tag = " + s);
        }
        if ((bd = this.getDate(BIRTHDAY)) != null) {
            target.add("Birthday = " + DatumFormat.getJustDateString(bd.getTime()));
        }
        if ((i = this.getInt(STARTMODE, 0)) != 0) {
            target.add("Startmode = " + Visit.translateMode(i));
        }
        if ((i = this.getInt(ENDMODE, 0)) != 0) {
            target.add("Endmode = " + Visit.translateMode(i));
        }
        if ((wantedObjectTypes == null || wantedObjectTypes.contains(new Integer(6))) && (arr = (long[])this.get(OWNERS)) != null) {
            int j = 0;
            while (j < arr.length) {
                if (j == 0) {
                    ido2 = ObjectStore.getObjectDeadOrAlive(6, arr[j], group, null, false);
                    target.add("Primary owner: " + ido2.getBrowseName() + "\t" + "object|" + group + "|" + 6 + "|" + arr[j]);
                } else {
                    ido2 = ObjectStore.getObjectDeadOrAlive(6, arr[j], group, null, false);
                    target.add("Owner: " + ido2.getBrowseName() + "\t" + "object|" + group + "|" + 6 + "|" + arr[j]);
                }
                ++j;
            }
        }
        if ((l = this.getLong(MOTHER, 0L)) != 0L) {
            ido2 = ObjectStore.getObjectDeadOrAlive(1, l, group, null, false);
            target.add("Mother: " + ido2.getBrowseName() + "\t" + "object|" + group + "|" + 1 + "|" + l);
        }
        if ((l = this.getLong(FATHER, 0L)) != 0L) {
            ido2 = ObjectStore.getObjectDeadOrAlive(1, l, group, null, false);
            target.add("Father: " + ido2.getBrowseName() + "\t" + "object|" + group + "|" + 1 + "|" + l);
        }
        if ((arr2 = (long[])this.get(KIDS)) != null) {
            int j = 0;
            while (j < arr2.length) {
                IDObject ido3 = ObjectStore.getObjectDeadOrAlive(1, arr2[j], group, null, false);
                target.add("Kid: " + ido3.getBrowseName() + "\t" + "object|" + group + "|" + 1 + "|" + arr2[j]);
                ++j;
            }
        }
        if ((wantedObjectTypes == null || wantedObjectTypes.contains(new Integer(2))) && (varr = (Visit[])this.get(VISITS)) != null) {
            int ii = 0;
            while (ii < varr.length) {
                Visit vis = varr[ii];
                if (vis.ivEndDate == null) {
                    ido = ObjectStore.getObjectDeadOrAlive(2, vis.ivCageID, group, null, false);
                    target.add("Act. visit in cage: " + ido.getBrowseName() + "\t" + "object|" + group + "|" + 2 + "|" + vis.ivCageID);
                } else {
                    ido = ObjectStore.getObjectDeadOrAlive(2, vis.ivCageID, group, null, false);
                    target.add("Old visit in cage: " + ido.getBrowseName() + "\t" + "object|" + group + "|" + 2 + "|" + vis.ivCageID);
                }
                ++ii;
            }
        }
        if ((wantedObjectTypes == null || wantedObjectTypes.contains(new Integer(7))) && (l = this.getLong(LINEID, 0L)) != 0L) {
            IDObject ido4 = ObjectStore.getObjectDeadOrAlive(7, l, group, null, false);
            target.add("Line: " + ido4.getBrowseName() + "\t" + "object|" + group + "|" + 7 + "|" + l);
        }
        if ((wantedObjectTypes == null || wantedObjectTypes.contains(new Integer(14))) && (lalarr = (LocusAndAlleles[])this.get(LOCUSGENOTYPES)) != null) {
            int lali = 0;
            while (lali < lalarr.length) {
                if (lalarr[lali].ivAllele != null) {
                    int j = 0;
                    while (j < lalarr[lali].ivAllele.length) {
                        ido = ObjectStore.getObjectDeadOrAlive(14, lalarr[lali].ivLocusID, group, null, false);
                        target.add("Allel: \"" + lalarr[lali].ivAllele[j] + "\" from Locus: " + ido.getBrowseName() + "\t" + "object|" + group + "|" + 14 + "|" + lalarr[lali].ivLocusID);
                        ++j;
                    }
                }
                ++lali;
            }
        }
        if ((wantedObjectTypes == null || wantedObjectTypes.contains(new Integer(8))) && (ioarr = (IndexObject[])this.get(STRAINS)) != null) {
            int j = 0;
            while (j < ioarr.length) {
                IndexObject indob = ioarr[j];
                ido = ObjectStore.getObjectDeadOrAlive(8, indob.ivObjectID, group, null, false);
                target.add("Strain (" + StringHelper.PERC_FORMATTER.format(indob.ivNumber) + "): " + ido.getBrowseName() + "\t" + "object|" + group + "|" + 8 + "|" + indob.ivObjectID);
                ++j;
            }
        }
        if ((pd = this.getDate(PLUG_DATE)) != null) {
            target.add("Plugdate = " + DatumFormat.getJustDateString(pd.getTime()));
        }
        if ((i = this.getInt(PLUG_ALERT, 0)) != 0) {
            target.add("Plug alert = " + i + " days");
        }
        if ((pregdate = (Integer)this.get(PREGNANT_DATE)) != null) {
            target.add("Pregnant date = " + DatumFormat.getJustDateString(pregdate));
        }
        if ((iarr = (int[])this.get(ALL_PLUG_DATES)) != null) {
            int j = 0;
            while (j < iarr.length) {
                target.add("Collected plugdate = " + DatumFormat.getJustDateString(iarr[i]));
                ++j;
            }
        }
        if ((matlim = this.getInt(MAT_LIMIT, 0)) != 0) {
            target.add("Maturity limit [days] = " + matlim);
        }
        if ((s = this.getString(COMMENT, null)) != null && s.trim().length() != 0) {
            target.add("Comment\t\t" + Base64Manager.encodeBase64(s));
        }
    }

    public String getBarcodeString() {
        return "M" + this.getID();
    }

    public String getExportString(boolean isInInstitute) {
        TaskExtended[] oarr = null;
        if (isInInstitute && (oarr = (TaskExtended[])this.get(TASKS_EXT)) != null) {
            TaskExtended[] narr = new TaskExtended[oarr.length];
            int i = 0;
            while (i < narr.length) {
                if (StandardTask.isGroupTask(oarr[i].ivProcType)) {
                    String name = StandardTask.getDescription(this.getGroup(), oarr[i].ivProcType, "?", false, null);
                    narr[i] = new TaskExtended(oarr[i]);
                    narr[i].ivProcType = -1;
                    narr[i].ivDescription = name;
                } else {
                    narr[i] = oarr[i];
                }
                ++i;
            }
            this.set(TASKS_EXT, narr);
            this.commit(false);
        }
        String res = IDObjectXMLHandler.getExportXML(this, isInInstitute ? EXPORT_ATTRIBUTES_IN_INSTITUTE : EXPORT_ATTRIBUTES);
        if (isInInstitute && oarr != null) {
            this.set(TASKS_EXT, oarr);
            this.commit(false);
        }
        return res;
    }

    public Color getLineColor() {
        Line ll = this.getLine();
        return ll != null ? (Color)ll.get("LIN_COLOR") : null;
    }

    public boolean itsMine(User user) {
        return user == null ? UserManager.cvIsCareTaker || this.itsMineInner(UserManager.getUser()) : UserManager.isACareTaker(user) || this.itsMineInner(user);
    }

    private boolean itsMineInner(User user) {
        long[] owners = (long[])this.get(OWNERS);
        long[] ownerGroups = (long[])this.get(OWNER_GROUPS);
        if (owners == null && ownerGroups == null) {
            return true;
        }
        if (UserManager.isRealUser()) {
            long userID = user.getID();
            if (owners != null) {
                int i = 0;
                while (i < owners.length) {
                    if (owners[i] == userID) {
                        return true;
                    }
                    ++i;
                }
            }
            long[] userOwnerGroups = (long[])user.get("USR_OWNER_GROUPS");
            if (ownerGroups != null && userOwnerGroups != null) {
                int i = 0;
                while (i < ownerGroups.length) {
                    int j = 0;
                    while (j < userOwnerGroups.length) {
                        if (ownerGroups[i] == userOwnerGroups[j]) {
                            return true;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        return false;
    }

    public boolean ofStrain(long strainID) {
        IndexObject[] strains = (IndexObject[])this.get(STRAINS);
        if (strains != null) {
            int i = 0;
            while (i < strains.length) {
                if (strains[i].ivObjectID == strainID) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean ofStrains(HashSet strainIDs) {
        IndexObject[] strains = (IndexObject[])this.get(STRAINS);
        if (strains != null) {
            int i = 0;
            while (i < strains.length) {
                if (strainIDs.contains(new Long(strains[i].ivObjectID))) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean ofLine(long lineID) {
        return this.getLong(LINEID, 0L) == lineID;
    }

    public boolean hasLocus(long locusID) {
        LocusAndAlleles[] lal;
        if (locusID > 0L && (lal = (LocusAndAlleles[])this.get(LOCUSGENOTYPES)) != null) {
            int i = 0;
            while (i < lal.length) {
                if (lal[i].ivLocusID == locusID) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean hasLocus(HashSet locusIDs) {
        LocusAndAlleles[] lal;
        if (locusIDs != null && (lal = (LocusAndAlleles[])this.get(LOCUSGENOTYPES)) != null) {
            int i = 0;
            while (i < lal.length) {
                if (locusIDs.contains(new Long(lal[i].ivLocusID))) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean hasAllel(long locusID, String allel) {
        LocusAndAlleles[] lal;
        if (locusID > 0L && allel != null && (lal = (LocusAndAlleles[])this.get(LOCUSGENOTYPES)) != null) {
            int i = 0;
            while (i < lal.length) {
                if (lal[i].ivLocusID == locusID && lal[i].ivAllele != null) {
                    int ai = 0;
                    while (ai < lal[i].ivAllele.length) {
                        if (lal[i].ivAllele[ai].equals(allel)) {
                            return true;
                        }
                        ++ai;
                    }
                }
                ++i;
            }
        }
        return false;
    }

    public boolean isOwnedBy(HashSet userIDs, String tag) {
        long[] arr = (long[])this.get(tag);
        if (arr != null) {
            int j = 0;
            while (j < arr.length) {
                if (userIDs.contains(new Long(arr[j]))) {
                    return true;
                }
                ++j;
            }
        }
        return false;
    }

    public String getGenotype() {
        return this.getGenotype("?");
    }

    public String getGenotype(String nullVal) {
        Line line = this.getLine();
        if (line == null) {
            return nullVal;
        }
        if (line.isBreeder()) {
            return "wt";
        }
        LocusAndAlleles[] lalInMouse = (LocusAndAlleles[])this.get(LOCUSGENOTYPES);
        LocusAndAlleles[] lalInLine = (LocusAndAlleles[])line.get("LIN_LOCIALLELES");
        if (lalInLine == null) {
            return nullVal;
        }
        StringBuilder msb = new StringBuilder();
        int i = 0;
        while (i < lalInLine.length) {
            LocusAndAlleles found;
            if (i != 0) {
                msb.append(";");
            }
            if ((found = LocusAndAlleles.findElement(lalInLine[i], lalInMouse)) == null) {
                msb.append(new LocusAndAlleles(lalInLine[i].ivLocusID).toGenotypeString(this.getGroup()));
            } else {
                msb.append(found.toGenotypeString(this.getGroup()));
            }
            ++i;
        }
        return msb.toString();
    }

    public String[] getGenotypeStringArray() {
        String[] res = null;
        Line line = this.getLine();
        if (line != null && !line.isBreeder()) {
            LocusAndAlleles[] lalInMouse = (LocusAndAlleles[])this.get(LOCUSGENOTYPES);
            LocusAndAlleles[] lalInLine = (LocusAndAlleles[])line.get("LIN_LOCIALLELES");
            if (lalInLine != null) {
                String group = this.getGroup();
                res = new String[2 * lalInLine.length];
                int i = 0;
                while (i < lalInLine.length) {
                    LocusAndAlleles found = LocusAndAlleles.findElement(lalInLine[i], lalInMouse);
                    Locus locus = (Locus)ObjectStore.getObjectDeadOrAlive(14, lalInLine[i].ivLocusID, group, null, false);
                    if (locus != null) {
                        res[2 * i] = locus.getName();
                        res[2 * i + 1] = LocusAndAlleles.getAlleleString(locus, found == null ? null : found.ivAllele);
                    } else {
                        res[2 * i] = "?";
                        res[2 * i + 1] = LocusAndAlleles.getAlleleString(locus, found == null ? null : found.ivAllele);
                    }
                    ++i;
                }
            }
        }
        return res;
    }

    public Vector getMultiFontGenotype(Font[] farr, boolean gtPralineMode) {
        Vector<MFLabel> erg = new Vector<MFLabel>();
        Line line = this.getLine();
        if (line == null) {
            erg.addElement(new MFLabel("", farr[4]));
        } else if (line.isBreeder()) {
            if (gtPralineMode) {
                String strains = this.getCLLWStrainString();
                if (strains != null && strains.length() != 0) {
                    erg.addElement(new MFLabel(" wt [" + strains + "]", farr[2]));
                } else {
                    erg.addElement(new MFLabel(" wt ", farr[2]));
                }
            } else {
                erg.addElement(new MFLabel(" wt ", farr[2]));
            }
        } else {
            String group = this.getGroup();
            LocusAndAlleles[] lalInMouse = (LocusAndAlleles[])this.get(LOCUSGENOTYPES);
            LocusAndAlleles[] lalInLine = (LocusAndAlleles[])line.get("LIN_LOCIALLELES");
            if (lalInLine == null) {
                erg.addElement(new MFLabel("", farr[4]));
            } else {
                int i = 0;
                while (i < lalInLine.length) {
                    LocusAndAlleles found = LocusAndAlleles.findElement(lalInLine[i], lalInMouse);
                    erg.addElement(new MFLabel(String.valueOf(i != 0 ? " ; " : "") + LocusAndAlleles.getLocusName(group, lalInLine[i].ivLocusID) + " ", farr[1]));
                    if (found == null || found.ivAllele == null) {
                        erg.addElement(new MFLabel(LocusAndAlleles.NO_ALLEL, farr[3]));
                    } else {
                        erg.addElement(new MFLabel(found.getAlleleString(group), farr[2]));
                    }
                    ++i;
                }
            }
        }
        return erg;
    }

    public LongPunkt getSexualActiveDates() {
        long limit = this.getMaturityLimit();
        Date birthDate = this.getDate(BIRTHDAY);
        if (birthDate == null) {
            birthDate = this.getDate("IDO_START_DATE");
        }
        if (birthDate != null) {
            long start = birthDate.getTime() + limit;
            Date endDate = this.getDate("IDO_END_DATE");
            if (endDate != null) {
                return new LongPunkt(start, endDate.getTime());
            }
            return new LongPunkt(start, System.currentTimeMillis());
        }
        return null;
    }

    public static String getSexTag() {
        return SEX;
    }

    public int getSex() {
        return this.getSex(0);
    }

    public int getSex(int defVal) {
        return this.getInt(SEX, defVal) & 3;
    }

    public void setNormalSex(int sex) {
        int sexToSet = this.getInt(SEX, 0) & 0x80 | sex;
        this.set(SEX, sexToSet == 0 ? null : new Integer(sexToSet));
    }

    public int getSexVariant(int defVal) {
        return this.getInt(SEX, defVal) & 0xC0;
    }

    public void setSexVariant(int variant) {
        int sexToSet = this.getSex() + variant;
        this.set(SEX, sexToSet == 0 ? null : new Integer(sexToSet));
    }

    public void setVasectomized(boolean sterile) {
        int sexToSet = sterile ? this.getInt(SEX, 0) | 0x40 : this.getInt(SEX, 0) & 3;
        this.set(SEX, sexToSet == 0 ? null : new Integer(sexToSet));
    }

    public boolean isNonFertile() {
        return (this.getInt(SEX, 0) & 0xC0) != 0;
    }

    public static int getCommonSex(Vector idobjects, int nullValue, int errorValue) {
        int tmpValue = nullValue;
        if (idobjects != null && !idobjects.isEmpty()) {
            boolean first = true;
            Iterator iter = idobjects.iterator();
            while (iter.hasNext()) {
                Mouse ido = (Mouse)iter.next();
                if (first) {
                    tmpValue = ido.getSex(nullValue);
                    first = false;
                    continue;
                }
                if (tmpValue == ido.getSex(nullValue)) continue;
                return errorValue;
            }
        }
        return tmpValue;
    }

    public Vector getSexualActiveVisits(long nullVal) {
        Visit[] arr;
        Vector<Visit> erg = new Vector<Visit>();
        LongPunkt timespan = this.getSexualActiveDates();
        if (timespan != null && (arr = (Visit[])this.get(VISITS)) != null) {
            int i = 0;
            while (i < arr.length) {
                Visit nv = arr[i].createIntersectVisit(timespan, nullVal);
                if (nv != null) {
                    erg.add(nv);
                }
                ++i;
            }
        }
        return erg;
    }

    public long getActCageIDFromARR(long defVal) {
        Visit[] arr;
        if (this.isAliveAndVisible() && (arr = (Visit[])this.get(VISITS)) != null && arr.length != 0) {
            Visit vis = arr[arr.length - 1];
            if (vis.ivEndDate == null) {
                return vis.ivCageID;
            }
        }
        return defVal;
    }

    public String getGenealogyString(boolean isProxy) {
        StringBuffer sb = new StringBuffer();
        if (isProxy) {
            sb.append(Babel.get("COPYOF")).append(" ");
            sb.append(this.getCLLWEartagString("[?]", true, true));
        } else {
            String strstr;
            sb.append(this.getCLLWEartagString("[?]", true, true)).append("   ");
            String gt = this.getGenotype();
            if (gt.length() > 0 && !gt.equals("?")) {
                sb.append(gt).append("   ");
            }
            if ((strstr = this.getCLLWStrainString()).length() == 0) {
                sb.append("?");
            } else {
                sb.append(strstr);
            }
        }
        return sb.toString();
    }

    public boolean isBreeder() {
        Line line = this.getLine();
        return line != null ? line.isBreeder() : false;
    }

    public Cage getActCage() {
        long cid = this.getActCageID(-1L);
        if (cid != -1L) {
            Cage cage = (Cage)ObjectStore.getObjectDeadOrAlive(2, cid, this.getString("IDO_GROUP"), null, false);
            if (cage == null) {
                String string = "Cage not found for Mouse " + this + " cage ID " + cid;
                Class<?> clazz = class$14;
                if (clazz == null) {
                    try {
                        clazz = class$14 = Class.forName("mausoleum.mouse.Mouse");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.warn(string, clazz);
            }
            return cage;
        }
        return null;
    }

    public long getActCageID(long defVal) {
        if (this.get("IDO_END_DATE") != null) {
            return defVal;
        }
        return this.getActCageIDAlsoDead(defVal);
    }

    public long getActCageIDAlsoDead(long defVal) {
        long cid = defVal;
        Visit[] visits = (Visit[])this.get(VISITS);
        if (visits != null) {
            long start = 0L;
            int i = 0;
            while (i < visits.length) {
                long vmillis;
                if (visits[i].ivEndDate == null && visits[i].ivStartDate != null && (vmillis = visits[i].ivStartDate.getTime()) > start) {
                    start = vmillis;
                    cid = visits[i].ivCageID;
                }
                ++i;
            }
        }
        return cid;
    }

    public boolean isInMatingCage() {
        Cage cage = this.getActCage();
        return cage != null ? cage.isMatingCage() : false;
    }

    public boolean isSexActive() {
        return this.isSexActive(System.currentTimeMillis());
    }

    public boolean isSexActive(long millis) {
        long diff;
        Date bd;
        return this.isAlive(millis) && (bd = this.getDate(BIRTHDAY)) != null && (diff = millis - bd.getTime()) > this.getMaturityLimit();
    }

    public long getMaturityLimit() {
        int mld = this.getInt(MAT_LIMIT, -1);
        if (mld != -1) {
            return (long)mld * 86400000L;
        }
        if (ProcessDefinition.isClient()) {
            Integer lmld = LineManager.getMatlimit((Long)this.get(LINEID), this.getGroup());
            if (lmld != null) {
                return (long)lmld.intValue() * 86400000L;
            }
            mld = this.getStrainMatLim(-1);
            if (mld != -1) {
                return (long)mld * 86400000L;
            }
        } else if (ProcessDefinition.isServer()) {
            Line line = this.getLine();
            if (line != null && (mld = line.getInt("LIN_MATLIM", -1)) != -1) {
                return (long)mld * 86400000L;
            }
            int min = Integer.MAX_VALUE;
            IndexObject[] strains = (IndexObject[])this.get(STRAINS);
            if (strains != null) {
                int i = 0;
                while (i < strains.length) {
                    Strain strain = (Strain)ObjectStore.getObjectDeadOrAlive(8, strains[i].ivObjectID, this.getString("IDO_GROUP"), null, false);
                    if (strain != null && (mld = strain.getInt("STR_MATLIM", -1)) != -1 && mld < min) {
                        min = mld;
                    }
                    ++i;
                }
            }
            if (min != Integer.MAX_VALUE) {
                return (long)min * 86400000L;
            }
        }
        return (long)Standards.getMaturityLimitInDays() * 86400000L;
    }

    private int getStrainMatLim(int defVal) {
        String group = this.getGroup();
        int min = Integer.MAX_VALUE;
        IndexObject[] strains = (IndexObject[])this.get(STRAINS);
        if (strains != null) {
            int i = 0;
            while (i < strains.length) {
                Integer sml = StrainManager.getMatlimit(strains[i].ivObjectID, group);
                if (sml != null && sml < min) {
                    min = sml;
                }
                ++i;
            }
        }
        if (min != Integer.MAX_VALUE) {
            return min;
        }
        return defVal;
    }

    public boolean hasSex() {
        return this.getInt(SEX) != 0;
    }

    public boolean isPossMatingPartner() {
        return this.isAlive() && this.hasSex() && this.isSexActive();
    }

    public String getCageString() {
        Cage cage = this.getActCage();
        if (cage != null) {
            return cage.getNumberString();
        }
        return "";
    }

    public Rack getRack() {
        Cage cage = this.getActCage();
        return cage != null ? cage.getSuperCageIfThere().getRack() : null;
    }

    public Room getRoom() {
        Cage cage = this.getActCage();
        if (cage != null) {
            return cage.getSuperCageIfThere().getRoom();
        }
        if (this.get(ROOM) != null) {
            return (Room)ObjectStore.getObjectDeadOrAlive(10, this.getLong(ROOM, 0L), this.getString("IDO_GROUP"), null, false);
        }
        return null;
    }

    public boolean canSitInRoom() {
        return true;
    }

    public Long getServiceRoomID() {
        Room room;
        if (this.isAlive() && (room = this.getRoom()) != null) {
            return room.getServiceRoomID();
        }
        return null;
    }

    public String getRackName() {
        Cage cage = this.getActCage();
        return cage == null ? "" : cage.getRackName();
    }

    public String getRackPosName() {
        Cage cage = this.getActCage();
        return cage == null ? "" : cage.getRackPosName();
    }

    public String getRackAndPosName() {
        Cage cage = this.getActCage();
        return cage == null ? "" : cage.getRackAndPosName();
    }

    public RackPos getRackPos() {
        Cage cage = this.getActCage();
        return cage != null ? cage.getRackPos() : null;
    }

    public String getRoomName() {
        Room room = this.getRoom();
        return room == null ? "" : room.getName();
    }

    public String getCLLWSexString(String defVal) {
        int sex = this.getSex();
        if (sex != 0) {
            return DefaultManager.getSexString(sex, this.getSexVariant(0), false);
        }
        return defVal;
    }

    public String getCLLWEartagString() {
        return this.getCLLWEartagString("", false, true);
    }

    public String getCLLWEartagString(String defVal, boolean useAnTag, boolean mitLinienOderStammPrefix) {
        return this.getCLLWEartagString(this.getInt(EARTAG, 0), defVal, useAnTag, mitLinienOderStammPrefix);
    }

    public String getCLLWEartagString(String defVal, boolean useAnTag, boolean mitKreuz, boolean mitLinienOderStammPrefix) {
        return this.getCLLWEartagString(this.getInt(EARTAG, 0), defVal, useAnTag, this.getString(EARTAG_PREFIX, ""), mitKreuz, mitLinienOderStammPrefix);
    }

    public String getCLLWEartagString(int et, String defVal, boolean useAnTag, boolean mitLinienOderStammPrefix) {
        return this.getCLLWEartagString(et, defVal, useAnTag, this.getString(EARTAG_PREFIX, ""), true, mitLinienOderStammPrefix);
    }

    public String getCLLWEartagString(int et, String defVal, boolean useAnTag, String earTagPrefix, boolean mitKreuz, boolean mitLinienOderStammPrefix) {
        String tag = null;
        if (et != 0) {
            tag = Integer.toString(et);
        } else if (useAnTag) {
            tag = this.getString(AN_TAG, "").trim();
        } else {
            return defVal;
        }
        if (tag == null || tag.length() == 0) {
            return defVal;
        }
        StringBuilder msb = new StringBuilder(20);
        if (mitKreuz && !this.isAlive()) {
            msb.append("\u2020 ");
        }
        try {
            Vector strains;
            Line line;
            String prefix = null;
            if (mitLinienOderStammPrefix && (line = this.getLine()) != null) {
                prefix = line.getString("LIN_ETPREFIX", null);
            }
            if (mitLinienOderStammPrefix && prefix == null && (strains = this.getStrains()) != null && strains.size() == 1) {
                prefix = ((Strain)strains.firstElement()).getString("STR_ETPREFIX", null);
            }
            if (prefix != null) {
                msb.append(prefix);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        msb.append(earTagPrefix).append(tag);
        return msb.toString();
    }

    public long getPrimaryOwnerIDAlsoOwnerGroup(long defVal) {
        long[] ownerIDs;
        IDObjectGroup ownerGroup;
        long res = this.getPrimaryOwnerIDNoOwnerGroup(-1L);
        if (res != -1L) {
            return res;
        }
        long[] ownerGroupIDs = (long[])this.get(OWNER_GROUPS);
        if (ownerGroupIDs != null && ownerGroupIDs.length != 0 && (ownerGroup = (IDObjectGroup)IDObjectGroupManager.cvInstance.getObject(ownerGroupIDs[0], this.getGroup())) != null && (ownerIDs = (long[])ownerGroup.get("IOG_IDS")) != null && ownerIDs.length != 0) {
            return ownerIDs[0];
        }
        return defVal;
    }

    public long getPrimaryOwnerIDNoOwnerGroup(long defVal) {
        long[] owners = (long[])this.get(OWNERS);
        if (owners != null && owners.length != 0) {
            return owners[0];
        }
        return defVal;
    }

    public String getPrimaryOwnerName(String defVal, Color[] colret) {
        long[] ownerGroups;
        long[] owners;
        int anzges;
        if (colret != null) {
            colret[0] = null;
        }
        if ((anzges = ((owners = (long[])this.get(OWNERS)) != null ? owners.length : 0) + ((ownerGroups = (long[])this.get(OWNER_GROUPS)) != null ? ownerGroups.length : 0)) != 0) {
            if (owners != null && owners.length == 0) {
                owners = null;
            }
            if (ownerGroups != null && ownerGroups.length == 0) {
                ownerGroups = null;
            }
            IDObject relevantIDO = null;
            if (owners != null) {
                relevantIDO = UserManager.getUser(owners[0], this.getGroup());
            } else if (ownerGroups != null) {
                relevantIDO = (IDObjectGroup)IDObjectGroupManager.cvInstance.getObject(ownerGroups[0], this.getGroup());
            }
            if (relevantIDO != null) {
                if (colret != null) {
                    if (relevantIDO instanceof User) {
                        User user = relevantIDO;
                        colret[0] = (Color)user.get("USR_COLOR");
                    }
                    if (relevantIDO instanceof IDObjectGroup) {
                        IDObjectGroup group = (IDObjectGroup)relevantIDO;
                        colret[0] = (Color)group.get("IOG_COL");
                    }
                }
                return String.valueOf(((IDObject)relevantIDO).getBrowseName()) + (anzges > 1 ? " [...]" : "");
            }
        }
        return defVal;
    }

    public String getName(String nullVal) {
        return this.getName();
    }

    public String getName() {
        return this.getIDStringForReports(false);
    }

    public String getIDStringForReports(boolean showSexFragezeichen) {
        String s;
        StringBuffer msb = new StringBuffer();
        if (!this.isAlive()) {
            msb.append("\u2020 ");
        }
        if ((s = DefaultManager.getSexString(this.getSex(), this.getSexVariant(0), showSexFragezeichen)) != null && s.length() > 0) {
            msb.append(s).append(" ");
        }
        msb.append("[ID:").append(this.get("IDO_ID"));
        String tag = this.getCLLWEartagString(null, true, false, true);
        if (tag != null) {
            msb.append(" T:").append(tag);
        }
        msb.append("]");
        return msb.toString();
    }

    public String getCLLWStrainString() {
        return this.getCLLWStrainString(false, false, true);
    }

    public String getCLLWStrainString(boolean mitServicePrefix) {
        return this.getCLLWStrainString(false, false, mitServicePrefix);
    }

    public String getCLLWStrainString(boolean mitZahl, boolean zahlMitMax1Nachkommastelle, boolean mitServicePrefix) {
        return IndexObject.getDisplayString((IndexObject[])this.get(STRAINS), this.getGroup(), 8, mitZahl, zahlMitMax1Nachkommastelle, mitServicePrefix);
    }

    public String getCLLWLineString() {
        Line line = this.getLine();
        return line != null ? line.getBrowseNameInclServicePrefix() : "";
    }

    public String getCLLWLineStringWithoutPrefix() {
        Line line = this.getLine();
        return line != null ? line.getBrowseNameWITHOUTServicePrefix() : "";
    }

    public String getCLLWBirthDayString(boolean veryShort) {
        Date ivValue = this.getDate(BIRTHDAY);
        if (ivValue != null) {
            return veryShort ? DatumFormat.getVeryShortDateString(ivValue) : DatumFormat.getJustDateString(ivValue);
        }
        return "";
    }

    public String getCLLWPregnantDateString(boolean veryShort) {
        Integer ivValue = (Integer)this.get(PREGNANT_DATE);
        if (ivValue != null) {
            return veryShort ? DatumFormat.getVeryShortDateString(new MyDate(ivValue)) : DatumFormat.getJustDateString(new MyDate(ivValue));
        }
        return "";
    }

    public String getCLLWPlugDateString(boolean[] alarm) {
        Date pd = this.getDate(PLUG_DATE);
        if (pd != null) {
            int diff = MyDate.HEUTE - MyDate.getTage(pd);
            int alertdate = this.getInt(PLUG_ALERT, 0);
            if (alertdate == 0) {
                alertdate = 21;
            }
            if (alarm != null) {
                alarm[0] = diff >= alertdate;
            }
            return String.valueOf(diff) + ".5/" + alertdate + ".5";
        }
        return "";
    }

    public Date getEntryInActCage(long cageID) {
        Visit[] visits = (Visit[])this.get(VISITS);
        if (visits != null && visits.length != 0) {
            int vi = 0;
            while (vi < visits.length) {
                Visit visit = visits[vi];
                if (visit.ivEndDate == null && visit.ivCageID == cageID) {
                    return visit.ivStartDate;
                }
                ++vi;
            }
        }
        return null;
    }

    public int getCoatColor() {
        Integer cc = (Integer)this.get(COAT_COLOR);
        if (cc != null) {
            return cc;
        }
        Strain singleStrain = this.getSingleStrain();
        if (singleStrain != null && (cc = (Integer)singleStrain.get("STR_CC")) != null) {
            return -cc.intValue();
        }
        return Integer.MIN_VALUE;
    }

    public int getAgeInDays(int defVal) {
        Date startDate = this.getDate(BIRTHDAY);
        return startDate != null ? Mouse.getRealAgeInDays(startDate, this.getDate("IDO_END_DATE")) : defVal;
    }

    public static int getRealAgeInDays(Date startDate, Date endDate) {
        long diff = 0L;
        diff = endDate == null ? (ProcessDefinition.isClient() ? TimeMachine.getCurrentMillis() - startDate.getTime() : System.currentTimeMillis() - startDate.getTime()) : endDate.getTime() - startDate.getTime();
        return (int)(diff / 86400000L);
    }

    public static Color getTaskColor(Vector mice, Mouse mouse) {
        Color res = null;
        Vector sortedTasks = TaskExtended.getSortedTaskList(mice, mouse, true, true);
        if (!sortedTasks.isEmpty()) {
            TaskExtended te = (TaskExtended)sortedTasks.firstElement();
            res = te.getColor(te.ivGroup);
        }
        return res;
    }

    public String getToolTipStringTasks() {
        return TaskExtended.getToolTipStringTasks(null, this, true);
    }

    public String getToolTipString() {
        return UIDef.getToolTipString(Mouse.getDescription(this, false));
    }

    public Object[] fillLabelInformation(Font normFont, boolean veryShortDate, long cageID, boolean[] wantedInfo, boolean gtPralineMode) {
        StringBuffer msb;
        Object[] sarr = new Object[15];
        if (wantedInfo[0]) {
            if (this.getChar(FLAG) == '\u0001') {
                sarr[0] = new MFLabel("\u261e ", normFont);
            } else if (this.getChar(FLAG) != '\u0000') {
                char[] ica = new char[]{this.getChar(FLAG)};
                sarr[0] = new MFLabel(new String(ica), normFont);
            } else {
                sarr[0] = null;
            }
        }
        if (wantedInfo[1]) {
            sarr[1] = this.getInt(EARTAG) == 0 ? new MFLabel("", normFont) : new MFLabel(Integer.toString(this.getInt(EARTAG)), normFont);
        }
        if (wantedInfo[8]) {
            sarr[8] = new MFLabel(this.getCLLWEartagString(), normFont);
        }
        if (wantedInfo[7]) {
            sarr[7] = new MFLabel(this.getString(AN_TAG, "").trim(), normFont);
        }
        if (wantedInfo[14]) {
            Color background = null;
            int sex = this.getInt(SEX, 0);
            if (sex == 1) {
                background = Wurf.FATHER_COLORS[0];
            } else if (sex == 2) {
                background = Wurf.MOTHER_COLORS[0];
            }
            sarr[14] = new MFLabel(this.getString(AN_TAG, "").trim(), normFont, background);
        }
        if (wantedInfo[2]) {
            sarr[2] = new MFLabel(DefaultManager.getSexString(this, true), normFont);
        }
        if (wantedInfo[3]) {
            sarr[3] = this.getMultiFontGenotype(FontManager.getGenotypeArray(false, normFont, 1.0), gtPralineMode);
        }
        if (wantedInfo[4]) {
            Date birthday = this.getDate(BIRTHDAY);
            sarr[4] = birthday == null ? new MFLabel(" ", normFont) : (veryShortDate ? new MFLabel(DatumFormat.getVeryShortDateString(birthday), normFont) : new MFLabel(DatumFormat.getJustDateString(birthday), normFont));
        }
        if (wantedInfo[5]) {
            sarr[5] = null;
            Date d = this.getEntryInActCage(cageID);
            if (d != null) {
                sarr[5] = veryShortDate ? new MFLabel("(" + DatumFormat.getVeryShortDateString(d) + ")", normFont) : new MFLabel("(" + DatumFormat.getJustDateString(d) + ")", normFont);
            }
        }
        if (wantedInfo[9]) {
            Date plugdate = this.getDate(PLUG_DATE);
            sarr[9] = plugdate == null ? new MFLabel("", normFont) : (veryShortDate ? new MFLabel("[PD:" + DatumFormat.getVeryShortDateString(plugdate) + "]", normFont) : new MFLabel("[PD:" + DatumFormat.getJustDateString(plugdate) + "]", normFont));
        }
        if (wantedInfo[10]) {
            msb = new StringBuffer("[");
            Mouse parent = this.getFather();
            if (parent != null) {
                msb.append(DefaultManager.getMale()).append(":").append(parent.getCLLWEartagString("?", false, true)).append(", ");
            } else {
                msb.append(DefaultManager.getMale()).append(":-, ");
            }
            parent = this.getMother();
            if (parent != null) {
                msb.append(String.valueOf(DefaultManager.getFemale()) + ":").append(parent.getCLLWEartagString("?", false, true));
            } else {
                msb.append(String.valueOf(DefaultManager.getFemale()) + ":-");
            }
            msb.append("]");
            sarr[10] = new MFLabel(msb.toString(), normFont);
        }
        if (wantedInfo[11]) {
            msb = new StringBuffer("[");
            Mouse parent = this.getFather();
            if (parent != null) {
                msb.append(String.valueOf(DefaultManager.getMale()) + ":").append(parent.getCLLWEartagString("?", true, true)).append(", ");
            } else {
                msb.append(String.valueOf(DefaultManager.getMale()) + ":-, ");
            }
            parent = this.getMother();
            if (parent != null) {
                msb.append(String.valueOf(DefaultManager.getFemale()) + ":").append(parent.getCLLWEartagString("?", true, true));
            } else {
                msb.append(String.valueOf(DefaultManager.getFemale()) + ":-");
            }
            msb.append("]");
            sarr[11] = new MFLabel(msb.toString(), normFont);
        }
        if (wantedInfo[6]) {
            sarr[6] = new MFLabel(Long.toString(this.getID()), normFont);
        }
        if (wantedInfo[12]) {
            sarr[12] = new MFLabel(this.getStrainInfo(false, ""), normFont);
        }
        if (wantedInfo[13]) {
            sarr[13] = new MFLabel(this.getStrainInfo(true, ""), normFont);
        }
        return sarr;
    }

    public static String getDescription(Mouse maus, boolean big) {
        int i;
        Visit[] visits;
        long[] kids;
        String modestring;
        IndexObject[] strains;
        long[] owners;
        if (maus == null || maus.neverExisted()) {
            return Babel.get("NOTEXISTENT");
        }
        StringBuffer s = new StringBuffer("");
        if (big) {
            s.append(String.valueOf(Babel.get("ID")) + "\t").append(maus.getLong("IDO_ID")).append("\n");
        }
        if (maus.getInt(EARTAG) != 0) {
            s.append(String.valueOf(Babel.get("EARTAG")) + "\t").append(maus.getInt(EARTAG)).append("\n");
        }
        if ((owners = (long[])maus.get(OWNERS)) == null) {
            s.append(String.valueOf(Babel.get("OWNER")) + "\t" + Babel.get("ALL") + "\n");
        } else {
            s.append(Babel.get("OWNER")).append("\t");
            int ij = 0;
            while (ij < owners.length) {
                if (ij != 0) {
                    s.append(", ");
                }
                s.append(UserManager.getNameOfUser(owners[ij], maus.getGroup()));
                ++ij;
            }
            s.append("\n");
        }
        if (big) {
            if (maus.isAlive()) {
                s.append(String.valueOf(Babel.get("STATUS")) + "\t" + Babel.get("ALIVE") + "\n");
            } else {
                s.append(String.valueOf(Babel.get("STATUS")) + "\t" + Babel.get("DEAD") + "\n");
            }
        }
        switch (maus.getSex()) {
            case 1: {
                s.append(String.valueOf(Babel.get("SEX")) + "\t" + Babel.get("MALE") + "\n");
                break;
            }
            case 2: {
                s.append(String.valueOf(Babel.get("SEX")) + "\t" + Babel.get("FEMALE") + "\n");
                break;
            }
            default: {
                s.append(String.valueOf(Babel.get("SEX")) + "\t" + Babel.get("UNDEFINED") + "\n");
            }
        }
        Cage cage = maus.getActCage();
        if (cage != null) {
            s.append(String.valueOf(Babel.get("CAGE")) + "\t").append(cage.getNumber()).append("\n");
        }
        if ((strains = (IndexObject[])maus.get(STRAINS)) != null) {
            s.append(String.valueOf(Babel.get("STRAIN")) + "\t").append(maus.getStrainInfo(true, "")).append("\n");
        }
        s.append(Babel.get("LINE")).append("\t");
        Line line = maus.getLine();
        if (line != null) {
            s.append(line.getBrowseName());
        }
        s.append("\n");
        String gt = maus.getGenotype();
        if (gt != null && !gt.equals("?") && gt.length() != 0) {
            s.append(String.valueOf(Babel.get("GENOTYPE")) + "\t").append(gt).append("\n");
        }
        if (maus.get("IDO_START_DATE") != null) {
            modestring = Visit.translateMode(maus.getInt(STARTMODE));
            s.append(String.valueOf(Babel.get("START")) + "\t").append(DatumFormat.getJustDateString((Date)maus.get("IDO_START_DATE"))).append(" ").append(modestring).append("\n");
        }
        if (maus.getDate(BIRTHDAY) != null) {
            s.append(String.valueOf(Babel.get("BIRTHDAY")) + "\t").append(DatumFormat.getJustDateString(maus.getDate(BIRTHDAY))).append("\n");
        }
        if (maus.get("IDO_END_DATE") != null) {
            modestring = Visit.translateMode(maus.getInt(ENDMODE));
            s.append(String.valueOf(Babel.get("EXIT")) + "\t").append(DatumFormat.getJustDateString(maus.getDate("IDO_END_DATE"))).append(" ").append(modestring).append("\n");
        }
        if (maus.getLong(MOTHER) != 0L) {
            s.append(String.valueOf(Babel.get("MOTHER")) + "\t").append(maus.getLong(MOTHER));
            int met = 0;
            Mouse mum = MouseManager.getMouse(maus.getLong(MOTHER), maus.getGroup());
            if (mum != null) {
                met = mum.getInt(EARTAG);
            }
            if (met != 0) {
                s.append(" (" + Babel.get("EARTAG") + ": ").append(met).append(")");
            }
            s.append("\n");
        }
        if (maus.getLong(FATHER) != 0L) {
            s.append(String.valueOf(Babel.get("FATHER")) + "\t").append(maus.getLong(FATHER));
            int fet = 0;
            Mouse dad = MouseManager.getMouse(maus.getLong(FATHER), maus.getGroup());
            if (dad != null) {
                fet = dad.getInt(EARTAG);
            }
            if (fet != 0) {
                s.append(" (" + Babel.get("EARTAG") + ": ").append(fet).append(")");
            } else {
                s.append(" (" + Babel.get("NOEARTAG") + ")");
            }
            s.append("\n");
        }
        Vector<Mouse> theKids = new Vector<Mouse>();
        if (big) {
            kids = (long[])maus.get(KIDS);
            if (kids != null && kids.length != 0) {
                int ij = 0;
                while (ij < kids.length) {
                    int ket = 0;
                    Mouse kiddy = MouseManager.getMouse(kids[ij], maus.getGroup());
                    if (kiddy != null) {
                        ket = kiddy.getInt(EARTAG);
                        theKids.addElement(kiddy);
                    }
                    s.append(String.valueOf(Babel.get("KID")) + "\t").append(kids[ij]);
                    if (ket != 0) {
                        s.append(" (" + Babel.get("EARTAG") + ": ").append(ket).append(")");
                    }
                    s.append("\n");
                    ++ij;
                }
            }
        } else {
            kids = (long[])maus.get(KIDS);
            if (kids != null && kids.length != 0) {
                s.append(Babel.get("KIDS")).append("\t").append(kids.length).append("\n");
            }
        }
        if (big && (visits = (Visit[])maus.get(VISITS)) != null && visits.length != 0) {
            i = 0;
            while (i < visits.length) {
                Visit v = visits[i];
                s.append(String.valueOf(Babel.get("VISIT")) + " " + Integer.toString(i + 1) + "\t");
                s.append(String.valueOf(Babel.get("IN")) + " " + Babel.get("CAGE") + " ");
                Cage c = (Cage)ObjectStore.getClientObject(2, v.ivCageID, maus.getGroup());
                if (c == null) {
                    s.append("[" + v.ivCageID + "]\n");
                } else {
                    s.append(String.valueOf(c.getNumber()) + "\n");
                }
                if (v.ivStartDate == null) {
                    s.append("\t" + Babel.get("START") + ":\t" + Babel.get("UNKNOWN") + "\n");
                } else {
                    s.append("\t" + Babel.get("START") + ":\t" + DatumFormat.getJustDateString(v.ivStartDate));
                    s.append(" " + Visit.translateMode(v.ivStartMode) + "\n");
                }
                if (v.ivEndDate == null) {
                    s.append("\t" + Babel.get("END") + ":\t" + Babel.get("UNKNOWN") + "\n");
                } else {
                    s.append("\t" + Babel.get("END") + ":\t" + DatumFormat.getJustDateString(v.ivEndDate));
                    s.append(" " + Visit.translateMode(v.ivEndMode) + "\n");
                }
                ++i;
            }
        }
        if (maus.getString(COMMENT) != null) {
            Vector v = StringHelper.splitStringByAny(maus.getString(COMMENT), "\n");
            i = 0;
            while (i < v.size()) {
                if (i == 0) {
                    s.append(String.valueOf(Babel.get("COMMENT")) + "\t" + (String)v.elementAt(i) + "\n");
                } else {
                    s.append(" \t" + (String)v.elementAt(i) + "\n");
                }
                ++i;
            }
        }
        s.append("\n");
        return s.toString();
    }

    private String getStrainInfo(boolean mitProz, String defVal) {
        if (mitProz) {
            return Mouse.getStrainInfo((IndexObject[])this.get(STRAINS), defVal, this.getGroup());
        }
        return this.getCLLWStrainString();
    }

    public static String getStrainInfo(IndexObject[] strains, String defVal, String group) {
        if (strains != null) {
            StringBuffer mstr = new StringBuffer();
            int iii = 0;
            while (iii < strains.length) {
                IndexObject mto = strains[iii];
                Strain str = (Strain)ObjectStore.getClientObject(8, mto.ivObjectID, group);
                if (str == null) {
                    mstr.append("Unknown Strain");
                } else {
                    mstr.append(str.getString("STR_NAME"));
                }
                mstr.append(" (");
                int ppe = (int)(mto.ivNumber * 10000.0);
                Double perc = new Double(ppe / 100);
                mstr.append(perc.toString()).append("%) ");
                ++iii;
            }
            return mstr.toString();
        }
        return defVal;
    }

    public void addYourLinesAndStrains(HashSet lineIDs, HashSet strainIDs) {
        IndexObject[] strains;
        Long lineID = (Long)this.get(LINEID);
        if (lineID != null) {
            lineIDs.add(lineID);
        }
        if ((strains = (IndexObject[])this.get(STRAINS)) != null) {
            int i = 0;
            while (i < strains.length) {
                Long strainID = new Long(strains[i].ivObjectID);
                strainIDs.add(strainID);
                ++i;
            }
        }
    }

    public void replaceLineAndStrainIDs(Hashtable linehash, Hashtable strainhash) {
        IndexObject[] strains;
        long lineID = this.getLong(LINEID, -1L);
        if (lineID >= 0L) {
            Long key = new Long(lineID);
            Long ins = (Long)linehash.get(key);
            if (ins != null) {
                this.set(LINEID, ins);
            } else {
                Log.warn("RiesenMurks bei replaceLineAndStrainIDs Keine LineID", null, this);
            }
        }
        if ((strains = (IndexObject[])this.get(STRAINS)) != null && strainhash != null) {
            int i = 0;
            while (i < strains.length) {
                IndexObject mto = strains[i];
                Long key = new Long(mto.ivObjectID);
                Long ins = (Long)strainhash.get(key);
                if (ins != null) {
                    mto.ivObjectID = ins;
                } else {
                    Log.warn("RiesenMurks bei replaceLineAndStrainIDs Keine StrainID", null, this);
                }
                ++i;
            }
        }
    }

    public Line getLine() {
        return (Line)ObjectStore.getObjectDeadOrAlive(7, this.getLong(LINEID, 0L), this.getGroup(), null, false);
    }

    public void appendLicenseIndexInfo(StringBuilder msb, String sep) {
        boolean had = false;
        int i = 0;
        while (i < LICENSE_TAGS.length) {
            Long l1 = (Long)this.get(LICENSE_TAGS[i]);
            if (l1 != null) {
                if (had) {
                    msb.append(sep);
                }
                had = true;
                msb.append(l1);
            }
            ++i;
        }
    }

    public int getLicenseIds(Long[] target) {
        int anzFound = 0;
        int i = 0;
        while (i < LICENSE_TAGS.length) {
            target[i] = (Long)this.get(LICENSE_TAGS[i]);
            if (target[i] != null) {
                ++anzFound;
            }
            ++i;
        }
        return anzFound;
    }

    public Vector getLicenses(Vector sammlerForReuse) {
        Long[] licidArr = new Long[LICENSE_TAGS.length];
        int anzFound = this.getLicenseIds(licidArr);
        if (anzFound != 0) {
            Vector res = sammlerForReuse != null ? sammlerForReuse : new Vector(anzFound);
            int i = 0;
            while (i < licidArr.length) {
                if (licidArr[i] != null) {
                    License lici = (License)ObjectStore.getObjectDeadOrAlive(16, licidArr[i], this.getGroup(), null, false);
                    if (lici != null) {
                        res.add(lici);
                    } else {
                        System.out.println("Kacke: " + licidArr[i]);
                    }
                }
                ++i;
            }
            licidArr = null;
            return res;
        }
        licidArr = null;
        return null;
    }

    public String getLicenseString(String trenner, String defVal) {
        Vector licenses = this.getLicenses(null);
        if (licenses != null) {
            if (licenses.size() == 1) {
                License lic = (License)licenses.firstElement();
                licenses.clear();
                licenses = null;
                return lic.getName();
            }
            TreeSet<String> ts = new TreeSet<String>();
            Iterator iterator = licenses.iterator();
            while (iterator.hasNext()) {
                License lic = (License)iterator.next();
                ts.add(lic.getName());
            }
            licenses.clear();
            licenses = null;
            StringBuilder msb = new StringBuilder();
            Iterator iterator2 = ts.iterator();
            while (iterator2.hasNext()) {
                String name = (String)iterator2.next();
                if (msb.length() != 0) {
                    msb.append(trenner).append(" ");
                }
                msb.append(name);
            }
            ts.clear();
            ts = null;
            return msb.toString();
        }
        return defVal;
    }

    public Vector getStrains() {
        Vector<Strain> erg = new Vector<Strain>();
        IndexObject[] strains = (IndexObject[])this.get(STRAINS);
        if (strains != null) {
            int w = 0;
            while (w < strains.length) {
                Strain strain;
                if (strains[w].ivObjectID != 0L && (strain = (Strain)ObjectStore.getObjectDeadOrAlive(8, strains[w].ivObjectID, this.getGroup(), null, false)) != null) {
                    erg.add(strain);
                }
                ++w;
            }
        }
        return erg;
    }

    public Strain getSingleStrain() {
        IndexObject[] strains = (IndexObject[])this.get(STRAINS);
        if (strains != null && strains.length == 1 && strains[0].ivNumber == 1.0) {
            return (Strain)ObjectStore.getObjectDeadOrAlive(8, strains[0].ivObjectID, this.getGroup(), null, false);
        }
        return null;
    }

    public Vector getKids() {
        return ObjectStore.getObjects(1, (long[])this.get(KIDS), this.getGroup());
    }

    public boolean hasKids() {
        long[] arr = (long[])this.get(KIDS);
        return arr != null && arr.length != 0;
    }

    public Vector getCohorts() {
        return ObjectStore.getObjects(19, (long[])this.get(COHORTS), this.getGroup());
    }

    public Mouse getMother() {
        return (Mouse)ObjectStore.getObjectDeadOrAlive(1, this.getLong(MOTHER, 0L), this.getGroup(), null, false);
    }

    public Mouse getFather() {
        return (Mouse)ObjectStore.getObjectDeadOrAlive(1, this.getLong(FATHER, 0L), this.getGroup(), null, false);
    }

    public boolean isActiveInMating() {
        return this.isInMatingCage() && this.getSex() != 0 && this.isSexActive();
    }

    public void addMresult(MResult mres) {
        Vector<MResult> ores = (Vector<MResult>)this.get(MRESULTS);
        if (ores != null) {
            Vector v = new Vector();
            v.addAll(ores);
            ores = v;
        } else {
            ores = new Vector<MResult>();
        }
        ores.add(mres);
        this.set(MRESULTS, ores);
    }

    public void remMresult(long pseudoID) {
        Vector<MResult> ores = (Vector<MResult>)this.get(MRESULTS);
        if (ores != null) {
            Vector<MResult> v = new Vector<MResult>(ores.size());
            Iterator iterator = ores.iterator();
            while (iterator.hasNext()) {
                MResult mres = (MResult)iterator.next();
                if (mres.ivPseudoID == pseudoID) continue;
                v.add(mres);
            }
            ores = v.isEmpty() ? null : v;
        }
        this.set(MRESULTS, ores);
    }

    public MResult getMResult(long pseudoID) {
        Vector ores = (Vector)this.get(MRESULTS);
        if (ores != null) {
            Iterator iterator = ores.iterator();
            while (iterator.hasNext()) {
                MResult mres = (MResult)iterator.next();
                if (mres.ivPseudoID == pseudoID) continue;
                return mres;
            }
        }
        return null;
    }

    public String getHerkunftOderZiel(boolean isHerkunft, boolean mitID) {
        String adresse = this.getString(isHerkunft ? CAME_FROM : WENT_TO, null);
        if (adresse != null) {
            if (adresse.startsWith(TO_OR_FROM_ADDRESS_LIST)) {
                try {
                    int id = Integer.parseInt(adresse.substring(TO_OR_FROM_ADDRESS_LIST.length(), adresse.length()));
                    String name = ListDefinition.getName(id < 5000 ? this.getGroup() : "service", 6, id, null);
                    return name;
                }
                catch (Exception id) {}
            } else if (adresse.startsWith(TO_OR_FROM_MAUSO_GROUP_NAME)) {
                try {
                    return adresse.substring(TO_OR_FROM_MAUSO_GROUP_NAME.length(), adresse.length());
                }
                catch (Exception id) {
                }
            } else if (adresse.startsWith(TO_OR_FROM_MAUSO_GROUP_FULL)) {
                try {
                    String identifier = adresse.substring(TO_OR_FROM_MAUSO_GROUP_FULL.length(), adresse.length());
                    IDObject.IDObjectIdentifier idi = new IDObject.IDObjectIdentifier(identifier);
                    return mitID ? String.valueOf(idi.ivGroup) + " [ID: " + idi.ivID + "]" : idi.ivGroup;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public boolean isGVO() {
        return !this.isPureWildType();
    }

    public boolean isPureWildType() {
        LocusAndAlleles[] lv;
        Line line = this.getLine();
        if (line != null && line.isBreeder()) {
            return true;
        }
        if (line == null) {
            return false;
        }
        LocusAndAlleles[] lociAndAlleles = (LocusAndAlleles[])this.get(LOCUSGENOTYPES);
        LocusAndAlleles[] locusAndAllelesArray = lv = line == null ? null : (LocusAndAlleles[])line.get("LIN_LOCIALLELES");
        return lociAndAlleles != null && MausoSearcherObject.SearcherGenotype.isPureWildType(this, lociAndAlleles, line, lv);
    }

    public void addDirectAndIndirectOwnerIDs(HashSet erg) {
        long[] owners = (long[])this.get(OWNERS);
        if (owners != null && owners.length != 0) {
            int j = 0;
            while (j < owners.length) {
                erg.add(new Long(owners[j]));
                ++j;
            }
        }
        if ((owners = (long[])this.get(OWNER_GROUPS)) != null && owners.length != 0) {
            String group = this.getGroup();
            int i = 0;
            while (i < owners.length) {
                long[] ogowners;
                IDObjectGroup idog = (IDObjectGroup)IDObjectGroupManager.cvInstance.getObject(owners[i], group);
                if (idog != null && (ogowners = (long[])idog.get("IOG_IDS")) != null) {
                    int j = 0;
                    while (j < ogowners.length) {
                        erg.add(new Long(ogowners[j]));
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    public Vector getOwners() {
        Vector<User> erg = new Vector<User>();
        long[] owners = (long[])this.get(OWNERS);
        if (owners != null) {
            int w = 0;
            while (w < owners.length) {
                User user = (User)ObjectStore.getObjectDeadOrAlive(6, owners[w], this.getGroup(), null, false);
                if (user != null) {
                    erg.add(user);
                }
                ++w;
            }
        }
        return erg;
    }

    public String getGenerationString(boolean pfSystem) {
        int fagenUse;
        int mgen = this.getGeneration(0, false);
        StringBuilder msb = new StringBuilder();
        String ich = Mouse.getGenerationString(mgen, pfSystem);
        if (ich != null) {
            msb.append(ich);
        }
        int mogen = this.getInt(GEN_MOTHER, 0);
        int fagen = this.getInt(GEN_FATHER, 0);
        int mogenUse = mogen == -42 ? 1 : mogen;
        int n = fagenUse = fagen == -42 ? 1 : fagen;
        if (mogenUse > 0 && mgen > 0 && mgen - mogenUse != 1 || fagenUse > 0 && mgen > 0 && mgen - fagenUse != 1) {
            msb.append(" (");
            if (mogen != 0) {
                msb.append(DefaultManager.getFemale()).append(": ").append(Mouse.getGenerationString(mogen, pfSystem));
            }
            if (mogen != 0 && fagen != 0) {
                msb.append(" / ");
            }
            if (fagen != 0) {
                msb.append(DefaultManager.getMale()).append(": ").append(Mouse.getGenerationString(fagen, pfSystem));
            }
            msb.append(")");
        }
        return msb.toString();
    }

    public static String getGenerationString(int generation, boolean pfSystem) {
        if (generation > 0) {
            if (pfSystem) {
                return generation == 1 ? "P" : "F" + (generation - 1);
            }
            return "N" + generation;
        }
        if (generation == -42) {
            return pfSystem ? "F0" : "N1";
        }
        return null;
    }

    public int getGeneration(int defVal, boolean ersetzeF0SonderKennung) {
        int res = defVal;
        int manuell = this.getInt(GEN_MANUAL, 0);
        if (manuell != 0) {
            res = manuell == -1 ? defVal : manuell;
        } else {
            int mama;
            int papaPre = this.getInt(GEN_FATHER, 0);
            int mamaPre = this.getInt(GEN_MOTHER, 0);
            int papa = papaPre == -42 ? 1 : papaPre;
            int n = mama = mamaPre == -42 ? 1 : mamaPre;
            if (papa > mama) {
                return papa + 1;
            }
            if (papa < mama) {
                return mama + 1;
            }
            res = papa == 0 ? defVal : papa + 1;
        }
        if (ersetzeF0SonderKennung && res == -42) {
            res = 1;
        }
        return res;
    }
}

