/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.mouse.tierschutz;

import de.hannse.netobjects.objectstore.IDObjectXMLHandler;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.util.ArrayHelper;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.helper.Zeile;
import mausoleum.line.Line;
import mausoleum.locus.Locus;
import mausoleum.locus.LocusAndAlleles;
import mausoleum.mouse.Mouse;
import mausoleum.mouse.tierschutz.Stress;

public class StressRule
implements Externalizable {
    static final long serialVersionUID = -871764367526504937L;
    private static final int VERSION = 1;
    private static final int NOT_DEF = 0;
    public int ivStress = 40;
    public int ivSex = 0;
    public int ivMinWeeks = 0;
    public Object[] ivGenotypes = null;
    public transient String ivTableString = null;

    public static int getStress(Line line, Mouse mouse) {
        return StressRule.getStress(line, mouse.getSex(), StressRule.getAge(mouse), StressRule.getLAL(mouse));
    }

    public static int getStress(Line line, int sex, int ageInWeeks, LocusAndAlleles[] mouseGTArr) {
        int res = 0;
        if (line != null) {
            StressRule[] arr = (StressRule[])line.get("LIN_STRRUL");
            if (arr != null) {
                int i = 0;
                while (i < arr.length) {
                    if (arr[i].ivStress > res && arr[i].matches(sex, ageInWeeks, mouseGTArr)) {
                        res = arr[i].ivStress;
                    }
                    ++i;
                }
            }
            if (res == 0) {
                res = line.getInt("LIN_DEFSTR", 0);
            }
        }
        return res;
    }

    public static StressRule getCopyFromService(StressRule sRule, String group) {
        HashMap<Long, Long> targetLocusIDsBySourceLocusID = new HashMap<Long, Long>();
        if (sRule.ivGenotypes != null) {
            Vector allLociInGroup = ObjectStore.getActualObjects(14, group);
            Iterator iterator = allLociInGroup.iterator();
            while (iterator.hasNext()) {
                Locus locus = (Locus)iterator.next();
                Long serviceID = (Long)locus.get("IDO_SERVID");
                if (serviceID == null) continue;
                targetLocusIDsBySourceLocusID.put(serviceID, locus.getLongID());
            }
        }
        return StressRule.getCopyFromOtherGroup(sRule, targetLocusIDsBySourceLocusID, group);
    }

    public static StressRule getCopyFromOtherGroup(StressRule sRule, HashMap targetLocusIDsBySourceLocusID, String targetGroup) {
        StressRule res = new StressRule();
        res.ivStress = sRule.ivStress;
        res.ivSex = sRule.ivSex;
        res.ivMinWeeks = sRule.ivMinWeeks;
        if (sRule.ivGenotypes != null) {
            res.ivGenotypes = new Object[sRule.ivGenotypes.length];
            int i = 0;
            while (i < sRule.ivGenotypes.length) {
                LocusAndAlleles[] tarr;
                LocusAndAlleles[] arr = (LocusAndAlleles[])sRule.ivGenotypes[i];
                res.ivGenotypes[i] = tarr = new LocusAndAlleles[arr.length];
                int j = 0;
                while (j < tarr.length) {
                    Long targetID = (Long)targetLocusIDsBySourceLocusID.get(new Long(arr[j].ivLocusID));
                    if (targetID == null) {
                        throw new IllegalArgumentException("Corresponding Locus to Locus (ID=" + arr[j].ivLocusID + ") not found in Group " + targetGroup + " while propagating LocusAndAllel-Array");
                    }
                    tarr[j] = new LocusAndAlleles((long)targetID, ArrayHelper.getCopy(arr[j].ivAllele));
                    ++j;
                }
                ++i;
            }
        }
        return res;
    }

    public static String toString(StressRule[] orig) {
        StringBuilder msb = new StringBuilder();
        msb.append("[");
        if (orig != null) {
            int i = 0;
            while (i < orig.length) {
                if (i != 0) {
                    msb.append(", ");
                }
                msb.append(orig[i].toString());
                ++i;
            }
        }
        msb.append("]");
        return msb.toString();
    }

    public static int getAge(Mouse mouse) {
        return mouse.getAgeInDays(0) / 7;
    }

    private static LocusAndAlleles[] getLAL(Mouse mouse) {
        return (LocusAndAlleles[])mouse.get("MOS_LOCUSGENOTYPES");
    }

    public StressRule() {
    }

    public StressRule(String initSTring) {
        Zeile z = new Zeile(initSTring, '|');
        this.ivStress = z.getInt(0, 0);
        this.ivSex = z.getInt(1, 0);
        this.ivMinWeeks = z.getInt(2, 0);
        String sub = z.getStringNONEmpty(3, null);
        if (sub != null) {
            this.ivGenotypes = (Object[])IDObjectXMLHandler.getObject(sub, null, true);
        }
    }

    public StressRule(StressRule model) {
        this(model.getInitString());
    }

    public String toString() {
        StringBuilder msb = new StringBuilder();
        msb.append("StressRule Stress: ").append(StringHelper.getStringForInt(this.ivStress, Stress.STRESS_INTS, Stress.STRESS_BABELS, true, "en", "?"));
        msb.append(" Sex: ").append(Mouse.translateSex(this.ivSex));
        msb.append(" min Weeks: ").append(this.ivMinWeeks);
        if (this.ivGenotypes != null && this.ivGenotypes.length != 0) {
            msb.append(" Genotypes: ");
            int i = 0;
            while (i < this.ivGenotypes.length) {
                msb.append(LocusAndAlleles.toString((LocusAndAlleles[])this.ivGenotypes[i]));
                ++i;
            }
        }
        return msb.toString();
    }

    public void addGenotype(LocusAndAlleles[] arr) {
        this.ivGenotypes = ArrayHelper.enlargeObjectArray(this.ivGenotypes, arr);
    }

    public void removeGenotype(int index) {
        this.ivGenotypes = ArrayHelper.shrinkObjectArray(this.ivGenotypes, index);
    }

    public void setSex(int sex) {
        this.ivSex = sex;
    }

    public boolean matches(Mouse mouse) {
        if (mouse != null) {
            return this.matches(mouse.getSex(), StressRule.getAge(mouse), StressRule.getLAL(mouse));
        }
        return false;
    }

    public boolean matches(int sex, int ageInWeeks, LocusAndAlleles[] mouseGTArr) {
        boolean res = this.sexMatch(sex);
        if (res) {
            res = this.ageMatch(ageInWeeks);
        }
        if (res) {
            res = this.gtMatch(mouseGTArr);
        }
        return res;
    }

    public String getInitString() {
        StringBuilder msb = new StringBuilder();
        msb.append(this.ivStress).append("|");
        msb.append(this.ivSex).append("|");
        msb.append(this.ivMinWeeks).append("|");
        msb.append(this.ivGenotypes != null ? IDObjectXMLHandler.getTransport(this.ivGenotypes, true, true) : "").append("|");
        return msb.toString();
    }

    private boolean sexMatch(int sex) {
        return this.ivSex == 0 || (sex & this.ivSex) != 0;
    }

    private boolean ageMatch(int ageInWeeks) {
        return this.ivMinWeeks == 0 || ageInWeeks >= this.ivMinWeeks;
    }

    private boolean gtMatch(LocusAndAlleles[] mouseGTArr) {
        if (this.ivGenotypes == null || this.ivGenotypes.length == 0) {
            return true;
        }
        int i = 0;
        while (i < this.ivGenotypes.length) {
            if (this.singleGTMatch(mouseGTArr, (LocusAndAlleles[])this.ivGenotypes[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean singleGTMatch(LocusAndAlleles[] mouseGTArr, LocusAndAlleles[] checkArr) {
        if (mouseGTArr == null) {
            return false;
        }
        int i = 0;
        while (i < checkArr.length) {
            LocusAndAlleles checkLal = checkArr[i];
            LocusAndAlleles mouseLal = LocusAndAlleles.findLocusAndAlleles(mouseGTArr, checkLal.ivLocusID);
            if (mouseLal == null || mouseLal.ivAllele == null || mouseLal.ivAllele.length != checkLal.ivAllele.length) {
                return false;
            }
            if (checkLal.isHomozygous()) {
                if (mouseLal.isHomozygous()) {
                    return checkLal.ivAllele[0].equals(mouseLal.ivAllele[0]);
                }
                return false;
            }
            if (mouseLal.isHomozygous()) {
                return false;
            }
            int j = 0;
            while (j < checkArr[i].ivAllele.length) {
                if (!mouseLal.isAllelContained(checkLal.ivAllele[j])) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(1);
        out.writeInt(this.ivStress);
        out.writeInt(this.ivSex);
        out.writeInt(this.ivMinWeeks);
        out.writeObject(this.ivGenotypes);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int server = in.readInt();
        if (server == 1) {
            this.ivStress = in.readInt();
            this.ivSex = in.readInt();
            this.ivMinWeeks = in.readInt();
            this.ivGenotypes = (Object[])in.readObject();
        }
    }
}

