/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.mouse.tierschutz;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.IDObjectXMLHandler;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.util.ArrayHelper;
import de.hannse.netobjects.util.Babel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.MatteBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mausoleum.gui.ColorManager;
import mausoleum.gui.RequesterPane;
import mausoleum.helper.FontManager;
import mausoleum.helper.WindowUtils;
import mausoleum.inspector.InspectorPanel;
import mausoleum.inspector.actions.documents.DocuButton;
import mausoleum.inspector.panels.IPTabPanel;
import mausoleum.inspector.util.InspectorCommandSender;
import mausoleum.line.Line;
import mausoleum.locus.LocusAndAlleles;
import mausoleum.main.DefaultManager;
import mausoleum.main.MausoleumClient;
import mausoleum.mouse.Mouse;
import mausoleum.mouse.MouseManager;
import mausoleum.mouse.tierschutz.Stress;
import mausoleum.mouse.tierschutz.StressRule;
import mausoleum.mouse.tierschutz.StressRuleRequester;
import mausoleum.tables.TableFrameMouse;
import mausoleum.tables.models.MTMouseStress;
import mausoleum.ui.UIDef;

public class StressRulePane
extends RequesterPane
implements ListSelectionListener,
IPTabPanel {
    private static final long serialVersionUID = 1L;
    private static final StressRule[] NIX_RULES = new StressRule[0];
    public final JList ivRulesList = new JList();
    private AddRuleButton ivAddRuleButton = new AddRuleButton();
    private EditRuleButton ivEditRuleButton = new EditRuleButton();
    private RemoveRuleButton ivRemoveRuleButton = new RemoveRuleButton();
    private ShowMiceForRuleButton ivMatcherButton = new ShowMiceForRuleButton();
    private ShowStressForMiceButton ivOverviewButton = new ShowStressForMiceButton();
    private JLabel ivRulesLabel = new JLabel();
    private Line ivLine = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public StressRulePane() {
        super((LayoutManager)new BorderLayout(UIDef.INNER_RAND, UIDef.INNER_RAND), "inspectorBack");
        this.ivRulesList.setOpaque(false);
        this.ivRulesList.getSelectionModel().addListSelectionListener(this);
        this.ivRulesLabel.setFont(FontManager.getFont("SSP11"));
        this.ivRulesLabel.setBorder(new MatteBorder(0, 0, 1, 0, Color.black));
        this.ivRulesLabel.setOpaque(true);
        JScrollPane jsp = new JScrollPane(this.ivRulesList);
        this.ivRulesList.setCellRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                StressRule rule = (StressRule)value;
                StressRulePane.this.ivRulesLabel.setText(StressRulePane.this.getVal(rule));
                StressRulePane.this.ivRulesLabel.setBackground(isSelected ? UIDef.SELECTED_BACKGROUND : Color.white);
                return StressRulePane.this.ivRulesLabel;
            }
        });
        this.add("Center", jsp);
        JPanel subPan = new JPanel(new GridLayout(1, 3, UIDef.INNER_RAND, UIDef.INNER_RAND));
        subPan.setOpaque(false);
        subPan.add(this.ivAddRuleButton);
        subPan.add(this.ivRemoveRuleButton);
        subPan.add(this.ivEditRuleButton);
        if (!MausoleumClient.isHeadOfService()) {
            JPanel bigSubPan = new JPanel(new GridLayout(3, 1, UIDef.INNER_RAND, UIDef.INNER_RAND));
            bigSubPan.setOpaque(false);
            bigSubPan.add(subPan);
            bigSubPan.add(this.ivMatcherButton);
            bigSubPan.add(this.ivOverviewButton);
            this.add("South", bigSubPan);
        } else {
            this.add("South", subPan);
        }
    }

    public void adapt(Vector idObjects, Vector mice, Vector changeSensitives) {
        if (idObjects != null && idObjects.size() == 1) {
            this.ivLine = (Line)idObjects.firstElement();
            StressRule[] arr = (StressRule[])this.ivLine.get("LIN_STRRUL");
            this.ivRulesList.setListData(arr == null ? NIX_RULES : arr);
            this.ivRulesList.setEnabled(true);
        } else {
            this.ivLine = null;
            this.ivRulesList.setListData(NIX_RULES);
            this.ivRulesList.setEnabled(false);
        }
        this.ivAddRuleButton.checkEnabled(idObjects);
        this.ivRemoveRuleButton.checkEnabled(idObjects);
        this.ivEditRuleButton.checkEnabled(idObjects);
        this.ivMatcherButton.checkEnabled(idObjects);
        this.ivOverviewButton.checkEnabled(idObjects);
    }

    private String getVal(StressRule rule) {
        if (rule.ivTableString == null) {
            StringBuilder msb = new StringBuilder();
            msb.append("<html><table width=\"100%\">");
            Color stressCol = null;
            int sind = ArrayHelper.findIndexInArray(rule.ivStress, Stress.STRESS_INTS);
            if (sind != -1) {
                stressCol = Stress.STRESS_COLORS[sind];
            }
            msb.append("<tr>");
            msb.append("<td>").append(Babel.get("STRESS")).append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>");
            msb.append("<td width=\"100%\"");
            if (stressCol != null) {
                msb.append(" bgcolor=\"").append(ColorManager.getHTMLColorString(stressCol)).append("\"");
            }
            msb.append("><b>").append(StringHelper.getStringForInt(rule.ivStress, Stress.STRESS_INTS, Stress.STRESS_BABELS, true, "")).append("</b></td>");
            msb.append("</tr>");
            if (rule.ivSex != 0) {
                msb.append("<tr>");
                msb.append("<td>").append(Babel.get("SEX")).append("</td>");
                msb.append("<td width=\"100%\"><b>").append(DefaultManager.getSexString(rule.ivSex, 0, true)).append("</b></td>");
                msb.append("</tr>");
            }
            if (rule.ivMinWeeks != 0) {
                msb.append("<tr>");
                msb.append("<td>").append(Babel.get("AGE")).append("</td>");
                msb.append("<td width=\"100%\"><b>").append(Babel.get("OLDER_THAN")).append(" ").append(rule.ivMinWeeks).append(" ");
                msb.append(Babel.get(rule.ivMinWeeks == 1 ? "WEEK" : "WEEKS"));
                msb.append("</b></td>");
                msb.append("</tr>");
            }
            if (rule.ivGenotypes != null && rule.ivGenotypes.length != 0) {
                msb.append("<tr>");
                msb.append("<td valign=\"top\">").append(Babel.get("GENOTYPE")).append("</td>");
                msb.append("<td><b>");
                StringBuilder tsb = new StringBuilder();
                int i = 0;
                while (i < rule.ivGenotypes.length) {
                    LocusAndAlleles[] arr = (LocusAndAlleles[])rule.ivGenotypes[i];
                    int j = 0;
                    while (j < arr.length) {
                        tsb.append(arr[j].toGenotypeStringMultiFont(this.ivLine.getGroup()));
                        ++j;
                    }
                    ++i;
                }
                String s = tsb.toString();
                s = StringHelper.gSub(s, "</html><html>", "<br>");
                msb.append(s).append("</b></td>");
                msb.append("</tr>");
            }
            msb.append("</table></html>");
            rule.ivTableString = msb.toString();
        }
        return rule.ivTableString;
    }

    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            InspectorPanel ip;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("mausoleum.inspector.InspectorPanel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((ip = (InspectorPanel)WindowUtils.getParent(this, clazz)) != null) {
                this.ivAddRuleButton.checkEnabled(ip.ivSelObjects);
                this.ivRemoveRuleButton.checkEnabled(ip.ivSelObjects);
                this.ivEditRuleButton.checkEnabled(ip.ivSelObjects);
                this.ivMatcherButton.checkEnabled(ip.ivSelObjects);
                this.ivOverviewButton.checkEnabled(ip.ivSelObjects);
            }
        }
    }

    public static class AddRuleButton
    extends RuleButton {
        private static final long serialVersionUID = 1324234L;

        public AddRuleButton() {
            super(Babel.get("ADD"), "LIC_ADD_STRESS_RULE", false);
        }

        public boolean checkAction(Line line, boolean withExecution, Object[] selectedRules) {
            StressRule sr;
            if (withExecution && (sr = this.editRule(line, null)) != null) {
                Vector<StressRule> neu = new Vector<StressRule>();
                StressRule[] orig = (StressRule[])line.get("LIN_STRRUL");
                if (orig != null) {
                    int i = 0;
                    while (i < orig.length) {
                        neu.add(orig[i]);
                        ++i;
                    }
                }
                neu.add(sr);
                return AddRuleButton.sendNewRules(line, neu);
            }
            return true;
        }
    }

    public static class EditRuleButton
    extends RuleButton {
        private static final long serialVersionUID = 1324234L;

        public EditRuleButton() {
            super(Babel.get("EDIT"), "LIC_EDIT_STRESS_RULE", true);
        }

        public boolean checkAction(Line line, boolean withExecution, Object[] selectedRules) {
            if (selectedRules != null && selectedRules.length == 1) {
                StressRule sr;
                if (withExecution && (sr = this.editRule(line, (StressRule)selectedRules[0])) != null) {
                    int ind;
                    StressRulePane srp;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("mausoleum.mouse.tierschutz.StressRulePane");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((srp = (StressRulePane)WindowUtils.getParent(this, clazz)) != null && (ind = srp.ivRulesList.getSelectedIndex()) != -1) {
                        Vector<StressRule> neu = new Vector<StressRule>();
                        StressRule[] orig = (StressRule[])line.get("LIN_STRRUL");
                        if (orig != null) {
                            int i = 0;
                            while (i < orig.length) {
                                if (i != ind) {
                                    neu.add(orig[i]);
                                } else {
                                    neu.add(sr);
                                }
                                ++i;
                            }
                        }
                        return EditRuleButton.sendNewRules(line, neu);
                    }
                }
                return true;
            }
            return false;
        }
    }

    public static class RemoveRuleButton
    extends RuleButton {
        private static final long serialVersionUID = 1324234L;

        public RemoveRuleButton() {
            super(Babel.get("REMOVE"), "LIC_REMOVE_STRESS_RULE", true);
        }

        public boolean checkAction(Line line, boolean withExecution, Object[] selectedRules) {
            if (selectedRules != null && selectedRules.length != 0) {
                StressRule[] orig;
                if (withExecution && (orig = (StressRule[])line.get("LIN_STRRUL")) != null && orig.length != 0) {
                    Vector<StressRule> neu = new Vector<StressRule>();
                    int i = 0;
                    while (i < orig.length) {
                        if (ArrayHelper.findObjectInArray(orig[i], selectedRules) == -1) {
                            neu.add(orig[i]);
                        }
                        ++i;
                    }
                    if (neu.size() != orig.length) {
                        StressRule[] neuArr = new StressRule[neu.size()];
                        int i2 = 0;
                        while (i2 < neuArr.length) {
                            neuArr[i2] = (StressRule)neu.elementAt(i2);
                            ++i2;
                        }
                        return RemoveRuleButton.sendNewRules(line, neu);
                    }
                }
                return true;
            }
            return false;
        }
    }

    public static abstract class RuleButton
    extends DocuButton {
        private static final long serialVersionUID = 1324234L;
        protected boolean ivLineMustBeEditable = true;

        protected static boolean sendNewRules(Line line, Vector rules) {
            StressRule[] neuArr = new StressRule[rules.size()];
            int i = 0;
            while (i < neuArr.length) {
                neuArr[i] = (StressRule)rules.elementAt(i);
                ++i;
            }
            StringBuilder msb = new StringBuilder();
            msb.append("LINCHSTRESSRULES").append(" ");
            msb.append(line.getID()).append(" ");
            msb.append(IDObjectXMLHandler.getTransport(neuArr, true, true));
            return InspectorCommandSender.executeCommand(msb.toString(), line.getGroup());
        }

        public RuleButton(String name, String privilege, boolean wantsSelectedRules) {
            super(name, privilege);
        }

        public boolean checkAction(Vector idObjects, boolean withExecution) {
            boolean res = false;
            if (!(this.ivPrivilege != null && !Privileges.hasPrivilege(this.ivPrivilege) || idObjects == null || idObjects.size() != 1 || this.ivLineMustBeEditable && !IDObject.nonEmptyAndAllActiveAndChangeable(idObjects))) {
                StressRulePane srp;
                Line line = (Line)idObjects.firstElement();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("mausoleum.mouse.tierschutz.StressRulePane");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((srp = (StressRulePane)WindowUtils.getParent(this, clazz)) != null) {
                    res = this.checkAction(line, withExecution, srp.ivRulesList.getSelectedValues());
                }
            }
            return res;
        }

        public StressRule editRule(Line line, StressRule orig) {
            return StressRuleRequester.editRule(line, orig);
        }

        public abstract boolean checkAction(Line var1, boolean var2, Object[] var3);
    }

    public static class ShowMiceForRuleButton
    extends RuleButton {
        private static final long serialVersionUID = 1324234L;

        public ShowMiceForRuleButton() {
            super(Babel.get("SHOW_MATCHING_MICE"), null, false);
            this.ivLineMustBeEditable = false;
        }

        public boolean checkAction(Line line, boolean withExecution, Object[] selectedRules) {
            if (selectedRules != null && selectedRules.length == 1) {
                if (withExecution) {
                    InspectorPanel ip;
                    StressRule sr = (StressRule)selectedRules[0];
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("mausoleum.inspector.InspectorPanel");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((ip = (InspectorPanel)WindowUtils.getParent(this, clazz)) != null) {
                        Vector<Mouse> matchings = new Vector<Mouse>();
                        Vector allMice = MouseManager.getActualMiceOfLines(ip.ivSelObjects);
                        Iterator iterator = allMice.iterator();
                        while (iterator.hasNext()) {
                            Mouse mouse = (Mouse)iterator.next();
                            if (!sr.matches(mouse)) continue;
                            matchings.add(mouse);
                        }
                        allMice.clear();
                        allMice = null;
                        TableFrameMouse.displayMiceAndSort(new MTMouseStress(matchings), Babel.get("MICE_MATCHING_SELECTED_RULE"), Babel.get("MOUSE_COLLECTION"), null);
                    }
                }
                return true;
            }
            return false;
        }
    }

    public static class ShowStressForMiceButton
    extends RuleButton {
        private static final long serialVersionUID = 1324234L;

        public ShowStressForMiceButton() {
            super(Babel.get("SHOW_STRESS_FOR_MICE"), null, false);
            this.ivLineMustBeEditable = false;
        }

        public boolean checkAction(Line line, boolean withExecution, Object[] selectedRules) {
            if (withExecution) {
                InspectorPanel ip;
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("mausoleum.inspector.InspectorPanel");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((ip = (InspectorPanel)WindowUtils.getParent(this, clazz)) != null) {
                    Vector allMice = MouseManager.getActualMiceOfLines(ip.ivSelObjects);
                    TableFrameMouse.displayMiceAndSort(new MTMouseStress(allMice), null, Babel.get("MOUSE_COLLECTION"), null);
                }
            }
            return true;
        }
    }
}

