/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.mouse.tierschutz;

import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.util.ArrayHelper;
import de.hannse.netobjects.util.Babel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.MatteBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mausoleum.gui.MGButton;
import mausoleum.helper.FontManager;
import mausoleum.inspector.Inspector;
import mausoleum.line.Line;
import mausoleum.locus.LocusAndAlleles;
import mausoleum.mouse.Mouse;
import mausoleum.mouse.tierschutz.Stress;
import mausoleum.mouse.tierschutz.StressRule;
import mausoleum.requester.BasicRequester;
import mausoleum.requester.mouse.SelectGenotypeRequester;
import mausoleum.ui.UIDef;

public class StressRuleRequester
extends BasicRequester {
    private static final long serialVersionUID = 1L;
    private static final Font LABEL_FONT = FontManager.getFont("SSB12");
    private static final int LIST_HEIGHT = 250;
    private static Object[] NIX_OBJ = new Object[0];
    private static final String[] ZEILEN_LABELS = new String[]{StringHelper.capitalize(Babel.get("STRESS")), StringHelper.capitalize(Babel.get("SEX")), StringHelper.capitalize(Babel.get("AGE")), StringHelper.capitalize(Babel.get("GENOTYPE"))};
    private static final String[] SEX_LABELS = new String[]{Babel.get("DOESNTMATTER"), Babel.get("MALE"), Babel.get("FEMALE")};
    private static int[] SEX_INTS;
    private static final String COM_ADD_GT = "ADDGT";
    private static final String COM_REM_GT = "REMGT";
    private static final Mouse OPFER_MOUSE;
    private static final Vector OPFER_VECTOR;
    private static StressRuleRequester cvInstance;
    private final JComboBox ivBelastungsCombo = new JComboBox<String>(Stress.STRESS_TEXTS_OHNE_NOT_DEF);
    private final JComboBox ivSexCombo = new JComboBox<String>(SEX_LABELS);
    private final JComboBox ivAgeCombo;
    private final JList ivGenotypeList = new JList();
    private final MGButton ivAddGTButton = MGButton.getInspectorActionButton(Babel.get("ADD"), "ADDGT");
    private final MGButton ivDelGTButton = MGButton.getInspectorActionButton(Babel.get("REMOVE"), "REMGT");
    private boolean ivWarOK = false;
    private StressRule ivStressRule = null;
    private Line ivLine = null;
    private JLabel ivGenotypeLabel = new JLabel();

    static {
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        SEX_INTS = nArray;
        OPFER_MOUSE = new Mouse();
        OPFER_VECTOR = new Vector();
        cvInstance = new StressRuleRequester();
    }

    public static StressRule editRule(Line line, StressRule orig) {
        StressRuleRequester.cvInstance.ivWarOK = false;
        cvInstance.adapt(orig);
        StressRuleRequester.cvInstance.ivLine = line;
        cvInstance.setVisible(true);
        return StressRuleRequester.cvInstance.ivWarOK ? StressRuleRequester.cvInstance.ivStressRule : null;
    }

    private StressRuleRequester() {
        super((Frame)Inspector.getInspector(), 0, 0);
        OPFER_VECTOR.add(OPFER_MOUSE);
        int labelWidth = this.getWidth(ZEILEN_LABELS, LABEL_FONT);
        int fieldWidth = 400;
        int innerWidth = labelWidth + UIDef.INNER_RAND + fieldWidth;
        int y = UIDef.RAND;
        int x1 = UIDef.RAND;
        int x2 = x1 + labelWidth + UIDef.INNER_RAND;
        int zeilenindex = 0;
        this.addAndApplyBounds(this.getZeilenLabel(zeilenindex), x1, y, labelWidth, UIDef.LINE_HEIGHT);
        this.ivBelastungsCombo.addActionListener(this);
        this.addAndApplyBounds(this.ivBelastungsCombo, x2, y, fieldWidth, UIDef.LINE_HEIGHT);
        this.addAndApplyBounds(this.getZeilenLabel(++zeilenindex), x1, y += UIDef.LINE_HEIGHT + UIDef.INNER_RAND, labelWidth, UIDef.LINE_HEIGHT);
        this.ivSexCombo.addActionListener(this);
        this.addAndApplyBounds(this.ivSexCombo, x2, y, fieldWidth, UIDef.LINE_HEIGHT);
        y += UIDef.LINE_HEIGHT + UIDef.INNER_RAND;
        ++zeilenindex;
        Vector<String> v = new Vector<String>();
        v.add(Babel.get("DOESNTMATTER"));
        v.add(String.valueOf(Babel.get("OLDER_THAN")) + " 1 " + Babel.get("WEEK"));
        int i = 2;
        while (i <= 100) {
            v.add(String.valueOf(Babel.get("OLDER_THAN")) + " " + i + " " + Babel.get("WEEKS"));
            ++i;
        }
        this.ivAgeCombo = new JComboBox(v);
        this.addAndApplyBounds(this.getZeilenLabel(zeilenindex), x1, y, labelWidth, UIDef.LINE_HEIGHT);
        this.ivAgeCombo.addActionListener(this);
        this.addAndApplyBounds(this.ivAgeCombo, x2, y, fieldWidth, UIDef.LINE_HEIGHT);
        y += UIDef.LINE_HEIGHT + UIDef.INNER_RAND;
        ++zeilenindex;
        JScrollPane jsp = new JScrollPane(this.ivGenotypeList);
        this.ivGenotypeLabel.setFont(FontManager.getFont("SSB11"));
        this.ivGenotypeLabel.setBorder(new MatteBorder(0, 0, 1, 0, Color.black));
        this.ivGenotypeList.setCellRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                LocusAndAlleles[] arr = (LocusAndAlleles[])value;
                StringBuilder msb = new StringBuilder();
                int j = 0;
                while (j < arr.length) {
                    msb.append(arr[j].toGenotypeStringMultiFont(StressRuleRequester.this.ivLine.getGroup()));
                    ++j;
                }
                String s = msb.toString();
                s = StringHelper.gSub(s, "</html><html>", "; ");
                StressRuleRequester.this.ivGenotypeLabel.setText(s);
                StressRuleRequester.this.ivGenotypeLabel.setOpaque(isSelected);
                StressRuleRequester.this.ivGenotypeLabel.setBackground(isSelected ? UIDef.SELECTED_BACKGROUND : null);
                return StressRuleRequester.this.ivGenotypeLabel;
            }
        });
        this.ivGenotypeList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    StressRuleRequester.this.ivDelGTButton.setEnabled(StressRuleRequester.this.ivGenotypeList.getSelectedIndex() != -1);
                }
            }
        });
        this.ivGenotypeList.setSelectionMode(0);
        JPanel pan = new JPanel(new BorderLayout());
        pan.add("Center", jsp);
        pan.setOpaque(false);
        JPanel bpan = new JPanel(new GridLayout(1, 2));
        bpan.setOpaque(false);
        this.ivAddGTButton.addActionListener(this);
        bpan.add(this.ivAddGTButton);
        this.ivDelGTButton.addActionListener(this);
        bpan.add(this.ivDelGTButton);
        pan.add("South", bpan);
        this.addAndApplyBounds(this.getZeilenLabel(zeilenindex), x1, y, labelWidth, UIDef.LINE_HEIGHT);
        this.addAndApplyBounds(pan, x2, y, fieldWidth, 250 + UIDef.BUT_HEIGHT);
        ++zeilenindex;
        this.applyBounds(this.ivOkButton, x1, y += 250 + UIDef.BUT_HEIGHT + UIDef.RAND, innerWidth, UIDef.BUT_HEIGHT);
        this.setInnerSize(innerWidth + 2 * UIDef.RAND, y += UIDef.BUT_HEIGHT + UIDef.RAND);
    }

    private void adapt(StressRule orig) {
        this.ivStressRule = orig == null ? new StressRule() : new StressRule(orig);
        this.ivBelastungsCombo.setSelectedIndex(ArrayHelper.findIndexInArray(this.ivStressRule.ivStress, Stress.STRESS_INTS_OHNE_NOT_DEF));
        this.ivSexCombo.setSelectedIndex(ArrayHelper.findIndexInArray(this.ivStressRule.ivSex, SEX_INTS));
        this.ivAgeCombo.setSelectedIndex(this.ivStressRule.ivMinWeeks);
        this.ivGenotypeList.setListData(this.ivStressRule.ivGenotypes == null ? NIX_OBJ : this.ivStressRule.ivGenotypes);
        this.ivDelGTButton.setEnabled(false);
    }

    public boolean okAndNoWanted() {
        return false;
    }

    public boolean onlyOKWanted() {
        return true;
    }

    public void OKPressed() {
        this.ivWarOK = true;
        this.setVisible(false);
    }

    private JLabel getZeilenLabel(int nummer) {
        JLabel lab = new JLabel(ZEILEN_LABELS[nummer]);
        lab.setFont(LABEL_FONT);
        lab.setOpaque(false);
        return lab;
    }

    public void actionPerformed(ActionEvent e) {
        int ind;
        if (e.getSource() == this.ivBelastungsCombo) {
            this.ivStressRule.ivStress = Stress.STRESS_INTS_OHNE_NOT_DEF[this.getIndex(this.ivBelastungsCombo, 0)];
        } else if (e.getSource() == this.ivSexCombo) {
            this.ivStressRule.ivSex = SEX_INTS[this.getIndex(this.ivSexCombo, 0)];
        } else if (e.getSource() == this.ivAgeCombo) {
            this.ivStressRule.ivMinWeeks = this.getIndex(this.ivAgeCombo, 0);
        }
        String ac = e.getActionCommand();
        if (COM_ADD_GT.equals(ac)) {
            OPFER_MOUSE.set("MOS_LOCUSGENOTYPES", null);
            OPFER_MOUSE.commit(false);
            SelectGenotypeRequester.setGenotype(OPFER_VECTOR, this.ivLine);
            LocusAndAlleles[] arr = (LocusAndAlleles[])OPFER_MOUSE.get("MOS_LOCUSGENOTYPES");
            if (arr != null && arr.length != 0) {
                this.ivStressRule.ivGenotypes = ArrayHelper.enlargeObjectArray(this.ivStressRule.ivGenotypes, arr);
                this.ivGenotypeList.setListData(this.ivStressRule.ivGenotypes == null ? NIX_OBJ : this.ivStressRule.ivGenotypes);
            }
        } else if (COM_REM_GT.equals(ac) && (ind = this.ivGenotypeList.getSelectedIndex()) != -1) {
            this.ivStressRule.ivGenotypes = ArrayHelper.shrinkObjectArray(this.ivStressRule.ivGenotypes, ind);
            this.ivGenotypeList.setListData(this.ivStressRule.ivGenotypes == null ? NIX_OBJ : this.ivStressRule.ivGenotypes);
        }
        super.actionPerformed(e);
    }

    private int getIndex(JComboBox combo, int defVal) {
        int res = combo.getSelectedIndex();
        return res == -1 ? defVal : res;
    }
}

