/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.mouse.tierschutz;

import de.hannse.netobjects.objectstore.IDObjectXMLHandler;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.RequestManager;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.GregorianCalendar;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import mausoleum.alert.Alert;
import mausoleum.factsheets.FactSheetComponentScreen;
import mausoleum.factsheets.IDObjectMerker;
import mausoleum.factsheets.PrintElementFactSheet;
import mausoleum.gui.ColorManager;
import mausoleum.helper.DatumFormat;
import mausoleum.helper.FocusHoler;
import mausoleum.helper.MausoleumImageStore;
import mausoleum.mouse.tierschutz.TierSchutzReportD1FS;
import mausoleum.mouse.tierschutz.TierschutzReport;
import mausoleum.tables.MausoleumTable;
import mausoleum.tables.models.MTMouseTSRD1;
import mausoleum.ui.UIDef;

public class TierSchutzReportD1Client
extends JFrame
implements Runnable {
    private static final long serialVersionUID = 1816186156L;
    private final FactSheetComponentScreen ivComponent;
    private final JScrollPane ivScrollpane;
    private TierSchutzReportD1FS ivFS = new TierSchutzReportD1FS();
    public String ivTicket;
    public int[] ivArr;
    public int ivStart;
    public int ivEnd;
    public boolean ivComplete = false;
    public String ivLink = null;
    private final MTMouseTSRD1 ivMouseModel = new MTMouseTSRD1();
    private final MausoleumTable ivMouseTable = new MausoleumTable(this.ivMouseModel, false);

    public static void showReport() {
        int[] arr = TierschutzReport.getReportAndDates(1);
        if (arr != null) {
            String ticket = (String)RequestManager.createSendAndGetObjectIfFinished((byte)84, arr, UserManager.getFirstGroup());
            if (ticket != null) {
                new TierSchutzReportD1Client(arr, ticket);
            } else {
                Alert.showAlert(Babel.get("REPORT_NOT_POSSIBLE"), true);
            }
        }
    }

    private TierSchutzReportD1Client(int[] arr, String ticket) {
        this.setTitle(Babel.get("REP_TS_D1"));
        this.setIconImage(MausoleumImageStore.getLogo());
        this.ivStart = arr[2];
        this.ivEnd = arr[3];
        this.ivTicket = ticket;
        this.ivArr = arr;
        new Thread(this).start();
        this.ivComponent = new FactSheetComponentScreen(true);
        this.ivScrollpane = new JScrollPane(this.ivComponent);
        this.ivScrollpane.setVerticalScrollBarPolicy(22);
        this.ivScrollpane.setHorizontalScrollBarPolicy(31);
        this.ivScrollpane.getVerticalScrollBar().setUnitIncrement(20);
        this.ivScrollpane.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                TierSchutzReportD1Client.this.ivComponent.manageResize();
                TierSchutzReportD1Client.this.ivScrollpane.repaint();
            }
        });
        this.ivComponent.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                if (e.isMetaDown()) {
                    JPopupMenu erg = new JPopupMenu();
                    TierSchutzReportD1Client.this.ivComponent.addPopupItems(erg);
                    erg.show(TierSchutzReportD1Client.this.ivComponent, e.getX(), e.getY());
                }
            }

            public void mousePressed(MouseEvent e) {
                TierSchutzReportD1Client.this.ivLink = null;
                Object o = TierSchutzReportD1Client.this.ivComponent.getElementAt(e.getPoint(), -1);
                if (o instanceof PrintElementFactSheet) {
                    PrintElementFactSheet pe = (PrintElementFactSheet)o;
                    TierSchutzReportD1Client.this.ivLink = pe.ivLink;
                    if (TierSchutzReportD1Client.this.ivLink != null && TierSchutzReportD1Client.this.ivLink.trim().length() != 0) {
                        TierSchutzReportD1Client.this.ivComponent.setCursor(Cursor.getPredefinedCursor(3));
                        try {
                            if (!e.isMetaDown()) {
                                TierSchutzReportD1Client.this.ivMouseTable.setHeader(pe.ivLinkDescr);
                                TierSchutzReportD1Client.this.ivMouseModel.setTable(IDObjectMerker.getObjectsFromLink(TierSchutzReportD1Client.this.ivLink));
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        TierSchutzReportD1Client.this.ivComponent.setCursor(Cursor.getDefaultCursor());
                    }
                }
            }
        });
        this.ivMouseTable.setHeader("");
        this.ivMouseTable.setIsSubdisplay();
        JSplitPane jsp = new JSplitPane(0);
        jsp.setResizeWeight(0.7);
        this.getContentPane().add(jsp);
        jsp.add(this.ivScrollpane);
        jsp.add(this.ivMouseTable);
        this.handleResult("|");
        this.setBounds(UIDef.getScaled(10), UIDef.getScaled(10), UIDef.getScaled(800), UIDef.getScaled(700));
        if (!this.ivComponent.hasFocus()) {
            new FocusHoler(this.ivComponent);
        }
        this.setVisible(true);
    }

    public void run() {
        while (!this.ivComplete) {
            try {
                Thread.sleep(2000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String res = (String)RequestManager.createSendAndGetObjectIfFinished((byte)84, this.ivArr, UserManager.getFirstGroup(), this.ivTicket);
            if (res != null) {
                if (res.startsWith("INTERMEDIATE")) {
                    this.handleResult(res);
                    continue;
                }
                this.handleResult(IDObjectXMLHandler.getObject(res, UserManager.getFirstGroup(), true));
                this.ivComplete = true;
                continue;
            }
            this.ivComplete = true;
            Alert.showAlert(Babel.get("REPORT_NOT_POSSIBLE"), true);
        }
    }

    private void handleResult(Object ooo) {
        this.ivComponent.setBackground(ooo instanceof String ? ColorManager.getColorFromString("gainsboro") : Color.white);
        Vector target = new Vector();
        int y = this.ivFS.addPrintElements(UserManager.getFirstGroup(), new TSD1Rep(ooo, this.ivStart, this.ivEnd), 0, 600, target, null, null);
        this.ivComponent.setElements(target, y);
        this.ivComponent.revalidate();
        this.ivComponent.repaint();
        if (!(ooo instanceof String)) {
            this.ivComponent.setPrintDelegate(this.ivFS);
        }
    }

    public static class TSD1Rep {
        public String ivTitel;
        public String ivZeitraum;
        public String ivZeitpunkt;
        public Object ivObject;

        public TSD1Rep(Object ooo, int start, int end) {
            this.ivObject = ooo;
            this.ivTitel = String.valueOf(Babel.get("REP_TS_D1")) + " " + Babel.get("GROUP") + " " + UserManager.getGroupOfUser();
            this.ivZeitraum = "Berichtstzeitraum: " + DatumFormat.getJustDateString(start) + " - " + DatumFormat.getJustDateString(end);
            this.ivZeitpunkt = "Bericht erstellt: " + DatumFormat.getDateTimeString(new GregorianCalendar());
        }
    }
}

