/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.objectstore;

import de.hannse.netobjects.objectstore.CommandManagerExecutive;
import de.hannse.netobjects.tools.Base64Manager;
import java.util.Date;
import mausoleum.building.Building;
import mausoleum.helper.Zeile;

public class CommandManagerBuilding
extends CommandManagerExecutive {
    public static final String COM_BLDG_NEW = "BLDGNEW";
    public static final String COM_BLDG_RM = "BLDGRM";
    public static final String COM_BLDG_CHNAME = "BLDGCHNAME";
    public static final String COM_BLDG_CHCOMMENT = "BLDGCHCOMMENT";

    public CommandManagerBuilding() {
        super(22);
        this.addMeth(COM_BLDG_NEW, "handleBLDGNEW", 2, false);
        this.addMeth(COM_BLDG_RM, "handleBLDGREMOVE", 2, true);
        this.addMeth(COM_BLDG_CHNAME, "handleBLDGCHNAME", 3, true);
        this.addMeth(COM_BLDG_CHCOMMENT, "handleBLDGCHCOMMENT", 3, true);
    }

    public String getParsedCommandIfTouched(String command, Zeile z, String group, int typ, long id, String objectGroup) {
        if (command.equals(COM_BLDG_NEW)) {
            if (typ == 0 && id == 0L) {
                return "Created new building";
            }
            return null;
        }
        if (command.equals(COM_BLDG_RM)) {
            if (typ == 0 && id == 0L) {
                return "Removed building " + this.getIDObjectRef(group, 22, z.getLong(1, 0L), objectGroup);
            }
            if (typ == 22 && z.getLong(1, 0L) == id) {
                return "Removed building";
            }
            return null;
        }
        if (command.equals(COM_BLDG_CHNAME)) {
            if (typ == 0 && id == 0L) {
                String bldgref = this.getIDObjectRef(group, 22, z.getLong(1, 0L), objectGroup);
                return CommandManagerBuilding.getPB64String("Changed name of building " + bldgref + " to: ", z, 2);
            }
            if (typ == 22 && z.getLong(1, 0L) == id) {
                return CommandManagerBuilding.getPB64String("Changed name to: ", z, 2);
            }
            return null;
        }
        if (command.equals(COM_BLDG_CHCOMMENT)) {
            if (typ == 0 && id == 0L) {
                String bldgref = this.getIDObjectRef(group, 22, z.getLong(1, 0L), objectGroup);
                return CommandManagerBuilding.getPB64String("Set comment of building " + bldgref + " to: ", z, 2);
            }
            if (typ == 22 && z.getLong(1, 0L) == id) {
                return CommandManagerBuilding.getPB64String("Set comment to: ", z, 2);
            }
            return null;
        }
        return "CME_NP";
    }

    public boolean handleBLDGNEW() {
        Building building = new Building();
        building.set("BLD_NAME", Base64Manager.getDecodedString(this.ivLine[1]));
        return this.finishNewObject(building, null);
    }

    public boolean handleBLDGCHNAME() {
        this.ivObjectForCommand.setAndPropagateAttributes(this.ivObjectBag, null, "BLD_NAME", Base64Manager.getDecodedString(this.ivLine[2]));
        return true;
    }

    public boolean handleBLDGCHCOMMENT() {
        this.ivObjectForCommand.setAndPropagateAttributes(this.ivObjectBag, null, "BLD_DESC", Base64Manager.getDecodedString(this.ivLine[2]));
        return true;
    }

    public boolean handleBLDGREMOVE() {
        this.ivObjectForCommand.setAndPropagateAttributes(this.ivObjectBag, null, "IDO_END_DATE", new Date());
        return true;
    }
}

