/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.objectstore;

import de.hannse.netobjects.objectstore.CommandManagerExecutive;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.objectstore.ObjectStoreServer;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.util.ArrayHelper;
import de.hannse.netobjects.util.Log;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.cage.cagetalker.CageTalker;
import mausoleum.helper.AllgUtils;
import mausoleum.helper.DatumFormat;
import mausoleum.helper.Zeile;
import mausoleum.mouse.Mouse;
import mausoleum.mouse.TaskExtended;
import mausoleum.objectstore.CommanManUtil;
import mausoleum.rack.Rack;
import mausoleum.rack.RackPos;
import mausoleum.room.Room;
import mausoleum.visit.Visit;

public class CommandManagerCage
extends CommandManagerExecutive {
    public static final String COM_CAG_NEW = "CN";
    public static final String COM_CAG_NEW_ROOMID = "CN_ROOMID";
    public static final String COM_CAG_NEW_UNIQUE = "CN_UNIQUE";
    public static final String COM_CAG_NEW_UNIQUE_ROOMID = "CN_UNIQUE_ROOMID";
    public static final String COM_CAG_REMOVE = "CR";
    public static final String COM_CAG_SETTAG = "CSTG";
    public static final String COM_CAG_SETRACKPOS = "CSETR";
    public static final String COM_CAG_CLEAN = "CCLEAN";
    public static final String COM_CAG_CONTIG = "CCONTIG";
    public static final String COM_CAG_SET_COMMENT = "CSETC";
    public static final String COM_CAG_NEW_DOUBLE = "CNDOUBLE";
    public static final String COM_CAG_NEW_DOUBLE_ROOMID = "CNDOUBLE_ROOMID";
    public static final String COM_CAG_SET_LICENSEID = "CLICENSEID";
    public static final String COM_CAG_SET_PSEUDOID = "CPSEUODID";
    public static final String COM_CAG_SET_ANTAG = "CSETANTAG";
    public static final String COM_CAG_ADD_COMMENT = "CADDC";
    public static final String COM_CAG_TRANSFER_TO_ROOM = "CTRR";
    public static final String COM_CAG_SET_CAGE_TALKER_ID = "CSETCAGETLAKERID";
    public static final String COM_CAG_END_VISIT = "CENDVISIT";
    static /* synthetic */ Class class$0;

    public CommandManagerCage() {
        super(2);
        this.addMeth(COM_CAG_NEW, "handleCAGNEW", 2, false);
        this.addMeth(COM_CAG_NEW_ROOMID, "handleCAGNEW_ROOMID", 3, false);
        this.addMeth(COM_CAG_NEW_UNIQUE, "handleCAGNEW_UNIQUE", 3, false);
        this.addMeth(COM_CAG_NEW_UNIQUE_ROOMID, "handleCAGNEW_UNIQUE_ROOMID", 4, false);
        this.addMeth(COM_CAG_NEW_DOUBLE, "handleCAGNEWDOUBLE", 2, false);
        this.addMeth(COM_CAG_NEW_DOUBLE_ROOMID, "handleCAGNEWDOUBLE_ROOMID", 3, false);
        this.addMeth(COM_CAG_REMOVE, "handleCAGRM", 3, true);
        this.addMeth(COM_CAG_SETTAG, "handleCAGSETTAG", 3, true);
        this.addMeth(COM_CAG_SETRACKPOS, "handleCAGSETRACKPOS", -1, false);
        this.addMeth(COM_CAG_CLEAN, "handleCAGCLEAN", 2, true);
        this.addMeth(COM_CAG_CONTIG, "handleCAGCONTIG", -1, false);
        this.addMeth(COM_CAG_SET_COMMENT, "handleCAG_SET_COMMENT", 3, true);
        this.addMeth(COM_CAG_SET_LICENSEID, "handleCAG_SET_LICENSEID", 3, true);
        this.addMeth(COM_CAG_SET_PSEUDOID, "handleCAG_SET_PSEUDOID", 3, true);
        this.addMeth(COM_CAG_SET_ANTAG, "handleCAG_SET_ANTAG", 3, true);
        this.addMeth(COM_CAG_ADD_COMMENT, "handleCAG_ADD_COMMENT", 3, true);
        this.addMeth(COM_CAG_TRANSFER_TO_ROOM, "handleCOM_CAG_TRANSFER_TO_ROOM", 4, true);
        this.addMeth(COM_CAG_SET_CAGE_TALKER_ID, "handleCAG_SET_CAGETALKER_ID", 3, true);
        this.addMeth(COM_CAG_END_VISIT, "handleCOM_CAG_END_VISIT", 7, true);
    }

    public String getParsedCommandIfTouched(String command, Zeile z, String group, int typ, long id, String objectGroup) {
        if (command.equals(COM_CAG_NEW) || command.equals(COM_CAG_NEW_ROOMID) || command.equals(COM_CAG_NEW_UNIQUE) || command.equals(COM_CAG_NEW_UNIQUE_ROOMID)) {
            if (typ == 0 && id == 0L) {
                return "Created new cage";
            }
            return null;
        }
        if (command.equals(COM_CAG_REMOVE)) {
            if (typ == 0 && id == 0L) {
                return "Removed cage " + this.getIDObjectRef(group, 2, z.getLong(1, 0L), objectGroup);
            }
            if (typ == 2 && z.getLong(1, 0L) == id) {
                return "Removed cage";
            }
            return null;
        }
        if (command.equals(COM_CAG_SETTAG)) {
            if (typ == 0 && id == 0L) {
                String mark = z.getString(2, "");
                if (mark.equals("f")) {
                    return "Cleared mark of cage " + this.getIDObjectRef(group, 2, z.getLong(1, 0L), objectGroup);
                }
                if (mark.equals("t")) {
                    return "Set standard mark for cage " + this.getIDObjectRef(group, 2, z.getLong(1, 0L), objectGroup);
                }
                return "Set mark: " + mark + " for cage " + this.getIDObjectRef(group, 2, z.getLong(1, 0L), objectGroup);
            }
            if (typ == 2 && z.getLong(1, 0L) == id) {
                String mark = z.getString(2, "");
                if (mark.equals("f")) {
                    return "Cleared mark";
                }
                if (mark.equals("t")) {
                    return "Set standard mark";
                }
                return "Set mark: " + mark;
            }
            return null;
        }
        if (command.equals(COM_CAG_SETRACKPOS)) {
            Cage cage;
            if (typ == 0 && id == 0L) {
                String cagRef = this.getIDObjectRef(group, 2, z.getLong(1, 0L), objectGroup);
                if (z.size() < 6) {
                    return "Moved cage " + cagRef + " to transfer area";
                }
                String rackRef = this.getIDObjectRef(group, 3, z.getLong(2, 0L), objectGroup);
                int side = z.getInt(3, 0);
                int row = z.getInt(4, 0);
                int col = z.getInt(5, 0);
                if (side == 0) {
                    return "Moved cage " + cagRef + " to rack: " + rackRef + " front row: " + row + " column: " + col;
                }
                return "Moved cage " + cagRef + " to rack: " + rackRef + " rear row: " + row + " column: " + col;
            }
            if (typ == 2 && z.getLong(1, 0L) == id) {
                if (z.size() < 6) {
                    return "Moved to transfer area";
                }
                Rack rack = (Rack)this.getIDObject(group, 3, z.getLong(2, 0L));
                if (rack != null) {
                    int side = z.getInt(3, 0);
                    int row = z.getInt(4, 0);
                    int col = z.getInt(5, 0);
                    if (side == 0) {
                        return "Moved to rack: " + rack.getName() + " front row: " + row + " column: " + col;
                    }
                    return "Moved to rack: " + rack.getName() + " rear row: " + row + " column: " + col;
                }
            } else if (typ == 3 && z.getLong(2, 0L) == id && z.size() >= 6 && (cage = (Cage)this.getIDObject(group, 2, z.getLong(1, 0L))) != null) {
                int side = z.getInt(3, 0);
                int row = z.getInt(4, 0);
                int col = z.getInt(5, 0);
                if (side == 0) {
                    return "Moved cage " + cage.getLabelIDString() + " to front row: " + row + " column: " + col;
                }
                return "Moved cage " + cage.getLabelIDString() + " to rear row: " + row + " column: " + col;
            }
            return null;
        }
        if (command.equals(COM_CAG_CLEAN)) {
            if (typ == 0 && id == 0L) {
                String cagRef = this.getIDObjectRef(group, 2, z.getLong(1, 0L), objectGroup);
                return "Removed inactive mice from cage " + cagRef;
            }
            if (typ == 2 && z.getLong(1, 0L) == id) {
                return "removed inactive mice";
            }
            return null;
        }
        if (command.equals(COM_CAG_CONTIG)) {
            if (typ == 0 && id == 0L) {
                String cagRef = this.getIDObjectRef(group, 2, z.getLong(1, 0L), objectGroup);
                return "changed cage number in order to get subsequent cage numbers for cage " + cagRef;
            }
            if (typ == 2 && z.getLong(1, 0L) == id) {
                return "changed cage number in order to get subsequent cage numbers";
            }
            return null;
        }
        if (command.equals(COM_CAG_SET_COMMENT)) {
            if (typ == 0 && id == 0L) {
                String cagRef = this.getIDObjectRef(group, 2, z.getLong(1, 0L), objectGroup);
                return CommandManagerCage.getPB64String("Set comment for cage" + cagRef + " to: ", z, 2);
            }
            if (typ == 2 && z.getLong(1, 0L) == id) {
                return CommandManagerCage.getPB64String("Set comment to: ", z, 2);
            }
            return null;
        }
        if (command.equals(COM_CAG_ADD_COMMENT)) {
            if (typ == 0 && id == 0L) {
                String cagRef = this.getIDObjectRef(group, 2, z.getLong(1, 0L), objectGroup);
                return CommandManagerCage.getPB64String("Added to comment of cage " + cagRef + ": ", z, 2);
            }
            if (typ == 2 && z.getLong(1, 0L) == id) {
                return CommandManagerCage.getPB64String("Added to comment: ", z, 2);
            }
            return null;
        }
        if (command.equals(COM_CAG_NEW_DOUBLE) || command.equals(COM_CAG_NEW_DOUBLE_ROOMID)) {
            if (typ == 0 && id == 0L) {
                return "Created new double cage";
            }
            return null;
        }
        if (command.equals(COM_CAG_SET_LICENSEID)) {
            if (typ == 0 && id == 0L) {
                String cagRef = this.getIDObjectRef(group, 2, z.getLong(1, 0L), objectGroup);
                return CommandManagerCage.getPB64String("Set license-ID for cage" + cagRef + " to: ", z, 2);
            }
            if (typ == 2 && z.getLong(1, 0L) == id) {
                return CommandManagerCage.getPB64String("Set license-ID to: ", z, 2);
            }
            return null;
        }
        if (command.equals(COM_CAG_SET_PSEUDOID)) {
            if (typ == 0 && id == 0L) {
                String cagRef = this.getIDObjectRef(group, 2, z.getLong(1, 0L), objectGroup);
                return "Set cage number for cage " + cagRef + " to: " + z.getInt(2, 0);
            }
            if (typ == 2 && z.getLong(1, 0L) == id) {
                return "Set cage number to: " + z.getInt(2, 0);
            }
            return null;
        }
        if (command.equals(COM_CAG_SET_ANTAG)) {
            if (typ == 0 && id == 0L) {
                String cagRef = this.getIDObjectRef(group, 2, z.getLong(1, 0L), objectGroup);
                return CommandManagerCage.getPB64String("Set alphanumerical tag for cage" + cagRef + " to: ", z, 2);
            }
            if (typ == 2 && z.getLong(1, 0L) == id) {
                return CommandManagerCage.getPB64String("Set alphanumerical tag to: ", z, 2);
            }
            return null;
        }
        if (command.equals(COM_CAG_SET_CAGE_TALKER_ID)) {
            if (typ == 0 && id == 0L) {
                String cagRef = this.getIDObjectRef(group, 2, z.getLong(1, 0L), objectGroup);
                return CommandManagerCage.getPB64String("Set CagetalkerID for cage" + cagRef + " to: ", z, 2);
            }
            if (typ == 2 && z.getLong(1, 0L) == id) {
                return CommandManagerCage.getPB64String("Set CagetalkerID tag to: ", z, 2);
            }
            return null;
        }
        if (command.equals(COM_CAG_TRANSFER_TO_ROOM)) {
            if (typ == 0 && id == 0L) {
                String cagRef = this.getIDObjectRef(group, 2, z.getLong(1, 0L), objectGroup);
                String roomRef = this.getIDObjectRef(group, 10, z.getLong(2, 0L), objectGroup);
                return "Transfered cage " + cagRef + " to room " + roomRef + " at " + DatumFormat.getDateTimeString(z.getString(3, ""), "");
            }
            if (typ == 2 && z.getLong(1, 0L) == id) {
                Room room = (Room)this.getIDObject(group, 10, z.getLong(2, 0L));
                if (room != null) {
                    return "Transfered to room " + room.getBrowseName() + " at " + DatumFormat.getDateTimeString(z.getString(3, ""), "");
                }
            } else if (typ == 10 && z.getLong(2, 0L) == id) {
                String cagRef = this.getIDObjectRef(group, 2, z.getLong(1, 0L), objectGroup);
                return "Imported cage " + cagRef + " at " + DatumFormat.getDateTimeString(z.getString(3, ""), "");
            }
            return null;
        }
        return "CME_NP";
    }

    public boolean handleCAGRM() {
        Cage cage = (Cage)this.ivObjectForCommand;
        if (cage != null) {
            Long serviceRoomID = cage.getServiceRoomID();
            Vector<Cage> v = new Vector<Cage>();
            v.add(cage);
            this.markObjectsForServiceRoom(v, serviceRoomID != null ? serviceRoomID : AllgUtils.NIX_ROOM);
        }
        String[] bruddel = new String[1];
        boolean res = CommandManagerCage.removeCage(cage, this.ivObjectBag, Long.parseLong(this.ivLine[2]), bruddel, this.ivServiceRoomOverride, false);
        if (bruddel[0] != null) {
            this.ivBugString = bruddel[0];
        }
        return res;
    }

    public static boolean removeCage(Cage cage, Hashtable objectBag, long millis, String[] bruddel, HashMap serviceRoomOverride, boolean removalOfFilledCageAllowed) {
        if (!removalOfFilledCageAllowed && cage.hasUnfinishedVisits()) {
            String bugString = "The cage cannot be removed because there are stil mice in the cage! Eventually the local cache is not up to date. Try to clear the directory 'files/client' within your local Mausoleum directory.";
            String string = String.valueOf(bugString) + "\nGroup: " + cage.getGroup() + " Cage: " + cage.toString();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("mausoleum.objectstore.CommandManagerCage");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.info(string, clazz);
            bruddel[0] = bugString;
            return false;
        }
        bruddel[0] = CommandManagerCage.removeCageFromRack(cage, objectBag, serviceRoomOverride);
        if (bruddel[0] != null) {
            return false;
        }
        cage.setDate("IDO_END_DATE", millis);
        if (cage.hasSubCages()) {
            Cage cr;
            Cage cl = (Cage)ObjectStoreServer.getObjectDeadOrAlive(2, cage.getLong("CAG_SUBCAGEL"), cage.getGroup(), objectBag, false, false);
            if (cl != null) {
                cl.setDate("IDO_END_DATE", millis);
                objectBag.put(cl.getIdentifierString(), cl);
            }
            if ((cr = (Cage)ObjectStoreServer.getObjectDeadOrAlive(2, cage.getLong("CAG_SUBCAGER"), cage.getGroup(), objectBag, false, false)) != null) {
                cr.setDate("IDO_END_DATE", millis);
                objectBag.put(cr.getIdentifierString(), cr);
            }
        }
        TaskExtended.handleTasksOfRemovedObject(cage, "CAG_TASKS", objectBag);
        return true;
    }

    public boolean handleCAGNEW() {
        Cage newCage = new Cage();
        newCage.setInt("CAG_PSEUDOID", CommandManagerCage.findNextPseudoID(this.ivGroupname));
        this.finishNewObject(newCage, this.ivLine[1]);
        return true;
    }

    public boolean handleCAGNEW_ROOMID() {
        Cage newCage = new Cage();
        newCage.setInt("CAG_PSEUDOID", CommandManagerCage.findNextPseudoID(this.ivGroupname));
        newCage.setLong("CAG_ROOM", Long.parseLong(this.ivLine[2]));
        this.finishNewObject(newCage, this.ivLine[1]);
        this.markObjectForServiceRoom(newCage, newCage.getLong("CAG_ROOM", 0L));
        return true;
    }

    public boolean handleCAGNEW_UNIQUE() {
        Cage newCage = new Cage();
        newCage.setInt("CAG_PSEUDOID", CommandManagerCage.findNextPseudoID(this.ivGroupname));
        newCage.setLong("IDO_UNIQUELONG", this.ivLine[2]);
        this.finishNewObject(newCage, this.ivLine[1]);
        return true;
    }

    public boolean handleCAGNEW_UNIQUE_ROOMID() {
        Cage newCage = new Cage();
        newCage.setInt("CAG_PSEUDOID", CommandManagerCage.findNextPseudoID(this.ivGroupname));
        newCage.setLong("IDO_UNIQUELONG", this.ivLine[2]);
        newCage.setLong("CAG_ROOM", this.ivLine[3]);
        this.finishNewObject(newCage, this.ivLine[1]);
        this.markObjectForServiceRoom(newCage, newCage.getLong("CAG_ROOM", 0L));
        return true;
    }

    public boolean handleCAGNEWDOUBLE() {
        this.createDoubleCages();
        return true;
    }

    public boolean handleCAGNEWDOUBLE_ROOMID() {
        Vector v = this.createDoubleCages();
        Iterator iter = v.iterator();
        while (iter.hasNext()) {
            Cage cage = (Cage)iter.next();
            cage.setLong("CAG_ROOM", Long.parseLong(this.ivLine[2]));
        }
        return true;
    }

    private Vector createDoubleCages() {
        Cage superCage = new Cage();
        Cage subCageLeft = new Cage();
        Cage subCageRight = new Cage();
        int ctpseudoid = CommandManagerCage.findNextPseudoID(this.ivGroupname);
        superCage.setInt("CAG_PSEUDOID", ctpseudoid);
        subCageLeft.setInt("CAG_PSEUDOID", ctpseudoid);
        subCageRight.setInt("CAG_PSEUDOID", ctpseudoid);
        this.finishNewObject(superCage, this.ivLine[1]);
        this.finishNewObject(subCageLeft, this.ivLine[1]);
        this.finishNewObject(subCageRight, this.ivLine[1]);
        superCage.setLong("CAG_SUBCAGEL", subCageLeft.getID());
        superCage.setLong("CAG_SUBCAGER", subCageRight.getID());
        subCageLeft.setLong("CAG_SUPERCAGE", superCage.getID());
        subCageLeft.setInt("CAG_SIDE", 1);
        subCageRight.setLong("CAG_SUPERCAGE", superCage.getID());
        subCageRight.setInt("CAG_SIDE", 2);
        Vector<Cage> res = new Vector<Cage>();
        res.add(superCage);
        res.add(subCageLeft);
        res.add(subCageRight);
        return res;
    }

    public static int findNextPseudoID(String group) {
        HashSet hs = CommandManagerCage.getPseudoIDs(group);
        int test = 1;
        while (hs.contains(new Integer(test))) {
            ++test;
        }
        return test;
    }

    public static int findNextPseudoIDRange(String group, int anz) {
        HashSet hs = CommandManagerCage.getPseudoIDs(group);
        int test = 1;
        while (true) {
            if (!hs.contains(new Integer(test))) {
                if (anz == 1) {
                    return test;
                }
                if (CommandManagerCage.checkNextPseudoIDs(hs, test + 1, anz - 1)) {
                    return test;
                }
                test += anz;
                continue;
            }
            ++test;
        }
    }

    private static HashSet getPseudoIDs(String group) {
        HashSet<Integer> hs = new HashSet<Integer>(200);
        Vector v = ObjectStore.getActualObjects(2, group);
        if (v != null) {
            Iterator iterator = v.iterator();
            while (iterator.hasNext()) {
                Cage cage = (Cage)iterator.next();
                Integer pid = (Integer)cage.get("CAG_PSEUDOID");
                if (pid == null) continue;
                hs.add(pid);
            }
        }
        return hs;
    }

    private static boolean checkNextPseudoIDs(HashSet ht, int start, int anz) {
        int i = 0;
        while (i < anz) {
            if (ht.contains(new Integer(i + start))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean handleCAGCONTIG() {
        int anz = this.ivLine.length - 1;
        if (anz <= 0) {
            return true;
        }
        int start = CommandManagerCage.findNextPseudoIDRange(this.ivGroupname, anz);
        int i = 0;
        while (i < anz) {
            Cage c = (Cage)ObjectStoreServer.getObjectToUpdate(2, Long.parseLong(this.ivLine[i + 1]), this.ivGroupname, this.ivObjectBag);
            if (c != null) {
                c.setInt("CAG_PSEUDOID", start + i);
                this.ivObjectBag.put(c.getIdentifierString(), c);
                if (c.hasSubCages()) {
                    Cage subcage;
                    long sid = c.getLong("CAG_SUBCAGEL", 1L);
                    if (sid != -1L && (subcage = (Cage)ObjectStore.getObjectDeadOrAlive(2, sid, c.getGroup(), this.ivObjectBag, false)) != null) {
                        subcage.setInt("CAG_PSEUDOID", start + i);
                        this.ivObjectBag.put(subcage.getIdentifierString(), subcage);
                    }
                    if ((sid = c.getLong("CAG_SUBCAGER", 1L)) != -1L && (subcage = (Cage)ObjectStore.getObjectDeadOrAlive(2, sid, c.getGroup(), this.ivObjectBag, false)) != null) {
                        subcage.setInt("CAG_PSEUDOID", start + i);
                        this.ivObjectBag.put(subcage.getIdentifierString(), subcage);
                    }
                }
            }
            ++i;
        }
        return true;
    }

    public boolean handleCAGCLEAN() {
        int i;
        Cage cage = (Cage)this.ivObjectForCommand;
        this.ivObjectBag.put(cage.getIdentifierString(), cage);
        Vector<Long> amv = new Vector<Long>();
        Visit[] arr = (Visit[])cage.get("CAG_VISIT");
        if (arr != null) {
            i = 0;
            while (i < arr.length) {
                if (arr[i].ivEndDate == null) {
                    amv.add(new Long(arr[i].ivMouseID));
                }
                ++i;
            }
        }
        i = 0;
        while (i < amv.size()) {
            Visit tv;
            Visit[] newCageVisits;
            Long longi = (Long)amv.elementAt(i);
            long mid = longi;
            Mouse mausi = (Mouse)ObjectStoreServer.getObjectDeadOrAlive(1, mid, this.ivGroupname, this.ivObjectBag, false, false);
            if (mausi != null && !mausi.neverExisted()) {
                if (mausi.get("IDO_END_DATE") != null) {
                    newCageVisits = Visit.enlargeVisitArray((Visit[])cage.get("CAG_VISIT"), 0);
                    tv = Visit.findLatestUnfinishedVisit(newCageVisits, mausi.getID(), cage.getID());
                    if (tv != null) {
                        tv.ivEndDate = (Date)mausi.get("IDO_END_DATE");
                        tv.ivEndMode = mausi.getInt("MOS_ENDMODE");
                    }
                    cage.set("CAG_VISIT", newCageVisits);
                    Visit[] newMouseVisits = Visit.enlargeVisitArray((Visit[])mausi.get("MOS_VISIT"), 0);
                    Visit mv = Visit.findLatestUnfinishedVisit(newMouseVisits, mausi.getID(), cage.getID());
                    if (mv != null) {
                        mv.ivEndDate = (Date)mausi.get("IDO_END_DATE");
                        mv.ivEndMode = mausi.getInt("MOS_ENDMODE");
                    }
                    mausi.set("MOS_VISIT", newMouseVisits);
                    this.ivObjectBag.put(mausi.getIdentifierString(), mausi);
                }
            } else {
                newCageVisits = Visit.enlargeVisitArray((Visit[])cage.get("CAG_VISIT"), 0);
                tv = Visit.findLatestUnfinishedVisit(newCageVisits, mid, cage.getID());
                if (tv != null) {
                    tv.ivEndDate = new Date();
                    tv.ivEndMode = 0;
                }
                cage.set("CAG_VISIT", newCageVisits);
            }
            ++i;
        }
        return true;
    }

    public boolean handleCOM_CAG_END_VISIT() {
        Cage cage = (Cage)this.ivObjectForCommand;
        this.ivObjectBag.put(cage.getIdentifierString(), cage);
        Visit[] newCageVisits = Visit.enlargeVisitArray((Visit[])cage.get("CAG_VISIT"), 0);
        Visit suchVisit = new Visit(cage.getID(), Long.parseLong(this.ivLine[2]), new Date(Long.parseLong(this.ivLine[3])), Integer.parseInt(this.ivLine[4]));
        Visit foundVisit = Visit.findExtactlyThisVisit(newCageVisits, suchVisit);
        if (foundVisit != null) {
            foundVisit.ivEndDate = new Date(Long.parseLong(this.ivLine[5]));
            foundVisit.ivEndMode = Integer.parseInt(this.ivLine[6]);
            cage.set("CAG_VISIT", newCageVisits);
        }
        return true;
    }

    public boolean handleCAGSETTAG() {
        return CommanManUtil.setMark(this.ivObjectForCommand, "CAG_FLAG", this.ivLine[2]);
    }

    public boolean handleCAGSETRACKPOS() {
        if (this.ivLine.length < 3) {
            this.ivBugString = "CommandManagerCage handleCAGSETRACKPOS: not enough arguments";
            Log.info(this.ivBugString, this);
            return false;
        }
        long cageID = Long.parseLong(this.ivLine[1]);
        if (cageID == 0L) {
            this.ivBugString = "CommandManagerCage handleCAGSETRACKPOS: couldn't get Cage with ID " + cageID;
            Log.info(this.ivBugString, this);
            return false;
        }
        Cage cage = (Cage)ObjectStoreServer.getObjectToUpdate(2, cageID, this.ivGroupname, this.ivObjectBag);
        if (cage == null) {
            this.ivBugString = "CommandManagerCage handleCAGSETRACKPOS: couldn't get Cage with ID " + cageID;
            Log.info(this.ivBugString, this);
            return false;
        }
        if (!cage.isAliveAndVisible()) {
            this.ivBugString = "CommandManagerCage handleCAGSETRACKPOS: Cage with ID " + cageID + " was already removed!";
            Log.info(this.ivBugString, this);
            return false;
        }
        if (this.ivLine.length <= 4) {
            String bruddel = CommandManagerCage.removeCageFromRack(cage, this.ivObjectBag, this.ivServiceRoomOverride);
            if (bruddel != null) {
                this.ivBugString = bruddel;
                return false;
            }
            return true;
        }
        if (this.ivLine.length < 6) {
            this.ivBugString = "CommandManagerCage handleCAGSETRACKPOS: not enough arguments";
            Log.info(this.ivBugString, this);
            return false;
        }
        String bruddel = CommandManagerCage.removeCageFromRack(cage, this.ivObjectBag, this.ivServiceRoomOverride);
        if (bruddel != null) {
            this.ivBugString = bruddel;
            return false;
        }
        long rackID = Long.parseLong(this.ivLine[2]);
        int side = Integer.parseInt(this.ivLine[3]);
        int row = Integer.parseInt(this.ivLine[4]);
        int column = Integer.parseInt(this.ivLine[5]);
        Rack rack = (Rack)ObjectStoreServer.getObjectToUpdate(3, rackID, this.ivGroupname, this.ivObjectBag);
        if (rack == null) {
            this.ivBugString = "CommandManagerCage handleCAGSETRACKPOS: couldn't get Rack with ID " + rackID;
            Log.info(this.ivBugString, this);
            return false;
        }
        String[] bruddelArr = new String[1];
        boolean res = CommandManagerCage.moveCageToRack(cage, rack, side, column, row, this.ivObjectBag, bruddelArr, this.ivServiceRoomOverride, this.ivGeneralSRId);
        if (!res) {
            this.ivBugString = bruddelArr[0];
            return false;
        }
        Long serviceRoomID = rack.getServiceRoomID();
        Vector<Cage> v = new Vector<Cage>();
        v.add(cage);
        this.markObjectsForServiceRoom(v, serviceRoomID != null ? serviceRoomID : AllgUtils.NIX_ROOM);
        return true;
    }

    public static boolean moveCageToRack(Cage cage, Rack rack, int side, int column, int row, Hashtable objectBag, String[] bruddel, HashMap serviceRoomOverride, Long generalServiceRoomID) {
        int racksides = rack.getInt("RCK_SIDES");
        if (side >= rack.getInt("RCK_SIDES")) {
            bruddel[0] = "CommandManagerCage handleCAGSETRACKPOS: The rack has not the wanted number of sides. You wanted to put the cage on side " + (side + 1) + ". But the rack has only " + racksides + " side(s)";
            String string = bruddel[0];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("mausoleum.objectstore.CommandManagerCage");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.info(string, clazz);
            return false;
        }
        long[] rackCages = (long[])rack.get("RCK_CAGES");
        if (rackCages == null) {
            bruddel[0] = "CommandManagerCage handleCAGSETRACKPOS: New Rack has no cages";
            String string = bruddel[0];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("mausoleum.objectstore.CommandManagerCage");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.info(string, clazz);
            return false;
        }
        int pos = rack.calcPos(side, row, column);
        if (pos >= rackCages.length) {
            bruddel[0] = "CommandManagerCage handleCAGSETRACKPOS: calculated pos " + pos + " ist not possibly contained in cagearray of Rack" + " with size " + rackCages.length;
            String string = bruddel[0];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("mausoleum.objectstore.CommandManagerCage");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.info(string, clazz);
            return false;
        }
        if (rack.istPosBelegt(side, row, column, false)) {
            bruddel[0] = "CommandManagerCage handleCAGSETRACKPOS: spot not empty";
            String string = bruddel[0];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("mausoleum.objectstore.CommandManagerCage");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.info(string, clazz);
            return false;
        }
        cage.set("CAG_POS", new RackPos(rack.getID(), side, row, column));
        cage.set("CAG_ROOM", null);
        objectBag.put(cage.getIdentifierString(), cage);
        long[] newRackCages = new long[rackCages.length];
        int i = 0;
        while (i < rackCages.length) {
            newRackCages[i] = rackCages[i];
            ++i;
        }
        newRackCages[pos] = cage.getID();
        String rids = rack.getIdentifierString();
        objectBag.put(rids, rack);
        if (generalServiceRoomID != null && serviceRoomOverride != null) {
            serviceRoomOverride.put(rids, generalServiceRoomID);
        }
        rack.setAndPropagateCages(newRackCages, objectBag, serviceRoomOverride);
        return true;
    }

    public static String removeCageFromRack(Cage cage, Hashtable objectBag, HashMap serviceRoomOverride) {
        RackPos rackPos = (RackPos)cage.get("CAG_POS");
        if (rackPos != null) {
            Rack rack = (Rack)ObjectStoreServer.getObjectToUpdate(3, rackPos.ivRackID, cage.getGroup(), objectBag);
            if (rack == null) {
                String bugString = "CommandManagerCage removeCageFromOldRack: couldn't get Rack with ID " + rackPos.ivRackID;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("mausoleum.objectstore.CommandManagerCage");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.info(bugString, clazz);
                return bugString;
            }
            long[] rackCages = (long[])rack.get("RCK_CAGES");
            if (rackCages == null) {
                String bugString = "CommandManagerCage removeCageFromOldRack: Old Rack has no cages";
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("mausoleum.objectstore.CommandManagerCage");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.info(bugString, clazz);
                return bugString;
            }
            long[] newRackCages = ArrayHelper.getCopy(rackCages);
            newRackCages[rack.calcPos((int)rackPos.ivSide, (int)rackPos.ivRow, (int)rackPos.ivColumn)] = 0L;
            objectBag.put(rack.getIdentifierString(), rack);
            if (rack.setAndPropagateCages(newRackCages, objectBag, serviceRoomOverride)) {
                cage.set("CAG_POS", null);
                objectBag.put(cage.getIdentifierString(), cage);
            } else {
                String bugString = "CommandManagerCage setAndPropagateCages crashed";
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("mausoleum.objectstore.CommandManagerCage");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.info(bugString, clazz);
                return bugString;
            }
        }
        return null;
    }

    public boolean handleCAG_SET_COMMENT() {
        this.ivObjectForCommand.set("CAG_COMMENT", Base64Manager.getDecodedString(this.ivLine[2]));
        return true;
    }

    public boolean handleCAG_ADD_COMMENT() {
        String comment = this.ivObjectForCommand.getString("CAG_COMMENT");
        String commentAdd = Base64Manager.getDecodedString(this.ivLine[2]);
        comment = comment == null ? commentAdd : String.valueOf(comment) + "\n" + commentAdd;
        this.ivObjectForCommand.set("CAG_COMMENT", comment);
        return true;
    }

    public boolean handleCAG_SET_LICENSEID() {
        this.ivObjectForCommand.set("CAG_LICENSEID", Base64Manager.getDecodedString(this.ivLine[2]));
        return true;
    }

    public boolean handleCAG_SET_PSEUDOID() {
        this.ivObjectForCommand.setInt("CAG_PSEUDOID", this.ivLine[2]);
        return true;
    }

    public boolean handleCAG_SET_ANTAG() {
        String anTag = Base64Manager.getDecodedString(this.ivLine[2]);
        if ((anTag = anTag.trim()).length() != 0) {
            this.ivObjectForCommand.set("CAG_ANTAG", anTag);
        } else {
            this.ivObjectForCommand.set("CAG_ANTAG", null);
        }
        return true;
    }

    public boolean handleCAG_SET_CAGETALKER_ID() {
        if (CageTalker.useCageTalker()) {
            String cageTalkerID = Base64Manager.getDecodedString(this.ivLine[2]);
            if ((cageTalkerID = cageTalkerID.trim()).length() != 0) {
                if (CageTalker.isCageTalkerIdTaken(cageTalkerID)) {
                    this.ivBugString = "CageTalker-ID is already in use!";
                    Log.info(this.ivBugString, this);
                    return false;
                }
                if (CageTalker.isLimitExceeded()) {
                    this.ivBugString = "CageTalker Maximum of IDs is exceeded!";
                    Log.info(this.ivBugString, this);
                    return false;
                }
                this.ivObjectForCommand.set("CAG_CTID", cageTalkerID);
            } else {
                this.ivObjectForCommand.set("CAG_CTID", null);
            }
        }
        return true;
    }

    public boolean handleCOM_CAG_TRANSFER_TO_ROOM() {
        Cage cage = (Cage)this.ivObjectForCommand;
        if (!cage.isAliveAndVisible()) {
            this.ivBugString = "CommandManagerCage handleCOM_CAG_TRANSFER_TO_ROOM: Cage with ID " + cage.getID() + " was already removed!";
            Log.info(this.ivBugString, this);
            return false;
        }
        long roomID = Long.parseLong(this.ivLine[2]);
        Room toRoom = (Room)ObjectStore.getObjectDeadOrAlive(10, roomID, this.ivGroupname, this.ivObjectBag, false);
        if (toRoom != null) {
            String bruddel = CommandManagerCage.removeCageFromRack(cage, this.ivObjectBag, this.ivServiceRoomOverride);
            if (bruddel != null) {
                this.ivBugString = bruddel;
                return false;
            }
            cage.set("CAG_ROOM", new Long(roomID));
            this.ivObjectBag.put(cage.getIdentifierString(), cage);
            Long serviceRoomID = toRoom.getServiceRoomID();
            Vector<Cage> v = new Vector<Cage>();
            v.add(cage);
            this.markObjectsForServiceRoom(v, serviceRoomID != null ? serviceRoomID : AllgUtils.NIX_ROOM);
            return true;
        }
        return false;
    }
}

