/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.objectstore;

import de.hannse.netobjects.objectstore.CommandManagerExecutive;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.tools.StringHelper;
import java.util.Vector;
import mausoleum.helper.Zeile;
import mausoleum.locus.Locus;

public class CommandManagerLocus
extends CommandManagerExecutive {
    private static final String PREFIX = "LOC";
    public static final String COM_LOC_NEW = "LOCNEW";
    public static final String COM_LOC_RM = "LOCRM";
    public static final String COM_LOC_REVIT = "LOCREVIT";
    public static final String COM_LOC_CHNAME = "LOCCHNAME";
    public static final String COM_LOC_CHENSEMBLNAME = "LOCCHENSEMBLNAME";
    public static final String COM_LOC_CHMGINAME = "LOCCHMGINAME";
    public static final String COM_LOC_CHCOMMENT = "LOCCHCOMMENT";
    public static final String COM_LOC_ADDALLEL = "LOCADDALLEL";
    public static final String COM_LOC_CHAUTOSOMAL = "LOCCHAUTOSOMAL";
    public static final String COM_LOC_CHALLORDER = "LOCCHALLORDER";
    public static final String COM_LOC_SET_ALIAS = "LOCSETALIAS";
    public static final String COM_LOC_CHAUTOGENOTYPE = "LOCCHAUTOGENOTYPE";
    public static final String COM_LOC_AKT_ALLEL = "LOCAKTALLEL";
    public static final String COM_LOC_KILL_FINAL = "LOC_KILL_FINAL";

    public CommandManagerLocus() {
        super(14);
        this.addMeth(COM_LOC_NEW, "handleLOCNEW", 9, false);
        this.addMeth(COM_LOC_RM, "setInvisible", 2, true);
        this.addMeth(COM_LOC_REVIT, "setVisible", 2, true);
        this.addMeth(COM_LOC_KILL_FINAL, "removeComObject", 2, true);
        this.addMeth(COM_LOC_CHNAME, "handleLOCCHNAME", 3, true);
        this.addMeth(COM_LOC_CHENSEMBLNAME, "handleLOCCHENSEMBLNAME", 3, true);
        this.addMeth(COM_LOC_CHMGINAME, "handleLOCCHMGINAME", 3, true);
        this.addMeth(COM_LOC_CHCOMMENT, "handleLOCCHCOMMENT", 3, true);
        this.addMeth(COM_LOC_ADDALLEL, "handleLOCADDALLEL", 3, true);
        this.addMeth(COM_LOC_CHAUTOSOMAL, "handleLOCCHAUTOSOMAL", 3, true);
        this.addMeth(COM_LOC_CHALLORDER, "handleLOCCHALLORDER", 3, true);
        this.addMeth(COM_LOC_SET_ALIAS, "handleLOCSETALIAS", 4, true);
        this.addMeth(COM_LOC_CHAUTOGENOTYPE, "handleLOCCHAUTOGENOTYPE", 3, true);
        this.addMeth(COM_LOC_AKT_ALLEL, "handleLOCAktAllel", 4, true);
    }

    public String getParsedCommandIfTouched(String command, Zeile z, String group, int typ, long id, String objectGroup) {
        if (command.equals(COM_LOC_NEW)) {
            if (typ == 0 && id == 0L) {
                return "Created new locus";
            }
            return null;
        }
        if (command.equals(COM_LOC_RM)) {
            if (typ == 0 && id == 0L) {
                return "Removed locus " + this.getIDObjectRef(group, 14, z.getLong(1, 0L), objectGroup);
            }
            if (typ == 14 && z.getLong(1, 0L) == id) {
                return "Removed Locus";
            }
            return null;
        }
        if (command.equals(COM_LOC_REVIT)) {
            if (typ == 0 && id == 0L) {
                return "Revitalized locus " + this.getIDObjectRef(group, 14, z.getLong(1, 0L), objectGroup);
            }
            if (typ == 14 && z.getLong(1, 0L) == id) {
                return "Revitalized Locus";
            }
            return null;
        }
        if (command.equals(COM_LOC_CHNAME)) {
            if (typ == 0 && id == 0L) {
                String locRef = this.getIDObjectRef(group, 14, z.getLong(1, 0L), objectGroup);
                return CommandManagerLocus.getPB64String("Changed name of locus " + locRef + " to: ", z, 2);
            }
            if (typ == 14 && z.getLong(1, 0L) == id) {
                return CommandManagerLocus.getPB64String("Changed name to: ", z, 2);
            }
            return null;
        }
        if (command.equals(COM_LOC_CHENSEMBLNAME)) {
            if (typ == 0 && id == 0L) {
                String locRef = this.getIDObjectRef(group, 14, z.getLong(1, 0L), objectGroup);
                return CommandManagerLocus.getPB64String("Changed ENSEMBL-ID of locus " + locRef + " to: ", z, 2);
            }
            if (typ == 14 && z.getLong(1, 0L) == id) {
                return CommandManagerLocus.getPB64String("Changed ENSEMBL-ID to: ", z, 2);
            }
            return null;
        }
        if (command.equals(COM_LOC_CHMGINAME)) {
            if (typ == 0 && id == 0L) {
                String locRef = this.getIDObjectRef(group, 14, z.getLong(1, 0L), objectGroup);
                return CommandManagerLocus.getPB64String("Changed MGI/ZFIN-ID of locus " + locRef + " to: ", z, 2);
            }
            if (typ == 14 && z.getLong(1, 0L) == id) {
                return CommandManagerLocus.getPB64String("Changed MGI/ZFIN-ID to: ", z, 2);
            }
            return null;
        }
        if (command.equals(COM_LOC_CHCOMMENT)) {
            if (typ == 0 && id == 0L) {
                String locRef = this.getIDObjectRef(group, 14, z.getLong(1, 0L), objectGroup);
                return CommandManagerLocus.getPB64String("Set comment of locus " + locRef + " to: ", z, 2);
            }
            if (typ == 14 && z.getLong(1, 0L) == id) {
                return CommandManagerLocus.getPB64String("Set comment to: ", z, 2);
            }
            return null;
        }
        if (command.equals(COM_LOC_ADDALLEL)) {
            if (typ == 0 && id == 0L) {
                String locRef = this.getIDObjectRef(group, 14, z.getLong(1, 0L), objectGroup);
                return CommandManagerLocus.getPB64String("Added allel to locus " + locRef + " : ", z, 2);
            }
            if (typ == 14 && z.getLong(1, 0L) == id) {
                return CommandManagerLocus.getPB64String("Added allel: ", z, 2);
            }
            return null;
        }
        if (command.equals(COM_LOC_CHAUTOSOMAL)) {
            if (typ == 0 && id == 0L) {
                String locRef = this.getIDObjectRef(group, 14, z.getLong(1, 0L), objectGroup);
                if (z.getString(2, "").equals("1")) {
                    return "Set locus " + locRef + " to autosomal";
                }
                return "Set locus " + locRef + " to non-autosomal";
            }
            if (typ == 14 && z.getLong(1, 0L) == id) {
                if (z.getString(2, "").equals("1")) {
                    return "set to autosomal";
                }
                return "set to non-autosomal";
            }
            return null;
        }
        if (command.equals(COM_LOC_CHALLORDER)) {
            if (typ == 0 && id == 0L) {
                String locRef = this.getIDObjectRef(group, 14, z.getLong(1, 0L), objectGroup);
                return "Changed allel order of locus " + locRef;
            }
            if (typ == 14 && z.getLong(1, 0L) == id) {
                return "changed allel order";
            }
            return null;
        }
        if (command.equals(COM_LOC_SET_ALIAS)) {
            if (typ == 0 && id == 0L) {
                String locRef = this.getIDObjectRef(group, 14, z.getLong(1, 0L), objectGroup);
                return "Set alias of allel " + Base64Manager.getDecodedString(z.getString(2, "")) + " to: " + Base64Manager.getDecodedString(z.getString(3, "")) + " for locus " + locRef;
            }
            if (typ == 14 && z.getLong(1, 0L) == id) {
                return "Set alias of allel " + Base64Manager.getDecodedString(z.getString(2, "")) + " to: " + Base64Manager.getDecodedString(z.getString(3, ""));
            }
            return null;
        }
        if (command.equals(COM_LOC_CHAUTOGENOTYPE)) {
            if (typ == 0 && id == 0L) {
                String locRef = this.getIDObjectRef(group, 14, z.getLong(1, 0L), objectGroup);
                if (z.getString(2, "").equals("1")) {
                    return "Enabled auomated genotyping for locus " + locRef;
                }
                return "Disabled auomated genotyping for locus " + locRef;
            }
            if (typ == 14 && z.getLong(1, 0L) == id) {
                if (z.getString(2, "").equals("1")) {
                    return "enabled auomated genotyping";
                }
                return "disabled auomated genotyping";
            }
            return null;
        }
        if (command.equals(COM_LOC_AKT_ALLEL)) {
            if (typ == 0 && id == 0L) {
                String locRef = this.getIDObjectRef(group, 14, z.getLong(1, 0L), objectGroup);
                String allel = Base64Manager.getDecodedString(z.getString(2, ""));
                if (z.getString(3, "").equals("1")) {
                    return "Reactivated allel " + allel + " in locus " + locRef;
                }
                return "Deactivated allel " + allel + " in locus " + locRef;
            }
            if (typ == 14 && z.getLong(1, 0L) == id) {
                String allel = Base64Manager.getDecodedString(z.getString(2, ""));
                if (z.getString(3, "").equals("1")) {
                    return "Reactivated allel " + allel;
                }
                return "Deactivated allel " + allel;
            }
            return null;
        }
        return "CME_NP";
    }

    public boolean handleLOCNEW() {
        String allelesString;
        Vector alleles;
        Locus locus = new Locus();
        locus.set("LOC_NAME", Base64Manager.getDecodedString(this.ivLine[1]));
        locus.set("LOC_ENSEMBL_NAME", Base64Manager.getDecodedString(this.ivLine[2]));
        locus.setLong("LOC_ENTERER", this.ivLine[3]);
        locus.setBoolean("LOC_AUTOSOMAL", this.ivLine[4].equals("1"));
        if (!this.ivLine[5].equals("nix")) {
            locus.set("LOC_WT_ALLEL", Base64Manager.getDecodedString(this.ivLine[5]));
        }
        if (!this.ivLine[7].equals("nix")) {
            locus.set("LOC_DESCRIPTION", Base64Manager.getDecodedString(this.ivLine[7]));
        }
        if (!this.ivLine[8].equals("nix")) {
            locus.set("LOC_ALLEL_DESC", this.ivLine[8]);
        }
        if ((alleles = StringHelper.splitStringByAny(allelesString = Base64Manager.getDecodedString(this.ivLine[6]), "\n")) != null && alleles.size() != 0) {
            String[] allelesArray = new String[alleles.size()];
            int i = 0;
            while (i < alleles.size()) {
                allelesArray[i] = (String)alleles.elementAt(i);
                ++i;
            }
            locus.set("LOC_ALLELES", allelesArray);
        }
        return this.finishNewObject(locus, null);
    }

    public boolean handleLOCCHNAME() {
        this.ivObjectForCommand.setAndPropagateAttributes(this.ivObjectBag, null, "LOC_NAME", Base64Manager.getDecodedString(this.ivLine[2]));
        return true;
    }

    public boolean handleLOCCHAUTOSOMAL() {
        this.ivObjectForCommand.setAndPropagateAttributes(this.ivObjectBag, null, "LOC_AUTOSOMAL", new Boolean(this.ivLine[2].equals("1")));
        return true;
    }

    public boolean handleLOCCHAUTOGENOTYPE() {
        this.ivObjectForCommand.setAndPropagateAttributes(this.ivObjectBag, null, "LOC_AUTOGTOK", new Boolean(this.ivLine[2].equals("1")));
        return true;
    }

    public boolean handleLOCCHENSEMBLNAME() {
        this.ivObjectForCommand.setAndPropagateAttributes(this.ivObjectBag, null, "LOC_ENSEMBL_NAME", Base64Manager.getDecodedString(this.ivLine[2]));
        return true;
    }

    public boolean handleLOCCHMGINAME() {
        this.ivObjectForCommand.setAndPropagateAttributes(this.ivObjectBag, null, "LOC_MGI_NAME", Base64Manager.getDecodedString(this.ivLine[2]));
        return true;
    }

    public boolean handleLOCADDALLEL() {
        String[] oldAlleles = (String[])this.ivObjectForCommand.get("LOC_ALLELES");
        String[] newAlleles = new String[oldAlleles.length + 1];
        int i = 0;
        while (i < oldAlleles.length) {
            newAlleles[i] = oldAlleles[i];
            ++i;
        }
        newAlleles[newAlleles.length - 1] = Base64Manager.getDecodedString(this.ivLine[2]);
        this.ivObjectForCommand.setAndPropagateAttributes(this.ivObjectBag, null, "LOC_ALLELES", newAlleles);
        return true;
    }

    public boolean handleLOCCHCOMMENT() {
        this.ivObjectForCommand.setAndPropagateAttributes(this.ivObjectBag, null, "LOC_DESCRIPTION", Base64Manager.getDecodedString(this.ivLine[2]));
        return true;
    }

    public boolean handleLOCCHALLORDER() {
        String decOrder = Base64Manager.getDecodedString(this.ivLine[2]);
        Vector v = StringHelper.splitStringByAny(decOrder, ",");
        int[] newPos = new int[v.size()];
        int i = 0;
        while (i < v.size()) {
            newPos[i] = Integer.parseInt((String)v.elementAt(i));
            ++i;
        }
        String[] oldArr = (String[])this.ivObjectForCommand.get("LOC_ALLELES");
        if (oldArr != null) {
            String[] newArr = new String[oldArr.length];
            int i2 = 0;
            while (i2 < newPos.length) {
                newArr[i2] = oldArr[newPos[i2]];
                ++i2;
            }
            this.ivObjectForCommand.setAndPropagateAttributes(this.ivObjectBag, null, "LOC_ALLELES", newArr);
        }
        return true;
    }

    public boolean handleLOCSETALIAS() {
        String allel = Base64Manager.getDecodedString(this.ivLine[2]);
        String alias = Base64Manager.getDecodedString(this.ivLine[3]);
        Locus locus = (Locus)this.ivObjectForCommand;
        locus.setAllelAlias(allel, alias);
        this.ivObjectForCommand.setAndPropagateAttributes(this.ivObjectBag, null, null, null);
        return true;
    }

    public boolean handleLOCAktAllel() {
        String allel = Base64Manager.getDecodedString(this.ivLine[2]);
        ((Locus)this.ivObjectForCommand).setAllelActivity(allel, this.ivLine[3].equals("1"));
        this.ivObjectForCommand.setAndPropagateAttributes(this.ivObjectBag, null, null, null);
        return true;
    }
}

